/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BatsEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 4.0E-5;
    private static final double MAX_PROB_PHASE1 = 4.5E-5;
    private static final double BASE_PROB_PHASE2 = 5.0E-5;
    private static final double MAX_PROB_PHASE2 = 5.5E-5;
    private static final int SCAN_RADIUS = 24;
    private static final int DURATION_TICKS = 240;
    private static final Map<Integer, BatState> active = new HashMap<Integer, BatState>();
    private static int counter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 4.0E-5 : 5.0E-5;
        double maxProb = phase == 1 ? 4.5E-5 : 5.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<Entity> bats = BatsEventsProcedure.findBats(server, player);
        if (bats.isEmpty()) {
            return;
        }
        BatEvent choice = BatEvent.values()[server.m_213780_().m_188503_(BatEvent.values().length)];
        active.put(counter++, new BatState(choice, player, bats));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, BatState>> it = active.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, BatState> entry = it.next();
            BatState s = entry.getValue();
            if (!(s.player.m_9236_() instanceof ServerLevel)) {
                it.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)s.player.m_9236_();
            ++s.tickCount;
            if (s.event == BatEvent.CIRCLE_PLAYER) {
                int i = 0;
                ArrayList liveBats = new ArrayList();
                AABB searchBox = s.player.m_20191_().m_82400_(24.0);
                for (Entity en : server.m_6443_(Entity.class, searchBox, e -> e.m_6095_() == EntityType.f_20549_)) {
                    liveBats.add(en);
                }
                if (liveBats.isEmpty()) {
                    if (s.tickCount < 240) continue;
                    it.remove();
                    continue;
                }
                for (UUID id : new ArrayList<UUID>(s.bats)) {
                    Entity b = BatsEventsProcedure.findEntityByUUID(server, s.player, id, 24.0);
                    if (b == null || b.m_213877_() || b.m_6095_() != EntityType.f_20549_) {
                        ++i;
                        continue;
                    }
                    double angle = (double)s.tickCount * 0.04 + (double)i * (Math.PI * 2 / (double)Math.max(1, liveBats.size()));
                    double radius = 2.0 + (double)(i % 3) * 0.6;
                    double px = s.player.m_20185_() + Math.cos(angle) * radius;
                    double pz = s.player.m_20189_() + Math.sin(angle) * radius;
                    double py = s.player.m_20186_() + 1.5 + Math.sin(angle * 2.0) * 0.5;
                    Vec3 to = new Vec3(px - b.m_20185_(), py - b.m_20186_(), pz - b.m_20189_());
                    double len = Math.sqrt(to.f_82479_ * to.f_82479_ + to.f_82480_ * to.f_82480_ + to.f_82481_ * to.f_82481_);
                    if (len > 1.0E-4) {
                        to = to.m_82541_().m_82490_(0.3);
                    }
                    b.m_20256_(to);
                    b.m_146922_((float)(Math.atan2(pz - b.m_20189_(), px - b.m_20185_()) * 57.29577951308232) - 90.0f);
                    ++i;
                }
            } else if (s.tickCount == 1) {
                Entity ref = null;
                for (UUID id : s.bats) {
                    Entity cand = BatsEventsProcedure.findEntityByUUID(server, s.player, id, 24.0);
                    if (cand == null || cand.m_213877_() || cand.m_6095_() != EntityType.f_20549_) continue;
                    ref = cand;
                    break;
                }
                if (ref != null) {
                    BlockPos target = ref.m_20183_();
                    for (UUID id : new ArrayList<UUID>(s.bats)) {
                        Entity b = BatsEventsProcedure.findEntityByUUID(server, s.player, id, 24.0);
                        if (b == null || b.m_213877_() || b.m_6095_() != EntityType.f_20549_) continue;
                        b.m_6021_((double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.5, (double)target.m_123343_() + 0.5);
                        b.m_20256_(Vec3.f_82478_);
                    }
                }
            }
            if (s.tickCount < 240) continue;
            it.remove();
        }
    }

    private static List<Entity> findBats(ServerLevel server, Player player) {
        AABB box = player.m_20191_().m_82400_(24.0);
        return server.m_6443_(Entity.class, box, e -> e.m_6095_() == EntityType.f_20549_);
    }

    private static Entity findEntityByUUID(ServerLevel server, Player player, UUID id, double radius) {
        AABB box = player.m_20191_().m_82400_(radius);
        for (Entity en : server.m_6443_(Entity.class, box, e -> true)) {
            if (!en.m_20148_().equals(id)) continue;
            return en;
        }
        return null;
    }

    private static enum BatEvent {
        CIRCLE_PLAYER,
        MERGE_INTO_BLOCK;

    }

    private static class BatState {
        BatEvent event;
        Player player;
        List<UUID> bats;
        int tickCount;
        long nextSoundTick;

        BatState(BatEvent event, Player player, List<Entity> bats) {
            this.event = event;
            this.player = player;
            this.bats = new ArrayList<UUID>();
            for (Entity e : bats) {
                this.bats.add(e.m_20148_());
            }
            this.tickCount = 0;
            this.nextSoundTick = 0L;
        }
    }
}

