/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WatcherCknSpawnProcedure {
    private static final double BASE_PROB = 1.5E-5;
    private static final double MAX_PROB = 2.5E-5;
    private static final double MIN_DIST = 23.0;
    private static final double MAX_DIST = 40.0;
    private static final double TRIGGER_DISTANCE = 10.0;
    private static final int LOOK_TRIGGER_TICKS = 10;
    private static final String KEY_LOOK_START = "pckn_lookStart";
    private static final int MAX_SPAWN_ATTEMPTS = 10;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 1.5E-5, 2.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        BlockPos spawnPos = WatcherCknSpawnProcedure.findGroundPosition(level, player, 23.0, 40.0);
        if (spawnPos == null) {
            return;
        }
        Mob mob = (Mob)((EntityType)FromTheCavesModEntities.WATCHER_CKN.get()).m_262496_(level, spawnPos, MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        CompoundTag data = mob.getPersistentData();
        data.m_128473_(KEY_LOOK_START);
    }

    private static BlockPos findGroundPosition(ServerLevel level, Player player, double minDist, double maxDist) {
        for (int attempt = 0; attempt < 10; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double dist = minDist + Math.random() * (maxDist - minDist);
            double sx = player.m_20185_() + Math.cos(angle) * dist;
            double sz = player.m_20189_() + Math.sin(angle) * dist;
            int sy = (int)player.m_20186_();
            BlockPos pos = new BlockPos((int)sx, sy, (int)sz);
            for (int y = sy + 4; y >= level.m_141937_(); --y) {
                BlockPos testPos = new BlockPos((int)sx, y, (int)sz);
                BlockPos belowPos = testPos.m_7495_();
                if (!level.m_46749_(testPos) || !level.m_46749_(belowPos)) continue;
                BlockState state = level.m_8055_(testPos);
                BlockState belowState = level.m_8055_(belowPos);
                FluidState fluidState = belowState.m_60819_();
                if (!state.m_60795_() || belowState.m_60795_() || fluidState.m_76170_() || belowState.m_60734_() == Blocks.f_50752_) continue;
                return testPos;
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        boolean inSightCone;
        Mob mob;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob) || !(mob = (Mob)entity).m_6095_().equals(FromTheCavesModEntities.WATCHER_CKN.get())) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 64.0);
        if (player == null) {
            return;
        }
        double dist = mob.m_20270_((Entity)player);
        if (dist <= 10.0) {
            WatcherCknSpawnProcedure.revertToChicken(mob, level);
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20188_(), mob.m_20189_() - player.m_20189_());
        if (toMob.m_82556_() == 0.0) {
            data.m_128473_(KEY_LOOK_START);
            return;
        }
        Vec3 toMobNorm = toMob.m_82541_();
        double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
        boolean bl = inSightCone = dot > 0.95 && hasLOS;
        if (inSightCone) {
            if (!data.m_128441_(KEY_LOOK_START)) {
                data.m_128356_(KEY_LOOK_START, now);
            } else {
                long started = data.m_128454_(KEY_LOOK_START);
                if (now - started >= 10L) {
                    WatcherCknSpawnProcedure.revertToChicken(mob, level);
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_LOOK_START);
        }
    }

    private static void revertToChicken(Mob possessed, ServerLevel level) {
        BlockPos pos = possessed.m_20183_();
        float yaw = possessed.m_146908_();
        float pitch = possessed.m_146909_();
        possessed.m_146870_();
        Mob chicken = (Mob)EntityType.f_20555_.m_20615_((Level)level);
        if (chicken != null) {
            chicken.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + 0.5, yaw, pitch);
            chicken.m_21557_(false);
            chicken.m_21530_();
            level.m_7967_((Entity)chicken);
        }
    }
}

