/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossessedMobChaseAttackProcedure {
    private static final double CHASE_PROBABILITY = 0.1;
    private static final double CHASE_SPEED = 1.2;
    private static final double ATTACK_RANGE = 2.5;
    private static final int ATTACK_COOLDOWN = 20;
    private static final int LOOK_DURATION_TICKS = 100;
    private static final int NAV_UPDATE_INTERVAL = 10;
    private static final int PEARL_COOLDOWN = 30;
    private static final int PEARL_COOLDOWN_ANGRY = 10;
    private static final double END_ATTACK_RANGE = 2.0;
    private static final float END_ATTACK_DAMAGE = 2.0f;
    private static final double END_PEARL_MIN_DIST = 2.5;
    private static final float END_FOV = 130.0f;
    private static final int END_ANGRY_DURATION = 120;
    private static final double CRP_SWELL_DIST = 5.0;
    private static final int CRP_SWELL_TIME = 45;
    private static final float CRP_EXPLOSION_POWER = 3.0f;
    private static final double CRP_MIN_JUMP_Y = 0.4;
    private static final double CRP_MAX_JUMP_Y = 5.0;
    private static final double CRP_MIN_JUMP_HORIZ = 0.2;
    private static final double CRP_MAX_JUMP_HORIZ = 5.0;
    private static final double CRP_MAX_CHECK_DIST = 64.0;
    private static final double CRP_MIN_DIST_TO_JUMP = 4.0;
    private static final double SK_DESIRED_DIST = 4.0;
    private static final int SK_ARROW_COOLDOWN = 30;
    private static final int SK_ARROW_COOLDOWN_ANGRY = 15;
    private static final int SK_ANGRY_DURATION = 100;
    private static final int SP_COBWEB_COOLDOWN = 40;
    private static final double SP_PROJECTILE_SPEED = 1.5;
    private static final int Z_ANGRY_DURATION = 100;
    private static final double Z_SPEED_BOOST = 0.1;

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
            return;
        }
        EntityType type = mob.m_6095_();
        long now = level.m_46467_();
        CompoundTag pd = mob.getPersistentData();
        if (type.equals(FromTheCavesModEntities.POSSESSED_END.get())) {
            pd.m_128356_("p2pos_angry_time", now);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_SK.get())) {
            pd.m_128356_("p2pos_angry_time", now);
        } else if (type.equals(FromTheCavesModEntities.POSSESSED_Z.get())) {
            pd.m_128356_("p2pos_angry_time", now);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent ev) {
        long lastCobweb;
        boolean isAngry;
        long lastNavUpdate;
        boolean shouldUpdateNav;
        long elapsed;
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
            return;
        }
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.POSSESSED_V.get()) || type.equals(FromTheCavesModEntities.POSSESSED_P.get()) || type.equals(FromTheCavesModEntities.POSSESSED_C.get()) || type.equals(FromTheCavesModEntities.POSSESSED_S.get()) || type.equals(FromTheCavesModEntities.POSSESSED_W.get()) || type.equals(FromTheCavesModEntities.POSSESSED_Z.get()) || type.equals(FromTheCavesModEntities.POSSESSED_CRP.get()) || type.equals(FromTheCavesModEntities.POSSESSED_END.get()) || type.equals(FromTheCavesModEntities.POSSESSED_SK.get()) || type.equals(FromTheCavesModEntities.POSSESSED_SP.get()) || type.equals(FromTheCavesModEntities.POSSESSED_CKN.get()) || type.equals(FromTheCavesModEntities.POSSESSED_IG.get()))) {
            return;
        }
        Player tgt = level.m_45930_((Entity)mob, 64.0);
        if (tgt == null) {
            return;
        }
        double dx = tgt.m_20185_() - mob.m_20185_();
        double dz = tgt.m_20189_() - mob.m_20189_();
        double dy = tgt.m_20186_() + (double)tgt.m_20192_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float flat = (float)Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        CompoundTag pd = mob.getPersistentData();
        long now = level.m_46467_();
        if (!pd.m_128441_("p2pos_spawnTick")) {
            pd.m_128356_("p2pos_spawnTick", now);
        }
        if ((elapsed = now - pd.m_128454_("p2pos_spawnTick")) < 100L) {
            return;
        }
        double dist = mob.m_20270_((Entity)tgt);
        double currentAttackRange = 2.5;
        float currentAttackDamage = 1.0f;
        if (type == FromTheCavesModEntities.POSSESSED_END.get()) {
            currentAttackRange = 2.0;
            currentAttackDamage = 2.0f;
        }
        boolean bl = shouldUpdateNav = now - (lastNavUpdate = pd.m_128454_("p2pos_lastNavUpdate")) >= 10L;
        if (shouldUpdateNav) {
            if (type == FromTheCavesModEntities.POSSESSED_SK.get()) {
                long angryTime = pd.m_128454_("p2pos_angry_time");
                boolean bl2 = isAngry = now - angryTime < 100L;
                if (isAngry) {
                    mob.m_21573_().m_5624_((Entity)tgt, 1.7999999999999998);
                } else if (dist > 5.0) {
                    mob.m_21573_().m_5624_((Entity)tgt, 1.2);
                } else if (dist < 3.0) {
                    Vec3 awayDir = mob.m_20182_().m_82546_(tgt.m_20182_()).m_82541_();
                    double tx = mob.m_20185_() + awayDir.f_82479_ * 4.0;
                    double ty = mob.m_20186_() + awayDir.f_82480_ * 4.0;
                    double tz = mob.m_20189_() + awayDir.f_82481_ * 4.0;
                    mob.m_21573_().m_26519_(tx, ty, tz, 1.2);
                } else {
                    mob.m_21573_().m_26573_();
                }
            } else if (type == FromTheCavesModEntities.POSSESSED_Z.get()) {
                long angryTime = pd.m_128454_("p2pos_angry_time");
                boolean bl3 = isAngry = now - angryTime < 100L;
                if (isAngry) {
                    mob.m_21573_().m_5624_((Entity)tgt, 1.3);
                } else if (level.f_46441_.m_188500_() < 0.1) {
                    mob.m_21573_().m_5624_((Entity)tgt, 1.2);
                }
            } else if (type == FromTheCavesModEntities.POSSESSED_END.get()) {
                boolean playerLooking = PossessedMobChaseAttackProcedure.isPlayerLooking(mob, tgt, 130.0f);
                if (dist < 2.5) {
                    if (level.f_46441_.m_188500_() < 0.1) {
                        mob.m_21573_().m_5624_((Entity)tgt, 1.2);
                    }
                } else if (!playerLooking) {
                    if (level.f_46441_.m_188500_() < 0.1) {
                        mob.m_21573_().m_5624_((Entity)tgt, 1.2);
                    }
                } else {
                    mob.m_21573_().m_26573_();
                }
            } else if (level.f_46441_.m_188500_() < 0.1) {
                mob.m_21573_().m_5624_((Entity)tgt, 1.2);
            }
            pd.m_128356_("p2pos_lastNavUpdate", now);
        }
        if (type == FromTheCavesModEntities.POSSESSED_END.get()) {
            long lastPearl;
            double offsetZ;
            double offsetY;
            double offsetX;
            long angryTime = pd.m_128454_("p2pos_angry_time");
            isAngry = now - angryTime < 120L;
            int cooldown = isAngry ? 10 : 30;
            boolean playerLooking = PossessedMobChaseAttackProcedure.isPlayerLooking(mob, tgt, 130.0f);
            if (level.f_46441_.m_188500_() < 0.3) {
                offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.8;
                offsetY = level.f_46441_.m_188500_() * (double)mob.m_20206_();
                offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.8;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, mob.m_20185_() + offsetX, mob.m_20186_() + offsetY, mob.m_20189_() + offsetZ, 2, 0.0, 0.0, 0.0, 0.0);
            }
            if (isAngry && level.f_46441_.m_188500_() < 0.7) {
                offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.0;
                offsetY = level.f_46441_.m_188500_() * (double)mob.m_20206_();
                offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.0;
                level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, mob.m_20185_() + offsetX, mob.m_20186_() + offsetY + 0.5, mob.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (dist > 2.5 && now - (lastPearl = pd.m_128454_("p2pos_last_pearl")) >= (long)cooldown) {
                PossessedMobChaseAttackProcedure.throwEnderpearl(level, mob, tgt, pd, now, playerLooking);
            }
        } else if (type == FromTheCavesModEntities.POSSESSED_CRP.get()) {
            int swell = pd.m_128451_("p2pos_swell");
            if (dist > 5.0 && swell == 0) {
                pd.m_128405_("p2pos_swell", 1);
                double dx_ = tgt.m_20185_() - mob.m_20185_();
                double dz_ = tgt.m_20189_() - mob.m_20189_();
                double dy_ = tgt.m_20186_() - mob.m_20186_();
                double distSq = dx_ * dx_ + dy_ * dy_ + dz_ * dz_;
                double dist_ = Math.sqrt(distSq);
                double factor = (dist_ - 4.0) / 60.0;
                factor = Math.max(0.0, Math.min(1.0, factor));
                double jumpY = 0.4 + factor * 4.6;
                double jumpHoriz = 0.2 + factor * 4.8;
                double lenXZ = Math.sqrt(dx_ * dx_ + dz_ * dz_);
                double nx = lenXZ > 1.0E-6 ? dx_ / lenXZ : 0.0;
                double nz = lenXZ > 1.0E-6 ? dz_ / lenXZ : 0.0;
                double newVelX = nx * jumpHoriz;
                double newVelZ = nz * jumpHoriz;
                double newVelY = Math.max(mob.m_20184_().f_82480_, 0.0) + jumpY;
                mob.m_20334_(newVelX, newVelY, newVelZ);
                mob.m_6478_(MoverType.SELF, mob.m_20184_());
                mob.m_5496_((SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("entity.creeper.primed")), 1.0f, 1.0f);
            }
            if (swell > 0) {
                pd.m_128405_("p2pos_swell", ++swell);
                if (shouldUpdateNav) {
                    mob.m_21573_().m_5624_((Entity)tgt, 1.2);
                }
                if (swell >= 45) {
                    level.m_254849_((Entity)mob, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), 3.0f, Level.ExplosionInteraction.MOB);
                    mob.m_146870_();
                }
            }
        } else if (type == FromTheCavesModEntities.POSSESSED_SK.get()) {
            long angryTime = pd.m_128454_("p2pos_angry_time");
            isAngry = now - angryTime < 100L;
            int cooldown = isAngry ? 15 : 30;
            long lastArrow = pd.m_128454_("p2pos_last_arrow");
            if (now - lastArrow >= (long)cooldown) {
                Arrow arrow = new Arrow((Level)level, (LivingEntity)mob);
                Vec3 dir = tgt.m_146892_().m_82546_(mob.m_146892_()).m_82541_();
                arrow.m_20256_(dir.m_82490_(1.5));
                arrow.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
                arrow.m_5602_((Entity)mob);
                level.m_7967_((Entity)arrow);
                pd.m_128356_("p2pos_last_arrow", now);
            }
        } else if (type == FromTheCavesModEntities.POSSESSED_SP.get() && now - (lastCobweb = pd.m_128454_("p2pos_last_cobweb")) >= 40L) {
            Snowball projectile = new Snowball((Level)level, (LivingEntity)mob);
            projectile.getPersistentData().m_128379_("is_cobweb_projectile", true);
            Vec3 dir = tgt.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
            projectile.m_20256_(dir.m_82490_(1.5));
            projectile.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
            level.m_7967_((Entity)projectile);
            pd.m_128356_("p2pos_last_cobweb", now);
        }
        long lastAttack = pd.m_128454_("p2pos_lastAttack");
        if (dist < currentAttackRange && now - lastAttack >= 20L) {
            tgt.m_6469_(mob.m_269291_().m_269333_((LivingEntity)mob), currentAttackDamage);
            pd.m_128356_("p2pos_lastAttack", now);
        }
    }

    private static boolean isPlayerLooking(Mob mob, Player player, float fov) {
        Vec3 mobPos = mob.m_146892_();
        Vec3 playerPos = player.m_146892_();
        Vec3 toMob = mobPos.m_82546_(playerPos).m_82541_();
        float yawRad = (float)Math.toRadians(player.m_146908_());
        float pitchRad = (float)Math.toRadians(player.m_146909_());
        Vec3 playerLook = new Vec3(-Math.sin(yawRad) * Math.cos(pitchRad), -Math.sin(pitchRad), Math.cos(yawRad) * Math.cos(pitchRad)).m_82541_();
        double dot = toMob.m_82526_(playerLook);
        float angle = (float)Math.toDegrees(Math.acos(Math.max(-1.0, Math.min(1.0, dot))));
        return angle < fov / 2.0f;
    }

    private static void throwEnderpearl(ServerLevel level, Mob mob, Player tgt, CompoundTag pd, long now, boolean playerLooking) {
        Vec3 targetPos;
        if (playerLooking) {
            playerLook = new Vec3(-Math.sin(Math.toRadians(tgt.m_146908_())), 0.0, Math.cos(Math.toRadians(tgt.m_146908_()))).m_82541_();
            Vec3 sideVector = new Vec3(-playerLook.f_82481_, 0.0, playerLook.f_82479_).m_82541_();
            double sideMultiplier = level.f_46441_.m_188499_() ? 1.5 : -1.5;
            targetPos = tgt.m_20182_().m_82549_(playerLook.m_82490_(-2.0)).m_82549_(sideVector.m_82490_(sideMultiplier));
        } else {
            playerLook = new Vec3(-Math.sin(Math.toRadians(tgt.m_146908_())), 0.0, Math.cos(Math.toRadians(tgt.m_146908_()))).m_82541_();
            targetPos = tgt.m_20182_().m_82549_(playerLook.m_82490_(2.0));
        }
        ThrownEnderpearl pearl = new ThrownEnderpearl((Level)level, (LivingEntity)mob);
        Vec3 dir = targetPos.m_82546_(mob.m_146892_()).m_82541_();
        pearl.m_20256_(dir.m_82490_(1.5));
        pearl.m_6034_(mob.m_20185_(), mob.m_20186_() + (double)mob.m_20192_(), mob.m_20189_());
        level.m_7967_((Entity)pearl);
        mob.m_5496_((SoundEvent)BuiltInRegistries.f_256894_.m_7745_(new ResourceLocation("entity.ender_pearl.throw")), 1.0f, 1.0f / (level.f_46441_.m_188501_() * 0.4f + 0.8f));
        pd.m_128356_("p2pos_last_pearl", now);
    }
}

