/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnBehindMobProcedure {
    private static final double BASE_PROB = 4.5E-5;
    private static final double MAX_PROB = 6.0E-5;
    private static final double MIN_SPAWN_DIST = 2.0;
    private static final double MAX_SPAWN_DIST = 6.0;
    private static final double LOOK_FOV_COS = Math.cos(Math.toRadians(50.0));
    private static final int DESPAWN_DELAY_TICKS = 8;
    private static final double MOVE_SPEED = 0.2;
    private static final double MIN_DISTANCE_DESPAWN = 0.5;
    private static final double MAX_DISTANCE_DESPAWN = 60.0;
    private static final double TARGET_DISTANCE_BEHIND = 2.0;
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 1200L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player.m_20186_() >= 50.0) {
            return;
        }
        long now = server.m_46467_();
        Long lastSpawn = playerCooldowns.get(player.m_20148_());
        if (lastSpawn != null && now - lastSpawn < 1200L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 4.5E-5, 6.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        Vec3 lookDir = player.m_20154_();
        Vec3 behindDir = new Vec3(-lookDir.f_82479_, 0.0, -lookDir.f_82481_);
        double len = Math.sqrt(behindDir.f_82479_ * behindDir.f_82479_ + behindDir.f_82481_ * behindDir.f_82481_);
        if (len < 1.0E-6) {
            return;
        }
        behindDir = behindDir.m_82541_();
        double distance = 2.0 + Math.random() * 4.0;
        Vec3 playerPos = player.m_20182_();
        Vec3 spawnPos = playerPos.m_82549_(behindDir.m_82490_(distance));
        int spawnX = (int)Math.floor(spawnPos.f_82479_);
        int spawnY = (int)Math.floor(playerPos.f_82480_);
        int spawnZ = (int)Math.floor(spawnPos.f_82481_);
        if (spawnY < server.m_141937_() + 1 || spawnY > server.m_151558_() - 2) {
            return;
        }
        Mob behind = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBEHIND.get()).m_20615_((Level)server);
        if (behind == null) {
            return;
        }
        behind.m_7678_(spawnPos.f_82479_, (double)spawnY, spawnPos.f_82481_, 0.0f, 0.0f);
        behind.m_21530_();
        behind.m_21557_(false);
        CompoundTag nbt = behind.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128379_("isBehindMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        server.m_7967_((Entity)behind);
        playerCooldowns.put(player.m_20148_(), now);
    }

    @SubscribeEvent
    public static void onBehindMobTick(LivingEvent.LivingTickEvent ev) {
        double distToPlayerSq;
        double distToPlayer;
        UUID targetId;
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isBehindMob")) {
            return;
        }
        if (!nbt.m_128403_("targetUUID")) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        Player target = server.m_46003_(targetId = nbt.m_128342_("targetUUID"));
        if (target == null) {
            mob.m_146870_();
            return;
        }
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        if (toPlayer.m_82556_() > 1.0E-6) {
            Vec3 toPlayerNorm = toPlayer.m_82541_();
            float yaw = (float)(Math.atan2(toPlayerNorm.f_82481_, toPlayerNorm.f_82479_) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
        Vec3 playerLookDir = target.m_20154_();
        Vec3 behindDir = new Vec3(-playerLookDir.f_82479_, 0.0, -playerLookDir.f_82481_);
        double len = Math.sqrt(behindDir.f_82479_ * behindDir.f_82479_ + behindDir.f_82481_ * behindDir.f_82481_);
        if (len > 1.0E-6) {
            behindDir = behindDir.m_82541_();
        } else {
            Vec3 toMob = mob.m_20182_().m_82546_(target.m_20182_());
            behindDir = new Vec3(toMob.f_82479_, 0.0, toMob.f_82481_).m_82541_();
        }
        Vec3 targetPos = target.m_20182_().m_82549_(behindDir.m_82490_(2.0));
        Vec3 currentPos = mob.m_20182_();
        Vec3 toTarget = targetPos.m_82546_(currentPos);
        double distSqHorizontal = toTarget.f_82479_ * toTarget.f_82479_ + toTarget.f_82481_ * toTarget.f_82481_;
        if (distSqHorizontal > 0.01) {
            Vec3 moveDir = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_).m_82541_();
            Vec3 movement = moveDir.m_82490_(0.2);
            mob.m_20334_(movement.f_82479_, mob.m_20184_().f_82480_, movement.f_82481_);
            mob.f_19864_ = true;
            BlockPos targetBlockPos = new BlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
            mob.m_21573_().m_26519_((double)targetBlockPos.m_123341_() + 0.5, (double)targetBlockPos.m_123342_(), (double)targetBlockPos.m_123343_() + 0.5, 0.5);
        }
        if (mob.f_19797_ % 10 == 0) {
            Vec3 playerEyePos = target.m_20299_(1.0f);
            Vec3 playerLook = target.m_20154_().m_82541_();
            Vec3 toMob = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0).m_82546_(playerEyePos);
            double distToMob = toMob.m_82553_();
            if (distToMob > 1.0E-6 && distToMob < 30.0) {
                Vec3 toMobNorm = toMob.m_82490_(1.0 / distToMob);
                double dot = playerLook.m_82526_(toMobNorm);
                if (dot > LOOK_FOV_COS) {
                    int lookingTicks = nbt.m_128451_("lookingAtTicks");
                    nbt.m_128405_("lookingAtTicks", lookingTicks += 10);
                    if (lookingTicks >= 8) {
                        server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.HOSTILE, 1.0f, 0.7f);
                        mob.m_146870_();
                        return;
                    }
                } else {
                    nbt.m_128405_("lookingAtTicks", 0);
                }
            }
        }
        if ((distToPlayer = Math.sqrt(distToPlayerSq = mob.m_20280_((Entity)target))) < 0.5) {
            server.m_6263_(null, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.HOSTILE, 0.8f, 0.9f);
            mob.m_146870_();
            return;
        }
        if (distToPlayer > 60.0) {
            mob.m_146870_();
            return;
        }
        long spawnTick = nbt.m_128454_("spawnTick");
        long now = server.m_46467_();
        if (now - spawnTick > 3600L) {
            mob.m_146870_();
            return;
        }
    }

    public static void forceSpawn(ServerLevel level, Player player) {
        Vec3 lookDir = player.m_20154_();
        Vec3 behindDir = new Vec3(-lookDir.f_82479_, 0.0, -lookDir.f_82481_);
        double len = Math.sqrt(behindDir.f_82479_ * behindDir.f_82479_ + behindDir.f_82481_ * behindDir.f_82481_);
        if (len < 1.0E-6) {
            return;
        }
        behindDir = behindDir.m_82541_();
        double distance = 4.0;
        Vec3 playerPos = player.m_20182_();
        Vec3 spawnPos = playerPos.m_82549_(behindDir.m_82490_(distance));
        int spawnX = (int)Math.floor(spawnPos.f_82479_);
        int spawnY = (int)Math.floor(playerPos.f_82480_);
        int spawnZ = (int)Math.floor(spawnPos.f_82481_);
        Mob behind = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBEHIND.get()).m_20615_((Level)level);
        if (behind == null) {
            return;
        }
        behind.m_7678_(spawnPos.f_82479_, (double)spawnY, spawnPos.f_82481_, 0.0f, 0.0f);
        behind.m_21530_();
        behind.m_21557_(false);
        CompoundTag nbt = behind.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", level.m_46467_());
        nbt.m_128379_("isBehindMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        level.m_7967_((Entity)behind);
    }

    public static void cleanupOldCooldowns(long currentTick) {
        playerCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 2400L);
    }
}

