/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class AnvilEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int SOUND_DURATION = 100;
    private static final Map<Integer, AnvilEventState> activeEvents = new HashMap<Integer, AnvilEventState>();
    private static final Map<BlockPos, Long> anvilCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validAnvils = AnvilEventsProcedure.findValidAnvils(server, player);
        if (validAnvils.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validAnvils.removeIf(pos -> anvilCooldowns.containsKey(pos) && currentTime < anvilCooldowns.get(pos));
        if (validAnvils.isEmpty()) {
            return;
        }
        BlockPos chosen = validAnvils.get(server.m_213780_().m_188503_(validAnvils.size()));
        AnvilEvent event = AnvilEvent.values()[server.m_213780_().m_188503_(AnvilEvent.values().length)];
        anvilCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new AnvilEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, AnvilEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, AnvilEventState> entry = iterator.next();
            AnvilEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case ANVIL_LAND_SOUND: {
                    AnvilEventsProcedure.handleAnvilLandSound(server, state);
                    break;
                }
                case ANVIL_USE_SOUND: {
                    AnvilEventsProcedure.handleAnvilUseSound(server, state);
                }
            }
            if (state.tickCount < 100) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidAnvils(ServerLevel server, Player player) {
        ArrayList<BlockPos> anvils = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof AnvilBlock)) continue;
                    anvils.add(pos.m_7949_());
                }
            }
        }
        return anvils;
    }

    private static void handleAnvilLandSound(ServerLevel server, AnvilEventState state) {
        if (state.tickCount % 60 == 0) {
            server.m_5594_(null, state.anvilPos, SoundEvents.f_11668_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static void handleAnvilUseSound(ServerLevel server, AnvilEventState state) {
        if (state.tickCount % 20 == 0) {
            server.m_5594_(null, state.anvilPos, SoundEvents.f_11671_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static enum AnvilEvent {
        ANVIL_LAND_SOUND,
        ANVIL_USE_SOUND;

    }

    private static class AnvilEventState {
        AnvilEvent event;
        Player player;
        BlockPos anvilPos;
        int tickCount;

        AnvilEventState(AnvilEvent event, Player player, BlockPos anvilPos) {
            this.event = event;
            this.player = player;
            this.anvilPos = anvilPos;
            this.tickCount = 0;
        }
    }
}

