/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.NoAfectarProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MobsSuperInteligentesProcedure {
    private static final int BREAK_INTERVAL = 20;
    private static final int SWITCH_COOLDOWN = 20;
    private static final double BUILD_MAX_DIST_SQR = 400.0;
    private static final double BREAK_RANGE = 1.0;
    private static final double FOLLOW_SPEED = 0.7;
    private static final int DOLPHIN_GRACE_INTERVAL = 60;
    private static final int DOLPHIN_GRACE_DURATION = 60;
    private static final int WATER_PUSH_INTERVAL = 20;
    private static final double WATER_PUSH_STRENGTH = 0.3;
    private static final String FROZEN_KEY = "frozenWaterBlocks";

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent ev) {
        BlockPos below;
        Player player;
        if (!FromTheCavesToggleManagerProcedure.isMobsSuperInteligentesEnabled()) {
            return;
        }
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)ent;
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        if (NoAfectarProcedure.shouldSkip((Entity)mob)) {
            return;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null || !key.m_135827_().equals("from_the_caves")) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        MobsSuperInteligentesProcedure.processFrozenBlocks(server, mob);
        String idPath = key.m_135815_().toLowerCase();
        boolean isPossessed = idPath.startsWith("possessed_");
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128471_("jumpEnhanced")) {
            mob.m_7292_(new MobEffectInstance(MobEffects.f_19603_, Integer.MAX_VALUE, 1, false, false, false));
            data.m_128379_("jumpEnhanced", true);
        }
        mob.m_21441_(BlockPathTypes.WATER, 0.0f);
        if (MobsSuperInteligentesProcedure.isInOrTouchingWater(mob)) {
            long nextWaterPush;
            long nextDolphinGrace;
            long tick = server.m_46467_();
            if (tick >= (nextDolphinGrace = data.m_128454_("nextDolphinGraceTick"))) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 60, 0, false, true));
                data.m_128356_("nextDolphinGraceTick", tick + 60L);
            }
            if (tick >= (nextWaterPush = data.m_128454_("nextWaterPushTick"))) {
                Player near = server.m_45930_((Entity)mob, 10.0);
                if (near != null) {
                    Vec3 mobPos = mob.m_20182_();
                    Vec3 playerPos = near.m_146892_();
                    Vec3 dir = playerPos.m_82546_(mobPos).m_82541_();
                    mob.m_20256_(mob.m_20184_().m_82549_(dir.m_82490_(0.3)));
                }
                data.m_128356_("nextWaterPushTick", tick + 20L);
            }
        }
        if ((player = server.m_45930_((Entity)mob, 42.0)) == null) {
            return;
        }
        if (player.m_20183_().m_123342_() == mob.m_20183_().m_123342_() && server.m_6425_(below = mob.m_20183_().m_7495_()).m_76152_() == Fluids.f_76193_ && !MobsSuperInteligentesProcedure.isPosAlreadyFrozen(mob, below)) {
            server.m_46597_(below, Blocks.f_50449_.m_49966_());
            long expire = server.m_46467_() + 20L;
            MobsSuperInteligentesProcedure.addFrozenBlock(mob, below, expire);
        }
        mob.m_21573_().m_5624_((Entity)player, 0.7);
        if (!isPossessed && mob.m_21573_().m_26571_() && mob.f_19797_ % 20 == 0) {
            MobsSuperInteligentesProcedure.breakAdjacentBlocks(server, mob);
        }
        if (mob.m_21573_().m_26571_()) {
            BlockPos climbable;
            long nextSwitch;
            long tick = server.m_46467_();
            if (tick >= (nextSwitch = data.m_128454_("nextSwitchTick"))) {
                MobsSuperInteligentesProcedure.toggleNearbySwitches(server, mob, 2);
                data.m_128356_("nextSwitchTick", tick + 20L);
            }
            if ((climbable = MobsSuperInteligentesProcedure.findNearbyClimbable(server, mob.m_20183_(), 3)) != null) {
                mob.m_21573_().m_26519_((double)climbable.m_123341_() + 0.5, (double)climbable.m_123342_() + 0.5, (double)climbable.m_123343_() + 0.5, 0.7);
            }
        }
    }

    private static void processFrozenBlocks(ServerLevel server, PathfinderMob mob) {
        String[] entries;
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        if (raw == null || raw.isEmpty()) {
            return;
        }
        StringBuilder remaining = new StringBuilder();
        long tick = server.m_46467_();
        for (String e : entries = raw.split(";")) {
            if (e == null || e.isEmpty()) continue;
            try {
                String[] parts = e.split(":");
                if (parts.length < 4) continue;
                int x = Integer.parseInt(parts[0]);
                int y = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                long expire = Long.parseLong(parts[3]);
                BlockPos p = new BlockPos(x, y, z);
                if (tick >= expire) {
                    Block cur = server.m_8055_(p).m_60734_();
                    if (cur != Blocks.f_50449_ && cur != Blocks.f_50126_) continue;
                    server.m_46597_(p, Blocks.f_49990_.m_49966_());
                    continue;
                }
                remaining.append(x).append(":").append(y).append(":").append(z).append(":").append(expire).append(";");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mob.getPersistentData().m_128359_(FROZEN_KEY, remaining.toString());
    }

    private static boolean isPosAlreadyFrozen(PathfinderMob mob, BlockPos pos) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        if (raw == null || raw.isEmpty()) {
            return false;
        }
        String token = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":";
        return raw.contains(token);
    }

    private static void addFrozenBlock(PathfinderMob mob, BlockPos pos, long expireTick) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        String token = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":";
        if (raw != null && raw.contains(token)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (raw != null && !raw.isEmpty()) {
            sb.append(raw);
        }
        sb.append(pos.m_123341_()).append(":").append(pos.m_123342_()).append(":").append(pos.m_123343_()).append(":").append(expireTick).append(";");
        mob.getPersistentData().m_128359_(FROZEN_KEY, sb.toString());
    }

    private static boolean isPassableOrCandle(ServerLevel server, BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof CandleBlock || block instanceof CandleCakeBlock) {
            return true;
        }
        if (state.m_204336_(BlockTags.f_144265_)) {
            return true;
        }
        ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
        if (blockId != null && blockId.m_135815_().contains("candle")) {
            return true;
        }
        try {
            boolean isFullBlock;
            VoxelShape collisionShape = state.m_60812_((BlockGetter)server, pos);
            if (collisionShape.m_83281_()) {
                return true;
            }
            AABB bounds = collisionShape.m_83215_();
            boolean bl = isFullBlock = bounds.f_82288_ <= 0.0 && bounds.f_82289_ <= 0.0 && bounds.f_82290_ <= 0.0 && bounds.f_82291_ >= 1.0 && bounds.f_82292_ >= 1.0 && bounds.f_82293_ >= 1.0;
            if (!isFullBlock) {
                return true;
            }
        }
        catch (Throwable ignored) {
            return true;
        }
        return false;
    }

    private static void breakAdjacentBlocks(ServerLevel server, PathfinderMob mob) {
        BlockPos[] adj;
        BlockPos o = mob.m_20183_();
        for (BlockPos p : adj = new BlockPos[]{o.m_122012_(), o.m_122019_(), o.m_122029_(), o.m_122024_(), o.m_7494_()}) {
            BlockState st = server.m_8055_(p);
            if (st.m_60795_() || st.m_60800_((BlockGetter)server, p) < 0.0f || MobsSuperInteligentesProcedure.isPassableOrCandle(server, p, st) || ProtectedBlocksProcedure.isProtected(st)) continue;
            server.m_46961_(p, false);
            return;
        }
    }

    private static boolean isInOrTouchingWater(PathfinderMob mob) {
        if (mob.m_20069_()) {
            return true;
        }
        Level world = mob.m_9236_();
        BlockPos o = mob.m_20183_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || world.m_8055_(o.m_7918_(dx, 0, dz)).m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }

    private static void toggleNearbySwitches(ServerLevel server, PathfinderMob mob, int r) {
        BlockPos o = mob.m_20183_();
        BooleanProperty prop = BlockStateProperties.f_61448_;
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                for (int dz = -r; dz <= r; ++dz) {
                    BlockPos p = o.m_7918_(dx, dy, dz);
                    BlockState st = server.m_8055_(p);
                    if (st.m_61138_((Property)prop)) {
                        server.m_46597_(p, (BlockState)st.m_61124_((Property)prop, (Comparable)Boolean.valueOf((Boolean)st.m_61143_((Property)prop) == false)));
                        continue;
                    }
                    if (!(st.m_60734_() instanceof LeverBlock) && !(st.m_60734_() instanceof ButtonBlock) || !st.m_61138_((Property)prop)) continue;
                    server.m_46597_(p, (BlockState)st.m_61124_((Property)prop, (Comparable)Boolean.valueOf((Boolean)st.m_61143_((Property)prop) == false)));
                }
            }
        }
    }

    private static BlockPos findNearbyClimbable(ServerLevel server, BlockPos origin, int radius) {
        for (int r = 1; r <= radius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -1; dy <= 2; ++dy) {
                    for (int dz = -r; dz <= r; ++dz) {
                        BlockPos p = origin.m_7918_(dx, dy, dz);
                        Block block = server.m_8055_(p).m_60734_();
                        if (!(block instanceof StairBlock) && !(block instanceof LadderBlock)) continue;
                        return p;
                    }
                }
            }
        }
        return null;
    }
}

