/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RestoreBrokenBlocksManagerProcedure {
    private static final long RESTORE_DELAY_TICKS = 150L;
    private static final int GRAVITY_SCAN_RADIUS = 8;
    private static final int GRAVITY_SCAN_HEIGHT = 16;
    private static final Map<ResourceKey<Level>, List<BrokenBlockInfo>> pending = new HashMap<ResourceKey<Level>, List<BrokenBlockInfo>>();
    private static final Map<ResourceKey<Level>, Map<BlockPos, GravityBlockSnapshot>> gravityBlocks = new HashMap<ResourceKey<Level>, Map<BlockPos, GravityBlockSnapshot>>();

    private static boolean isGravityAffectedBlock(Block block) {
        if (block == Blocks.f_49992_) {
            return true;
        }
        if (block == Blocks.f_49993_) {
            return true;
        }
        if (block == Blocks.f_49994_) {
            return true;
        }
        if (block == Blocks.f_50322_) {
            return true;
        }
        if (block == Blocks.f_50323_) {
            return true;
        }
        if (block == Blocks.f_50324_) {
            return true;
        }
        if (block == Blocks.f_50506_) {
            return true;
        }
        if (block == Blocks.f_50507_) {
            return true;
        }
        if (block == Blocks.f_50508_) {
            return true;
        }
        if (block == Blocks.f_50509_) {
            return true;
        }
        if (block == Blocks.f_50510_) {
            return true;
        }
        if (block == Blocks.f_50511_) {
            return true;
        }
        if (block == Blocks.f_50512_) {
            return true;
        }
        if (block == Blocks.f_50513_) {
            return true;
        }
        if (block == Blocks.f_50514_) {
            return true;
        }
        if (block == Blocks.f_50515_) {
            return true;
        }
        if (block == Blocks.f_50516_) {
            return true;
        }
        if (block == Blocks.f_50517_) {
            return true;
        }
        if (block == Blocks.f_50518_) {
            return true;
        }
        if (block == Blocks.f_50519_) {
            return true;
        }
        if (block == Blocks.f_50573_) {
            return true;
        }
        if (block == Blocks.f_50574_) {
            return true;
        }
        if (block == Blocks.f_50260_) {
            return true;
        }
        return block == Blocks.f_50616_;
    }

    private static void captureGravityBlocksInArea(ServerLevel server, BlockPos centerPos) {
        if (!FromTheCavesToggleManagerProcedure.isAutoRestoreBrokenEnabled()) {
            return;
        }
        ResourceKey dim = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravityBlocks.get(dim);
        if (gravityMap == null) {
            gravityMap = new HashMap<BlockPos, GravityBlockSnapshot>();
            gravityBlocks.put((ResourceKey<Level>)dim, gravityMap);
        }
        long currentTick = server.m_46467_();
        for (int x = -8; x <= 8; ++x) {
            for (int y = -2; y <= 16; ++y) {
                for (int z = -8; z <= 8; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(checkPos);
                    Block block = state.m_60734_();
                    if (!RestoreBrokenBlocksManagerProcedure.isGravityAffectedBlock(block) || gravityMap.containsKey(checkPos)) continue;
                    BlockEntity be = server.m_7702_(checkPos);
                    CompoundTag beTag = null;
                    if (be != null && (beTag = RestoreBrokenBlocksManagerProcedure.getBlockEntityNbt(be)) == null) {
                        beTag = RestoreBrokenBlocksManagerProcedure.getBlockEntityNbtAlternative(be);
                    }
                    gravityMap.put(checkPos.m_7949_(), new GravityBlockSnapshot(checkPos.m_7949_(), state, beTag, currentTick));
                }
            }
        }
    }

    private static List<DependentBlockInfo> collectFallenGravityBlocks(ServerLevel server, BlockPos centerPos) {
        ArrayList<DependentBlockInfo> fallen = new ArrayList<DependentBlockInfo>();
        ResourceKey dim = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravityBlocks.get(dim);
        if (gravityMap == null || gravityMap.isEmpty()) {
            return fallen;
        }
        Iterator<Map.Entry<BlockPos, GravityBlockSnapshot>> it = gravityMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, GravityBlockSnapshot> entry = it.next();
            BlockPos originalPos = entry.getKey();
            GravityBlockSnapshot snapshot = entry.getValue();
            BlockState currentState = server.m_8055_(originalPos);
            if (!currentState.m_60795_() && currentState.m_60713_(snapshot.state.m_60734_())) continue;
            fallen.add(new DependentBlockInfo(snapshot.originalPos, snapshot.state, snapshot.blockEntityNbt));
            it.remove();
        }
        if (gravityMap.isEmpty()) {
            gravityBlocks.remove(dim);
        }
        return fallen;
    }

    private static boolean isDependentBlock(Block block) {
        if (block == Blocks.f_50088_) {
            return true;
        }
        if (block == Blocks.f_50174_) {
            return true;
        }
        if (block == Blocks.f_50123_) {
            return true;
        }
        if (block == Blocks.f_50146_) {
            return true;
        }
        if (block == Blocks.f_50328_) {
            return true;
        }
        if (block == Blocks.f_50164_) {
            return true;
        }
        if (block == Blocks.f_50124_) {
            return true;
        }
        if (block == Blocks.f_50251_) {
            return true;
        }
        if (block == Blocks.f_50252_) {
            return true;
        }
        if (block == Blocks.f_50253_) {
            return true;
        }
        if (block == Blocks.f_50254_) {
            return true;
        }
        if (block == Blocks.f_50308_) {
            return true;
        }
        if (block == Blocks.f_50309_) {
            return true;
        }
        if (block == Blocks.f_50669_) {
            return true;
        }
        if (block == Blocks.f_50670_) {
            return true;
        }
        if (block == Blocks.f_50710_) {
            return true;
        }
        if (block == Blocks.f_220846_) {
            return true;
        }
        if (block == Blocks.f_271396_) {
            return true;
        }
        if (block == Blocks.f_244625_) {
            return true;
        }
        if (block == Blocks.f_50081_) {
            return true;
        }
        if (block == Blocks.f_50082_) {
            return true;
        }
        if (block == Blocks.f_50139_) {
            return true;
        }
        if (block == Blocks.f_50140_) {
            return true;
        }
        if (block == Blocks.f_50683_) {
            return true;
        }
        if (block == Blocks.f_50684_) {
            return true;
        }
        if (block == Blocks.f_50156_) {
            return true;
        }
        if (block == Blocks.f_50030_) {
            return true;
        }
        if (block == Blocks.f_50031_) {
            return true;
        }
        if (block == Blocks.f_50285_) {
            return true;
        }
        if (block == Blocks.f_50336_) {
            return true;
        }
        if (block == Blocks.f_50337_) {
            return true;
        }
        if (block == Blocks.f_50338_) {
            return true;
        }
        if (block == Blocks.f_50339_) {
            return true;
        }
        if (block == Blocks.f_50340_) {
            return true;
        }
        if (block == Blocks.f_50341_) {
            return true;
        }
        if (block == Blocks.f_50342_) {
            return true;
        }
        if (block == Blocks.f_50343_) {
            return true;
        }
        if (block == Blocks.f_50344_) {
            return true;
        }
        if (block == Blocks.f_50345_) {
            return true;
        }
        if (block == Blocks.f_50346_) {
            return true;
        }
        if (block == Blocks.f_50347_) {
            return true;
        }
        if (block == Blocks.f_50348_) {
            return true;
        }
        if (block == Blocks.f_50349_) {
            return true;
        }
        if (block == Blocks.f_50350_) {
            return true;
        }
        if (block == Blocks.f_50351_) {
            return true;
        }
        if (block == Blocks.f_152543_) {
            return true;
        }
        if (block == Blocks.f_50165_) {
            return true;
        }
        if (block == Blocks.f_50167_) {
            return true;
        }
        if (block == Blocks.f_50168_) {
            return true;
        }
        if (block == Blocks.f_50169_) {
            return true;
        }
        if (block == Blocks.f_50170_) {
            return true;
        }
        if (block == Blocks.f_50171_) {
            return true;
        }
        if (block == Blocks.f_50172_) {
            return true;
        }
        if (block == Blocks.f_50659_) {
            return true;
        }
        if (block == Blocks.f_50660_) {
            return true;
        }
        if (block == Blocks.f_50709_) {
            return true;
        }
        if (block == Blocks.f_220840_) {
            return true;
        }
        if (block == Blocks.f_271227_) {
            return true;
        }
        if (block == Blocks.f_244183_) {
            return true;
        }
        if (block == Blocks.f_50326_) {
            return true;
        }
        if (block == Blocks.f_50327_) {
            return true;
        }
        if (block == Blocks.f_50112_) {
            return true;
        }
        if (block == Blocks.f_50111_) {
            return true;
        }
        if (block == Blocks.f_50113_) {
            return true;
        }
        if (block == Blocks.f_50114_) {
            return true;
        }
        if (block == Blocks.f_50115_) {
            return true;
        }
        if (block == Blocks.f_50116_) {
            return true;
        }
        if (block == Blocks.f_50117_) {
            return true;
        }
        if (block == Blocks.f_50118_) {
            return true;
        }
        if (block == Blocks.f_50119_) {
            return true;
        }
        if (block == Blocks.f_50120_) {
            return true;
        }
        if (block == Blocks.f_50121_) {
            return true;
        }
        if (block == Blocks.f_50071_) {
            return true;
        }
        if (block == Blocks.f_50070_) {
            return true;
        }
        if (block == Blocks.f_50355_) {
            return true;
        }
        if (block == Blocks.f_50356_) {
            return true;
        }
        if (block == Blocks.f_50357_) {
            return true;
        }
        if (block == Blocks.f_50358_) {
            return true;
        }
        if (block == Blocks.f_50359_) {
            return true;
        }
        if (block == Blocks.f_50360_) {
            return true;
        }
        if (block == Blocks.f_50072_) {
            return true;
        }
        if (block == Blocks.f_50073_) {
            return true;
        }
        if (block == Blocks.f_50036_) {
            return true;
        }
        if (block == Blocks.f_50034_) {
            return true;
        }
        if (block == Blocks.f_50035_) {
            return true;
        }
        if (block == Blocks.f_50130_) {
            return true;
        }
        if (block == Blocks.f_50092_) {
            return true;
        }
        if (block == Blocks.f_50249_) {
            return true;
        }
        if (block == Blocks.f_50250_) {
            return true;
        }
        if (block == Blocks.f_50444_) {
            return true;
        }
        if (block == Blocks.f_50685_) {
            return true;
        }
        if (block == Blocks.f_50095_) {
            return true;
        }
        if (block == Blocks.f_50149_) {
            return true;
        }
        if (block == Blocks.f_50150_) {
            return true;
        }
        if (block == Blocks.f_50152_) {
            return true;
        }
        if (block == Blocks.f_50151_) {
            return true;
        }
        if (block == Blocks.f_50153_) {
            return true;
        }
        if (block == Blocks.f_50673_) {
            return true;
        }
        if (block == Blocks.f_50674_) {
            return true;
        }
        if (block == Blocks.f_220841_) {
            return true;
        }
        if (block == Blocks.f_271516_) {
            return true;
        }
        if (block == Blocks.f_244433_) {
            return true;
        }
        if (block == Blocks.f_50158_) {
            return true;
        }
        if (block == Blocks.f_50159_) {
            return true;
        }
        if (block == Blocks.f_50160_) {
            return true;
        }
        if (block == Blocks.f_50162_) {
            return true;
        }
        if (block == Blocks.f_50161_) {
            return true;
        }
        if (block == Blocks.f_50163_) {
            return true;
        }
        if (block == Blocks.f_50675_) {
            return true;
        }
        if (block == Blocks.f_50676_) {
            return true;
        }
        if (block == Blocks.f_220839_) {
            return true;
        }
        if (block == Blocks.f_271107_) {
            return true;
        }
        if (block == Blocks.f_244608_) {
            return true;
        }
        if (block == Blocks.f_50155_) {
            return true;
        }
        if (block == Blocks.f_50616_) {
            return true;
        }
        if (block == Blocks.f_50681_) {
            return true;
        }
        if (block == Blocks.f_50682_) {
            return true;
        }
        if (block == Blocks.f_50184_) {
            return true;
        }
        if (block == Blocks.f_50145_) {
            return true;
        }
        return block == Blocks.f_50125_;
    }

    private static List<DependentBlockInfo> findDependentBlocks(ServerLevel server, BlockPos pos) {
        ArrayList<DependentBlockInfo> dependents = new ArrayList<DependentBlockInfo>();
        RestoreBrokenBlocksManagerProcedure.checkAndAddDependent(server, pos.m_7494_(), dependents);
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            RestoreBrokenBlocksManagerProcedure.checkAndAddDependent(server, pos.m_121945_(dir), dependents);
        }
        RestoreBrokenBlocksManagerProcedure.checkAndAddDependent(server, pos.m_7495_(), dependents);
        return dependents;
    }

    private static void checkAndAddDependent(ServerLevel server, BlockPos checkPos, List<DependentBlockInfo> list) {
        BlockState state = server.m_8055_(checkPos);
        Block block = state.m_60734_();
        if (RestoreBrokenBlocksManagerProcedure.isDependentBlock(block)) {
            BlockEntity be = server.m_7702_(checkPos);
            CompoundTag beTag = null;
            if (be != null) {
                beTag = RestoreBrokenBlocksManagerProcedure.getBlockEntityNbt(be);
            }
            list.add(new DependentBlockInfo(checkPos.m_7949_(), state, beTag));
        }
    }

    public static void destroyAndRecord(ServerLevel server, BlockPos pos) {
        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, pos, false);
    }

    public static void destroyAndRecord(ServerLevel server, BlockPos pos, boolean dropItems) {
        if (server == null || pos == null) {
            return;
        }
        BlockState state = server.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        boolean isGravityBlock = RestoreBrokenBlocksManagerProcedure.isGravityAffectedBlock(state.m_60734_());
        if (isGravityBlock) {
            RestoreBrokenBlocksManagerProcedure.captureGravityBlocksInArea(server, pos);
        }
        List<DependentBlockInfo> dependents = RestoreBrokenBlocksManagerProcedure.findDependentBlocks(server, pos);
        BlockEntity be = server.m_7702_(pos);
        CompoundTag beTag = null;
        if (be != null && (beTag = RestoreBrokenBlocksManagerProcedure.getBlockEntityNbt(be)) == null) {
            beTag = RestoreBrokenBlocksManagerProcedure.getBlockEntityNbtAlternative(be);
        }
        for (DependentBlockInfo dep : dependents) {
            try {
                server.m_46961_(dep.pos, false);
            }
            catch (Throwable t) {
                try {
                    server.m_7731_(dep.pos, Blocks.f_50016_.m_49966_(), 3);
                }
                catch (Throwable throwable) {}
            }
        }
        boolean destroyed = false;
        try {
            destroyed = server.m_46961_(pos, dropItems);
        }
        catch (Throwable t) {
            try {
                server.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                destroyed = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (isGravityBlock) {
            server.m_7654_().execute(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                List<DependentBlockInfo> fallenBlocks = RestoreBrokenBlocksManagerProcedure.collectFallenGravityBlocks(server, pos);
                if (!fallenBlocks.isEmpty()) {
                    dependents.addAll(fallenBlocks);
                }
            });
        }
        if (!FromTheCavesToggleManagerProcedure.isAutoRestoreBrokenEnabled()) {
            return;
        }
        long restoreTick = server.m_46467_() + 150L;
        ResourceKey dim = server.m_46472_();
        List<BrokenBlockInfo> list = pending.get(dim);
        if (list == null) {
            list = new ArrayList<BrokenBlockInfo>();
            pending.put((ResourceKey<Level>)dim, list);
        }
        list.add(new BrokenBlockInfo(pos.m_7949_(), state, beTag, restoreTick, dependents));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.level.f_46443_) {
            return;
        }
        Level level = ev.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        RestoreBrokenBlocksManagerProcedure.cleanupOldGravitySnapshots(server);
        ResourceKey dim = server.m_46472_();
        List<BrokenBlockInfo> list = pending.get(dim);
        if (list == null || list.isEmpty()) {
            return;
        }
        long now = server.m_46467_();
        Iterator<BrokenBlockInfo> it = list.iterator();
        while (it.hasNext()) {
            BrokenBlockInfo info = it.next();
            if (now < info.restoreAtTick) continue;
            try {
                BlockEntity be;
                boolean restored = false;
                for (int attempt = 0; attempt < 3; ++attempt) {
                    try {
                        server.m_7731_(info.pos, info.state, 3);
                        restored = true;
                        break;
                    }
                    catch (Throwable throwable) {
                        continue;
                    }
                }
                if (restored && info.blockEntityNbt != null && (be = server.m_7702_(info.pos)) != null) {
                    for (int attempt = 0; attempt < 3; ++attempt) {
                        try {
                            RestoreBrokenBlocksManagerProcedure.restoreBlockEntityFromNbt(be, info.blockEntityNbt);
                            be.m_6596_();
                            server.m_7260_(info.pos, info.state, info.state, 3);
                            break;
                        }
                        catch (Throwable throwable) {
                            continue;
                        }
                    }
                }
                for (DependentBlockInfo dep : info.dependents) {
                    try {
                        BlockEntity depBe;
                        server.m_7731_(dep.pos, dep.state, 3);
                        if (dep.blockEntityNbt == null || (depBe = server.m_7702_(dep.pos)) == null) continue;
                        try {
                            RestoreBrokenBlocksManagerProcedure.restoreBlockEntityFromNbt(depBe, dep.blockEntityNbt);
                            depBe.m_6596_();
                        }
                        catch (Throwable throwable) {
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            finally {
                it.remove();
            }
        }
        if (list.isEmpty()) {
            pending.remove(dim);
        }
    }

    private static void cleanupOldGravitySnapshots(ServerLevel server) {
        ResourceKey dim = server.m_46472_();
        Map<BlockPos, GravityBlockSnapshot> gravityMap = gravityBlocks.get(dim);
        if (gravityMap == null || gravityMap.isEmpty()) {
            return;
        }
        long now = server.m_46467_();
        long maxAge = 200L;
        gravityMap.entrySet().removeIf(entry -> now - ((GravityBlockSnapshot)entry.getValue()).capturedTick > maxAge);
        if (gravityMap.isEmpty()) {
            gravityBlocks.remove(dim);
        }
    }

    private static CompoundTag getBlockEntityNbt(BlockEntity be) {
        String[] writeIntoMethods;
        String[] zeroArgReturnMethods;
        if (be == null) {
            return null;
        }
        for (String mName : zeroArgReturnMethods = new String[]{"saveWithFullMetadata", "saveWithId", "saveWithoutMetadata", "createNbtWithIdentifyingData", "createNbt", "createNbtWithId", "serializeNBT", "toTag", "save"}) {
            try {
                Method m = be.getClass().getMethod(mName, new Class[0]);
                Object r = m.invoke((Object)be, new Object[0]);
                if (!(r instanceof CompoundTag)) continue;
                return (CompoundTag)r;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException m) {
                // empty catch block
            }
        }
        for (String mName : writeIntoMethods = new String[]{"save", "saveAdditional", "writeNbt", "write", "writeToNbt"}) {
            try {
                Method m = be.getClass().getMethod(mName, CompoundTag.class);
                CompoundTag tag = new CompoundTag();
                Object r = m.invoke((Object)be, tag);
                if (r instanceof CompoundTag) {
                    return (CompoundTag)r;
                }
                return tag;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        }
        try {
            Method m = be.getClass().getDeclaredMethod("saveAdditional", CompoundTag.class);
            m.setAccessible(true);
            CompoundTag tag = new CompoundTag();
            m.invoke((Object)be, tag);
            return tag;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private static CompoundTag getBlockEntityNbtAlternative(BlockEntity be) {
        if (be == null) {
            return null;
        }
        try {
            CompoundTag tag = new CompoundTag();
            be.m_187476_(new ItemStack((ItemLike)Items.f_41905_));
            return tag;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void restoreBlockEntityFromNbt(BlockEntity be, CompoundTag tag) {
        String[] loadMethods;
        if (be == null || tag == null) {
            return;
        }
        for (String mName : loadMethods = new String[]{"load", "readNbt", "deserializeNBT", "fromTag", "read"}) {
            try {
                Method m = be.getClass().getMethod(mName, CompoundTag.class);
                m.invoke((Object)be, tag);
                return;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            }
        }
        try {
            Method m = be.getClass().getDeclaredMethod("load", CompoundTag.class);
            m.setAccessible(true);
            m.invoke((Object)be, tag);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return;
        }
    }

    private static class GravityBlockSnapshot {
        final BlockPos originalPos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final long capturedTick;

        GravityBlockSnapshot(BlockPos originalPos, BlockState state, CompoundTag blockEntityNbt, long capturedTick) {
            this.originalPos = originalPos;
            this.state = state;
            this.blockEntityNbt = blockEntityNbt;
            this.capturedTick = capturedTick;
        }
    }

    private static class DependentBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final CompoundTag blockEntityNbt;

        DependentBlockInfo(BlockPos pos, BlockState state, CompoundTag blockEntityNbt) {
            this.pos = pos;
            this.state = state;
            this.blockEntityNbt = blockEntityNbt;
        }
    }

    private static class BrokenBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final CompoundTag blockEntityNbt;
        final long restoreAtTick;
        final List<DependentBlockInfo> dependents;

        BrokenBlockInfo(BlockPos pos, BlockState state, CompoundTag blockEntityNbt, long restoreAtTick, List<DependentBlockInfo> dependents) {
            this.pos = pos;
            this.state = state;
            this.blockEntityNbt = blockEntityNbt;
            this.restoreAtTick = restoreAtTick;
            this.dependents = dependents != null ? dependents : new ArrayList();
        }
    }
}

