/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2FLYINGEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnPhase2FlyingProcedure {
    private static final double BASE_PROB = 0.0045;
    private static final double MAX_PROB = 0.0055;
    private static final double MIN_HEIGHT_OFFSET = 15.0;
    private static final double MAX_HEIGHT_OFFSET = 20.0;
    private static final double HORIZONTAL_SPAWN_RADIUS = 12.0;
    private static final long STALK_DURATION = 240L;
    private static final double DRIFT_SPEED = 0.2;
    private static final long DRIFT_INTERVAL = 20L;
    private static final double IMPULSE_SPEED = 5.0;
    private static final double MAX_DIST_SQ = 400.0;
    private static final long MAX_LIFETIME = 300L;
    private static final double LOOK_FOV_COS = Math.cos(Math.toRadians(55.0));
    private static final int DETECTION_THRESHOLD = 30;
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 1900L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 2) {
            return;
        }
        long dayTime = level.m_6106_().m_6792_() % 24000L;
        if (dayTime <= 12000L || player.m_20186_() < 55.0) {
            return;
        }
        long now = level.m_46467_();
        Long lastSpawn = playerCooldowns.get(player.m_20148_());
        if (lastSpawn != null && now - lastSpawn < 1900L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 0.0045, 0.0055);
        if (Math.random() >= dynamicProb) {
            return;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double horizontalDist = Math.random() * 12.0;
        double offsetX = Math.cos(angle) * horizontalDist;
        double offsetZ = Math.sin(angle) * horizontalDist;
        double heightOffset = 15.0 + Math.random() * 5.0;
        double spawnX = player.m_20185_() + offsetX;
        double spawnY = player.m_20186_() + heightOffset;
        double spawnZ = player.m_20189_() + offsetZ;
        if (spawnY >= (double)(level.m_151558_() - 2)) {
            return;
        }
        Entity spawned = ((EntityType)FromTheCavesModEntities.FROMTHECAVES_2_FLYING.get()).m_262496_(level, BlockPos.m_274561_((double)spawnX, (double)spawnY, (double)spawnZ), MobSpawnType.MOB_SUMMONED);
        if (spawned instanceof FROMTHECAVES2FLYINGEntity) {
            FROMTHECAVES2FLYINGEntity fly = (FROMTHECAVES2FLYINGEntity)spawned;
            fly.m_21557_(false);
            fly.m_21530_();
            fly.m_20242_(true);
            fly.f_19794_ = true;
            double initialAngle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double vx0 = Math.cos(initialAngle) * 0.2;
            double vz0 = Math.sin(initialAngle) * 0.2;
            fly.m_20334_(vx0, 0.0, vz0);
            CompoundTag nbt = fly.getPersistentData();
            nbt.m_128356_("spawnTick", now);
            nbt.m_128347_("originX", spawnX);
            nbt.m_128347_("originY", spawnY);
            nbt.m_128347_("originZ", spawnZ);
            nbt.m_128362_("targetUUID", player.m_20148_());
            nbt.m_128379_("isFlyingStalker", true);
            nbt.m_128405_("detectionTicks", 0);
            nbt.m_128379_("hasImpulsed", false);
            playerCooldowns.put(player.m_20148_(), now);
        }
    }

    @SubscribeEvent
    public static void onFlyingStalkerTick(LivingEvent.LivingTickEvent event) {
        double distToPlayer;
        boolean hasImpulsed;
        ServerPlayer target;
        Level level;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof FROMTHECAVES2FLYINGEntity)) {
            return;
        }
        FROMTHECAVES2FLYINGEntity fly = (FROMTHECAVES2FLYINGEntity)entity;
        Level worldAcc = fly.m_9236_();
        if (!(worldAcc instanceof Level) || (level = worldAcc).m_5776_()) {
            return;
        }
        CompoundTag nbt = fly.getPersistentData();
        if (!nbt.m_128471_("isFlyingStalker")) {
            return;
        }
        if (!nbt.m_128403_("targetUUID")) {
            return;
        }
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)worldAcc) != 2) {
            fly.m_146870_();
            return;
        }
        long now = level.m_46467_();
        long spawnTick = nbt.m_128454_("spawnTick");
        long age = now - spawnTick;
        UUID targetId = nbt.m_128342_("targetUUID");
        ServerPlayer serverPlayer = target = level.m_7654_() != null ? level.m_7654_().m_6846_().m_11259_(targetId) : null;
        if (target == null) {
            fly.m_146870_();
            return;
        }
        Vec3 fromFlyEye = fly.m_20182_().m_82520_(0.0, (double)fly.m_20192_(), 0.0);
        Vec3 toPlayerEye = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        Vec3 dir = toPlayerEye.m_82546_(fromFlyEye);
        if (dir.m_82556_() > 1.0E-6) {
            Vec3 dirNorm = dir.m_82541_();
            double dx = dirNorm.f_82479_;
            double dy = dirNorm.f_82480_;
            double dz = dirNorm.f_82481_;
            float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
            float flat = (float)Math.sqrt(dx * dx + dz * dz);
            float pitch = (float)(-Math.atan2(dy, flat) * 180.0 / Math.PI);
            fly.m_146922_(yaw);
            fly.f_20883_ = yaw;
            fly.f_20885_ = yaw;
            fly.m_146926_(pitch);
        }
        if (!(hasImpulsed = nbt.m_128471_("hasImpulsed"))) {
            if (age < 240L) {
                if (age % 20L == 0L) {
                    double randomAngle = level.f_46441_.m_188500_() * Math.PI * 2.0;
                    double vx = Math.cos(randomAngle) * 0.2;
                    double vz = Math.sin(randomAngle) * 0.2;
                    fly.m_20334_(vx, fly.m_20184_().f_82480_, vz);
                }
                if (fly.f_19797_ % 10 == 0) {
                    Vec3 playerEyePos = target.m_20299_(1.0f);
                    Vec3 playerLook = target.m_20154_().m_82541_();
                    Vec3 toMob = fly.m_20182_().m_82520_(0.0, (double)fly.m_20192_() * 0.9, 0.0).m_82546_(playerEyePos);
                    double distToMob = toMob.m_82553_();
                    if (distToMob > 1.0E-6) {
                        Vec3 toMobNorm = toMob.m_82490_(1.0 / distToMob);
                        double dot = playerLook.m_82526_(toMobNorm);
                        if (dot > LOOK_FOV_COS) {
                            int detectionTicks = nbt.m_128451_("detectionTicks");
                            nbt.m_128405_("detectionTicks", detectionTicks += 10);
                            if (detectionTicks >= 30) {
                                SpawnPhase2FlyingProcedure.triggerImpulse(fly, level, nbt);
                                return;
                            }
                        } else {
                            int currentTicks = nbt.m_128451_("detectionTicks");
                            if (currentTicks > 0) {
                                nbt.m_128405_("detectionTicks", Math.max(0, currentTicks - 5));
                            }
                        }
                    }
                }
            } else {
                SpawnPhase2FlyingProcedure.triggerImpulse(fly, level, nbt);
            }
        } else {
            double dz;
            double ox = nbt.m_128459_("originX");
            double oz = nbt.m_128459_("originZ");
            double dx = fly.m_20185_() - ox;
            if (dx * dx + (dz = fly.m_20189_() - oz) * dz > 400.0 || age >= 300L) {
                fly.m_146870_();
                return;
            }
        }
        if ((distToPlayer = (double)fly.m_20270_((Entity)target)) > 60.0) {
            fly.m_146870_();
            return;
        }
    }

    private static void triggerImpulse(FROMTHECAVES2FLYINGEntity fly, Level level, CompoundTag nbt) {
        double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
        double vx = Math.cos(angle) * 5.0;
        double vz = Math.sin(angle) * 5.0;
        fly.m_20334_(vx, fly.m_20184_().f_82480_, vz);
        nbt.m_128379_("hasImpulsed", true);
    }

    public static void forceSpawn(ServerLevel level, Player player) {
        double angle = Math.random() * Math.PI * 2.0;
        double horizontalDist = 6.0;
        double offsetX = Math.cos(angle) * horizontalDist;
        double offsetZ = Math.sin(angle) * horizontalDist;
        double heightOffset = 17.5;
        double spawnX = player.m_20185_() + offsetX;
        double spawnY = player.m_20186_() + heightOffset;
        double spawnZ = player.m_20189_() + offsetZ;
        Entity spawned = ((EntityType)FromTheCavesModEntities.FROMTHECAVES_2_FLYING.get()).m_262496_(level, BlockPos.m_274561_((double)spawnX, (double)spawnY, (double)spawnZ), MobSpawnType.MOB_SUMMONED);
        if (spawned instanceof FROMTHECAVES2FLYINGEntity) {
            FROMTHECAVES2FLYINGEntity fly = (FROMTHECAVES2FLYINGEntity)spawned;
            fly.m_21557_(false);
            fly.m_21530_();
            fly.m_20242_(true);
            fly.f_19794_ = true;
            double initialAngle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double vx0 = Math.cos(initialAngle) * 0.2;
            double vz0 = Math.sin(initialAngle) * 0.2;
            fly.m_20334_(vx0, 0.0, vz0);
            long now = level.m_46467_();
            CompoundTag nbt = fly.getPersistentData();
            nbt.m_128356_("spawnTick", now);
            nbt.m_128347_("originX", spawnX);
            nbt.m_128347_("originY", spawnY);
            nbt.m_128347_("originZ", spawnZ);
            nbt.m_128362_("targetUUID", player.m_20148_());
            nbt.m_128379_("isFlyingStalker", true);
            nbt.m_128405_("detectionTicks", 0);
            nbt.m_128379_("hasImpulsed", false);
        }
    }

    public static void cleanupOldCooldowns(long currentTick) {
        playerCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 3800L);
    }
}

