/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class WatcherEyesProcedure {
    private static final double BASE_PROB = 8.5E-5;
    private static final double MAX_PROB = 1.0E-4;
    private static final double MIN_DIST = 10.0;
    private static final double MAX_DIST = 40.0;
    private static final double WATCH_DISTANCE = 64.0;
    private static final double CHASE_TRIGGER_DIST = 20.0;
    private static final int LOOK_TRIGGER_TICKS = 160;
    private static final double RUN_SPEED = 0.7;
    private static final int RUN_DURATION_TICKS = 160;
    private static final int BREAK_TICKS = 5;
    private static final int BREAK_SEARCH_AHEAD = 1;
    private static final double GRAVITY = 0.42;
    private static final double HIDE_SEARCH_RADIUS = 8.0;
    private static final double HIDE_CHECK_INTERVAL = 10.0;
    private static final double HIDE_MIN_COVER = 0.6;
    private static final double DESCEND_PREFER_CHANCE = 0.7;
    private static final double BURROW_SPEED = 0.3;
    private static final int BURROW_BREAK_TICKS = 3;
    private static final double DESPAWN_BEHIND_COVER_DIST = 25.0;
    private static final int DESPAWN_HIDDEN_TICKS = 60;
    private static final double AGGRESSIVE_PROB = 0.0;
    private static final double DIG_HEALTH_RATIO = 0.3;
    private static final int DIG_BREAK_TICKS = 6;
    private static final int DIG_DURATION_TICKS = 80;
    private static final double DIG_DESCEND_SPEED = 0.45;
    private static final String KEY_SPAWN_TIME = "peyes_spawnTime";
    private static final String KEY_LOOK_START = "peyes_lookStart";
    private static final String KEY_RUNNING = "peyes_running";
    private static final String KEY_RUN_START = "peyes_runStart";
    private static final String KEY_LAST_BREAK = "peyes_lastBreakTick";
    private static final String KEY_AGGRESSIVE = "peyes_aggressive";
    private static final String KEY_DIGGING = "peyes_digging";
    private static final String KEY_DIG_START = "peyes_digStart";
    private static final String KEY_DIG_LAST_BREAK = "peyes_digLastBreak";
    private static final String KEY_HIDE_CHECK = "peyes_hideCheck";
    private static final String KEY_BURROWING = "peyes_burrowing";
    private static final String KEY_HIDDEN_START = "peyes_hiddenStart";
    private static final String KEY_PREFER_DESCEND = "peyes_preferDescend";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (player.m_20186_() >= 50.0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase < 1 || phase > 3) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 8.5E-5, 1.0E-4);
        if (Math.random() >= dynamicProb) {
            return;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 10.0 + Math.random() * 30.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        double sy = player.m_20186_();
        Mob mob = (Mob)((EntityType)FromTheCavesModEntities.WATCHEYES.get()).m_262496_(level, BlockPos.m_274561_((double)sx, (double)sy, (double)sz), MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        BlockPos mPos = mob.m_20183_();
        if (!level.m_8055_(mPos).m_60795_()) {
            mob.m_146870_();
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        CompoundTag data = mob.getPersistentData();
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_RUNNING, false);
        data.m_128473_(KEY_LOOK_START);
        data.m_128473_(KEY_RUN_START);
        data.m_128405_(KEY_LAST_BREAK, 0);
        data.m_128405_(KEY_HIDE_CHECK, 0);
        data.m_128379_(KEY_BURROWING, false);
        data.m_128379_(KEY_PREFER_DESCEND, Math.random() < 0.7);
        boolean aggressive = Math.random() < 0.0;
        data.m_128379_(KEY_AGGRESSIVE, aggressive);
        data.m_128379_(KEY_DIGGING, false);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!mob.m_6095_().equals(FromTheCavesModEntities.WATCHEYES.get())) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 64.0);
        if (player == null && !data.m_128471_(KEY_DIGGING)) {
            return;
        }
        if (data.m_128471_(KEY_DIGGING)) {
            WatcherEyesProcedure.handleDigging(mob, data, level, now);
            return;
        }
        double dist = player != null ? (double)mob.m_20270_((Entity)player) : Double.MAX_VALUE;
        boolean running = data.m_128471_(KEY_RUNNING);
        boolean aggressive = data.m_128471_(KEY_AGGRESSIVE);
        if (!running) {
            if (player != null) {
                double dx = player.m_20185_() - mob.m_20185_();
                double dz = player.m_20189_() - mob.m_20189_();
                float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                mob.m_146922_(yaw);
                mob.f_20883_ = yaw;
                mob.f_20885_ = yaw;
                mob.m_146926_(0.0f);
            }
            if (player != null) {
                boolean inSightCone;
                if (dist <= 20.0) {
                    WatcherEyesProcedure.startRunning(mob, data, now);
                    return;
                }
                boolean hasLOS = player.m_142582_((Entity)mob);
                Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
                Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
                if (toMob.m_82553_() == 0.0) {
                    if (data.m_128441_(KEY_LOOK_START)) {
                        data.m_128473_(KEY_LOOK_START);
                    }
                    return;
                }
                Vec3 toMobNorm = toMob.m_82541_();
                double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
                boolean bl = inSightCone = dot > 0.95 && hasLOS;
                if (inSightCone) {
                    if (!data.m_128441_(KEY_LOOK_START)) {
                        data.m_128356_(KEY_LOOK_START, now);
                    } else {
                        long started = data.m_128454_(KEY_LOOK_START);
                        if (now - started >= 160L) {
                            WatcherEyesProcedure.startRunning(mob, data, now);
                            return;
                        }
                    }
                } else if (data.m_128441_(KEY_LOOK_START)) {
                    data.m_128473_(KEY_LOOK_START);
                }
            }
            return;
        }
        if (aggressive) {
            if (player == null) {
                mob.m_146870_();
                return;
            }
            try {
                mob.m_21557_(false);
                mob.m_20242_(false);
                mob.m_21573_().m_5624_((Entity)player, 0.9799999999999999);
            }
            catch (Throwable ex) {
                Vec3 dir = player.m_20182_().m_82546_(mob.m_20182_()).m_82541_();
                mob.m_20334_(dir.f_82479_ * 0.7 * 1.4, mob.m_20184_().f_82480_, dir.f_82481_ * 0.7 * 1.4);
                try {
                    mob.m_6478_(MoverType.SELF, mob.m_20184_());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            double distSq = mob.m_20280_((Entity)player);
            if (distSq <= 6.25) {
                try {
                    mob.m_7327_((Entity)player);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((double)mob.m_21223_() <= (double)mob.m_21233_() * 0.3) {
                WatcherEyesProcedure.startDigging(mob, data, now);
                return;
            }
            if (data.m_128441_(KEY_RUN_START) && now - data.m_128454_(KEY_RUN_START) >= 160L) {
                mob.m_146870_();
                return;
            }
            return;
        }
        WatcherEyesProcedure.handleFleeingBehavior(mob, data, level, player, now);
    }

    private static void handleFleeingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        BlockState bs;
        BlockPos below;
        if (player == null) {
            mob.m_146870_();
            return;
        }
        boolean burrowing = data.m_128471_(KEY_BURROWING);
        boolean preferDescend = data.m_128471_(KEY_PREFER_DESCEND);
        if (burrowing) {
            WatcherEyesProcedure.handleBurrowing(mob, data, level, player, now);
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 25.0) {
            if (!data.m_128441_(KEY_HIDDEN_START)) {
                data.m_128356_(KEY_HIDDEN_START, now);
            } else {
                long hiddenTime = now - data.m_128454_(KEY_HIDDEN_START);
                if (hiddenTime >= 60L) {
                    mob.m_146870_();
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_HIDDEN_START);
        }
        int hideCheck = data.m_128451_(KEY_HIDE_CHECK);
        data.m_128405_(KEY_HIDE_CHECK, ++hideCheck);
        Vec3 targetDir = null;
        if ((double)hideCheck >= 10.0) {
            Vec3 toHide;
            data.m_128405_(KEY_HIDE_CHECK, 0);
            BlockPos hideSpot = WatcherEyesProcedure.findBestHidingSpot(mob, player, level, preferDescend);
            if (hideSpot != null && (toHide = new Vec3((double)hideSpot.m_123341_() + 0.5 - mob.m_20185_(), (double)hideSpot.m_123342_() - mob.m_20186_(), (double)hideSpot.m_123343_() + 0.5 - mob.m_20189_())).m_82556_() > 1.0E-6) {
                targetDir = toHide.m_82541_();
            }
        }
        if (targetDir == null) {
            Vec3 fleeDir = new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_());
            if (fleeDir.m_82556_() < 1.0E-6) {
                Vec3 look = player.m_20252_(1.0f).m_82541_();
                fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
            }
            targetDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        }
        if (preferDescend && dist < 15.0 && level.m_46749_(below = mob.m_20183_().m_7495_()) && !(bs = level.m_8055_(below)).m_60795_() && bs.m_60734_() != Blocks.f_50752_ && !ProtectedBlocksProcedure.isProtected(bs)) {
            data.m_128379_(KEY_BURROWING, true);
            data.m_128405_(KEY_DIG_LAST_BREAK, 0);
            return;
        }
        mob.m_21557_(true);
        mob.m_20242_(false);
        double speedFactor = 0.63;
        BlockPos belowPos = mob.m_20183_().m_7495_();
        boolean onGround = true;
        if (level.m_46749_(belowPos)) {
            BlockState belowState = level.m_8055_(belowPos);
            onGround = !belowState.m_60795_();
        }
        double currentY = mob.m_20184_().f_82480_;
        double newY = onGround ? Math.min(currentY, 0.0) : currentY - 0.42;
        Vec3 motion = new Vec3(targetDir.f_82479_ * speedFactor, newY, targetDir.f_82481_ * speedFactor);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Vec3 predicted = new Vec3(mob.m_20185_() + motion.f_82479_, mob.m_20186_() + motion.f_82480_, mob.m_20189_() + motion.f_82481_);
        double dx = predicted.f_82479_ - mob.m_20185_();
        double dz = predicted.f_82481_ - mob.m_20189_();
        if (Math.abs(dx) < 1.0E-5 && Math.abs(dz) < 1.0E-5) {
            double nudge = 0.5;
            double nx = mob.m_20185_() + targetDir.f_82479_ * nudge;
            double nz = mob.m_20189_() + targetDir.f_82481_ * nudge;
            mob.m_6021_(nx, mob.m_20186_(), nz);
        }
        int lastBreak = data.m_128451_(KEY_LAST_BREAK);
        data.m_128405_(KEY_LAST_BREAK, ++lastBreak);
        if (lastBreak >= 5) {
            data.m_128405_(KEY_LAST_BREAK, 0);
            WatcherEyesProcedure.breakBlocksInPath(mob, level, targetDir);
        }
        if (data.m_128441_(KEY_RUN_START)) {
            long runStart = data.m_128454_(KEY_RUN_START);
            if (now - runStart >= 160L) {
                mob.m_146870_();
                return;
            }
        } else {
            data.m_128356_(KEY_RUN_START, now);
        }
        if ((double)mob.m_21223_() <= (double)mob.m_21233_() * 0.3) {
            WatcherEyesProcedure.startDigging(mob, data, now);
            return;
        }
    }

    private static void handleBurrowing(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        double dist;
        int last = data.m_128451_(KEY_DIG_LAST_BREAK);
        data.m_128405_(KEY_DIG_LAST_BREAK, ++last);
        if (last >= 3) {
            BlockState bs;
            data.m_128405_(KEY_DIG_LAST_BREAK, 0);
            BlockPos below = mob.m_20183_().m_7495_();
            if (level.m_46749_(below) && !(bs = level.m_8055_(below)).m_60795_() && bs.m_60734_() != Blocks.f_50752_ && !ProtectedBlocksProcedure.isProtected(bs)) {
                RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, below, false);
            }
        }
        Vec3 motion = new Vec3(0.0, -0.3, 0.0);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable bs) {
            // empty catch block
        }
        boolean hasLOS = player != null && player.m_142582_((Entity)mob);
        double d = dist = player != null ? (double)mob.m_20270_((Entity)player) : 100.0;
        if (!hasLOS && dist > 10.0) {
            mob.m_146870_();
            return;
        }
        if (mob.m_20186_() < player.m_20186_() - 8.0 || mob.m_20183_().m_123342_() <= 1) {
            mob.m_146870_();
            return;
        }
        if (!data.m_128441_(KEY_RUN_START)) {
            data.m_128356_(KEY_RUN_START, now);
        } else if (now - data.m_128454_(KEY_RUN_START) >= 160L) {
            mob.m_146870_();
            return;
        }
    }

    private static BlockPos findBestHidingSpot(Mob mob, Player player, ServerLevel level, boolean preferDescend) {
        BlockPos mobPos = mob.m_20183_();
        BlockPos bestSpot = null;
        double bestScore = -1000.0;
        int dx = -8;
        while ((double)dx <= 8.0) {
            for (int dy = -2; dy <= 2; ++dy) {
                int dz = -8;
                while ((double)dz <= 8.0) {
                    double score;
                    BlockState belowState;
                    BlockPos below;
                    BlockState state;
                    BlockPos testPos = mobPos.m_7918_(dx, dy, dz);
                    if (level.m_46749_(testPos) && (state = level.m_8055_(testPos)).m_60795_() && level.m_46749_(below = testPos.m_7495_()) && !(belowState = level.m_8055_(below)).m_60795_() && (score = WatcherEyesProcedure.evaluateHidingSpot(testPos, mob.m_20182_(), player, level, preferDescend)) > bestScore) {
                        bestScore = score;
                        bestSpot = testPos;
                    }
                    ++dz;
                }
            }
            ++dx;
        }
        return bestScore > 0.0 ? bestSpot : null;
    }

    private static double evaluateHidingSpot(BlockPos spot, Vec3 mobPos, Player player, ServerLevel level, boolean preferDescend) {
        double yDiff;
        Vec3 spotVec = new Vec3((double)spot.m_123341_() + 0.5, (double)spot.m_123342_() + 0.5, (double)spot.m_123343_() + 0.5);
        Vec3 playerPos = player.m_20182_();
        double distToPlayer = spotVec.m_82554_(playerPos);
        double distScore = Math.min(distToPlayer / 10.0, 5.0);
        double distFromMob = spotVec.m_82554_(mobPos);
        if (distFromMob > 6.4) {
            distScore -= 3.0;
        }
        Vec3 playerEye = new Vec3(playerPos.f_82479_, player.m_20188_(), playerPos.f_82481_);
        ClipContext ctx = new ClipContext(playerEye, spotVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hit = level.m_45547_(ctx);
        double coverScore = 0.0;
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            coverScore = 10.0;
        }
        double heightScore = 0.0;
        if (preferDescend && (yDiff = mobPos.f_82480_ - spotVec.f_82480_) > 0.0) {
            heightScore = yDiff * 2.0;
        }
        return distScore + coverScore + heightScore;
    }

    private static void breakBlocksInPath(Mob mob, ServerLevel level, Vec3 direction) {
        double aheadZ;
        double aheadY;
        double aheadX = mob.m_20185_() + direction.f_82479_ * 1.0;
        BlockPos aheadPos = BlockPos.m_274561_((double)aheadX, (double)(aheadY = mob.m_20186_()), (double)(aheadZ = mob.m_20189_() + direction.f_82481_ * 1.0));
        if (level.m_46749_(aheadPos)) {
            boolean destroyedAny = false;
            for (int dx = 0; dx <= 1; ++dx) {
                for (int dy = 0; dy <= 1; ++dy) {
                    for (int dz = 0; dz <= 1; ++dz) {
                        BlockState bs;
                        BlockPos p = aheadPos.m_7918_(dx, dy, dz);
                        if (!level.m_46749_(p) || (bs = level.m_8055_(p)).m_60795_() || bs.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(bs)) continue;
                        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, p, false);
                        destroyedAny = true;
                    }
                }
            }
            if (destroyedAny) {
                return;
            }
            BlockPos tryAbove = aheadPos.m_7494_();
            if (level.m_46749_(tryAbove)) {
                boolean destroyedAbove = false;
                for (int dx = 0; dx <= 1; ++dx) {
                    for (int dy = 0; dy <= 1; ++dy) {
                        for (int dz = 0; dz <= 1; ++dz) {
                            BlockState bs2;
                            BlockPos p = tryAbove.m_7918_(dx, dy, dz);
                            if (!level.m_46749_(p) || (bs2 = level.m_8055_(p)).m_60795_() || bs2.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(bs2)) continue;
                            RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, p, false);
                            destroyedAbove = true;
                        }
                    }
                }
                if (destroyedAbove) {
                    return;
                }
            }
        }
        BlockPos base = mob.m_20183_();
        for (int dxOff = -1; dxOff <= 0; ++dxOff) {
            for (int dyOff = -1; dyOff <= 0; ++dyOff) {
                for (int dzOff = -1; dzOff <= 0; ++dzOff) {
                    BlockState bs;
                    BlockPos p = base.m_7918_(dxOff, dyOff, dzOff);
                    if (!level.m_46749_(p) || (bs = level.m_8055_(p)).m_60795_() || bs.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(bs)) continue;
                    RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, p, false);
                    return;
                }
            }
        }
    }

    private static void startRunning(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RUNNING, true);
        data.m_128356_(KEY_RUN_START, now);
        data.m_128405_(KEY_LAST_BREAK, 0);
        mob.m_21557_(true);
        mob.m_20242_(false);
    }

    private static void startDigging(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_DIGGING, true);
        data.m_128356_(KEY_DIG_START, now);
        data.m_128405_(KEY_DIG_LAST_BREAK, 0);
        mob.m_21557_(true);
        mob.m_20242_(false);
    }

    private static void handleDigging(Mob mob, CompoundTag data, ServerLevel level, long now) {
        if (!data.m_128441_(KEY_DIG_START)) {
            data.m_128356_(KEY_DIG_START, now);
        }
        long digStart = data.m_128454_(KEY_DIG_START);
        long elapsed = now - digStart;
        int last = data.m_128451_(KEY_DIG_LAST_BREAK);
        data.m_128405_(KEY_DIG_LAST_BREAK, ++last);
        if (last >= 6) {
            BlockState bs;
            data.m_128405_(KEY_DIG_LAST_BREAK, 0);
            BlockPos below = mob.m_20183_().m_7495_();
            if (level.m_46749_(below) && !(bs = level.m_8055_(below)).m_60795_() && bs.m_60734_() != Blocks.f_50752_ && !ProtectedBlocksProcedure.isProtected(bs)) {
                RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, below, false);
            }
        }
        Vec3 motion = new Vec3(0.0, -0.45, 0.0);
        mob.m_20256_(motion);
        try {
            mob.m_6478_(MoverType.SELF, motion);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (elapsed >= 80L) {
            mob.m_146870_();
            return;
        }
        if (mob.m_20186_() < -16.0 || mob.m_20183_().m_123342_() <= 1) {
            mob.m_146870_();
            return;
        }
    }
}

