/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESMINEREntity;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MinerAIProcedure {
    private static final int BREAK_INTERVAL = 15;
    private static final int SIGHT_DELAY = 20;
    private static final int BLIND_TICKS = 100;
    private static final double FOLLOW_SPEED = 0.3;
    private static final double HIT_DISTANCE = 0.8;

    @SubscribeEvent
    public static void onMinerTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof FROMTHECAVESMINEREntity)) {
            return;
        }
        FROMTHECAVESMINEREntity miner = (FROMTHECAVESMINEREntity)ent;
        if (miner.m_9236_().m_5776_()) {
            return;
        }
        Level level = miner.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        if (!miner.getPersistentData().m_128471_("isMiner")) {
            return;
        }
        UUID tid = miner.getPersistentData().m_128342_("targetUUID");
        Player player = server.m_46003_(tid);
        if (player == null) {
            return;
        }
        CompoundTag nbt = miner.getPersistentData();
        long now = server.m_46467_();
        long firstSight = nbt.m_128454_("sightedTick");
        if (firstSight == 0L && player.m_142582_((Entity)miner)) {
            nbt.m_128356_("sightedTick", now);
        }
        if (miner.f_19797_ % 15 == 0) {
            MinerAIProcedure.breakNearbyBlock(server, miner, player);
        }
        if (firstSight > 0L && miner.m_21525_() && now >= firstSight + 20L) {
            miner.m_21557_(false);
        }
        if (!miner.m_21525_()) {
            Vec3 diff = player.m_20182_().m_82546_(miner.m_20182_());
            float yaw = (float)Math.toDegrees(Math.atan2(diff.f_82481_, diff.f_82479_)) - 90.0f;
            miner.m_146922_(yaw);
            miner.f_20885_ = yaw;
            miner.f_20883_ = yaw;
            Vec3 vel = diff.m_82541_().m_82490_(0.3);
            miner.m_20334_(vel.f_82479_, miner.m_20184_().f_82480_, vel.f_82481_);
            miner.m_6478_(MoverType.SELF, miner.m_20184_());
            if ((double)miner.m_20270_((Entity)player) < 0.8) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, true));
                SoundEvent cave = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("ambient.cave"));
                if (cave != null) {
                    server.m_6263_(null, miner.m_20185_(), miner.m_20186_(), miner.m_20189_(), cave, SoundSource.AMBIENT, 1.0f, 0.9f);
                }
                miner.m_146870_();
            }
        }
    }

    private static void breakNearbyBlock(ServerLevel server, FROMTHECAVESMINEREntity miner, Player player) {
        BlockPos mPos = miner.m_20183_();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    BlockPos pos;
                    BlockState state;
                    if (dx == 0 && dy == 0 && dz == 0 || (state = server.m_8055_(pos = mPos.m_7918_(dx, dy, dz))).m_60795_() || state.m_60734_() == Blocks.f_50752_) continue;
                    candidates.add(pos);
                }
            }
        }
        if (candidates.isEmpty()) {
            return;
        }
        Vec3 playerEye = player.m_20299_(1.0f);
        BlockPos target = candidates.stream().min(Comparator.comparingDouble(bp -> bp.m_203198_(playerEye.f_82479_, playerEye.f_82480_, playerEye.f_82481_))).orElse((BlockPos)candidates.get(0));
        server.m_46961_(target, true);
    }
}

