/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.client;

import java.util.List;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="from_the_caves", value={Dist.CLIENT})
public class SkyStormParticles {
    private static final double DETECTION_RADIUS = 120.0;
    private static final int RAIN_PARTICLE_RADIUS = 35;
    private static final int RAIN_DENSITY = 8;
    private static boolean skyMobNearby = false;
    private static int soundCooldown = 0;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        ClientLevel level = mc.f_91073_;
        LocalPlayer player = mc.f_91074_;
        AABB searchBox = new AABB(player.m_20185_() - 120.0, player.m_20186_() - 120.0, player.m_20189_() - 120.0, player.m_20185_() + 120.0, player.m_20186_() + 120.0, player.m_20189_() + 120.0);
        List nearbyEntities = level.m_6249_((Entity)null, searchBox, entity -> entity.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESSKY.get()));
        boolean bl = skyMobNearby = !nearbyEntities.isEmpty();
        if (!skyMobNearby) {
            return;
        }
        SkyStormParticles.spawnBloodRain(level, (Player)player);
        if (soundCooldown > 0) {
            --soundCooldown;
        } else if (level.f_46441_.m_188501_() < 0.05f) {
            soundCooldown = 40 + level.f_46441_.m_188503_(60);
            level.m_7785_(player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 20.0, player.m_20186_(), player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 20.0, SoundEvents.f_12541_, SoundSource.WEATHER, 0.5f, 1.0f, false);
        }
    }

    private static void spawnBloodRain(ClientLevel level, Player player) {
        for (int i = 0; i < 8; ++i) {
            double px = player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 35.0 * 2.0;
            double pz = player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 35.0 * 2.0;
            double py = player.m_20186_() + 10.0 + level.f_46441_.m_188500_() * 15.0;
            BlockPos checkPos = new BlockPos((int)px, (int)py, (int)pz);
            BlockPos groundPos = level.m_5452_(Heightmap.Types.MOTION_BLOCKING, checkPos);
            if ((double)groundPos.m_123342_() < py - 5.0) {
                py = groundPos.m_123342_() + 1;
            }
            level.m_7106_((ParticleOptions)ParticleTypes.f_123801_, px, py, pz, 0.0, -1.0, 0.0);
            if (level.f_46441_.m_188501_() < 0.4f) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123784_, px, py - 2.0, pz, (level.f_46441_.m_188500_() - 0.5) * 0.03, -0.05, (level.f_46441_.m_188500_() - 0.5) * 0.03);
            }
            if (py < player.m_20186_() + 3.0 && level.f_46441_.m_188501_() < 0.3f) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123802_, px, (double)groundPos.m_123342_() + 0.1, pz, (level.f_46441_.m_188500_() - 0.5) * 0.1, 0.01, (level.f_46441_.m_188500_() - 0.5) * 0.1);
            }
            if (!(level.f_46441_.m_188501_() < 0.2f)) continue;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123801_, px, player.m_20186_() + level.f_46441_.m_188500_() * 5.0, pz, (level.f_46441_.m_188500_() - 0.5) * 0.02, 0.01, (level.f_46441_.m_188500_() - 0.5) * 0.02);
        }
        if (level.f_46441_.m_188501_() < 0.01f) {
            double lx = player.m_20185_() + (level.f_46441_.m_188500_() - 0.5) * 80.0;
            double lz = player.m_20189_() + (level.f_46441_.m_188500_() - 0.5) * 80.0;
            BlockPos lightningPos = new BlockPos((int)lx, (int)player.m_20186_() + 20, (int)lz);
            for (int j = 0; j < 8; ++j) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123747_, (double)lightningPos.m_123341_() + level.f_46441_.m_188500_() - 0.5, (double)lightningPos.m_123342_() + level.f_46441_.m_188500_() * 40.0 - 20.0, (double)lightningPos.m_123343_() + level.f_46441_.m_188500_() - 0.5, 0.0, 0.0, 0.0);
            }
        }
    }
}

