/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.mcreator.fromthecaves.AudioCapture;
import net.mcreator.fromthecaves.client.gui.DbMeterSettingsScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class AudioDeviceSelectorScreen
extends Screen {
    private final Screen lastScreen;
    private List<String> audioDevices;
    private int scrollOffset = 0;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_SPACING = 20;
    private static final int MAX_VISIBLE = 5;

    public AudioDeviceSelectorScreen(Screen lastScreen) {
        super((Component)Component.m_237113_((String)"Select Audio Input Device"));
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        String[] devices = AudioCapture.getAudioDevices();
        this.audioDevices = new ArrayList<String>();
        for (String device : devices) {
            if (device == null || device.isEmpty()) continue;
            this.audioDevices.add(device);
        }
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"dB Meter Settings"), button -> this.f_96541_.m_91152_((Screen)new DbMeterSettingsScreen(this))).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 55, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Close"), button -> this.f_96541_.m_91152_(this.lastScreen)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, 20).m_253136_());
        if (this.scrollOffset > 0) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25b2 Scroll Up"), button -> {
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
                this.m_232761_();
            }).m_252987_(this.f_96543_ / 2 + 110, 50, 80, 20).m_253136_());
        }
        if (this.audioDevices.size() > 5 && this.scrollOffset < this.audioDevices.size() - 5) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25bc Scroll Down"), button -> {
                this.scrollOffset = Math.min(this.audioDevices.size() - 5, this.scrollOffset + 1);
                this.m_232761_();
            }).m_252987_(this.f_96543_ / 2 + 110, this.f_96544_ - 105, 80, 20).m_253136_());
        }
        int startY = 50;
        int endIndex = Math.min(this.audioDevices.size(), this.scrollOffset + 5);
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            boolean isSelected;
            String deviceName = this.audioDevices.get(i);
            int yPos = startY + (i - this.scrollOffset) * 20;
            String currentDevice = "";
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                currentDevice = this.f_96541_.f_91074_.getPersistentData().m_128461_("fromthecaves_selectedMixer");
            }
            Object buttonText = (isSelected = deviceName.equals(currentDevice)) ? "\u2713 " + deviceName : deviceName;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)buttonText), button -> this.selectDevice(deviceName)).m_252987_(this.f_96543_ / 2 - 200, yPos, 400, 20).m_253136_());
        }
    }

    private void selectDevice(String deviceName) {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.getPersistentData().m_128359_("fromthecaves_selectedMixer", deviceName);
            AudioCapture.stopCapture();
            AudioCapture.startCapture(deviceName);
            this.m_232761_();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        String info = "Select your audio input device for voice detection";
        guiGraphics.m_280137_(this.f_96547_, info, this.f_96543_ / 2, 35, 0xAAAAAA);
        String currentDevice = "";
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            currentDevice = this.f_96541_.f_91074_.getPersistentData().m_128461_("fromthecaves_selectedMixer");
        }
        if (currentDevice != null && !currentDevice.isEmpty()) {
            String current = "Current: " + (String)(currentDevice.length() > 40 ? currentDevice.substring(0, 37) + "..." : currentDevice);
            guiGraphics.m_280137_(this.f_96547_, current, this.f_96543_ / 2, this.f_96544_ - 70, 65280);
        }
        if (this.audioDevices.size() > 5) {
            String counter = String.format("Showing %d-%d of %d devices", this.scrollOffset + 1, Math.min(this.audioDevices.size(), this.scrollOffset + 5), this.audioDevices.size());
            guiGraphics.m_280137_(this.f_96547_, counter, this.f_96543_ / 2, this.f_96544_ - 85, 0xCCCCCC);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return true;
    }
}

