/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.Rotations;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ArmorStandEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_RADIUS = 16;
    private static final Map<Integer, ArmorStandEventState> activeEvents = new HashMap<Integer, ArmorStandEventState>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<ArmorStand> validStands = ArmorStandEventsProcedure.findValidArmorStands(server, player);
        if (validStands.isEmpty()) {
            return;
        }
        ArmorStand chosen = validStands.get(server.m_213780_().m_188503_(validStands.size()));
        ArmorStandEvent event = ArmorStandEvent.values()[server.m_213780_().m_188503_(ArmorStandEvent.values().length)];
        activeEvents.put(eventIdCounter++, new ArmorStandEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, ArmorStandEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ArmorStandEventState> entry = iterator.next();
            ArmorStandEventState state = entry.getValue();
            if (!state.armorStand.m_6084_() || state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                if (state.armorStand.m_6084_()) {
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                }
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case HEAD_TRACKING: {
                    ArmorStandEventsProcedure.handleHeadTracking(server, state);
                    if (state.tickCount < 200) break;
                    ArmorStandEventsProcedure.restoreOriginalPoses(state);
                    iterator.remove();
                    break;
                }
                case ARMOR_SHIMMER: {
                    ArmorStandEventsProcedure.handleArmorShimmer(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<ArmorStand> findValidArmorStands(ServerLevel server, Player player) {
        ArrayList<ArmorStand> stands = new ArrayList<ArmorStand>();
        for (Entity entity : server.m_8583_()) {
            if (!(entity instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)entity;
            if (!(entity.m_20280_((Entity)player) <= 256.0)) continue;
            stands.add(stand);
        }
        return stands;
    }

    private static void handleHeadTracking(ServerLevel server, ArmorStandEventState state) {
        if (state.tickCount % 10 != 0) {
            return;
        }
        double dx = state.player.m_20185_() - state.armorStand.m_20185_();
        double dy = state.player.m_20186_() + (double)state.player.m_20192_() - state.armorStand.m_20186_() - 1.5;
        double dz = state.player.m_20189_() - state.armorStand.m_20189_();
        float yaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float pitch = (float)(Mth.m_14136_((double)dy, (double)Math.sqrt(dx * dx + dz * dz)) * 57.29577951308232);
        float standYaw = state.armorStand.m_146908_();
        float relativeYaw = Mth.m_14177_((float)(yaw - standYaw));
        state.armorStand.m_31597_(new Rotations(Mth.m_14036_((float)pitch, (float)-45.0f, (float)45.0f), Mth.m_14036_((float)relativeYaw, (float)-75.0f, (float)75.0f), 0.0f));
    }

    private static void handleArmorShimmer(ServerLevel server, ArmorStandEventState state) {
        if (state.player.m_20280_((Entity)state.armorStand) > 36.0) {
            return;
        }
        if (state.tickCount % 5 == 0) {
            double x = state.armorStand.m_20185_();
            double y = state.armorStand.m_20186_() + 1.0;
            double z = state.armorStand.m_20189_();
            server.m_8767_((ParticleOptions)ParticleTypes.f_123809_, x, y, z, 2, 0.3, 0.5, 0.3, 0.1);
        }
    }

    private static void restoreOriginalPoses(ArmorStandEventState state) {
        if (state.armorStand.m_6084_()) {
            state.armorStand.m_31597_(state.originalHeadPose);
        }
    }

    private static enum ArmorStandEvent {
        HEAD_TRACKING,
        ARMOR_SHIMMER;

    }

    private static class ArmorStandEventState {
        ArmorStandEvent event;
        Player player;
        ArmorStand armorStand;
        int tickCount;
        Rotations originalHeadPose;

        ArmorStandEventState(ArmorStandEvent event, Player player, ArmorStand armorStand) {
            this.event = event;
            this.player = player;
            this.armorStand = armorStand;
            this.tickCount = 0;
            this.originalHeadPose = armorStand.m_31680_();
        }
    }
}

