/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashMap;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class ChunkTensionProcedure {
    private static final int DEFAULT_TICKS_PER_MINUTE = 1700;
    private static final int TICKS_PER_MINUTE_FOR_CROSS = 420;
    private static final double INCREMENT = 0.01;
    private static final double MAX_TENSION = 0.1;
    private static final double MIN_TENSION = 0.01;
    private static final double TENSION_RANGE = 0.09000000000000001;
    private static final int DEBUG_UPDATE_TICKS = 20;
    private static final double LEGACY_BASE_PROB = 4.0E-5;
    private static final double LEGACY_MAX_PROB = 5.5E-5;
    private static final ResourceLocation UPSIDE_DOWN_CROSS_RL = new ResourceLocation("from_the_caves", "upside_down_cross");
    private static Block CROSS_BLOCK_CACHE = null;

    public static double getDynamicProbability(ServerLevel server, Player player, double baseProb, double maxProb) {
        if (player == null || server == null || baseProb >= maxProb) {
            return baseProb;
        }
        int chunkX = (int)Math.floor(player.m_20185_() / 16.0);
        int chunkZ = (int)Math.floor(player.m_20189_() / 16.0);
        String key = "tension_" + chunkX + "_" + chunkZ;
        TensionSavedData tensionData = (TensionSavedData)server.m_8895_().m_164861_(TensionSavedData::new, TensionSavedData::new, "from_the_caves_tension");
        double tension = tensionData.getTension(key);
        tension = Math.max(0.01, Math.min(0.1, tension));
        double probDelta = (tension - 0.01) / 0.09000000000000001 * (maxProb - baseProb);
        return baseProb + probDelta;
    }

    public static double getDynamicProbability(ServerLevel server, Player player) {
        return ChunkTensionProcedure.getDynamicProbability(server, player, 4.0E-5, 5.5E-5);
    }

    public static void incrementTension(ServerLevel server, Player player) {
        if (player == null || server == null) {
            return;
        }
        int chunkX = (int)Math.floor(player.m_20185_() / 16.0);
        int chunkZ = (int)Math.floor(player.m_20189_() / 16.0);
        String key = "tension_" + chunkX + "_" + chunkZ;
        TensionSavedData tensionData = (TensionSavedData)server.m_8895_().m_164861_(TensionSavedData::new, TensionSavedData::new, "from_the_caves_tension");
        double current = tensionData.getTension(key);
        double newTension = Math.min(0.1, current + 0.01);
        tensionData.setTension(key, newTension);
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (player.getPersistentData().m_128471_("debugAdaptiveAI")) {
                sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(0, 40, 0));
                sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)" ")));
                sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)("Chunk Tension Increased: " + String.format("%.2f", newTension)))));
                sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)("Incremented in Chunk: " + chunkX + ", " + chunkZ))));
            }
        }
    }

    private static void sendDebugTitles(ServerLevel server, Player player, double tension, double prob, int chunkX, int chunkZ) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(0, 40, 0));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)" ")));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)("Tension: " + String.format("%.2f", tension) + " | Prob (Ejemplo): " + String.format("%.6f", prob)))));
            sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)("Chunk: " + chunkX + ", " + chunkZ))));
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"fromthecaves").then(Commands.m_82127_((String)"debugAdaptiveAI").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player."));
                return 0;
            }
            boolean current = player.getPersistentData().m_128471_("debugAdaptiveAI");
            boolean newState = !current;
            player.getPersistentData().m_128379_("debugAdaptiveAI", newState);
            source.m_288197_(() -> Component.m_237113_((String)("Debug mode " + (newState ? "enabled" : "disabled"))), false);
            return 1;
        })));
    }

    private static int getTicksPerMinuteForChunk(ServerLevel server, int chunkX, int chunkZ) {
        if (CROSS_BLOCK_CACHE == null && (CROSS_BLOCK_CACHE = (Block)ForgeRegistries.BLOCKS.getValue(UPSIDE_DOWN_CROSS_RL)) == null) {
            return 1700;
        }
        int startX = chunkX * 16;
        int startZ = chunkZ * 16;
        int maxY = server.m_151558_();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = startX; x < startX + 16; ++x) {
            for (int z = startZ; z < startZ + 16; ++z) {
                mutablePos.m_122178_(x, 0, z);
                if (!server.m_46749_((BlockPos)mutablePos)) continue;
                for (int y = 0; y < maxY; ++y) {
                    mutablePos.m_142448_(y);
                    if (server.m_8055_((BlockPos)mutablePos).m_60734_() != CROSS_BLOCK_CACHE) continue;
                    return 420;
                }
            }
        }
        return 1700;
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level world = player.m_9236_();
        if (world.m_5776_() || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        int chunkX = (int)Math.floor(player.m_20185_() / 16.0);
        int chunkZ = (int)Math.floor(player.m_20189_() / 16.0);
        int ticksPerMinute = ChunkTensionProcedure.getTicksPerMinuteForChunk(server, chunkX, chunkZ);
        int tickCount = player.f_19797_;
        if (tickCount > 0 && tickCount % ticksPerMinute == 0) {
            ChunkTensionProcedure.incrementTension(server, player);
        }
        if (tickCount % 20 == 0 && player.getPersistentData().m_128471_("debugAdaptiveAI")) {
            String key = "tension_" + chunkX + "_" + chunkZ;
            TensionSavedData tensionData = (TensionSavedData)server.m_8895_().m_164861_(TensionSavedData::new, TensionSavedData::new, "from_the_caves_tension");
            double tension = tensionData.getTension(key);
            double exampleBaseProb = 1.0E-5;
            double exampleMaxProb = 2.0E-5;
            double prob = ChunkTensionProcedure.getDynamicProbability(server, player, exampleBaseProb, exampleMaxProb);
            ChunkTensionProcedure.sendDebugTitles(server, player, tension, prob, chunkX, chunkZ);
        }
    }

    public static class TensionSavedData
    extends SavedData {
        private final Map<String, Double> tensions = new HashMap<String, Double>();

        public TensionSavedData() {
        }

        public TensionSavedData(CompoundTag tag) {
            ListTag list = tag.m_128437_("tensions", 10);
            for (Tag t : list) {
                CompoundTag ct = (CompoundTag)t;
                String key = ct.m_128461_("key");
                double val = ct.m_128459_("val");
                this.tensions.put(key, val);
            }
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            ListTag list = new ListTag();
            for (Map.Entry<String, Double> entry : this.tensions.entrySet()) {
                CompoundTag ct = new CompoundTag();
                ct.m_128359_("key", entry.getKey());
                ct.m_128347_("val", entry.getValue().doubleValue());
                list.add((Object)ct);
            }
            tag.m_128365_("tensions", (Tag)list);
            return tag;
        }

        public double getTension(String key) {
            return this.tensions.getOrDefault(key, 0.0);
        }

        public void setTension(String key, double val) {
            this.tensions.put(key, val);
            this.m_77762_();
        }
    }
}

