/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ItemFrameEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final Map<Integer, ItemFrameEventState> activeEvents = new HashMap<Integer, ItemFrameEventState>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<ItemFrame> validFrames = ItemFrameEventsProcedure.findValidItemFrames(server, player);
        if (validFrames.isEmpty()) {
            return;
        }
        ItemFrame chosen = validFrames.get(server.m_213780_().m_188503_(validFrames.size()));
        ItemFrameEvent event = ItemFrameEvent.values()[server.m_213780_().m_188503_(ItemFrameEvent.values().length)];
        activeEvents.put(eventIdCounter++, new ItemFrameEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, ItemFrameEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ItemFrameEventState> entry = iterator.next();
            ItemFrameEventState state = entry.getValue();
            if (!state.itemFrame.m_6084_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case ITEM_ROTATION: {
                    ItemFrameEventsProcedure.handleItemRotation(server, state);
                    if (state.tickCount < 1) break;
                    iterator.remove();
                    break;
                }
                case ITEM_TELEPORT: {
                    ItemFrameEventsProcedure.handleItemTeleport(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                    break;
                }
                case ITEM_EYE_TRANSFORM: {
                    ItemFrameEventsProcedure.handleEyeTransform(server, state);
                    if (state.tickCount < 160) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<ItemFrame> findValidItemFrames(ServerLevel server, Player player) {
        ArrayList<ItemFrame> frames = new ArrayList<ItemFrame>();
        int radius = 16;
        for (Entity entity : server.m_8583_()) {
            if (!(entity instanceof ItemFrame)) continue;
            ItemFrame frame = (ItemFrame)entity;
            if (!(entity.m_20280_((Entity)player) <= (double)(radius * radius)) || frame.m_31822_().m_41619_()) continue;
            frames.add(frame);
        }
        return frames;
    }

    private static void handleItemRotation(ServerLevel server, ItemFrameEventState state) {
        if (state.tickCount == 1) {
            if (server.m_213780_().m_188499_()) {
                double dx = state.player.m_20185_() - state.itemFrame.m_20185_();
                double dz = state.player.m_20189_() - state.itemFrame.m_20189_();
                float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                int rotation = Math.floorMod((int)(targetYaw / 45.0f), 8);
                state.itemFrame.m_31770_(Math.max(0, Math.min(7, rotation)));
            } else {
                state.itemFrame.m_31770_(server.m_213780_().m_188503_(8));
            }
            server.m_5594_(null, state.itemFrame.m_20183_(), SoundEvents.f_12017_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    private static void handleItemTeleport(ServerLevel server, ItemFrameEventState state) {
        if (state.tickCount == 1) {
            state.itemFrame.m_31805_(ItemStack.f_41583_);
            server.m_5594_(null, state.itemFrame.m_20183_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 0.5f, 1.0f);
            state.targetFrame = ItemFrameEventsProcedure.findNearbyItemFrame(server, state.itemFrame);
        } else if (state.tickCount == 100) {
            if (state.targetFrame != null && state.targetFrame.m_6084_()) {
                state.targetFrame.m_31805_(state.originalItem);
                server.m_5594_(null, state.targetFrame.m_20183_(), SoundEvents.f_11852_, SoundSource.BLOCKS, 0.5f, 0.8f);
            } else {
                state.itemFrame.m_31805_(state.originalItem);
            }
        }
    }

    private static void handleEyeTransform(ServerLevel server, ItemFrameEventState state) {
        if (state.tickCount == 1) {
            state.itemFrame.m_31805_(new ItemStack((ItemLike)Items.f_42545_));
            server.m_5594_(null, state.itemFrame.m_20183_(), SoundEvents.f_11898_, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else if (state.tickCount == 160) {
            state.itemFrame.m_31805_(state.originalItem);
            server.m_5594_(null, state.itemFrame.m_20183_(), SoundEvents.f_12016_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
    }

    private static ItemFrame findNearbyItemFrame(ServerLevel server, ItemFrame sourceFrame) {
        ArrayList<ItemFrame> nearbyFrames = new ArrayList<ItemFrame>();
        int radius = 16;
        for (Entity entity : server.m_8583_()) {
            ItemFrame frame;
            if (!(entity instanceof ItemFrame) || (frame = (ItemFrame)entity) == sourceFrame || !(entity.m_20280_((Entity)sourceFrame) <= (double)(radius * radius)) || !frame.m_31822_().m_41619_()) continue;
            nearbyFrames.add(frame);
        }
        return nearbyFrames.isEmpty() ? null : (ItemFrame)nearbyFrames.get(server.m_213780_().m_188503_(nearbyFrames.size()));
    }

    private static enum ItemFrameEvent {
        ITEM_ROTATION,
        ITEM_TELEPORT,
        ITEM_EYE_TRANSFORM;

    }

    private static class ItemFrameEventState {
        ItemFrameEvent event;
        Player player;
        ItemFrame itemFrame;
        int tickCount;
        ItemStack originalItem;
        ItemFrame targetFrame;

        ItemFrameEventState(ItemFrameEvent event, Player player, ItemFrame itemFrame) {
            this.event = event;
            this.player = player;
            this.itemFrame = itemFrame;
            this.tickCount = 0;
            this.originalItem = itemFrame.m_31822_().m_41777_();
            this.targetFrame = null;
        }
    }
}

