/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="from_the_caves", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RunParticlesProcedure {
    private static final double BASE_PROB = 1.5E-5;
    private static final double MAX_PROB = 3.5E-5;
    private static final int PARTICLE_COUNT = 8;
    private static final int TICKS_BETWEEN = 10;
    private static final double PARTICLE_DISTANCE = 3.0;
    private static final double DISTANCE_JITTER = 0.4;
    private static final double HEIGHT_JITTER = 0.5;
    private static final int MIN_PHASE = 1;
    private static final int MAX_PHASE = 2;
    private static final Map<UUID, SequenceState> active = new ConcurrentHashMap<UUID, SequenceState>();
    private static final double RUN_SPAWN_CHANCE_CHANCE = 0.35;
    private static final double RUN_SPAWN_DISTANCE = 1.0;
    private static final double LOOK_DOT_THRESHOLD = Math.cos(Math.toRadians(60.0));
    private static final long LOOK_DESPAWN_TICKS = 10L;
    private static final Map<UUID, RunMobState> runMobs = new ConcurrentHashMap<UUID, RunMobState>();

    public static void startSequenceFor(ServerPlayer player) {
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        active.computeIfAbsent(player.m_20148_(), k -> new SequenceState());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        RunMobState rms;
        SequenceState state;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        Level level = event.player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ServerPlayer player = (ServerPlayer)event.player;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            active.remove(player.m_20148_());
            return;
        }
        UUID pid = player.m_20148_();
        if (!active.containsKey(pid)) {
            double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, (Player)player, 1.5E-5, 3.5E-5);
            if (server.f_46441_.m_188500_() < dynamicProb) {
                active.put(pid, new SequenceState());
            }
        }
        if ((state = active.get(pid)) != null) {
            ++state.tickCounter;
            if (state.tickCounter >= 10) {
                SoundEvent stepSound;
                BlockParticleOption dust;
                int offsetZ;
                int offsetY;
                int offsetX;
                state.tickCounter = 0;
                Vec3 base = player.m_20182_().m_82520_(0.0, 0.25, 0.0);
                double angle = server.f_46441_.m_188500_() * Math.PI * 2.0;
                double radius = 3.0 + (server.f_46441_.m_188500_() * 2.0 - 1.0) * 0.4;
                double px = base.f_82479_ + Math.cos(angle) * radius;
                double pz = base.f_82481_ + Math.sin(angle) * radius;
                double py = player.m_20186_() + server.f_46441_.m_188500_() * 0.5;
                BlockPos playerBlock = player.m_20183_();
                BlockPos nearbyPos = playerBlock.m_7918_(offsetX = server.f_46441_.m_188503_(3) - 1, offsetY = server.f_46441_.m_188503_(3) - 1, offsetZ = server.f_46441_.m_188503_(3) - 1);
                BlockState nearbyState = server.m_8055_(nearbyPos);
                if (!nearbyState.m_60795_()) {
                    dust = new BlockParticleOption(ParticleTypes.f_123794_, nearbyState);
                    stepSound = nearbyState.m_60827_().m_56776_();
                } else {
                    BlockPos floorPos = player.m_20183_().m_7495_();
                    BlockState floorState = server.m_8055_(floorPos);
                    dust = new BlockParticleOption(ParticleTypes.f_123794_, floorState);
                    stepSound = floorState.m_60827_().m_56776_();
                }
                server.m_8767_((ParticleOptions)dust, px, py, pz, 2, 0.0, 0.0, 0.0, 0.0);
                if (stepSound != null) {
                    BlockPos soundPos = new BlockPos((int)Math.floor(px), (int)Math.floor(py), (int)Math.floor(pz));
                    server.m_5594_(null, soundPos, stepSound, SoundSource.BLOCKS, 0.9f, 1.0f);
                }
                ++state.spawned;
                if (state.spawned >= 8) {
                    active.remove(pid);
                    if (server.f_46441_.m_188500_() < 0.35) {
                        double yawRad = Math.toRadians(player.m_146908_());
                        double dx = -Math.sin(yawRad) * 1.0;
                        double dz = Math.cos(yawRad) * 1.0;
                        double mx = player.m_20185_() + dx;
                        double my = player.m_20186_();
                        double mz = player.m_20189_() + dz;
                        Mob runMob = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESPARTRUN.get()).m_262496_(server, BlockPos.m_274561_((double)mx, (double)my, (double)mz), MobSpawnType.MOB_SUMMONED);
                        if (runMob != null) {
                            runMob.m_7678_(mx, my, mz, 0.0f, 0.0f);
                            server.m_7967_((Entity)runMob);
                            runMobs.put(pid, new RunMobState(runMob));
                        }
                    }
                } else {
                    active.put(pid, state);
                }
            }
        }
        if ((rms = runMobs.get(pid)) != null) {
            if (!rms.mob.m_6084_()) {
                runMobs.remove(pid);
            } else {
                long now = server.m_46467_();
                if (rms.despawnAt < 0L) {
                    Vec3 dir;
                    Vec3 look = player.m_20154_().m_82541_();
                    Vec3 toMob = Vec3.m_82512_((Vec3i)rms.mob.m_20183_()).m_82546_(player.m_20182_());
                    double len = toMob.m_82553_();
                    if (len > 1.0E-6 && look.m_82526_(dir = toMob.m_82490_(1.0 / len)) >= LOOK_DOT_THRESHOLD) {
                        rms.despawnAt = now + 10L;
                    }
                } else if (now >= rms.despawnAt) {
                    rms.mob.m_146870_();
                    runMobs.remove(pid);
                }
            }
        }
    }

    private static class SequenceState {
        int spawned = 0;
        int tickCounter = 0;

        private SequenceState() {
        }
    }

    private static class RunMobState {
        final Mob mob;
        long despawnAt = -1L;

        RunMobState(Mob m) {
            this.mob = m;
        }
    }
}

