/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SculkSensorEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 200;
    private static final Map<Integer, SculkSensorEventState> activeEvents = new HashMap<Integer, SculkSensorEventState>();
    private static final Map<BlockPos, Long> sensorCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validSensors = SculkSensorEventsProcedure.findValidSculkSensors(server, player);
        if (validSensors.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validSensors.removeIf(pos -> sensorCooldowns.containsKey(pos) && currentTime < sensorCooldowns.get(pos));
        if (validSensors.isEmpty()) {
            return;
        }
        BlockPos chosen = validSensors.get(server.m_213780_().m_188503_(validSensors.size()));
        SculkSensorEvent event = SculkSensorEvent.values()[server.m_213780_().m_188503_(SculkSensorEvent.values().length)];
        BlockState originalState = server.m_8055_(chosen);
        sensorCooldowns.put(chosen, currentTime + 200L);
        activeEvents.put(eventIdCounter++, new SculkSensorEventState(event, player, chosen, originalState));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.getServer().m_129921_() % 200 == 0) {
            long currentTime = ev.getServer().m_129783_().m_46467_();
            sensorCooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        }
        Iterator<Map.Entry<Integer, SculkSensorEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SculkSensorEventState> entry2 = iterator.next();
            SculkSensorEventState state = entry2.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case PHANTOM_ACTIVATION: {
                    SculkSensorEventsProcedure.handlePhantomActivation(server, state);
                    if (state.tickCount < 60) break;
                    iterator.remove();
                    break;
                }
                case PHANTOM_SOUNDS: {
                    SculkSensorEventsProcedure.handlePhantomSounds(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                    break;
                }
                case CRIMSON_PARTICLES: {
                    SculkSensorEventsProcedure.handleCrimsonParticles(server, state);
                    if (state.tickCount < 80) break;
                    iterator.remove();
                    break;
                }
                case WARDEN_HEARTBEAT: {
                    SculkSensorEventsProcedure.handleWardenHeartbeat(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findValidSculkSensors(ServerLevel server, Player player) {
        ArrayList<BlockPos> sensors = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof SculkSensorBlock)) continue;
                    sensors.add(pos.m_7949_());
                }
            }
        }
        return sensors;
    }

    private static void handlePhantomActivation(ServerLevel server, SculkSensorEventState state) {
        if (state.tickCount == 1) {
            double px = (double)state.sensorPos.m_123341_() + 0.5;
            double py = (double)state.sensorPos.m_123342_() + 0.5;
            double pz = (double)state.sensorPos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py + 0.2, pz, 6, 0.2, 0.1, 0.2, 0.02);
            SoundEvent s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.sculk_sensor.clicking"));
            if (s == null) {
                s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "block.sculk_sensor.clicking"));
            }
            if (s != null && state.player.m_20275_(px, py, pz) <= 36.0) {
                server.m_5594_(null, state.sensorPos, s, SoundSource.BLOCKS, 0.6f, 1.0f);
            }
        }
    }

    private static void handlePhantomSounds(ServerLevel server, SculkSensorEventState state) {
        if (state.player.m_20275_((double)state.sensorPos.m_123341_() + 0.5, (double)state.sensorPos.m_123342_() + 0.5, (double)state.sensorPos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        if (state.tickCount % 25 == 0) {
            int soundType = server.m_213780_().m_188503_(3);
            SoundEvent s = null;
            switch (soundType) {
                case 0: {
                    s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.player.hurt"));
                    if (s != null) break;
                    s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.player.hurt"));
                    break;
                }
                case 1: {
                    s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.wood.break"));
                    if (s != null) break;
                    s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "block.wood.break"));
                    break;
                }
                case 2: {
                    s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.stone.step"));
                    if (s != null) break;
                    s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "block.stone.step"));
                }
            }
            if (s != null) {
                server.m_5594_(null, state.sensorPos, s, SoundSource.BLOCKS, 0.35f, 0.7f + server.m_213780_().m_188501_() * 0.4f);
            }
        }
    }

    private static void handleCrimsonParticles(ServerLevel server, SculkSensorEventState state) {
        if (state.player.m_20275_((double)state.sensorPos.m_123341_() + 0.5, (double)state.sensorPos.m_123342_() + 0.5, (double)state.sensorPos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        if (state.tickCount % 5 == 0) {
            double x = (double)state.sensorPos.m_123341_() + 0.5;
            double y = (double)state.sensorPos.m_123342_() + 0.5;
            double z = (double)state.sensorPos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123784_, x, y, z, 4, 0.25, 0.25, 0.25, 0.01);
        }
    }

    private static void handleWardenHeartbeat(ServerLevel server, SculkSensorEventState state) {
        if (state.player.m_20275_((double)state.sensorPos.m_123341_() + 0.5, (double)state.sensorPos.m_123342_() + 0.5, (double)state.sensorPos.m_123343_() + 0.5) > 36.0) {
            return;
        }
        if (state.tickCount % 40 == 0) {
            SoundEvent s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.warden.heartbeat"));
            if (s == null) {
                s = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "entity.warden.heartbeat"));
            }
            if (s != null) {
                server.m_5594_(null, state.sensorPos, s, SoundSource.BLOCKS, 0.6f, 0.8f + server.m_213780_().m_188501_() * 0.4f);
            }
        }
    }

    private static enum SculkSensorEvent {
        PHANTOM_ACTIVATION,
        PHANTOM_SOUNDS,
        CRIMSON_PARTICLES,
        WARDEN_HEARTBEAT;

    }

    private static class SculkSensorEventState {
        SculkSensorEvent event;
        Player player;
        BlockPos sensorPos;
        int tickCount;
        BlockState originalState;

        SculkSensorEventState(SculkSensorEvent event, Player player, BlockPos sensorPos, BlockState originalState) {
            this.event = event;
            this.player = player;
            this.sensorPos = sensorPos;
            this.tickCount = 0;
            this.originalState = originalState;
        }
    }
}

