/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnFarMobProcedure {
    private static final double BASE_PROB = 3.5E-5;
    private static final double MAX_PROB = 5.0E-5;
    private static final double MIN_SPAWN_DIST = 9.0;
    private static final double MAX_SPAWN_DIST = 20.0;
    private static final int MIN_Y_OFFSET = -10;
    private static final int MAX_Y_OFFSET = 10;
    private static final double LOOK_FOV_COS = Math.cos(Math.toRadians(50.0));
    private static final int LOOK_DELAY_TICKS = 20;
    private static final double CLOSE_DISTANCE = 7.0;
    private static final double FLEE_SPEED = 0.7;
    private static final double MAX_DISTANCE_DESPAWN = 50.0;
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 1800L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        long now = server.m_46467_();
        Long lastSpawn = playerCooldowns.get(player.m_20148_());
        if (lastSpawn != null && now - lastSpawn < 1800L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 3.5E-5, 5.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double distance = 9.0 + Math.random() * 11.0;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        int yOffset = -10 + (int)(Math.random() * 21.0);
        Vec3 playerPos = player.m_20182_();
        int spawnX = (int)Math.floor(playerPos.f_82479_ + offsetX);
        int spawnY = (int)Math.floor(playerPos.f_82480_) + yOffset;
        int spawnZ = (int)Math.floor(playerPos.f_82481_ + offsetZ);
        if (spawnY < server.m_141937_() + 1 || spawnY > server.m_151558_() - 2) {
            return;
        }
        Mob far = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get()).m_20615_((Level)server);
        if (far == null) {
            return;
        }
        far.m_7678_((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5, 0.0f, 0.0f);
        far.m_21530_();
        far.m_21557_(false);
        CompoundTag nbt = far.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128379_("isFarMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        nbt.m_128379_("isFleeing", false);
        server.m_7967_((Entity)far);
        playerCooldowns.put(player.m_20148_(), now);
    }

    @SubscribeEvent
    public static void onFarMobTick(LivingEvent.LivingTickEvent ev) {
        UUID targetId;
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isFarMob")) {
            return;
        }
        if (!nbt.m_128403_("targetUUID")) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        Player target = server.m_46003_(targetId = nbt.m_128342_("targetUUID"));
        if (target == null) {
            mob.m_146870_();
            return;
        }
        boolean isFleeing = nbt.m_128471_("isFleeing");
        if (!isFleeing) {
            toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
            if (toPlayer.m_82556_() > 1.0E-6) {
                Vec3 toPlayerNorm = toPlayer.m_82541_();
                float yaw = (float)(Math.atan2(toPlayerNorm.f_82481_, toPlayerNorm.f_82479_) * 180.0 / Math.PI) - 90.0f;
                mob.m_146922_(yaw);
                mob.f_20885_ = yaw;
                mob.f_20883_ = yaw;
            }
            mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
            mob.m_21573_().m_26573_();
            double distToPlayer = mob.m_20270_((Entity)target);
            if (distToPlayer < 7.0) {
                SpawnFarMobProcedure.startFleeing(mob, target, nbt);
                return;
            }
            if (mob.f_19797_ % 10 == 0) {
                Vec3 playerEyePos = target.m_20299_(1.0f);
                Vec3 playerLook = target.m_20154_().m_82541_();
                Vec3 toMob = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0).m_82546_(playerEyePos);
                double distToMob = toMob.m_82553_();
                if (distToMob > 1.0E-6) {
                    Vec3 toMobNorm = toMob.m_82490_(1.0 / distToMob);
                    double dot = playerLook.m_82526_(toMobNorm);
                    if (dot > LOOK_FOV_COS) {
                        int lookingTicks = nbt.m_128451_("lookingAtTicks");
                        nbt.m_128405_("lookingAtTicks", lookingTicks += 10);
                        if (lookingTicks >= 20) {
                            SpawnFarMobProcedure.startFleeing(mob, target, nbt);
                            return;
                        }
                    } else {
                        int currentTicks = nbt.m_128451_("lookingAtTicks");
                        if (currentTicks > 0) {
                            nbt.m_128405_("lookingAtTicks", 0);
                        }
                    }
                }
            }
        } else {
            toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
            Vec3 fleeDir = toPlayer.m_82490_(-1.0).m_82541_();
            Vec3 movement = fleeDir.m_82490_(0.7);
            mob.m_20334_(movement.f_82479_, mob.m_20184_().f_82480_, movement.f_82481_);
            mob.f_19864_ = true;
            Vec3 fleeTarget = mob.m_20182_().m_82549_(fleeDir.m_82490_(10.0));
            BlockPos fleeBlockPos = new BlockPos((int)fleeTarget.f_82479_, (int)fleeTarget.f_82480_, (int)fleeTarget.f_82481_);
            mob.m_21573_().m_26519_((double)fleeBlockPos.m_123341_() + 0.5, (double)fleeBlockPos.m_123342_(), (double)fleeBlockPos.m_123343_() + 0.5, 1.0);
            if (fleeDir.m_82556_() > 1.0E-6) {
                float yaw = (float)(Math.atan2(fleeDir.f_82481_, fleeDir.f_82479_) * 180.0 / Math.PI) - 90.0f;
                mob.m_146922_(yaw);
                mob.f_20885_ = yaw;
                mob.f_20883_ = yaw;
            }
            if (mob.f_19797_ % 10 == 0) {
                Vec3 playerEyePos = target.m_20299_(1.0f);
                Vec3 playerLook = target.m_20154_().m_82541_();
                Vec3 toMob = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0).m_82546_(playerEyePos);
                double distToMob = toMob.m_82553_();
                boolean playerSeesMe = false;
                if (distToMob > 1.0E-6) {
                    Vec3 toMobNorm = toMob.m_82490_(1.0 / distToMob);
                    double dot = playerLook.m_82526_(toMobNorm);
                    boolean bl = playerSeesMe = dot > LOOK_FOV_COS;
                }
                if (!playerSeesMe) {
                    mob.m_146870_();
                    return;
                }
            }
        }
        double distToPlayer = mob.m_20270_((Entity)target);
        if (distToPlayer > 50.0) {
            mob.m_146870_();
            return;
        }
        long spawnTick = nbt.m_128454_("spawnTick");
        long now = server.m_46467_();
        if (now - spawnTick > 6000L) {
            mob.m_146870_();
            return;
        }
    }

    private static void startFleeing(Mob mob, Player target, CompoundTag nbt) {
        nbt.m_128379_("isFleeing", true);
        nbt.m_128405_("lookingAtTicks", 0);
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        Vec3 fleeDir = toPlayer.m_82490_(-1.0).m_82541_();
        Vec3 movement = fleeDir.m_82490_(0.7);
        mob.m_20334_(movement.f_82479_, mob.m_20184_().f_82480_, movement.f_82481_);
        mob.f_19864_ = true;
    }

    public static void forceSpawn(ServerLevel level, Player player) {
        double angle = Math.random() * Math.PI * 2.0;
        double distance = 14.5;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        int yOffset = 0;
        Vec3 playerPos = player.m_20182_();
        int spawnX = (int)Math.floor(playerPos.f_82479_ + offsetX);
        int spawnY = (int)Math.floor(playerPos.f_82480_) + yOffset;
        int spawnZ = (int)Math.floor(playerPos.f_82481_ + offsetZ);
        Mob far = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get()).m_20615_((Level)level);
        if (far == null) {
            return;
        }
        far.m_7678_((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5, 0.0f, 0.0f);
        far.m_21530_();
        far.m_21557_(false);
        CompoundTag nbt = far.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", level.m_46467_());
        nbt.m_128379_("isFarMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        nbt.m_128379_("isFleeing", false);
        level.m_7967_((Entity)far);
    }

    public static void cleanupOldCooldowns(long currentTick) {
        playerCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 3600L);
    }
}

