/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StairsEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 200;
    private static final Map<Integer, StairsEventState> activeEvents = new HashMap<Integer, StairsEventState>();
    private static final Map<BlockPos, Long> stairsCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validStairs = StairsEventsProcedure.findValidStairs(server, player);
        if (validStairs.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validStairs.removeIf(pos -> stairsCooldowns.containsKey(pos) && currentTime < stairsCooldowns.get(pos));
        if (validStairs.isEmpty()) {
            return;
        }
        BlockPos chosen = validStairs.get(server.m_213780_().m_188503_(validStairs.size()));
        StairsEvent event = StairsEvent.values()[server.m_213780_().m_188503_(StairsEvent.values().length)];
        stairsCooldowns.put(chosen, currentTime + 200L);
        List<BlockPos> stairsSequence = StairsEventsProcedure.getStairsSequence(server, chosen, 5);
        activeEvents.put(eventIdCounter++, new StairsEventState(event, player, stairsSequence));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.getServer().m_129921_() % 200 == 0) {
            long currentTime = ev.getServer().m_129783_().m_46467_();
            stairsCooldowns.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
        }
        Iterator<Map.Entry<Integer, StairsEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, StairsEventState> entry2 = iterator.next();
            StairsEventState state = entry2.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case FOOTSTEP_SOUNDS: {
                    StairsEventsProcedure.handleFootstepSounds(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                    break;
                }
                case BREAK_SOUNDS: {
                    StairsEventsProcedure.handleBreakSounds(server, state);
                    if (state.tickCount < 100) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findValidStairs(ServerLevel server, Player player) {
        ArrayList<BlockPos> stairs = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)server.m_141937_(), (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof StairBlock)) continue;
                    stairs.add(pos.m_7949_());
                }
            }
        }
        return stairs;
    }

    private static List<BlockPos> getStairsSequence(ServerLevel server, BlockPos start, int length) {
        ArrayList<BlockPos> sequence = new ArrayList<BlockPos>();
        sequence.add(start.m_7949_());
        BlockPos current = start;
        for (int i = 1; i < length; ++i) {
            BlockPos above = current.m_7494_();
            BlockPos below = current.m_7495_();
            if (server.m_8055_(above).m_60734_() instanceof StairBlock && !sequence.contains(above)) {
                sequence.add(above.m_7949_());
                current = above;
                continue;
            }
            if (!(server.m_8055_(below).m_60734_() instanceof StairBlock) || sequence.contains(below)) break;
            sequence.add(below.m_7949_());
            current = below;
        }
        return sequence;
    }

    private static void handleFootstepSounds(ServerLevel server, StairsEventState state) {
        if (state.tickCount % 20 == 0 && state.currentStep < state.stairsSequence.size()) {
            BlockPos stepPos = state.stairsSequence.get(state.currentStep);
            if (state.player.m_20275_((double)stepPos.m_123341_() + 0.5, (double)stepPos.m_123342_() + 0.5, (double)stepPos.m_123343_() + 0.5) <= 36.0) {
                BlockState stairState = server.m_8055_(stepPos);
                SoundEvent stepSound = stairState.m_60827_().m_56776_();
                server.m_5594_(null, stepPos, stepSound, SoundSource.BLOCKS, 0.4f, 0.8f + server.m_213780_().m_188501_() * 0.4f);
            }
            ++state.currentStep;
        }
    }

    private static void handleBreakSounds(ServerLevel server, StairsEventState state) {
        BlockPos randomStair;
        if (state.tickCount % 30 == 0 && !state.stairsSequence.isEmpty() && state.player.m_20275_((double)(randomStair = state.stairsSequence.get(server.m_213780_().m_188503_(state.stairsSequence.size()))).m_123341_() + 0.5, (double)randomStair.m_123342_() + 0.5, (double)randomStair.m_123343_() + 0.5) <= 36.0) {
            BlockState stairState = server.m_8055_(randomStair);
            SoundEvent breakSound = stairState.m_60827_().m_56775_();
            server.m_5594_(null, randomStair, breakSound, SoundSource.BLOCKS, 0.3f, 0.6f + server.m_213780_().m_188501_() * 0.4f);
        }
    }

    private static enum StairsEvent {
        FOOTSTEP_SOUNDS,
        BREAK_SOUNDS;

    }

    private static class StairsEventState {
        StairsEvent event;
        Player player;
        List<BlockPos> stairsSequence;
        int tickCount;
        int currentStep;

        StairsEventState(StairsEvent event, Player player, List<BlockPos> stairsSequence) {
            this.event = event;
            this.player = player;
            this.stairsSequence = stairsSequence;
            this.tickCount = 0;
            this.currentStep = 0;
        }
    }
}

