/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BellEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final Map<Integer, BellRingState> activeRings = new HashMap<Integer, BellRingState>();
    private static final Map<BlockPos, Long> bellCooldowns = new HashMap<BlockPos, Long>();
    private static int ringIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validBells = BellEventsProcedure.findValidBells(server, player);
        if (validBells.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validBells.removeIf(pos -> bellCooldowns.containsKey(pos) && currentTime < bellCooldowns.get(pos));
        if (validBells.isEmpty()) {
            return;
        }
        BlockPos chosen = validBells.get(server.m_213780_().m_188503_(validBells.size()));
        bellCooldowns.put(chosen, currentTime + 600L);
        activeRings.put(ringIdCounter++, new BellRingState(player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, BellRingState>> iterator = activeRings.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, BellRingState> entry = iterator.next();
            BellRingState state = entry.getValue();
            if (state.ringsRemaining <= 0) {
                iterator.remove();
                continue;
            }
            --state.nextRingTick;
            if (state.nextRingTick > 0) continue;
            BellEventsProcedure.ringBell((ServerLevel)state.player.m_9236_(), state);
            --state.ringsRemaining;
            if (state.ringsRemaining <= 0) continue;
            state.nextRingTick = 4 + new Random().nextInt(9);
        }
    }

    private static List<BlockPos> findValidBells(ServerLevel server, Player player) {
        ArrayList<BlockPos> bells = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -8; y <= 8; ++y) {
                    BlockPos pos = playerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof BellBlock)) continue;
                    bells.add(pos.m_7949_());
                }
            }
        }
        return bells;
    }

    private static void ringBell(ServerLevel server, BellRingState state) {
        float pitchVariation = (server.m_213780_().m_188501_() - 0.5f) * 0.2f;
        float pitch = Mth.m_14036_((float)(state.basePitch + pitchVariation), (float)0.5f, (float)2.0f);
        server.m_5594_(null, state.bellPos, SoundEvents.f_11699_, SoundSource.BLOCKS, 1.0f, pitch);
        if (server.m_213780_().m_188499_()) {
            double x = (double)state.bellPos.m_123341_() + 0.5;
            double y = (double)state.bellPos.m_123342_() + 0.5;
            double z = (double)state.bellPos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static class BellRingState {
        Player player;
        BlockPos bellPos;
        int ringsRemaining;
        int nextRingTick;
        float basePitch;

        BellRingState(Player player, BlockPos bellPos) {
            this.player = player;
            this.bellPos = bellPos;
            this.ringsRemaining = 2 + new Random().nextInt(4);
            this.nextRingTick = 0;
            this.basePitch = 1.0f;
        }
    }
}

