/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DoorSpawnProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int LOCK_DURATION = 400;
    private static final Map<Integer, DoorEventState> activeEvents = new HashMap<Integer, DoorEventState>();
    private static final Map<BlockPos, Long> doorCooldowns = new HashMap<BlockPos, Long>();
    private static final Map<BlockPos, Long> lockedDoors = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validDoors = DoorSpawnProcedure.findValidDoors(server, player);
        if (validDoors.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validDoors.removeIf(pos -> doorCooldowns.containsKey(pos) && currentTime < doorCooldowns.get(pos));
        if (validDoors.isEmpty()) {
            return;
        }
        BlockPos chosen = validDoors.get(server.m_213780_().m_188503_(validDoors.size()));
        DoorEvent event = DoorEvent.values()[server.m_213780_().m_188503_(DoorEvent.values().length)];
        doorCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new DoorEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, DoorEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, DoorEventState> entry2 = iterator.next();
            DoorEventState state = entry2.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case DOOR_OPEN_CLOSE: {
                    DoorSpawnProcedure.handleDoorOpenClose(server, state);
                    if (state.tickCount < 2) break;
                    iterator.remove();
                    break;
                }
                case DOOR_SLAM_LOCK: {
                    DoorSpawnProcedure.handleDoorSlamLock(server, state);
                    if (!state.slammed || state.tickCount < 2) break;
                    iterator.remove();
                }
            }
        }
        long currentTime = ev.getServer().m_129783_().m_46467_();
        lockedDoors.entrySet().removeIf(entry -> currentTime >= (Long)entry.getValue());
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        long currentTime = level.m_46467_();
        if (lockedDoors.containsKey(pos) && currentTime < lockedDoors.get(pos)) {
            event.setCanceled(true);
            level.m_5594_(null, pos, SoundEvents.f_12626_, SoundSource.BLOCKS, 0.5f, 1.0f);
            level.m_5594_(null, pos, SoundEvents.f_11748_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static List<BlockPos> findValidDoors(ServerLevel server, Player player) {
        ArrayList<BlockPos> doors = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof DoorBlock)) continue;
                    doors.add(pos.m_7949_());
                }
            }
        }
        return doors;
    }

    private static void handleDoorOpenClose(ServerLevel server, DoorEventState state) {
        BlockState doorState = server.m_8055_(state.doorPos);
        if (!(doorState.m_60734_() instanceof DoorBlock)) {
            return;
        }
        if (state.tickCount == 1) {
            boolean currentlyOpen = (Boolean)doorState.m_61143_((Property)DoorBlock.f_52727_);
            server.m_7731_(state.doorPos, (BlockState)doorState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
            server.m_5594_(null, state.doorPos, currentlyOpen ? SoundEvents.f_12626_ : SoundEvents.f_12627_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static void handleDoorSlamLock(ServerLevel server, DoorEventState state) {
        BlockState doorState = server.m_8055_(state.doorPos);
        if (!(doorState.m_60734_() instanceof DoorBlock)) {
            return;
        }
        if (state.tickCount == 1) {
            if (((Boolean)doorState.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                server.m_7731_(state.doorPos, (BlockState)doorState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(false)), 3);
                server.m_5594_(null, state.doorPos, SoundEvents.f_12601_, SoundSource.BLOCKS, 1.0f, 1.0f);
                state.slammed = true;
                lockedDoors.put(state.doorPos, server.m_46467_() + 400L);
            } else {
                state.slammed = true;
            }
        }
    }

    private static enum DoorEvent {
        DOOR_OPEN_CLOSE,
        DOOR_SLAM_LOCK;

    }

    private static class DoorEventState {
        DoorEvent event;
        Player player;
        BlockPos doorPos;
        int tickCount;
        boolean slammed;

        DoorEventState(DoorEvent event, Player player, BlockPos doorPos) {
            this.event = event;
            this.player = player;
            this.doorPos = doorPos;
            this.tickCount = 0;
            this.slammed = false;
        }
    }
}

