/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NoteBlockEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 200;
    private static final int INTERVAL_TICKS = 6;
    private static final Map<Integer, NoteBlockEventState> activeEvents = new HashMap<Integer, NoteBlockEventState>();
    private static final Map<BlockPos, Long> noteBlockCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;
    private static final int[] CREEPY_MELODY = new int[]{0, 3, 0, 3, 5, 3, 1, 0};

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> noteBlocks = NoteBlockEventsProcedure.findNearbyNoteBlocks(server, player);
        if (noteBlocks.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        noteBlocks.removeIf(pos -> noteBlockCooldowns.containsKey(pos) && currentTime < noteBlockCooldowns.get(pos));
        if (noteBlocks.isEmpty()) {
            return;
        }
        BlockPos chosen = noteBlocks.get(server.m_213780_().m_188503_(noteBlocks.size()));
        NoteBlockEvent event = NoteBlockEvent.values()[server.m_213780_().m_188503_(NoteBlockEvent.values().length)];
        noteBlockCooldowns.put(chosen, currentTime + 200L);
        NoteBlockEventState st = new NoteBlockEventState(event, player, switch (event) {
            case NoteBlockEvent.CREEPY_MELODY -> NoteBlockEventsProcedure.pickMelodySequence(server, chosen);
            case NoteBlockEvent.DISCORDANT_NOTES -> Collections.singletonList(chosen);
            case NoteBlockEvent.SYNCHRONIZED_NOTES -> NoteBlockEventsProcedure.findNearbyNoteBlocks(server, player);
            default -> Collections.singletonList(chosen);
        });
        st.basePitch = event == NoteBlockEvent.DISCORDANT_NOTES ? 0.5 + server.m_213780_().m_188500_() * 1.0 : 1.0;
        activeEvents.put(eventIdCounter++, st);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, NoteBlockEventState>> iterator = activeEvents.entrySet().iterator();
        SoundEvent noteSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.note_block.pling"));
        if (noteSound == null) {
            noteSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "block.note_block.pling"));
        }
        block5: while (iterator.hasNext()) {
            Map.Entry<Integer, NoteBlockEventState> entry = iterator.next();
            NoteBlockEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case CREEPY_MELODY: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block5;
                    if (state.melodyCursor >= CREEPY_MELODY.length) {
                        iterator.remove();
                        break;
                    }
                    int note = CREEPY_MELODY[state.melodyCursor];
                    double pitch = Math.pow(2.0, (double)note / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock) || noteSound == null) continue;
                        server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.9f, (float)pitch);
                    }
                    ++state.melodyCursor;
                    break;
                }
                case DISCORDANT_NOTES: {
                    if (state.tickCount % 6 != 0) continue block5;
                    for (BlockPos pos : state.noteBlockPositions) {
                        BlockState s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock)) continue;
                        double pitch = 0.5 + server.m_213780_().m_188500_() * 1.0;
                        if (noteSound == null) continue;
                        server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.9f, (float)pitch);
                    }
                    if (state.tickCount < 72) continue block5;
                    iterator.remove();
                    break;
                }
                case SYNCHRONIZED_NOTES: {
                    BlockState s;
                    if (state.tickCount % 6 != 0) continue block5;
                    int note = server.m_213780_().m_188503_(25);
                    double pitch = Math.pow(2.0, (double)note / 12.0);
                    for (BlockPos pos : state.noteBlockPositions) {
                        s = server.m_8055_(pos);
                        if (!(s.m_60734_() instanceof NoteBlock) || noteSound == null) continue;
                        server.m_5594_(null, pos, noteSound, SoundSource.BLOCKS, 0.85f, (float)pitch);
                    }
                    if (state.tickCount < 60) continue block5;
                    iterator.remove();
                    break;
                }
                default: {
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findNearbyNoteBlocks(ServerLevel server, Player player) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        int radiusBlocks = 32;
        int minX = player.m_20183_().m_123341_() - radiusBlocks;
        int maxX = player.m_20183_().m_123341_() + radiusBlocks;
        int minZ = player.m_20183_().m_123343_() - radiusBlocks;
        int maxZ = player.m_20183_().m_123343_() + radiusBlocks;
        int minY = Math.max(0, player.m_20183_().m_123342_() - 6);
        int maxY = Math.min(server.m_151558_() - 1, player.m_20183_().m_123342_() + 6);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState s = server.m_8055_(pos);
                    if (!(s.m_60734_() instanceof NoteBlock)) continue;
                    list.add(pos.m_7949_());
                }
            }
        }
        return list;
    }

    private static List<BlockPos> pickMelodySequence(ServerLevel server, BlockPos origin) {
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        res.add(origin.m_7949_());
        for (int i = 1; i <= 4; ++i) {
            BlockPos p = origin.m_7918_(server.m_213780_().m_188503_(3) - 1, 0, server.m_213780_().m_188503_(3) - 1);
            if (res.contains(p) || !(server.m_8055_(p).m_60734_() instanceof NoteBlock)) continue;
            res.add(p.m_7949_());
        }
        return res;
    }

    private static enum NoteBlockEvent {
        CREEPY_MELODY,
        DISCORDANT_NOTES,
        SYNCHRONIZED_NOTES;

    }

    private static class NoteBlockEventState {
        NoteBlockEvent event;
        Player player;
        List<BlockPos> noteBlockPositions;
        int tickCount;
        int melodyCursor;
        double basePitch;

        NoteBlockEventState(NoteBlockEvent event, Player player, List<BlockPos> noteBlockPositions) {
            this.event = event;
            this.player = player;
            this.noteBlockPositions = noteBlockPositions;
            this.tickCount = 0;
            this.melodyCursor = 0;
            this.basePitch = 1.0;
        }
    }
}

