/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StepsEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int STEP_INTERVAL = 8;
    private static final Map<Integer, StepsEventState> activeEvents = new HashMap<Integer, StepsEventState>();
    private static final Map<BlockPos, Long> stairCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<List<BlockPos>> stairSequences = StepsEventsProcedure.findStairSequences(server, player);
        if (stairSequences.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        stairSequences.removeIf(seq -> stairCooldowns.containsKey(seq.get(0)) && currentTime < stairCooldowns.get(seq.get(0)));
        if (stairSequences.isEmpty()) {
            return;
        }
        List<BlockPos> chosen = stairSequences.get(server.m_213780_().m_188503_(stairSequences.size()));
        stairCooldowns.put(chosen.get(0), currentTime + 5L);
        activeEvents.put(eventIdCounter++, new StepsEventState(chosen, player, server.f_46441_.m_188499_()));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, StepsEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, StepsEventState> entry = iterator.next();
            StepsEventState state = entry.getValue();
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            if (state.tickCount % 8 == 0 && state.stepIndex < state.stairs.size()) {
                ArrayList<BlockPos> ordered = new ArrayList<BlockPos>(state.stairs);
                ordered.sort((a, b) -> state.goingUp ? Integer.compare(a.m_123342_(), b.m_123342_()) : Integer.compare(b.m_123342_(), a.m_123342_()));
                BlockPos pos = (BlockPos)ordered.get(state.stepIndex);
                server.m_5594_(null, pos, SoundEvents.f_12638_, SoundSource.BLOCKS, 0.8f, 1.0f);
                ++state.stepIndex;
            }
            if (state.stepIndex < state.stairs.size()) continue;
            iterator.remove();
        }
    }

    private static List<List<BlockPos>> findStairSequences(ServerLevel server, Player player) {
        ArrayList<List<BlockPos>> sequences = new ArrayList<List<BlockPos>>();
        int centerChunkX = player.m_146902_().f_45578_;
        int centerChunkZ = player.m_146902_().f_45579_;
        int playerY = player.m_20183_().m_123342_();
        int minY = Math.max(0, playerY - 10);
        int maxY = Math.min(server.m_151558_() - 1, playerY + 10);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                LevelChunk chunk = server.m_6325_(centerChunkX + dx, centerChunkZ + dz);
                int baseX = chunk.m_7697_().m_45604_();
                int baseZ = chunk.m_7697_().m_45605_();
                for (int lx = 0; lx < 16; ++lx) {
                    for (int lz = 0; lz < 16; ++lz) {
                        for (int y = minY; y <= maxY; ++y) {
                            List<BlockPos> sequence;
                            BlockPos pos = new BlockPos(baseX + lx, y, baseZ + lz);
                            BlockState state = server.m_8055_(pos);
                            if (!(state.m_60734_() instanceof StairBlock) || (sequence = StepsEventsProcedure.buildStairSequence(server, pos)).size() < 3) continue;
                            sequences.add(sequence);
                        }
                    }
                }
            }
        }
        return sequences;
    }

    private static List<BlockPos> buildStairSequence(ServerLevel server, BlockPos start) {
        BlockPos above;
        BlockPos below;
        int dy;
        ArrayList<BlockPos> sequence = new ArrayList<BlockPos>();
        sequence.add(start.m_7949_());
        for (dy = -1; dy >= -10 && (below = start.m_7918_(0, dy, 0)).m_123342_() >= 0 && server.m_8055_(below).m_60734_() instanceof StairBlock; --dy) {
            sequence.add(below.m_7949_());
        }
        for (dy = 1; dy <= 10 && (above = start.m_7918_(0, dy, 0)).m_123342_() < server.m_151558_() && server.m_8055_(above).m_60734_() instanceof StairBlock; ++dy) {
            sequence.add(above.m_7949_());
        }
        return sequence;
    }

    private static class StepsEventState {
        List<BlockPos> stairs;
        Player player;
        boolean goingUp;
        int tickCount;
        int stepIndex;

        StepsEventState(List<BlockPos> stairs, Player player, boolean goingUp) {
            this.stairs = stairs;
            this.player = player;
            this.goingUp = goingUp;
            this.tickCount = 0;
            this.stepIndex = 0;
        }
    }
}

