/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SpawnFarMobProcedure {
    private static final double BASE_PROB = 3.5E-5;
    private static final double MAX_PROB = 5.0E-5;
    private static final double MIN_SPAWN_DIST = 9.0;
    private static final double MAX_SPAWN_DIST = 20.0;
    private static final int MIN_Y_OFFSET = -10;
    private static final int MAX_Y_OFFSET = 10;
    private static final double LOOK_FOV_COS = Math.cos(Math.toRadians(50.0));
    private static final int LOOK_DELAY_TICKS = 20;
    private static final double CLOSE_DISTANCE = 7.0;
    private static final double FLEE_SPEED = 0.5;
    private static final double WALL_CHECK_DISTANCE = 2.5;
    private static final int PATH_RECALC_INTERVAL = 12;
    private static final int DRIBBLE_INTERVAL = 25;
    private static final double DRIBBLE_ANGLE = 45.0;
    private static final int DRIBBLE_DURATION = 20;
    private static final double MAX_DISTANCE_DESPAWN = 50.0;
    private static final Map<UUID, Long> playerCooldowns = new HashMap<UUID, Long>();
    private static final long COOLDOWN_TICKS = 1800L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player.m_20186_() >= 50.0) {
            return;
        }
        long now = server.m_46467_();
        Long lastSpawn = playerCooldowns.get(player.m_20148_());
        if (lastSpawn != null && now - lastSpawn < 1800L) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 3.5E-5, 5.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        BlockPos spawnPos = SpawnFarMobProcedure.findValidSpawnPosition(server, player);
        if (spawnPos == null) {
            return;
        }
        Mob far = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get()).m_20615_((Level)server);
        if (far == null) {
            return;
        }
        far.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        far.m_21530_();
        far.m_21557_(false);
        CompoundTag nbt = far.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128379_("isFarMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        nbt.m_128379_("isFleeing", false);
        nbt.m_128356_("lastPathUpdate", now);
        nbt.m_128356_("lastDribble", 0L);
        nbt.m_128379_("isDribbling", false);
        nbt.m_128405_("dribbleTicksLeft", 0);
        nbt.m_128347_("dribbleAngle", 0.0);
        server.m_7967_((Entity)far);
        playerCooldowns.put(player.m_20148_(), now);
    }

    @SubscribeEvent
    public static void onFarMobTick(LivingEvent.LivingTickEvent ev) {
        UUID targetId;
        LivingEntity entity = ev.getEntity();
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("isFarMob")) {
            return;
        }
        if (!nbt.m_128403_("targetUUID")) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        Player target = server.m_46003_(targetId = nbt.m_128342_("targetUUID"));
        if (target == null) {
            mob.m_146870_();
            return;
        }
        if (SpawnFarMobProcedure.shouldDespawn(mob, target, nbt, server)) {
            mob.m_146870_();
            return;
        }
        boolean isFleeing = nbt.m_128471_("isFleeing");
        if (!isFleeing) {
            SpawnFarMobProcedure.handleIdleState(mob, target, nbt, server);
        } else {
            SpawnFarMobProcedure.handleFleeingState(mob, target, nbt, server);
        }
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, Player player) {
        Vec3 playerPos = player.m_20182_();
        for (int attempt = 0; attempt < 15; ++attempt) {
            BlockPos pos;
            double angle = Math.random() * Math.PI * 2.0;
            double distance = 9.0 + Math.random() * 11.0;
            double offsetX = Math.cos(angle) * distance;
            double offsetZ = Math.sin(angle) * distance;
            int yOffset = -10 + (int)(Math.random() * 21.0);
            int spawnX = (int)Math.floor(playerPos.f_82479_ + offsetX);
            int spawnY = (int)Math.floor(playerPos.f_82480_) + yOffset;
            int spawnZ = (int)Math.floor(playerPos.f_82481_ + offsetZ);
            if (spawnY < level.m_141937_() + 1 || spawnY > level.m_151558_() - 2 || !SpawnFarMobProcedure.isValidSpawnLocation(level, pos = new BlockPos(spawnX, spawnY, spawnZ))) continue;
            return pos;
        }
        return null;
    }

    private static boolean isValidSpawnLocation(ServerLevel level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState at = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        return SpawnFarMobProcedure.isSolidGround(below) && SpawnFarMobProcedure.isPassable(at) && SpawnFarMobProcedure.isPassable(above);
    }

    private static void handleIdleState(Mob mob, Player target, CompoundTag nbt, ServerLevel server) {
        SpawnFarMobProcedure.lookAtPlayer(mob, target);
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        mob.m_21573_().m_26573_();
        double distToPlayer = mob.m_20270_((Entity)target);
        if (distToPlayer < 7.0) {
            SpawnFarMobProcedure.startFleeing(mob, target, nbt, server);
            return;
        }
        if (mob.f_19797_ % 10 == 0) {
            if (SpawnFarMobProcedure.isPlayerLookingAtMob(mob, target)) {
                int lookingTicks = nbt.m_128451_("lookingAtTicks");
                nbt.m_128405_("lookingAtTicks", lookingTicks += 10);
                if (lookingTicks >= 20) {
                    SpawnFarMobProcedure.startFleeing(mob, target, nbt, server);
                    return;
                }
            } else {
                int currentTicks = nbt.m_128451_("lookingAtTicks");
                if (currentTicks > 0) {
                    nbt.m_128405_("lookingAtTicks", 0);
                }
            }
        }
    }

    private static void handleFleeingState(Mob mob, Player target, CompoundTag nbt, ServerLevel server) {
        long now = server.m_46467_();
        long lastPathUpdate = nbt.m_128454_("lastPathUpdate");
        long lastDribble = nbt.m_128454_("lastDribble");
        boolean isDribbling = nbt.m_128471_("isDribbling");
        int dribbleTicksLeft = nbt.m_128451_("dribbleTicksLeft");
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        Vec3 baseFleeDir = toPlayer.m_82490_(-1.0).m_82541_();
        if (isDribbling && dribbleTicksLeft > 0) {
            nbt.m_128405_("dribbleTicksLeft", --dribbleTicksLeft);
            if (dribbleTicksLeft <= 0) {
                nbt.m_128379_("isDribbling", false);
            }
        } else {
            nbt.m_128379_("isDribbling", false);
        }
        if (!isDribbling && now - lastDribble >= 25L && server.f_46441_.m_188500_() < 0.6) {
            SpawnFarMobProcedure.startDribble(mob, nbt, server);
            isDribbling = true;
        }
        Vec3 fleeDir = baseFleeDir;
        if (isDribbling) {
            double dribbleAngle = nbt.m_128459_("dribbleAngle");
            fleeDir = SpawnFarMobProcedure.rotateDirOnY(baseFleeDir, dribbleAngle);
        }
        if (now - lastPathUpdate >= 12L) {
            Vec3 adjustedFleeDir = SpawnFarMobProcedure.avoidWalls(mob, fleeDir, server);
            Vec3 fleeTarget = mob.m_20182_().m_82549_(adjustedFleeDir.m_82490_(10.0));
            BlockPos fleeBlockPos = new BlockPos((int)fleeTarget.f_82479_, (int)fleeTarget.f_82480_, (int)fleeTarget.f_82481_);
            BlockPos validTarget = SpawnFarMobProcedure.findNearestWalkablePosition(server, fleeBlockPos, mob.m_20183_());
            if (validTarget != null) {
                mob.m_21573_().m_26519_((double)validTarget.m_123341_() + 0.5, (double)validTarget.m_123342_(), (double)validTarget.m_123343_() + 0.5, 1.3);
            }
            nbt.m_128356_("lastPathUpdate", now);
        }
        SpawnFarMobProcedure.lookInDirection(mob, fleeDir);
        if (mob.f_19797_ % 10 == 0 && !SpawnFarMobProcedure.isPlayerLookingAtMob(mob, target)) {
            mob.m_146870_();
            return;
        }
    }

    private static void startDribble(Mob mob, CompoundTag nbt, ServerLevel server) {
        double angle = (double)(server.f_46441_.m_188499_() ? 1 : -1) * (45.0 + server.f_46441_.m_188500_() * 15.0);
        nbt.m_128379_("isDribbling", true);
        nbt.m_128405_("dribbleTicksLeft", 20);
        nbt.m_128347_("dribbleAngle", angle);
        nbt.m_128356_("lastDribble", server.m_46467_());
    }

    private static Vec3 rotateDirOnY(Vec3 dir, double angleDegrees) {
        double rad = Math.toRadians(angleDegrees);
        double cos = Math.cos(rad);
        double sin = Math.sin(rad);
        return new Vec3(dir.f_82479_ * cos - dir.f_82481_ * sin, dir.f_82480_, dir.f_82479_ * sin + dir.f_82481_ * cos);
    }

    private static Vec3 avoidWalls(Mob mob, Vec3 direction, ServerLevel level) {
        Vec3 checkPos;
        Vec3 mobPos = mob.m_20182_();
        Vec3 eyePos = mobPos.m_82520_(0.0, (double)mob.m_20192_() * 0.5, 0.0);
        if (!SpawnFarMobProcedure.hasObstacleInPath(level, eyePos, checkPos = eyePos.m_82549_(direction.m_82490_(2.5)), mob)) {
            return direction;
        }
        Vec3 right = new Vec3(-direction.f_82481_, 0.0, direction.f_82479_).m_82541_();
        Vec3 left = right.m_82490_(-1.0);
        Vec3 rightCheck = eyePos.m_82549_(right.m_82490_(2.5));
        boolean rightBlocked = SpawnFarMobProcedure.hasObstacleInPath(level, eyePos, rightCheck, mob);
        Vec3 leftCheck = eyePos.m_82549_(left.m_82490_(2.5));
        boolean leftBlocked = SpawnFarMobProcedure.hasObstacleInPath(level, eyePos, leftCheck, mob);
        if (!rightBlocked) {
            return direction.m_82549_(right.m_82490_(0.8)).m_82541_();
        }
        if (!leftBlocked) {
            return direction.m_82549_(left.m_82490_(0.8)).m_82541_();
        }
        Vec3 rightDiag = SpawnFarMobProcedure.rotateDirOnY(direction, 60.0);
        Vec3 rightDiagCheck = eyePos.m_82549_(rightDiag.m_82490_(2.5));
        if (!SpawnFarMobProcedure.hasObstacleInPath(level, eyePos, rightDiagCheck, mob)) {
            return rightDiag;
        }
        Vec3 leftDiag = SpawnFarMobProcedure.rotateDirOnY(direction, -60.0);
        Vec3 leftDiagCheck = eyePos.m_82549_(leftDiag.m_82490_(2.5));
        if (!SpawnFarMobProcedure.hasObstacleInPath(level, eyePos, leftDiagCheck, mob)) {
            return leftDiag;
        }
        Vec3 back = SpawnFarMobProcedure.rotateDirOnY(direction, 180.0);
        return back;
    }

    private static boolean hasObstacleInPath(ServerLevel level, Vec3 from, Vec3 to, Mob mob) {
        ClipContext context = new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob);
        BlockHitResult result = level.m_45547_(context);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos hitPos = new BlockPos((int)result.m_82450_().f_82479_, (int)result.m_82450_().f_82480_, (int)result.m_82450_().f_82481_);
            BlockState hitState = level.m_8055_(hitPos);
            return !SpawnFarMobProcedure.isPassable(hitState);
        }
        return false;
    }

    private static boolean isPassable(BlockState state) {
        if (state.m_60795_()) {
            return true;
        }
        if (state.m_60811_() == PushReaction.DESTROY) {
            return true;
        }
        return !state.m_60815_();
    }

    private static boolean isSolidGround(BlockState state) {
        if (state.m_60795_()) {
            return false;
        }
        if (state.m_60811_() == PushReaction.DESTROY) {
            return false;
        }
        return state.m_60815_();
    }

    private static BlockPos findNearestWalkablePosition(ServerLevel level, BlockPos target, BlockPos start) {
        if (SpawnFarMobProcedure.isWalkablePosition(level, target)) {
            return target;
        }
        for (int radius = 1; radius <= 4; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (Math.abs(dx) != radius && Math.abs(dz) != radius) continue;
                    for (int dy = -1; dy <= 1; ++dy) {
                        BlockPos check = target.m_7918_(dx, dy, dz);
                        if (!SpawnFarMobProcedure.isWalkablePosition(level, check)) continue;
                        return check;
                    }
                }
            }
        }
        return start;
    }

    private static boolean isWalkablePosition(ServerLevel level, BlockPos pos) {
        BlockState below = level.m_8055_(pos.m_7495_());
        BlockState at = level.m_8055_(pos);
        BlockState above = level.m_8055_(pos.m_7494_());
        return SpawnFarMobProcedure.isSolidGround(below) && SpawnFarMobProcedure.isPassable(at) && SpawnFarMobProcedure.isPassable(above);
    }

    private static void lookAtPlayer(Mob mob, Player target) {
        Vec3 toPlayer = target.m_20182_().m_82546_(mob.m_20182_());
        if (toPlayer.m_82556_() > 1.0E-6) {
            Vec3 toPlayerNorm = toPlayer.m_82541_();
            float yaw = (float)(Math.atan2(toPlayerNorm.f_82481_, toPlayerNorm.f_82479_) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
    }

    private static void lookInDirection(Mob mob, Vec3 direction) {
        if (direction.m_82556_() > 1.0E-6) {
            float yaw = (float)(Math.atan2(direction.f_82481_, direction.f_82479_) * 180.0 / Math.PI) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
    }

    private static boolean isPlayerLookingAtMob(Mob mob, Player target) {
        Vec3 playerEyePos = target.m_20299_(1.0f);
        Vec3 playerLook = target.m_20154_().m_82541_();
        Vec3 toMob = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0).m_82546_(playerEyePos);
        double distToMob = toMob.m_82553_();
        if (distToMob <= 1.0E-6) {
            return false;
        }
        Vec3 toMobNorm = toMob.m_82490_(1.0 / distToMob);
        double dot = playerLook.m_82526_(toMobNorm);
        return dot > LOOK_FOV_COS;
    }

    private static void startFleeing(Mob mob, Player target, CompoundTag nbt, ServerLevel server) {
        nbt.m_128379_("isFleeing", true);
        nbt.m_128405_("lookingAtTicks", 0);
        nbt.m_128356_("lastPathUpdate", server.m_46467_() - 12L);
        nbt.m_128356_("lastDribble", 0L);
        nbt.m_128379_("isDribbling", false);
    }

    private static boolean shouldDespawn(Mob mob, Player target, CompoundTag nbt, ServerLevel server) {
        double distToPlayer = mob.m_20270_((Entity)target);
        if (distToPlayer > 50.0) {
            return true;
        }
        long spawnTick = nbt.m_128454_("spawnTick");
        long now = server.m_46467_();
        return now - spawnTick > 6000L;
    }

    public static void forceSpawn(ServerLevel level, Player player) {
        BlockPos spawnPos = SpawnFarMobProcedure.findValidSpawnPosition(level, player);
        if (spawnPos == null) {
            return;
        }
        Mob far = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESFAR.get()).m_20615_((Level)level);
        if (far == null) {
            return;
        }
        far.m_7678_((double)spawnPos.m_123341_() + 0.5, (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
        far.m_21530_();
        far.m_21557_(false);
        CompoundTag nbt = far.getPersistentData();
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", level.m_46467_());
        nbt.m_128379_("isFarMob", true);
        nbt.m_128405_("lookingAtTicks", 0);
        nbt.m_128379_("isFleeing", false);
        nbt.m_128356_("lastPathUpdate", level.m_46467_());
        nbt.m_128356_("lastDribble", 0L);
        nbt.m_128379_("isDribbling", false);
        nbt.m_128405_("dribbleTicksLeft", 0);
        nbt.m_128347_("dribbleAngle", 0.0);
        level.m_7967_((Entity)far);
    }

    public static void cleanupOldCooldowns(long currentTick) {
        playerCooldowns.entrySet().removeIf(entry -> currentTick - (Long)entry.getValue() > 3600L);
    }
}

