/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FallingStalactiteProcedure {
    private static final double BASE_PROB = 0.008;
    private static final double MAX_PROB = 0.0015;
    private static final int MIN_FALL_DISTANCE = 3;
    private static final int MAX_FALL_DISTANCE = 12;
    private static final int CHECK_HEIGHT = 20;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        if (ev.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = ev.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel level = (ServerLevel)player2.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 2) {
            return;
        }
        BlockPos playerPos = player2.m_20183_();
        BlockPos blockBelow = playerPos.m_7495_();
        BlockState stateBelow = level.m_8055_(blockBelow);
        if (!FallingStalactiteProcedure.isCaveUpdateBlock(stateBelow)) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, (Player)player2, 0.008, 0.0015);
        if (Math.random() >= dynamicProb) {
            return;
        }
        int horizontalDist = 3 + level.f_46441_.m_188503_(10);
        double angle = level.f_46441_.m_188500_() * Math.PI * 2.0;
        int dx = (int)Math.round(Math.cos(angle) * (double)horizontalDist);
        int dz = (int)Math.round(Math.sin(angle) * (double)horizontalDist);
        BlockPos targetBase = playerPos.m_7918_(dx, 0, dz);
        for (int y = 1; y <= 20; ++y) {
            BlockPos belowDripstone;
            BlockPos abovePos;
            BlockPos checkPos = targetBase.m_6630_(y);
            BlockState checkState = level.m_8055_(checkPos);
            if (checkState.m_60734_() == Blocks.f_152588_ && level.m_8055_(abovePos = checkPos.m_7494_()).m_60795_()) {
                level.m_7731_(checkPos, Blocks.f_50016_.m_49966_(), 3);
                FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)checkPos, (BlockState)checkState);
                falling.m_149656_(2.0f, 40);
                level.m_7967_((Entity)falling);
                level.m_5594_(null, checkPos, SoundEvents.f_144140_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return;
            }
            if (checkState.m_60734_() != Blocks.f_152537_ || !level.m_8055_(belowDripstone = checkPos.m_7495_()).m_60795_()) continue;
            BlockState stalactiteState = Blocks.f_152588_.m_49966_();
            FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)belowDripstone, (BlockState)stalactiteState);
            falling.m_149656_(2.0f, 40);
            level.m_7967_((Entity)falling);
            level.m_5594_(null, belowDripstone, SoundEvents.f_144140_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return;
        }
    }

    private static boolean isCaveUpdateBlock(BlockState state) {
        return state.m_60734_() == Blocks.f_152588_ || state.m_60734_() == Blocks.f_152537_ || state.m_60734_() == Blocks.f_152497_ || state.m_60734_() == Blocks.f_152597_ || state.m_60734_() == Blocks.f_152496_ || state.m_60734_() == Blocks.f_152550_ || state.m_60734_() == Blocks.f_152551_ || state.m_60734_() == Blocks.f_152544_ || state.m_60734_() == Blocks.f_152543_ || state.m_60734_() == Blocks.f_152541_ || state.m_60734_() == Blocks.f_152542_ || state.m_60734_() == Blocks.f_152549_ || state.m_60734_() == Blocks.f_152475_ || state.m_60734_() == Blocks.f_220855_ || state.m_60734_() == Blocks.f_220856_ || state.m_60734_() == Blocks.f_152490_ || state.m_60734_() == Blocks.f_152491_;
    }
}

