/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.FromTheCavesToggleManagerProcedure;
import net.mcreator.fromthecaves.procedures.NoAfectarProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class MobWaterAbilitiesProcedure {
    private static final int DOLPHIN_GRACE_INTERVAL = 30;
    private static final int DOLPHIN_GRACE_DURATION = 100;
    private static final int SPEED_INTERVAL = 25;
    private static final int SPEED_DURATION = 80;
    private static final int WATER_PUSH_INTERVAL = 9;
    private static final double WATER_PUSH_STRENGTH = 1.0;
    private static final double WATER_SPRINT_BOOST = 1.0;
    private static final String FROZEN_KEY = "frozenWaterBlocks";
    private static final int ICE_DURATION = 40;
    private static final double PLAYER_DETECTION_RANGE = 128.0;
    private static final double WATER_PUSH_RANGE = 30.0;
    private static final int REGEN_INTERVAL = 40;
    private static final int REGEN_DURATION = 60;
    private static final int RESISTANCE_INTERVAL = 60;
    private static final int RESISTANCE_DURATION = 100;
    private static final int ICE_PATH_RANGE = 3;
    private static final int FREEZE_PLAYER_INTERVAL = 100;
    private static final double FREEZE_RANGE = 8.0;
    private static final int MIN_HEIGHT_DIFF_TO_FREEZE = 2;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent ev) {
        if (!FromTheCavesToggleManagerProcedure.isMobsSuperInteligentesEnabled()) {
            return;
        }
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)ent;
        if (!FromTheCavesToggleManagerProcedure.isAllSpawnsEnabled()) {
            return;
        }
        if (NoAfectarProcedure.shouldSkip((Entity)mob)) {
            return;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null || !key.m_135827_().equals("from_the_caves")) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        MobWaterAbilitiesProcedure.processFrozenBlocks(server, mob);
        MobWaterAbilitiesProcedure.configureWaterPathfinding(mob);
        if (MobWaterAbilitiesProcedure.isInOrTouchingWater(mob)) {
            MobWaterAbilitiesProcedure.handleWaterAbilities(server, mob);
            MobWaterAbilitiesProcedure.handleWaterBuffs(server, mob);
        }
        MobWaterAbilitiesProcedure.handleAdvancedIcePathCreation(server, mob);
        MobWaterAbilitiesProcedure.handlePlayerFreezing(server, mob);
    }

    private static void configureWaterPathfinding(PathfinderMob mob) {
        mob.m_21441_(BlockPathTypes.WATER, -1.0f);
        mob.m_21441_(BlockPathTypes.WATER_BORDER, -1.0f);
    }

    private static void handleWaterAbilities(ServerLevel server, PathfinderMob mob) {
        long tick = server.m_46467_();
        CompoundTag data = mob.getPersistentData();
        MobWaterAbilitiesProcedure.applyDolphinGrace(server, mob, data, tick);
        MobWaterAbilitiesProcedure.applySpeedBoost(server, mob, data, tick);
        MobWaterAbilitiesProcedure.applyWaterPush(server, mob, data, tick);
    }

    private static void applyDolphinGrace(ServerLevel server, PathfinderMob mob, CompoundTag data, long tick) {
        long nextDolphinGrace = data.m_128454_("nextDolphinGraceTick");
        if (tick < nextDolphinGrace) {
            return;
        }
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 100, 2, false, false));
        data.m_128356_("nextDolphinGraceTick", tick + 30L);
    }

    private static void applySpeedBoost(ServerLevel server, PathfinderMob mob, CompoundTag data, long tick) {
        long nextSpeed = data.m_128454_("nextSpeedTick");
        if (tick < nextSpeed) {
            return;
        }
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, 1, false, false));
        data.m_128356_("nextSpeedTick", tick + 25L);
    }

    private static void applyWaterPush(ServerLevel server, PathfinderMob mob, CompoundTag data, long tick) {
        long nextWaterPush = data.m_128454_("nextWaterPushTick");
        if (tick < nextWaterPush) {
            return;
        }
        Player nearPlayer = server.m_45930_((Entity)mob, 30.0);
        if (nearPlayer == null) {
            return;
        }
        Vec3 direction = nearPlayer.m_146892_().m_82546_(mob.m_20182_()).m_82541_();
        double boost = mob.m_20142_() ? 1.0 : 0.0;
        Vec3 finalDirection = direction.m_82490_(1.0 + boost);
        mob.m_20256_(mob.m_20184_().m_82549_(finalDirection));
        mob.f_19812_ = true;
        data.m_128356_("nextWaterPushTick", tick + 9L);
    }

    private static void handleWaterBuffs(ServerLevel server, PathfinderMob mob) {
        long tick = server.m_46467_();
        CompoundTag data = mob.getPersistentData();
        MobWaterAbilitiesProcedure.applyRegeneration(mob, data, tick);
        MobWaterAbilitiesProcedure.applyResistance(mob, data, tick);
    }

    private static void applyRegeneration(PathfinderMob mob, CompoundTag data, long tick) {
        long nextRegen = data.m_128454_("nextRegenTick");
        if (tick < nextRegen) {
            return;
        }
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60, 0, false, false));
        data.m_128356_("nextRegenTick", tick + 40L);
    }

    private static void applyResistance(PathfinderMob mob, CompoundTag data, long tick) {
        long nextResistance = data.m_128454_("nextResistanceTick");
        if (tick < nextResistance) {
            return;
        }
        mob.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 0, false, false));
        data.m_128356_("nextResistanceTick", tick + 60L);
    }

    private static void handleAdvancedIcePathCreation(ServerLevel server, PathfinderMob mob) {
        Player player = server.m_45930_((Entity)mob, 128.0);
        if (player == null) {
            return;
        }
        if (!MobWaterAbilitiesProcedure.shouldFreezeForPlayer(mob, player)) {
            return;
        }
        MobWaterAbilitiesProcedure.createIcePathAroundMob(server, mob);
    }

    private static boolean shouldFreezeForPlayer(PathfinderMob mob, Player player) {
        int playerY;
        int mobY = mob.m_20183_().m_123342_();
        int heightDiff = mobY - (playerY = player.m_20183_().m_123342_());
        return heightDiff < 2;
    }

    private static void createIcePathAroundMob(ServerLevel server, PathfinderMob mob) {
        BlockPos mobPos = mob.m_20183_();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dz = -3; dz <= 3; ++dz) {
                BlockPos targetPos;
                if (dx == 0 && dz == 0 || !MobWaterAbilitiesProcedure.isWithinCircularRange(dx, dz, 3) || !MobWaterAbilitiesProcedure.canFreezePosition(server, mob, targetPos = mobPos.m_7918_(dx, -1, dz))) continue;
                MobWaterAbilitiesProcedure.freezeWaterBlock(server, mob, targetPos);
            }
        }
    }

    private static boolean isWithinCircularRange(int dx, int dz, int range) {
        double dist = Math.sqrt(dx * dx + dz * dz);
        return dist <= (double)range;
    }

    private static boolean canFreezePosition(ServerLevel server, PathfinderMob mob, BlockPos pos) {
        if (server.m_6425_(pos).m_76152_() != Fluids.f_76193_) {
            return false;
        }
        return !MobWaterAbilitiesProcedure.isPosAlreadyFrozen(mob, pos);
    }

    private static void freezeWaterBlock(ServerLevel server, PathfinderMob mob, BlockPos pos) {
        server.m_46597_(pos, Blocks.f_50449_.m_49966_());
        long expireTime = server.m_46467_() + 40L;
        MobWaterAbilitiesProcedure.addFrozenBlock(mob, pos, expireTime);
    }

    private static void handlePlayerFreezing(ServerLevel server, PathfinderMob mob) {
        CompoundTag data;
        long nextFreeze;
        long tick = server.m_46467_();
        if (tick < (nextFreeze = (data = mob.getPersistentData()).m_128454_("nextFreezeTick"))) {
            return;
        }
        Player target = server.m_45930_((Entity)mob, 8.0);
        if (target == null) {
            return;
        }
        if (!MobWaterAbilitiesProcedure.canFreezePlayer(mob, target)) {
            return;
        }
        MobWaterAbilitiesProcedure.applyFreezeEffects(mob, target, data, tick);
    }

    private static boolean canFreezePlayer(PathfinderMob mob, Player target) {
        int playerY;
        if (!MobWaterAbilitiesProcedure.isInOrTouchingWater(mob)) {
            return false;
        }
        if (!target.m_20069_()) {
            return false;
        }
        int mobY = mob.m_20183_().m_123342_();
        int heightDiff = mobY - (playerY = target.m_20183_().m_123342_());
        return heightDiff < 2;
    }

    private static void applyFreezeEffects(PathfinderMob mob, Player target, CompoundTag data, long tick) {
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 2, false, true));
        target.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 60, 1, false, true));
        target.m_6469_(mob.m_269291_().m_269109_(), 2.0f);
        data.m_128356_("nextFreezeTick", tick + 100L);
    }

    private static void processFrozenBlocks(ServerLevel server, PathfinderMob mob) {
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128425_(FROZEN_KEY, 9)) {
            return;
        }
        ListTag frozenList = data.m_128437_(FROZEN_KEY, 10);
        ListTag updatedList = new ListTag();
        long currentTick = server.m_46467_();
        for (int i = 0; i < frozenList.size(); ++i) {
            CompoundTag blockData = frozenList.m_128728_(i);
            if (!MobWaterAbilitiesProcedure.shouldMeltBlock(server, blockData, currentTick)) {
                updatedList.add((Object)blockData);
                continue;
            }
            MobWaterAbilitiesProcedure.meltFrozenBlock(server, blockData);
        }
        data.m_128365_(FROZEN_KEY, (Tag)updatedList);
    }

    private static boolean shouldMeltBlock(ServerLevel server, CompoundTag blockData, long currentTick) {
        long expireTime = blockData.m_128454_("expire");
        return currentTick >= expireTime;
    }

    private static void meltFrozenBlock(ServerLevel server, CompoundTag blockData) {
        BlockPos pos = new BlockPos(blockData.m_128451_("x"), blockData.m_128451_("y"), blockData.m_128451_("z"));
        Block currentBlock = server.m_8055_(pos).m_60734_();
        if (currentBlock == Blocks.f_50449_ || currentBlock == Blocks.f_50126_) {
            server.m_46597_(pos, Blocks.f_49990_.m_49966_());
        }
    }

    private static boolean isPosAlreadyFrozen(PathfinderMob mob, BlockPos pos) {
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128425_(FROZEN_KEY, 9)) {
            return false;
        }
        ListTag frozenList = data.m_128437_(FROZEN_KEY, 10);
        for (int i = 0; i < frozenList.size(); ++i) {
            CompoundTag blockData = frozenList.m_128728_(i);
            if (!MobWaterAbilitiesProcedure.isSamePosition(blockData, pos)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSamePosition(CompoundTag blockData, BlockPos pos) {
        return blockData.m_128451_("x") == pos.m_123341_() && blockData.m_128451_("y") == pos.m_123342_() && blockData.m_128451_("z") == pos.m_123343_();
    }

    private static void addFrozenBlock(PathfinderMob mob, BlockPos pos, long expireTick) {
        CompoundTag data = mob.getPersistentData();
        ListTag frozenList = data.m_128425_(FROZEN_KEY, 9) ? data.m_128437_(FROZEN_KEY, 10) : new ListTag();
        CompoundTag blockData = MobWaterAbilitiesProcedure.createFrozenBlockData(pos, expireTick);
        frozenList.add((Object)blockData);
        data.m_128365_(FROZEN_KEY, (Tag)frozenList);
    }

    private static CompoundTag createFrozenBlockData(BlockPos pos, long expireTick) {
        CompoundTag blockData = new CompoundTag();
        blockData.m_128405_("x", pos.m_123341_());
        blockData.m_128405_("y", pos.m_123342_());
        blockData.m_128405_("z", pos.m_123343_());
        blockData.m_128356_("expire", expireTick);
        return blockData;
    }

    private static boolean isInOrTouchingWater(PathfinderMob mob) {
        if (mob.m_20069_()) {
            return true;
        }
        Level world = mob.m_9236_();
        BlockPos origin = mob.m_20183_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos checkPos;
                if (dx == 0 && dz == 0 || world.m_8055_(checkPos = origin.m_7918_(dx, 0, dz)).m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }
}

