/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Phase0WatchersProcedure {
    private static final double BASE_PROB = 5.0E-5;
    private static final double MAX_PROB = 7.0E-5;
    private static final double MIN_DIST = 16.0;
    private static final double MAX_DIST = 45.0;
    private static final double WATCH_DISTANCE = 80.0;
    private static final double CHASE_TRIGGER_DIST = 14.0;
    private static final int LOOK_TRIGGER_TICKS = 120;
    private static final double RUN_SPEED = 0.8;
    private static final int RUN_DURATION_TICKS = 200;
    private static final double GRAVITY = 0.42;
    private static final double HIDE_SEARCH_RADIUS = 10.0;
    private static final double HIDE_CHECK_INTERVAL = 8.0;
    private static final double HIDE_MIN_COVER = 0.5;
    private static final double DESCEND_PREFER_CHANCE = 0.75;
    private static final double BURROW_SPEED = 0.35;
    private static final double DESPAWN_BEHIND_COVER_DIST = 30.0;
    private static final int DESPAWN_HIDDEN_TICKS = 80;
    private static final int DESPAWN_DELAY_TICKS = 20;
    private static final double DARK_SPOT_PREFERENCE = 0.7;
    private static final int MAX_LIGHT_LEVEL = 5;
    private static final double BEHIND_PLAYER_CHANCE = 0.15;
    private static final double CEILING_SPAWN_CHANCE = 0.15;
    private static final double CORNER_SPAWN_CHANCE = 0.15;
    private static final double BEHIND_DOOR_CHANCE = 0.15;
    private static final double BEHIND_GLASS_CHANCE = 0.1;
    private static final double BEHIND_FOLIAGE_CHANCE = 0.1;
    private static final double ON_TRAPDOOR_CHANCE = 0.1;
    private static final int MAX_SPAWN_ATTEMPTS = 15;
    private static final double NOCLIP_SPEED = 0.6;
    private static final String KEY_SPAWN_TIME = "poyes_spawnTime";
    private static final String KEY_LOOK_START = "poyes_lookStart";
    private static final String KEY_RUNNING = "poyes_running";
    private static final String KEY_RUN_START = "poyes_runStart";
    private static final String KEY_HIDE_CHECK = "poyes_hideCheck";
    private static final String KEY_BURROWING = "poyes_burrowing";
    private static final String KEY_HIDDEN_START = "poyes_hiddenStart";
    private static final String KEY_PREFER_DESCEND = "poyes_preferDescend";
    private static final String KEY_FROZEN = "poyes_frozen";
    private static final String KEY_FADE_START = "poyes_fadeStart";
    private static final String KEY_SPAWN_TYPE = "poyes_spawnType";
    private static final String KEY_DESPAWN_DELAY = "poyes_despawnDelay";
    private static final String KEY_DESPAWN_STARTED = "poyes_despawnStarted";
    private static final String KEY_ON_TRAPDOOR = "poyes_onTrapdoor";

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        if (player.m_20186_() >= 50.0) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 0) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 5.0E-5, 7.0E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        EntityType<?> chosenEntity = Phase0WatchersProcedure.chooseRandomEntity();
        BlockPos spawnPos = Phase0WatchersProcedure.findOptimalSpawnPosition(level, player, chosenEntity);
        if (spawnPos == null) {
            return;
        }
        Mob mob = (Mob)chosenEntity.m_262496_(level, spawnPos, MobSpawnType.MOB_SUMMONED);
        if (mob == null) {
            return;
        }
        mob.m_20242_(false);
        mob.m_21557_(false);
        mob.m_21530_();
        mob.f_19794_ = false;
        Phase0WatchersProcedure.makeEntityLookAtPlayer(mob, player);
        CompoundTag data = mob.getPersistentData();
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_RUNNING, false);
        data.m_128473_(KEY_LOOK_START);
        data.m_128473_(KEY_RUN_START);
        data.m_128405_(KEY_HIDE_CHECK, 0);
        data.m_128379_(KEY_BURROWING, false);
        data.m_128379_(KEY_PREFER_DESCEND, Math.random() < 0.75);
        data.m_128379_(KEY_FROZEN, false);
        data.m_128379_(KEY_DESPAWN_STARTED, false);
        BlockState stateBelow = level.m_8055_(spawnPos.m_7495_());
        if (stateBelow.m_60734_() instanceof TrapDoorBlock) {
            data.m_128379_(KEY_ON_TRAPDOOR, true);
        } else {
            data.m_128379_(KEY_ON_TRAPDOOR, false);
        }
    }

    private static EntityType<?> chooseRandomEntity() {
        double roll = Math.random();
        if (roll < 0.5) {
            return (EntityType)FromTheCavesModEntities.WATCHEYES.get();
        }
        if (roll < 0.8) {
            return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get();
        }
        return (EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get();
    }

    private static BlockPos findOptimalSpawnPosition(ServerLevel level, Player player, EntityType<?> entityType) {
        BlockPos trapdoor;
        BlockPos foliage;
        BlockPos glass;
        BlockPos door;
        BlockPos corner;
        BlockPos ceiling;
        BlockPos behind;
        double totalChance = 0.8999999999999999;
        double spawnTypeRoll = Math.random() * totalChance;
        double accumulated = 0.0;
        if (spawnTypeRoll < (accumulated += 0.15) && (behind = Phase0WatchersProcedure.findPositionBehindPlayer(level, player)) != null) {
            return behind;
        }
        if (spawnTypeRoll < (accumulated += 0.15) && (ceiling = Phase0WatchersProcedure.findCeilingPosition(level, player)) != null) {
            return ceiling;
        }
        if (spawnTypeRoll < (accumulated += 0.15) && (corner = Phase0WatchersProcedure.findCornerPosition(level, player)) != null) {
            return corner;
        }
        if (spawnTypeRoll < (accumulated += 0.15) && (door = Phase0WatchersProcedure.findPositionBehindDoor(level, player)) != null) {
            return door;
        }
        if (spawnTypeRoll < (accumulated += 0.1) && (glass = Phase0WatchersProcedure.findPositionBehindGlass(level, player)) != null) {
            return glass;
        }
        if (spawnTypeRoll < (accumulated += 0.1) && (foliage = Phase0WatchersProcedure.findPositionBehindFoliage(level, player)) != null) {
            return foliage;
        }
        if (spawnTypeRoll < (accumulated += 0.1) && (trapdoor = Phase0WatchersProcedure.findPositionOnTrapdoor(level, player)) != null) {
            return trapdoor;
        }
        for (int attempt = 0; attempt < 15; ++attempt) {
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 16.0 + Math.random() * 29.0;
            double sx = player.m_20185_() + Math.cos(angle) * dist;
            double sz = player.m_20189_() + Math.sin(angle) * dist;
            BlockPos testPos = Phase0WatchersProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz));
            if (testPos == null) continue;
            boolean preferDark = Math.random() < 0.7;
            int lightLevel = level.m_46803_(testPos);
            if (preferDark && lightLevel > 5 && attempt < 12 || !Phase0WatchersProcedure.isPositionValid(level, testPos, player)) continue;
            return testPos;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 16.0 + Math.random() * 29.0;
        return BlockPos.m_274561_((double)(player.m_20185_() + Math.cos(angle) * dist), (double)player.m_20186_(), (double)(player.m_20189_() + Math.sin(angle) * dist));
    }

    private static BlockPos findPositionBehindPlayer(ServerLevel level, Player player) {
        Vec3 lookDir = player.m_20252_(1.0f).m_82541_();
        Vec3 behindDir = new Vec3(-lookDir.f_82479_, 0.0, -lookDir.f_82481_).m_82541_();
        double dist = 16.0 + Math.random() * 10.0;
        double sx = player.m_20185_() + behindDir.f_82479_ * dist;
        double sz = player.m_20189_() + behindDir.f_82481_ * dist;
        BlockPos groundPos = Phase0WatchersProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz));
        if (groundPos != null && Phase0WatchersProcedure.isPositionValid(level, groundPos, player)) {
            return groundPos;
        }
        return null;
    }

    private static BlockPos findCeilingPosition(ServerLevel level, Player player) {
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 16.0 + Math.random() * 15.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        int y = (int)player.m_20186_() + 3;
        while ((double)y <= Math.min(player.m_20186_() + 12.0, (double)(level.m_151558_() - 1))) {
            BlockPos testPos = BlockPos.m_274561_((double)sx, (double)y, (double)sz);
            BlockPos above = testPos.m_7494_();
            if (level.m_46749_(testPos) && level.m_46749_(above)) {
                int lightLevel;
                BlockState stateAt = level.m_8055_(testPos);
                BlockState stateAbove = level.m_8055_(above);
                if (stateAt.m_60795_() && stateAbove.m_280296_() && !stateAbove.m_60713_(Blocks.f_50752_) && (lightLevel = level.m_46803_(testPos)) <= 7) {
                    return testPos;
                }
            }
            ++y;
        }
        return null;
    }

    private static BlockPos findCornerPosition(ServerLevel level, Player player) {
        int[][] directions;
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 16.0 + Math.random() * 12.0;
        double sx = player.m_20185_() + Math.cos(angle) * dist;
        double sz = player.m_20189_() + Math.sin(angle) * dist;
        BlockPos basePos = Phase0WatchersProcedure.findSuitableGroundPosition(level, BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz));
        if (basePos == null) {
            return null;
        }
        int wallsNearby = 0;
        for (int[] dir : directions = new int[][]{{1, 0}, {-1, 0}, {0, 1}, {0, -1}}) {
            BlockPos wallCheck = basePos.m_7918_(dir[0], 0, dir[1]);
            if (!level.m_46749_(wallCheck) || !level.m_8055_(wallCheck).m_280296_()) continue;
            ++wallsNearby;
        }
        if (wallsNearby >= 2 && Phase0WatchersProcedure.isPositionValid(level, basePos, player)) {
            return basePos;
        }
        return null;
    }

    private static BlockPos findPositionBehindDoor(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int radius = 3; radius <= 10; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -2; dy <= 2; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockState state;
                        BlockPos checkPos;
                        if (Math.abs(dx) != radius && Math.abs(dz) != radius || !level.m_46749_(checkPos = playerPos.m_7918_(dx, dy, dz)) || !((state = level.m_8055_(checkPos)).m_60734_() instanceof DoorBlock)) continue;
                        Vec3 doorVec = new Vec3((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5);
                        Vec3 playerVec = player.m_20182_();
                        Vec3 toDoor = doorVec.m_82546_(playerVec).m_82541_();
                        double distance = 1.5;
                        BlockPos behindDoor = BlockPos.m_274561_((double)(doorVec.f_82479_ + toDoor.f_82479_ * distance), (double)checkPos.m_123342_(), (double)(doorVec.f_82481_ + toDoor.f_82481_ * distance));
                        if (!Phase0WatchersProcedure.isPositionValidForSpawn(level, behindDoor)) continue;
                        return behindDoor;
                    }
                }
            }
        }
        return null;
    }

    private static BlockPos findPositionBehindGlass(ServerLevel level, Player player) {
        Vec3 lookDir = player.m_20252_(1.0f).m_82541_();
        BlockPos playerPos = player.m_20183_();
        for (int dist = 3; dist <= 15; ++dist) {
            BlockState state;
            BlockPos checkPos = BlockPos.m_274561_((double)((double)playerPos.m_123341_() + lookDir.f_82479_ * (double)dist), (double)playerPos.m_123342_(), (double)((double)playerPos.m_123343_() + lookDir.f_82481_ * (double)dist));
            if (!level.m_46749_(checkPos) || !Phase0WatchersProcedure.isGlassBlock(state = level.m_8055_(checkPos))) continue;
            for (int behind = 1; behind <= 3; ++behind) {
                BlockPos spawnPos = BlockPos.m_274561_((double)((double)checkPos.m_123341_() + lookDir.f_82479_ * (double)behind), (double)checkPos.m_123342_(), (double)((double)checkPos.m_123343_() + lookDir.f_82481_ * (double)behind));
                if (!Phase0WatchersProcedure.isPositionValidForSpawn(level, spawnPos)) continue;
                return spawnPos;
            }
        }
        return null;
    }

    private static BlockPos findPositionBehindFoliage(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int attempts = 0; attempts < 20; ++attempts) {
            BlockPos groundPos;
            double angle = Math.random() * Math.PI * 2.0;
            double dist = 16.0 + Math.random() * 15.0;
            double sx = player.m_20185_() + Math.cos(angle) * dist;
            double sz = player.m_20189_() + Math.sin(angle) * dist;
            BlockPos checkPos = BlockPos.m_274561_((double)sx, (double)player.m_20186_(), (double)sz);
            if (!level.m_46749_(checkPos)) continue;
            boolean hasFoliage = false;
            for (int dy = 0; dy <= 2; ++dy) {
                BlockPos foliageCheck = checkPos.m_7918_(0, dy, 0);
                BlockState state = level.m_8055_(foliageCheck);
                if (!Phase0WatchersProcedure.isFoliageBlock(state)) continue;
                hasFoliage = true;
                break;
            }
            if (!hasFoliage || (groundPos = Phase0WatchersProcedure.findSuitableGroundPosition(level, checkPos)) == null || !Phase0WatchersProcedure.isPositionValid(level, groundPos, player)) continue;
            return groundPos;
        }
        return null;
    }

    private static BlockPos findPositionOnTrapdoor(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int radius = 3; radius <= 12; ++radius) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -2; dy <= 2; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        double distance;
                        BlockPos above;
                        BlockPos checkPos;
                        if (Math.abs(dx) != radius && Math.abs(dz) != radius || !level.m_46749_(checkPos = playerPos.m_7918_(dx, dy, dz))) continue;
                        BlockState stateBelow = level.m_8055_(checkPos.m_7495_());
                        BlockState stateAt = level.m_8055_(checkPos);
                        if (!(stateBelow.m_60734_() instanceof TrapDoorBlock) || !stateAt.m_60795_() || !level.m_8055_(above = checkPos.m_7494_()).m_60795_() || !((distance = Math.sqrt(checkPos.m_203193_((Position)player.m_20182_()))) >= 16.0) || !(distance <= 45.0)) continue;
                        return checkPos;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isGlassBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13049_) || state.m_60734_() == Blocks.f_50058_ || state.m_60734_() == Blocks.f_152498_ || state.m_60734_() == Blocks.f_50147_ || state.m_60734_() == Blocks.f_50148_ || state.m_60734_() == Blocks.f_50202_ || state.m_60734_() == Blocks.f_50203_ || state.m_60734_() == Blocks.f_50204_ || state.m_60734_() == Blocks.f_50205_ || state.m_60734_() == Blocks.f_50206_ || state.m_60734_() == Blocks.f_50207_ || state.m_60734_() == Blocks.f_50208_ || state.m_60734_() == Blocks.f_50209_ || state.m_60734_() == Blocks.f_50210_ || state.m_60734_() == Blocks.f_50211_ || state.m_60734_() == Blocks.f_50212_ || state.m_60734_() == Blocks.f_50213_ || state.m_60734_() == Blocks.f_50214_ || state.m_60734_() == Blocks.f_50215_ || state.m_60734_() == Blocks.f_50185_ || state.m_60734_() == Blocks.f_50303_ || state.m_60734_() == Blocks.f_50304_ || state.m_60734_() == Blocks.f_50305_ || state.m_60734_() == Blocks.f_50306_ || state.m_60734_() == Blocks.f_50307_ || state.m_60734_() == Blocks.f_50361_ || state.m_60734_() == Blocks.f_50362_ || state.m_60734_() == Blocks.f_50363_ || state.m_60734_() == Blocks.f_50364_ || state.m_60734_() == Blocks.f_50365_ || state.m_60734_() == Blocks.f_50366_ || state.m_60734_() == Blocks.f_50367_ || state.m_60734_() == Blocks.f_50368_ || state.m_60734_() == Blocks.f_50369_ || state.m_60734_() == Blocks.f_50370_ || state.m_60734_() == Blocks.f_50371_;
    }

    private static boolean isFoliageBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13041_) || state.m_60734_() == Blocks.f_50359_ || state.m_60734_() == Blocks.f_50360_ || state.m_60734_() == Blocks.f_50038_ || state.m_60734_() == Blocks.f_50191_ || state.m_60734_() == Blocks.f_50702_ || state.m_60734_() == Blocks.f_50704_ || state.m_60734_() == Blocks.f_152538_ || state.m_60734_() == Blocks.f_152539_ || state.m_60734_() instanceof FenceBlock || state.m_60734_() instanceof FenceGateBlock;
    }

    private static boolean isPositionValidForSpawn(ServerLevel level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_()) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        if (!level.m_46749_(below)) {
            return false;
        }
        BlockState belowState = level.m_8055_(below);
        return !belowState.m_60795_() || belowState.m_60734_() instanceof TrapDoorBlock;
    }

    private static BlockPos findSuitableGroundPosition(ServerLevel level, BlockPos start) {
        BlockPos.MutableBlockPos mutable = start.m_122032_();
        for (int dy = 3; dy >= -5; --dy) {
            mutable.m_122178_(start.m_123341_(), start.m_123342_() + dy, start.m_123343_());
            if (!level.m_46749_((BlockPos)mutable)) continue;
            BlockState stateAt = level.m_8055_((BlockPos)mutable);
            BlockState stateBelow = level.m_8055_(mutable.m_7495_());
            if (!stateAt.m_60795_() || stateBelow.m_60795_() || !stateBelow.m_280296_()) continue;
            return mutable.m_7949_();
        }
        return null;
    }

    private static boolean isPositionValid(ServerLevel level, BlockPos pos, Player player) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        BlockState state = level.m_8055_(pos);
        if (!state.m_60795_()) {
            return false;
        }
        BlockPos above = pos.m_7494_();
        if (level.m_46749_(above) && !level.m_8055_(above).m_60795_()) {
            return false;
        }
        double dist = Math.sqrt(pos.m_203193_((Position)player.m_20182_()));
        return !(dist < 16.0) && !(dist > 45.0);
    }

    private static void makeEntityLookAtPlayer(Mob mob, Player player) {
        double dx = player.m_20185_() - mob.m_20185_();
        double dz = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        double dy = player.m_20188_() - mob.m_20188_();
        double horizontalDist = Math.sqrt(dx * dx + dz * dz);
        float pitch = (float)(Math.atan2(dy, horizontalDist) * 180.0 / Math.PI);
        mob.m_146926_(pitch);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        EntityType type = mob.m_6095_();
        if (!(type.equals(FromTheCavesModEntities.WATCHEYES.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWLARGE.get()) || type.equals(FromTheCavesModEntities.FROMTHECAVESSHADOWSPIDER.get()))) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        if (data.m_128471_("hcs_houseCorner")) {
            return;
        }
        long now = level.m_46467_();
        Player player = level.m_45930_((Entity)mob, 80.0);
        if (player == null) {
            mob.m_146870_();
            return;
        }
        double dist = mob.m_20270_((Entity)player);
        boolean running = data.m_128471_(KEY_RUNNING);
        boolean frozen = data.m_128471_(KEY_FROZEN);
        boolean onTrapdoor = data.m_128471_(KEY_ON_TRAPDOOR);
        if (frozen) {
            Phase0WatchersProcedure.handleFrozenBehavior(mob, data, level, player, now);
            return;
        }
        if (!running) {
            Phase0WatchersProcedure.handleWatchingBehavior(mob, data, level, player, now, dist, onTrapdoor);
            return;
        }
        if (onTrapdoor) {
            Phase0WatchersProcedure.handleTrapdoorFlee(mob, data, level, player, now);
        } else {
            Phase0WatchersProcedure.handleFleeingBehavior(mob, data, level, player, now);
        }
    }

    private static void handleWatchingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now, double dist, boolean onTrapdoor) {
        double vanishRoll;
        boolean inSightCone;
        Phase0WatchersProcedure.makeEntityLookAtPlayer(mob, player);
        if (!onTrapdoor) {
            mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        } else {
            mob.m_20334_(0.0, 0.0, 0.0);
            mob.m_20242_(true);
        }
        if (dist <= 14.0) {
            Phase0WatchersProcedure.startRunning(mob, data, now);
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        Vec3 toMob = new Vec3(mob.m_20185_() - player.m_20185_(), mob.m_20186_() - player.m_20186_(), mob.m_20189_() - player.m_20189_());
        if (toMob.m_82553_() == 0.0) {
            data.m_128473_(KEY_LOOK_START);
            return;
        }
        Vec3 toMobNorm = toMob.m_82541_();
        double dot = playerLook.f_82479_ * toMobNorm.f_82479_ + playerLook.f_82480_ * toMobNorm.f_82480_ + playerLook.f_82481_ * toMobNorm.f_82481_;
        boolean bl = inSightCone = dot > 0.92 && hasLOS;
        if (inSightCone) {
            if (!data.m_128441_(KEY_LOOK_START)) {
                data.m_128356_(KEY_LOOK_START, now);
            } else {
                long started = data.m_128454_(KEY_LOOK_START);
                if (now - started >= 120L) {
                    double freezeRoll = Math.random();
                    if (freezeRoll < 0.15) {
                        data.m_128379_(KEY_FROZEN, true);
                        data.m_128356_(KEY_FADE_START, now);
                    } else {
                        Phase0WatchersProcedure.startRunning(mob, data, now);
                    }
                    return;
                }
            }
        } else {
            data.m_128473_(KEY_LOOK_START);
        }
        long spawnTime = data.m_128454_(KEY_SPAWN_TIME);
        if (now - spawnTime > 600L && (vanishRoll = Math.random()) < 0.02 && !hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleFrozenBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.m_20334_(0.0, mob.m_20184_().f_82480_, 0.0);
        mob.m_21557_(true);
        long fadeStart = data.m_128454_(KEY_FADE_START);
        long fadeDuration = 60L;
        if (now - fadeStart >= fadeDuration) {
            mob.m_146870_();
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        if (!hasLOS) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleTrapdoorFlee(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.f_19794_ = true;
        mob.m_20242_(true);
        Vec3 motion = new Vec3(0.0, -0.42, 0.0);
        mob.m_20256_(motion);
        double newY = mob.m_20186_() + motion.f_82480_;
        mob.m_6021_(mob.m_20185_(), newY, mob.m_20189_());
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 12.0) {
            mob.m_146870_();
            return;
        }
        if (mob.m_20186_() < player.m_20186_() - 8.0 || mob.m_20183_().m_123342_() <= 1) {
            mob.m_146870_();
            return;
        }
        if (!data.m_128441_(KEY_RUN_START)) {
            data.m_128356_(KEY_RUN_START, now);
        } else if (now - data.m_128454_(KEY_RUN_START) >= 200L) {
            mob.m_146870_();
            return;
        }
    }

    private static void handleFleeingBehavior(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        BlockState bs;
        BlockPos below;
        boolean burrowing = data.m_128471_(KEY_BURROWING);
        boolean preferDescend = data.m_128471_(KEY_PREFER_DESCEND);
        boolean despawnStarted = data.m_128471_(KEY_DESPAWN_STARTED);
        if (burrowing) {
            Phase0WatchersProcedure.handleBurrowing(mob, data, level, player, now);
            return;
        }
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 30.0) {
            if (!data.m_128441_(KEY_HIDDEN_START)) {
                data.m_128356_(KEY_HIDDEN_START, now);
            } else {
                long hiddenTime = now - data.m_128454_(KEY_HIDDEN_START);
                if (hiddenTime >= 80L) {
                    if (!despawnStarted) {
                        data.m_128379_(KEY_DESPAWN_STARTED, true);
                        data.m_128356_(KEY_DESPAWN_DELAY, now);
                    } else {
                        long despawnTime = now - data.m_128454_(KEY_DESPAWN_DELAY);
                        if (despawnTime >= 20L) {
                            mob.m_146870_();
                            return;
                        }
                    }
                }
            }
        } else {
            data.m_128473_(KEY_HIDDEN_START);
            data.m_128379_(KEY_DESPAWN_STARTED, false);
        }
        int hideCheck = data.m_128451_(KEY_HIDE_CHECK);
        data.m_128405_(KEY_HIDE_CHECK, ++hideCheck);
        Vec3 targetDir = null;
        if ((double)hideCheck >= 8.0) {
            Vec3 toHide;
            data.m_128405_(KEY_HIDE_CHECK, 0);
            BlockPos hideSpot = Phase0WatchersProcedure.findBestHidingSpot(mob, player, level, preferDescend);
            if (hideSpot != null && (toHide = new Vec3((double)hideSpot.m_123341_() + 0.5 - mob.m_20185_(), (double)hideSpot.m_123342_() - mob.m_20186_(), (double)hideSpot.m_123343_() + 0.5 - mob.m_20189_())).m_82556_() > 1.0E-6) {
                targetDir = toHide.m_82541_();
            }
        }
        if (targetDir == null) {
            Vec3 fleeDir = new Vec3(mob.m_20185_() - player.m_20185_(), 0.0, mob.m_20189_() - player.m_20189_());
            if (fleeDir.m_82556_() < 1.0E-6) {
                Vec3 look = player.m_20252_(1.0f).m_82541_();
                fleeDir = new Vec3(-look.f_82479_, 0.0, -look.f_82481_);
            }
            targetDir = new Vec3(fleeDir.f_82479_, 0.0, fleeDir.f_82481_).m_82541_();
        }
        if (preferDescend && dist < 20.0 && Math.random() < 0.15 && level.m_46749_(below = mob.m_20183_().m_7495_()) && !(bs = level.m_8055_(below)).m_60795_() && bs.m_60734_() != Blocks.f_50752_) {
            data.m_128379_(KEY_BURROWING, true);
            return;
        }
        mob.m_21557_(true);
        mob.m_20242_(false);
        mob.f_19794_ = true;
        double speedFactor = 0.6;
        BlockPos belowPos = mob.m_20183_().m_7495_();
        boolean onGround = true;
        if (level.m_46749_(belowPos)) {
            BlockState belowState = level.m_8055_(belowPos);
            onGround = !belowState.m_60795_();
        }
        double currentY = mob.m_20184_().f_82480_;
        double newY = onGround ? Math.min(currentY, 0.0) : currentY - 0.21;
        Vec3 motion = new Vec3(targetDir.f_82479_ * speedFactor, newY, targetDir.f_82481_ * speedFactor);
        mob.m_20256_(motion);
        double newX = mob.m_20185_() + motion.f_82479_;
        double newY_pos = mob.m_20186_() + motion.f_82480_;
        double newZ = mob.m_20189_() + motion.f_82481_;
        mob.m_6021_(newX, newY_pos, newZ);
        if (data.m_128441_(KEY_RUN_START)) {
            long runStart = data.m_128454_(KEY_RUN_START);
            if (now - runStart >= 200L) {
                mob.m_146870_();
                return;
            }
        } else {
            data.m_128356_(KEY_RUN_START, now);
        }
    }

    private static void handleBurrowing(Mob mob, CompoundTag data, ServerLevel level, Player player, long now) {
        mob.f_19794_ = true;
        Vec3 motion = new Vec3(0.0, -0.35, 0.0);
        mob.m_20256_(motion);
        double newY = mob.m_20186_() + motion.f_82480_;
        mob.m_6021_(mob.m_20185_(), newY, mob.m_20189_());
        boolean hasLOS = player.m_142582_((Entity)mob);
        double dist = mob.m_20270_((Entity)player);
        if (!hasLOS && dist > 12.0) {
            mob.m_146870_();
            return;
        }
        if (mob.m_20186_() < player.m_20186_() - 10.0 || mob.m_20183_().m_123342_() <= 1) {
            mob.m_146870_();
            return;
        }
        if (!data.m_128441_(KEY_RUN_START)) {
            data.m_128356_(KEY_RUN_START, now);
        } else if (now - data.m_128454_(KEY_RUN_START) >= 200L) {
            mob.m_146870_();
            return;
        }
    }

    private static BlockPos findBestHidingSpot(Mob mob, Player player, ServerLevel level, boolean preferDescend) {
        BlockPos mobPos = mob.m_20183_();
        BlockPos bestSpot = null;
        double bestScore = -1000.0;
        int dx = -10;
        while ((double)dx <= 10.0) {
            for (int dy = -3; dy <= 2; ++dy) {
                int dz = -10;
                while ((double)dz <= 10.0) {
                    double score;
                    BlockState belowState;
                    BlockPos below;
                    BlockState state;
                    BlockPos testPos = mobPos.m_7918_(dx, dy, dz);
                    if (level.m_46749_(testPos) && (state = level.m_8055_(testPos)).m_60795_() && level.m_46749_(below = testPos.m_7495_()) && !(belowState = level.m_8055_(below)).m_60795_() && (score = Phase0WatchersProcedure.evaluateHidingSpot(testPos, mob.m_20182_(), player, level, preferDescend)) > bestScore) {
                        bestScore = score;
                        bestSpot = testPos;
                    }
                    ++dz;
                }
            }
            ++dx;
        }
        return bestScore > 0.0 ? bestSpot : null;
    }

    private static double evaluateHidingSpot(BlockPos spot, Vec3 mobPos, Player player, ServerLevel level, boolean preferDescend) {
        double yDiff;
        Vec3 spotVec = new Vec3((double)spot.m_123341_() + 0.5, (double)spot.m_123342_() + 0.5, (double)spot.m_123343_() + 0.5);
        Vec3 playerPos = player.m_20182_();
        double distToPlayer = spotVec.m_82554_(playerPos);
        double distScore = Math.min(distToPlayer / 12.0, 6.0);
        double distFromMob = spotVec.m_82554_(mobPos);
        if (distFromMob > 7.5) {
            distScore -= 4.0;
        }
        Vec3 playerEye = new Vec3(playerPos.f_82479_, player.m_20188_(), playerPos.f_82481_);
        ClipContext ctx = new ClipContext(playerEye, spotVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hit = level.m_45547_(ctx);
        double coverScore = 0.0;
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            coverScore = 12.0;
        }
        int lightLevel = level.m_46803_(spot);
        double lightScore = 0.0;
        if (lightLevel <= 5) {
            lightScore = 3.0;
        }
        double heightScore = 0.0;
        if (preferDescend && (yDiff = mobPos.f_82480_ - spotVec.f_82480_) > 0.0) {
            heightScore = yDiff * 2.5;
        }
        return distScore + coverScore + heightScore + lightScore;
    }

    private static void startRunning(Mob mob, CompoundTag data, long now) {
        data.m_128379_(KEY_RUNNING, true);
        data.m_128356_(KEY_RUN_START, now);
        data.m_128405_(KEY_HIDE_CHECK, 0);
        mob.m_21557_(true);
        mob.m_20242_(false);
        data.m_128379_(KEY_DESPAWN_STARTED, false);
    }
}

