/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib.animatable.GeoEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhaseBlockSpawnProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 5.5E-5;
    private static final int SCAN_RADIUS = 22;
    private static final int MIN_SPAWN_DISTANCE = 8;
    private static final int MAX_SPAWN_DISTANCE = 20;
    private static final double DESPAWN_DISTANCE = 2.0;
    private static final double DESPAWN_DISTANCE_SQ = 4.0;
    private static final double CHASE_START_DISTANCE = 5.0;
    private static final double CHASE_START_DISTANCE_SQ = 25.0;
    private static final double CHASE_SPEED = 0.65;
    private static final int BLINDNESS_DURATION = 100;
    private static final Map<Block, RegistryObject<? extends EntityType<?>>> BLOCK_TO_ENTITY = PhaseBlockSpawnProcedure.initBlockMap();

    private static Map<Block, RegistryObject<? extends EntityType<?>>> initBlockMap() {
        HashMap<Block, Object> map = new HashMap<Block, Object>();
        map.put(Blocks.f_50069_, FromTheCavesModEntities.FROMTHECAVESSTONE);
        map.put(Blocks.f_50652_, FromTheCavesModEntities.FROMTHECAVESCOBBLESTONE);
        map.put(Blocks.f_152490_, FromTheCavesModEntities.FROMTHECAVESAMETHYST);
        map.put(Blocks.f_50705_, FromTheCavesModEntities.FROMTHECAVESOAKPLANKS);
        map.put(Blocks.f_50741_, FromTheCavesModEntities.FROMTHECAVESSPRUCEPLANKS);
        map.put(Blocks.f_50000_, FromTheCavesModEntities.FROMTHECAVESSPRUCELOGS);
        map.put(Blocks.f_49999_, FromTheCavesModEntities.FROMTHECAVESOAKLOGS);
        map.put(Blocks.f_50742_, FromTheCavesModEntities.FROMTHECAVESBIRCHPLANKS);
        map.put(Blocks.f_50001_, FromTheCavesModEntities.FROMTHECAVESBIRCHLOGS);
        map.put(Blocks.f_50002_, FromTheCavesModEntities.FROMTHECAVESJUNGLELOGS);
        map.put(Blocks.f_50004_, FromTheCavesModEntities.FROMTHECAVESDARKOAKLOGS);
        map.put(Blocks.f_50493_, FromTheCavesModEntities.FROMTHECAVESDIRT);
        return Collections.unmodifiableMap(map);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 4.0E-5, 5.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        PhaseBlockSpawnProcedure.attemptSpawn(server, player);
    }

    private static void attemptSpawn(ServerLevel world, Player player) {
        BlockPos playerPos = player.m_20183_();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        int minDistSq = 64;
        int maxDistSq = 400;
        for (int x = -22; x <= 22; ++x) {
            for (int y = -22; y <= 22; ++y) {
                for (int z = -22; z <= 22; ++z) {
                    Block above;
                    Block block;
                    BlockPos pos = playerPos.m_7918_(x, y, z);
                    double distSq = pos.m_123331_((Vec3i)playerPos);
                    if (distSq < (double)minDistSq || distSq > (double)maxDistSq || !BLOCK_TO_ENTITY.containsKey(block = world.m_8055_(pos).m_60734_()) || (above = world.m_8055_(pos.m_7494_()).m_60734_()) != block || !PhaseBlockSpawnProcedure.hasValidSpawnSpace(world, pos)) continue;
                    candidates.add(pos);
                }
            }
        }
        if (candidates.isEmpty()) {
            return;
        }
        BlockPos chosen = (BlockPos)candidates.get(world.f_46441_.m_188503_(candidates.size()));
        PhaseBlockSpawnProcedure.spawnPhaseStone(world, chosen);
    }

    private static boolean hasValidSpawnSpace(ServerLevel world, BlockPos blockPos) {
        Direction[] dirs;
        for (Direction dir : dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos checkPos = blockPos.m_121945_(dir);
            if (!world.m_46859_(checkPos) || !world.m_46859_(checkPos.m_7494_())) continue;
            return true;
        }
        return false;
    }

    private static void spawnPhaseStone(ServerLevel world, BlockPos blockPos) {
        Block block = world.m_8055_(blockPos).m_60734_();
        RegistryObject<? extends EntityType<?>> entityRO = BLOCK_TO_ENTITY.get(block);
        if (entityRO == null) {
            return;
        }
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        ArrayList<Direction> dirList = new ArrayList<Direction>(Arrays.asList(dirs));
        Collections.shuffle(dirList);
        for (Direction dir : dirList) {
            EntityType type;
            BlockPos spawnPos = blockPos.m_121945_(dir);
            if (!world.m_46859_(spawnPos) || !world.m_46859_(spawnPos.m_7494_()) || (type = (EntityType)entityRO.get()) == null) continue;
            try {
                Entity entity = type.m_262496_(world, spawnPos, MobSpawnType.MOB_SUMMONED);
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    if (entity instanceof GeoEntity) {
                        PhaseBlockSpawnProcedure.initializeMob(mob, blockPos);
                        return;
                    }
                }
                if (entity == null) continue;
                entity.m_146870_();
            }
            catch (Exception e) {}
        }
    }

    private static void initializeMob(Mob mob, BlockPos targetBlock) {
        Vec3 targetVec = Vec3.m_82512_((Vec3i)targetBlock);
        Vec3 dir = targetVec.m_82546_(mob.m_20182_()).m_82541_();
        float yaw = (float)(Math.atan2(dir.f_82481_, dir.f_82479_) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.m_5616_(yaw);
        mob.m_21557_(true);
        mob.m_20049_("phaseStone");
        mob.getPersistentData().m_128379_("chasing", false);
        mob.getPersistentData().m_128379_("initialized", false);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)livingEntity;
        if (!(event.getEntity() instanceof GeoEntity)) {
            return;
        }
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        if (!mob.m_19880_().contains("phaseStone")) {
            return;
        }
        ServerLevel world = (ServerLevel)mob.m_9236_();
        Player nearest = world.m_45930_((Entity)mob, 50.0);
        if (nearest == null) {
            return;
        }
        double distSq = mob.m_20280_((Entity)nearest);
        if (distSq <= 4.0) {
            PhaseBlockSpawnProcedure.handleDespawn(world, (Mob)mob, nearest);
            return;
        }
        if (mob.getPersistentData().m_128471_("chasing")) {
            PhaseBlockSpawnProcedure.updateChasing(mob, nearest);
        } else if (distSq <= 25.0 && mob.m_142582_((Entity)nearest)) {
            PhaseBlockSpawnProcedure.startChasing(mob, nearest);
        }
    }

    private static void startChasing(PathfinderMob mob, Player target) {
        mob.getPersistentData().m_128379_("chasing", true);
        mob.m_21557_(false);
        mob.m_6710_((LivingEntity)target);
        if (!mob.getPersistentData().m_128471_("initialized")) {
            mob.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal(mob, 0.65, true));
            mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)mob, Player.class, true));
            mob.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal(mob, 0.6));
            mob.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)mob, Player.class, 8.0f));
            mob.getPersistentData().m_128379_("initialized", true);
        }
        mob.m_21573_().m_5624_((Entity)target, 0.65);
    }

    private static void updateChasing(PathfinderMob mob, Player target) {
        if (mob.m_142582_((Entity)target)) {
            mob.m_21573_().m_5624_((Entity)target, 0.65);
            if (mob.m_5448_() != target) {
                mob.m_6710_((LivingEntity)target);
            }
        } else if (mob.m_21573_().m_26571_()) {
            ServerLevel world = (ServerLevel)mob.m_9236_();
            if (world.f_46441_.m_188501_() < 0.03f) {
                double rx = mob.m_20185_() + (world.f_46441_.m_188500_() - 0.5) * 8.0;
                double rz = mob.m_20189_() + (world.f_46441_.m_188500_() - 0.5) * 8.0;
                mob.m_21573_().m_26519_(rx, mob.m_20186_(), rz, 0.39);
            }
        }
    }

    private static void handleDespawn(ServerLevel world, Mob mob, Player player) {
        BlockPos pos = mob.m_20183_();
        world.m_5594_(null, pos, (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.HOSTILE, 1.0f, 0.4f);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false));
        mob.m_142687_(Entity.RemovalReason.DISCARDED);
    }
}

