/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnRedstoneTunnelProcedure {
    private static final long RESTORE_DELAY_TICKS = 6000L;
    private static final int CHECK_INTERVAL = 10;
    private static final double BASE_PROB = 7.5E-4;
    private static final double MAX_PROB = 9.5E-4;
    private static final Set<BlockState> REPLACEABLE_BLOCKS = new HashSet<BlockState>();
    private static final Map<ResourceKey<Level>, List<TunnelBlockInfo>> pendingRestoration;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (serverLevel.m_46467_() % 10L != 0L) {
            return;
        }
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player.m_20186_() >= 45.0) {
            return;
        }
        double spawnProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, player, 7.5E-4, 9.5E-4);
        double roll = Math.random();
        if (roll > spawnProb) {
            return;
        }
        BlockPos tunnelStart = SpawnRedstoneTunnelProcedure.findValidTunnelStart(serverLevel, player.m_20183_());
        if (tunnelStart == null) {
            return;
        }
        long now = serverLevel.m_46467_();
        SpawnRedstoneTunnelProcedure.generateTunnel(serverLevel, tunnelStart, now);
    }

    private static BlockPos findValidTunnelStart(ServerLevel level, BlockPos playerPos) {
        RandomSource rand = level.f_46441_;
        for (int attempts = 0; attempts < 20; ++attempts) {
            int distance = 12 + rand.m_188503_(21);
            double angle = rand.m_188500_() * Math.PI * 2.0;
            int offsetX = (int)(Math.cos(angle) * (double)distance);
            int offsetZ = (int)(Math.sin(angle) * (double)distance);
            int offsetY = -5 + rand.m_188503_(11);
            BlockPos testPos = playerPos.m_7918_(offsetX, offsetY, offsetZ);
            if (!SpawnRedstoneTunnelProcedure.isValidTunnelLocation(level, testPos)) continue;
            return testPos;
        }
        return null;
    }

    private static boolean isValidTunnelLocation(ServerLevel level, BlockPos pos) {
        int validBlocks = 0;
        int totalBlocks = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y <= 2; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos checkPos = pos.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    ++totalBlocks;
                    if (!SpawnRedstoneTunnelProcedure.isReplaceable(state)) continue;
                    ++validBlocks;
                }
            }
        }
        boolean valid = validBlocks >= 15;
        return valid;
    }

    private static boolean isReplaceable(BlockState state) {
        return state.m_60713_(Blocks.f_50069_) || state.m_60713_(Blocks.f_152550_) || state.m_60713_(Blocks.f_50334_) || state.m_60713_(Blocks.f_50228_) || state.m_60713_(Blocks.f_49994_);
    }

    private static void generateTunnel(ServerLevel level, BlockPos start, long currentTick) {
        ResourceKey dim;
        List<TunnelBlockInfo> list;
        RandomSource rand = level.f_46441_;
        Direction[] horizontalDirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        Direction dir = horizontalDirs[rand.m_188503_(horizontalDirs.length)];
        int tunnelLength = 6 + rand.m_188503_(16);
        boolean hasStairs = rand.m_188500_() < 0.5;
        boolean hasRoom = rand.m_188500_() < 0.25;
        boolean hasEnemy = hasRoom && rand.m_188500_() < 0.1;
        ArrayList<TunnelBlockInfo> blocksToRestore = new ArrayList<TunnelBlockInfo>();
        BlockPos currentPos = start;
        for (int i = 0; i < tunnelLength; ++i) {
            BlockPos floorPos;
            BlockPos torchPos;
            for (int y = 0; y < 2; ++y) {
                BlockPos airPos = currentPos.m_6630_(y);
                if (!SpawnRedstoneTunnelProcedure.isReplaceable(level.m_8055_(airPos))) continue;
                blocksToRestore.add(new TunnelBlockInfo(airPos, level.m_8055_(airPos), currentTick + 6000L));
                level.m_7731_(airPos, Blocks.f_50016_.m_49966_(), 3);
            }
            if (i % 4 == 0 && level.m_8055_(torchPos = currentPos).m_60795_() && level.m_8055_(floorPos = torchPos.m_7495_()).m_280296_()) {
                level.m_7731_(torchPos, Blocks.f_50174_.m_49966_(), 3);
            }
            currentPos = currentPos.m_121945_(dir);
            if (!hasStairs || i <= 0 || i % 5 != 0) continue;
            SpawnRedstoneTunnelProcedure.generateStairSection(level, currentPos, dir, blocksToRestore, currentTick);
            currentPos = currentPos.m_6625_(3);
        }
        if (hasRoom) {
            BlockPos roomCenter = currentPos.m_7494_();
            SpawnRedstoneTunnelProcedure.generateRoom(level, roomCenter, blocksToRestore, currentTick, hasEnemy);
        }
        if ((list = pendingRestoration.get(dim = level.m_46472_())) == null) {
            list = new ArrayList<TunnelBlockInfo>();
            pendingRestoration.put((ResourceKey<Level>)dim, list);
        }
        list.addAll(blocksToRestore);
    }

    private static void generateStairSection(ServerLevel level, BlockPos start, Direction dir, List<TunnelBlockInfo> blocksToRestore, long currentTick) {
        BlockPos currentPos = start;
        for (int step = 0; step < 3; ++step) {
            for (int y = 0; y < 2; ++y) {
                BlockPos airPos = currentPos.m_6630_(y);
                if (!SpawnRedstoneTunnelProcedure.isReplaceable(level.m_8055_(airPos))) continue;
                blocksToRestore.add(new TunnelBlockInfo(airPos, level.m_8055_(airPos), currentTick + 6000L));
                level.m_7731_(airPos, Blocks.f_50016_.m_49966_(), 3);
            }
            BlockPos stepPos = currentPos.m_7495_();
            if (SpawnRedstoneTunnelProcedure.isReplaceable(level.m_8055_(stepPos)) || level.m_8055_(stepPos).m_60795_()) {
                if (!level.m_8055_(stepPos).m_60795_()) {
                    blocksToRestore.add(new TunnelBlockInfo(stepPos, level.m_8055_(stepPos), currentTick + 6000L));
                }
                level.m_7731_(stepPos, Blocks.f_50069_.m_49966_(), 3);
            }
            currentPos = currentPos.m_121945_(dir).m_7495_();
        }
    }

    private static void generateRoom(ServerLevel level, BlockPos center, List<TunnelBlockInfo> blocksToRestore, long currentTick, boolean spawnEnemy) {
        BlockPos[] torchPositions;
        int blocksCleared = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = 0; y < 3; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos roomPos = center.m_7918_(x, y, z);
                    BlockState state = level.m_8055_(roomPos);
                    if (!SpawnRedstoneTunnelProcedure.isReplaceable(state) && state.m_60795_()) continue;
                    blocksToRestore.add(new TunnelBlockInfo(roomPos, state, currentTick + 6000L));
                    level.m_7731_(roomPos, Blocks.f_50016_.m_49966_(), 3);
                    ++blocksCleared;
                }
            }
        }
        BlockPos crossPos = center;
        BlockState crossFloorState = level.m_8055_(crossPos.m_7495_());
        if (!crossFloorState.m_280296_()) {
            blocksToRestore.add(new TunnelBlockInfo(crossPos.m_7495_(), crossFloorState, currentTick + 6000L));
            level.m_7731_(crossPos.m_7495_(), Blocks.f_50069_.m_49966_(), 3);
        }
        level.m_7731_(crossPos, ((Block)FromTheCavesModBlocks.UPSIDE_DOWN_CROSS.get()).m_49966_(), 3);
        if (spawnEnemy) {
            BlockPos spawnPos = center.m_7494_();
            try {
                ((EntityType)FromTheCavesModEntities.FROMTHECAVESFRONT.get()).m_262496_(level, spawnPos, MobSpawnType.TRIGGERED);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (BlockPos torchPos : torchPositions = new BlockPos[]{center.m_7918_(-1, 0, -1), center.m_7918_(1, 0, -1), center.m_7918_(-1, 0, 1), center.m_7918_(1, 0, 1)}) {
            BlockState floorState = level.m_8055_(torchPos.m_7495_());
            if (!floorState.m_280296_()) {
                blocksToRestore.add(new TunnelBlockInfo(torchPos.m_7495_(), floorState, currentTick + 6000L));
                level.m_7731_(torchPos.m_7495_(), Blocks.f_50069_.m_49966_(), 3);
            }
            level.m_7731_(torchPos, Blocks.f_50174_.m_49966_(), 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.level.m_5776_()) {
            return;
        }
        Level level = event.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ResourceKey dim = server.m_46472_();
        List<TunnelBlockInfo> list = pendingRestoration.get(dim);
        if (list == null || list.isEmpty()) {
            return;
        }
        long now = server.m_46467_();
        Iterator<TunnelBlockInfo> it = list.iterator();
        int restored = 0;
        while (it.hasNext()) {
            TunnelBlockInfo info = it.next();
            if (now < info.restoreAtTick) continue;
            try {
                server.m_46597_(info.pos, info.state);
                ++restored;
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                it.remove();
            }
        }
        if (list.isEmpty()) {
            pendingRestoration.remove(dim);
        }
    }

    static {
        REPLACEABLE_BLOCKS.add(Blocks.f_50069_.m_49966_());
        REPLACEABLE_BLOCKS.add(Blocks.f_152550_.m_49966_());
        REPLACEABLE_BLOCKS.add(Blocks.f_50334_.m_49966_());
        REPLACEABLE_BLOCKS.add(Blocks.f_50228_.m_49966_());
        REPLACEABLE_BLOCKS.add(Blocks.f_49994_.m_49966_());
        pendingRestoration = new HashMap<ResourceKey<Level>, List<TunnelBlockInfo>>();
    }

    private static class TunnelBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final long restoreAtTick;

        TunnelBlockInfo(BlockPos pos, BlockState state, long restoreAtTick) {
            this.pos = pos.m_7949_();
            this.state = state;
            this.restoreAtTick = restoreAtTick;
        }
    }
}

