/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class DbMeterSettingsScreen
extends Screen {
    private final Screen lastScreen;
    private String currentPosition;
    private boolean currentVisible;
    private int scrollOffset = 0;
    private static final int MAX_VISIBLE_BUTTONS = 4;

    public DbMeterSettingsScreen(Screen lastScreen) {
        super((Component)Component.m_237113_((String)"dB Meter Settings"));
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.currentPosition = this.f_96541_.f_91074_.getPersistentData().m_128461_("fromthecaves_dbMeterPosition");
            if (this.currentPosition.isEmpty()) {
                this.currentPosition = "left";
            }
            this.currentVisible = this.f_96541_.f_91074_.getPersistentData().m_128471_("fromthecaves_dbMeterVisible");
            if (!this.f_96541_.f_91074_.getPersistentData().m_128441_("fromthecaves_dbMeterVisible")) {
                this.currentVisible = false;
            }
        }
        int startY = 60;
        int buttonSpacing = 20;
        String[][] positions = new String[][]{{"left", "Left Side (Center)"}, {"right", "Right Side (Center)"}, {"top_left", "Top Left Corner"}, {"top_right", "Top Right Corner"}, {"bottom_left", "Bottom Left Corner"}, {"bottom_right", "Bottom Right Corner"}, {"hotbar_left", "Hotbar Left (Small)"}, {"hotbar_right", "Hotbar Right (Small)"}, {"above_hotbar", "Above Hotbar (Horizontal)"}, {"hotbar_right_side", "Hotbar Right Side"}};
        if (this.scrollOffset > 0) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25b2 Scroll Up"), button -> {
                this.scrollOffset = Math.max(0, this.scrollOffset - 1);
                this.m_232761_();
            }).m_252987_(this.f_96543_ / 2 + 110, startY, 80, 20).m_253136_());
        }
        if (positions.length > 4 && this.scrollOffset < positions.length - 4) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u25bc Scroll Down"), button -> {
                this.scrollOffset = Math.min(positions.length - 4, this.scrollOffset + 1);
                this.m_232761_();
            }).m_252987_(this.f_96543_ / 2 + 110, startY + 3 * buttonSpacing, 80, 20).m_253136_());
        }
        int endIndex = Math.min(positions.length, this.scrollOffset + 4);
        for (int i = this.scrollOffset; i < endIndex; ++i) {
            String posKey = positions[i][0];
            String posLabel = positions[i][1];
            int yPos = startY + (i - this.scrollOffset) * buttonSpacing;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.currentPosition.equals(posKey) ? "\u2713 " + posLabel : posLabel)), button -> {
                this.currentPosition = posKey;
                this.saveSettings();
                this.m_232761_();
            }).m_252987_(this.f_96543_ / 2 - 100, yPos, 200, 20).m_253136_());
        }
        int visibilityY = startY + 4 * buttonSpacing + 10;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)(this.currentVisible ? "\u2713 Visible" : "Hidden")), button -> {
            this.currentVisible = !this.currentVisible;
            this.saveSettings();
            this.m_232761_();
        }).m_252987_(this.f_96543_ / 2 - 100, visibilityY, 200, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Done"), button -> this.f_96541_.m_91152_(this.lastScreen)).m_252987_(this.f_96543_ / 2 - 100, this.f_96544_ - 30, 200, 20).m_253136_());
    }

    private void saveSettings() {
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.getPersistentData().m_128359_("fromthecaves_dbMeterPosition", this.currentPosition);
            this.f_96541_.f_91074_.getPersistentData().m_128379_("fromthecaves_dbMeterVisible", this.currentVisible);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        String subtitle = "Customize your voice detection meter";
        guiGraphics.m_280137_(this.f_96547_, subtitle, this.f_96543_ / 2, 35, 0xAAAAAA);
        guiGraphics.m_280137_(this.f_96547_, "Position", this.f_96543_ / 2, 48, 0xFFFFFF);
        int visibilityY = 158;
        guiGraphics.m_280137_(this.f_96547_, "Visibility", this.f_96543_ / 2, visibilityY - 12, 0xFFFFFF);
        String positionName = this.getPositionName(this.currentPosition);
        String previewText = String.format("%s | %s", positionName, this.currentVisible ? "Visible" : "Hidden");
        guiGraphics.m_280137_(this.f_96547_, previewText, this.f_96543_ / 2, this.f_96544_ - 50, 65280);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private String getPositionName(String key) {
        switch (key) {
            case "left": {
                return "Left Center";
            }
            case "right": {
                return "Right Center";
            }
            case "top_left": {
                return "Top Left";
            }
            case "top_right": {
                return "Top Right";
            }
            case "bottom_left": {
                return "Bottom Left";
            }
            case "bottom_right": {
                return "Bottom Right";
            }
            case "hotbar_left": {
                return "Hotbar Left";
            }
            case "hotbar_right": {
                return "Hotbar Right";
            }
            case "above_hotbar": {
                return "Above Hotbar";
            }
            case "hotbar_right_side": {
                return "Hotbar Right Side";
            }
        }
        return "Unknown";
    }

    public boolean m_7043_() {
        return true;
    }
}

