/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AngerSystemProcedure {
    private static final double CROSS_USE_ANGER = 0.1;
    private static final double WOLF_KILL_ANGER = 0.8;
    private static final double VILLAGER_KILL_ANGER = 0.9;
    private static final double EXORCISM_ANGER = 23.0;
    private static final double ENCLOSED_ANGER_PER_INTERVAL = 3.0;
    private static final double BELOW_Y45_ANGER_PER_INTERVAL = 8.0;
    private static final double INSIDE_HOUSE_ANGER_PER_INTERVAL = 1.0;
    private static final int CAVE_Y_THRESHOLD = 55;
    private static final int DEEP_CAVE_Y_THRESHOLD = 70;
    private static final int ENCLOSED_CHECK_TICKS = 2400;
    private static final int BELOW_Y45_CHECK_TICKS = 12000;
    private static final int INSIDE_HOUSE_CHECK_TICKS = 1200;
    private static final int DEBUG_UPDATE_TICKS = 20;
    private static final double ANGER_THRESHOLD_PHASE2 = 50.0;

    private static AngerSavedData getAngerData(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (AngerSavedData)storage.m_164861_(AngerSavedData::load, AngerSavedData::new, "fromthecaves_anger_data");
    }

    public static double getAngerLevel(ServerLevel level) {
        return AngerSystemProcedure.getAngerData(level).getAngerLevel();
    }

    public static void addAnger(ServerLevel level, double amount) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) < 1) {
            return;
        }
        AngerSavedData data = AngerSystemProcedure.getAngerData(level);
        double previousAnger = data.getAngerLevel();
        data.addAnger(amount);
        double currentAnger = data.getAngerLevel();
        if (previousAnger < 50.0 && currentAnger >= 50.0) {
            PhaseManagerProcedure.setManualPhase((LevelAccessor)level, 2);
        }
    }

    public static void setAngerLevel(ServerLevel level, double amount) {
        AngerSystemProcedure.getAngerData(level).setAngerLevel(amount);
    }

    public static void resetAnger(ServerLevel level) {
        AngerSystemProcedure.getAngerData(level).resetAnger();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fromthecaves").then(Commands.m_82127_((String)"angerDebug").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player."));
                return 0;
            }
            boolean current = player.getPersistentData().m_128471_("debugAnger");
            boolean newState = !current;
            player.getPersistentData().m_128379_("debugAnger", newState);
            source.m_288197_(() -> Component.m_237113_((String)("Anger Debug mode " + (newState ? "enabled" : "disabled"))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                AngerSystemProcedure.resetAnger(server);
                source.m_288197_(() -> Component.m_237113_((String)"Anger level has been reset to 0"), true);
                return 1;
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                double anger = AngerSystemProcedure.getAngerLevel(server);
                source.m_288197_(() -> Component.m_237113_((String)("Current Anger Level: " + String.format("%.2f", anger))), false);
                return 1;
            }
            return 0;
        })));
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        LivingEntity deadEntity = event.getEntity();
        Level level = deadEntity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        EntityType type = deadEntity.m_6095_();
        if (type == EntityType.f_20499_) {
            AngerSystemProcedure.addAnger(server, 0.8);
            AngerSystemProcedure.sendAngerNotification(server, "Wolf killed", 0.8);
        } else if (type == EntityType.f_20492_) {
            AngerSystemProcedure.addAnger(server, 0.9);
            AngerSystemProcedure.sendAngerNotification(server, "Villager killed", 0.9);
        }
    }

    public static void onCrossUsed(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 0.1);
        AngerSystemProcedure.sendAngerNotification(server, "Cross used", 0.1);
    }

    public static void onExorcism(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 23.0);
        AngerSystemProcedure.sendAngerNotification(server, "Exorcism performed", 23.0);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        CompoundTag nbt = player.getPersistentData();
        BlockPos playerPos = player.m_20183_();
        boolean isEnclosed = AngerSystemProcedure.isPlayerEnclosed(server, playerPos, player);
        boolean isInCave = AngerSystemProcedure.isPlayerInCave(server, playerPos, player);
        boolean isInsideHouse = AngerSystemProcedure.isPlayerInsideHouse(server, playerPos, player);
        int enclosedTicks = nbt.m_128451_("ftc_enclosedTicks");
        if (isEnclosed) {
            nbt.m_128405_("ftc_enclosedTicks", ++enclosedTicks);
            if (enclosedTicks >= 2400) {
                AngerSystemProcedure.addAnger(server, 3.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player enclosed", 3.0);
                nbt.m_128405_("ftc_enclosedTicks", 0);
            }
        } else if (enclosedTicks > 0) {
            nbt.m_128405_("ftc_enclosedTicks", 0);
        }
        int belowY45Ticks = nbt.m_128451_("ftc_belowY45Ticks");
        if (isInCave) {
            nbt.m_128405_("ftc_belowY45Ticks", ++belowY45Ticks);
            if (belowY45Ticks >= 12000) {
                AngerSystemProcedure.addAnger(server, 8.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player in caves", 8.0);
                nbt.m_128405_("ftc_belowY45Ticks", 0);
            }
        } else if (belowY45Ticks > 0) {
            nbt.m_128405_("ftc_belowY45Ticks", 0);
        }
        int insideHouseTicks = nbt.m_128451_("ftc_insideHouseTicks");
        if (isInsideHouse) {
            nbt.m_128405_("ftc_insideHouseTicks", ++insideHouseTicks);
            if (insideHouseTicks >= 1200) {
                AngerSystemProcedure.addAnger(server, 1.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player inside house", 1.0);
                nbt.m_128405_("ftc_insideHouseTicks", 0);
            }
        } else if (insideHouseTicks > 0) {
            nbt.m_128405_("ftc_insideHouseTicks", 0);
        }
        if (player.f_19797_ % 20 == 0 && nbt.m_128471_("debugAnger")) {
            AngerSystemProcedure.sendDebugInfo(server, player, isEnclosed, isInCave, isInsideHouse, enclosedTicks, belowY45Ticks, insideHouseTicks);
        }
    }

    private static boolean isPlayerEnclosed(ServerLevel level, BlockPos playerPos, Player player) {
        if (playerPos.m_123342_() >= 50) {
            return false;
        }
        if (player.m_5833_() || !player.m_20096_()) {
            return false;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int solidBlocksAround = 0;
        int totalChecks = 0;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dy = -1; dy <= 3; ++dy) {
                for (int dz = -2; dz <= 2; ++dz) {
                    if (dx == 0 && dz == 0 && dy >= 0 && dy <= 2) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    ++totalChecks;
                    if (!state.m_280296_() || !state.m_60815_()) continue;
                    ++solidBlocksAround;
                }
            }
        }
        return (double)solidBlocksAround / (double)totalChecks >= 0.8;
    }

    private static boolean isPlayerInCave(ServerLevel level, BlockPos playerPos, Player player) {
        if (player.m_5833_()) {
            return false;
        }
        int playerY = playerPos.m_123342_();
        if (playerY >= 50) {
            return false;
        }
        boolean hasRoofAbove = false;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int y = playerY + 1; y <= Math.min(playerY + 10, level.m_151558_()); ++y) {
            mutable.m_122178_(playerPos.m_123341_(), y, playerPos.m_123343_());
            BlockState state = level.m_8055_((BlockPos)mutable);
            if (!state.m_280296_() || !state.m_60815_()) continue;
            hasRoofAbove = true;
            break;
        }
        if (!hasRoofAbove) {
            return false;
        }
        int caveBlocksNearby = 0;
        int totalSolidBlocks = 0;
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (!state.m_280296_()) continue;
                    ++totalSolidBlocks;
                    if (!AngerSystemProcedure.isCaveBlock(state)) continue;
                    ++caveBlocksNearby;
                }
            }
        }
        return caveBlocksNearby > 15 && totalSolidBlocks > 20;
    }

    private static boolean isCaveBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13061_) || state.m_204336_(BlockTags.f_144267_) || state.m_60734_() == Blocks.f_152550_ || state.m_60734_() == Blocks.f_152496_ || state.m_60734_() == Blocks.f_50122_ || state.m_60734_() == Blocks.f_50228_ || state.m_60734_() == Blocks.f_50334_ || state.m_60734_() == Blocks.f_152497_ || state.m_60734_() == Blocks.f_152537_ || state.m_60734_() == Blocks.f_152588_ || state.m_60734_() == Blocks.f_152544_ || state.m_60734_() == Blocks.f_152543_ || state.m_204336_(BlockTags.f_144262_) || state.m_204336_(BlockTags.f_144264_) || state.m_204336_(BlockTags.f_144258_) || state.m_204336_(BlockTags.f_13043_) || state.m_204336_(BlockTags.f_144259_) || state.m_204336_(BlockTags.f_144260_) || state.m_204336_(BlockTags.f_144261_) || state.m_204336_(BlockTags.f_144263_);
    }

    private static boolean isPlayerInsideHouse(ServerLevel level, BlockPos playerPos, Player player) {
        if (player.m_5833_()) {
            return false;
        }
        int structureBlocksNearby = 0;
        int totalChecks = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -3; dx <= 3; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -3; dz <= 3; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    if (!level.m_46749_((BlockPos)mutable)) continue;
                    ++totalChecks;
                    BlockState state = level.m_8055_((BlockPos)mutable);
                    if (!AngerSystemProcedure.isStructureBlock(state)) continue;
                    ++structureBlocksNearby;
                }
            }
        }
        if (totalChecks == 0) {
            return false;
        }
        double ratio = (double)structureBlocksNearby / (double)totalChecks;
        return ratio > 0.25;
    }

    private static boolean isStructureBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13090_) || state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13097_) || state.m_204336_(BlockTags.f_13096_) || state.m_204336_(BlockTags.f_13098_) || state.m_60734_() == Blocks.f_50652_ || state.m_60734_() == Blocks.f_50079_ || state.m_60734_() == Blocks.f_50222_ || state.m_60734_() == Blocks.f_50223_ || state.m_60734_() == Blocks.f_50224_ || state.m_60734_() == Blocks.f_50225_ || state.m_60734_() == Blocks.f_50076_ || state.m_60734_() == Blocks.f_50387_ || state.m_60734_() == Blocks.f_50281_ || state.m_60734_() == Blocks.f_50175_ || state.m_60734_() == Blocks.f_152555_ || state.m_60734_() == Blocks.f_152589_ || state.m_60734_() == Blocks.f_152559_ || state.m_60734_() == Blocks.f_50062_ || state.m_60734_() == Blocks.f_50394_ || state.m_60734_() == Blocks.f_50471_ || state.m_60734_() == Blocks.f_50473_ || state.m_60734_() == Blocks.f_50064_ || state.m_60734_() == Blocks.f_50396_ || state.m_60734_() == Blocks.f_50377_ || state.m_60734_() == Blocks.f_50378_ || state.m_60734_() == Blocks.f_50379_ || state.m_60734_() == Blocks.f_50734_ || state.m_60734_() == Blocks.f_50735_ || state.m_60734_() == Blocks.f_50197_ || state.m_60734_() == Blocks.f_50452_ || state.m_60734_() == Blocks.f_50259_ || state.m_60734_() == Blocks.f_50443_ || state.m_60734_() == Blocks.f_50492_ || state.m_60734_() == Blocks.f_50333_ || state.m_60734_() == Blocks.f_50472_ || state.m_60734_() == Blocks.f_50352_ || state.m_60734_() == Blocks.f_50287_ || state.m_60734_() == Blocks.f_50288_ || state.m_60734_() == Blocks.f_50289_ || state.m_60734_() == Blocks.f_50290_ || state.m_60734_() == Blocks.f_50291_ || state.m_60734_() == Blocks.f_50292_ || state.m_60734_() == Blocks.f_50293_ || state.m_60734_() == Blocks.f_50294_ || state.m_60734_() == Blocks.f_50295_ || state.m_60734_() == Blocks.f_50296_ || state.m_60734_() == Blocks.f_50297_ || state.m_60734_() == Blocks.f_50298_ || state.m_60734_() == Blocks.f_50299_ || state.m_60734_() == Blocks.f_50300_ || state.m_60734_() == Blocks.f_50301_ || state.m_60734_() == Blocks.f_50302_ || state.m_204336_(BlockTags.f_13103_) || state.m_204336_(BlockTags.f_13036_) || state.m_204336_(BlockTags.f_13100_) || state.m_204336_(BlockTags.f_13092_) || state.m_204336_(BlockTags.f_13102_) || state.m_204336_(BlockTags.f_13055_) || state.m_204336_(BlockTags.f_13032_) || state.m_204336_(BlockTags.f_13049_) || state.m_204336_(BlockTags.f_13089_) || state.m_60734_() == Blocks.f_50058_ || state.m_60734_() == Blocks.f_50147_ || state.m_60734_() == Blocks.f_50148_ || state.m_60734_() == Blocks.f_50202_ || state.m_60734_() == Blocks.f_50203_ || state.m_60734_() == Blocks.f_50204_ || state.m_60734_() == Blocks.f_50205_ || state.m_60734_() == Blocks.f_50206_ || state.m_60734_() == Blocks.f_50207_ || state.m_60734_() == Blocks.f_50208_ || state.m_60734_() == Blocks.f_50209_ || state.m_60734_() == Blocks.f_50210_ || state.m_60734_() == Blocks.f_50211_ || state.m_60734_() == Blocks.f_50212_ || state.m_60734_() == Blocks.f_50213_ || state.m_60734_() == Blocks.f_50214_ || state.m_60734_() == Blocks.f_50215_ || state.m_60734_() == Blocks.f_50303_ || state.m_60734_() == Blocks.f_50304_ || state.m_60734_() == Blocks.f_50305_ || state.m_60734_() == Blocks.f_50306_ || state.m_60734_() == Blocks.f_50307_ || state.m_60734_() == Blocks.f_50361_ || state.m_60734_() == Blocks.f_50362_ || state.m_60734_() == Blocks.f_50363_ || state.m_60734_() == Blocks.f_50364_ || state.m_60734_() == Blocks.f_50365_ || state.m_60734_() == Blocks.f_50366_ || state.m_60734_() == Blocks.f_50367_ || state.m_60734_() == Blocks.f_50368_ || state.m_60734_() == Blocks.f_50369_ || state.m_60734_() == Blocks.f_50370_ || state.m_60734_() == Blocks.f_50371_ || state.m_60734_() == Blocks.f_50185_ || state.m_60734_() == Blocks.f_50183_ || state.m_60734_() == Blocks.f_50087_ || state.m_60734_() == Blocks.f_50325_ || state.m_60734_() == Blocks.f_50094_ || state.m_60734_() == Blocks.f_50620_ || state.m_60734_() == Blocks.f_50619_ || state.m_60734_() == Blocks.f_50091_ || state.m_60734_() == Blocks.f_50078_ || state.m_60734_() == Blocks.f_50201_ || state.m_60734_() == Blocks.f_50322_ || state.m_60734_() == Blocks.f_50323_ || state.m_60734_() == Blocks.f_50324_ || state.m_60734_() == Blocks.f_50255_ || state.m_60734_() == Blocks.f_50256_ || state.m_60734_() == Blocks.f_152476_ || state.m_60734_() == Blocks.f_152477_ || state.m_60734_() == Blocks.f_152478_ || state.m_60734_() == Blocks.f_50618_ || state.m_60734_() == Blocks.f_50715_ || state.m_60734_() == Blocks.f_50623_ || state.m_60734_() == Blocks.f_50617_ || state.m_60734_() == Blocks.f_50679_ || state.m_60734_() == Blocks.f_50621_ || state.m_60734_() == Blocks.f_50622_ || state.m_60734_() == Blocks.f_50625_ || state.m_60734_() == Blocks.f_50066_ || state.m_60734_() == Blocks.f_50067_ || state.m_60734_() == Blocks.f_50068_ || state.m_60734_() == Blocks.f_50017_ || state.m_60734_() == Blocks.f_50018_ || state.m_60734_() == Blocks.f_50019_ || state.m_60734_() == Blocks.f_50020_ || state.m_60734_() == Blocks.f_50021_ || state.m_60734_() == Blocks.f_50022_ || state.m_60734_() == Blocks.f_50023_ || state.m_60734_() == Blocks.f_50024_ || state.m_60734_() == Blocks.f_50025_ || state.m_60734_() == Blocks.f_50026_ || state.m_60734_() == Blocks.f_50027_ || state.m_60734_() == Blocks.f_50028_ || state.m_60734_() == Blocks.f_50029_ || state.m_60734_() == Blocks.f_50155_ || state.m_60734_() == Blocks.f_50616_ || state.m_60734_() == Blocks.f_50542_ || state.m_60734_() == Blocks.f_50543_ || state.m_60734_() == Blocks.f_50544_ || state.m_60734_() == Blocks.f_50545_ || state.m_60734_() == Blocks.f_50494_ || state.m_60734_() == Blocks.f_50495_ || state.m_60734_() == Blocks.f_50496_ || state.m_60734_() == Blocks.f_50497_ || state.m_60734_() == Blocks.f_50498_ || state.m_60734_() == Blocks.f_50499_ || state.m_60734_() == Blocks.f_50500_ || state.m_60734_() == Blocks.f_50501_ || state.m_60734_() == Blocks.f_50502_ || state.m_60734_() == Blocks.f_50503_ || state.m_60734_() == Blocks.f_50504_ || state.m_60734_() == Blocks.f_50505_ || state.m_60734_() == Blocks.f_50506_ || state.m_60734_() == Blocks.f_50507_ || state.m_60734_() == Blocks.f_50508_ || state.m_60734_() == Blocks.f_50509_ || state.m_60734_() == Blocks.f_50510_ || state.m_60734_() == Blocks.f_50511_ || state.m_60734_() == Blocks.f_50512_ || state.m_60734_() == Blocks.f_50513_ || state.m_60734_() == Blocks.f_50514_ || state.m_60734_() == Blocks.f_50515_ || state.m_60734_() == Blocks.f_50516_ || state.m_60734_() == Blocks.f_50517_ || state.m_60734_() == Blocks.f_50518_ || state.m_60734_() == Blocks.f_50519_ || state.m_60734_() == Blocks.f_50573_ || state.m_60734_() == Blocks.f_50574_ || state.m_60734_() == Blocks.f_50526_ || state.m_60734_() == Blocks.f_50527_ || state.m_60734_() == Blocks.f_50528_ || state.m_60734_() == Blocks.f_50529_ || state.m_60734_() == Blocks.f_50530_ || state.m_60734_() == Blocks.f_50531_ || state.m_60734_() == Blocks.f_50532_ || state.m_60734_() == Blocks.f_50533_ || state.m_60734_() == Blocks.f_50534_ || state.m_60734_() == Blocks.f_50535_ || state.m_60734_() == Blocks.f_50536_ || state.m_60734_() == Blocks.f_50537_ || state.m_60734_() == Blocks.f_50538_ || state.m_60734_() == Blocks.f_50539_ || state.m_60734_() == Blocks.f_50540_ || state.m_60734_() == Blocks.f_50541_ || state.m_60734_() == Blocks.f_50274_ || state.m_60734_() == Blocks.f_50275_ || state.m_60734_() == Blocks.f_50609_ || state.m_60734_() == Blocks.f_50607_ || state.m_60734_() == Blocks.f_50611_ || state.m_60734_() == Blocks.f_50615_ || state.m_60734_() == Blocks.f_50608_ || state.m_60734_() == Blocks.f_50605_ || state.m_60734_() == Blocks.f_50613_ || state.m_60734_() == Blocks.f_50606_ || state.m_60734_() == Blocks.f_50604_ || state.m_60734_() == Blocks.f_50610_ || state.m_60734_() == Blocks.f_50612_ || state.m_60734_() == Blocks.f_50614_ || state.m_60734_() == Blocks.f_50732_ || state.m_60734_() == Blocks.f_50711_ || state.m_60734_() == Blocks.f_50740_ || state.m_60734_() == Blocks.f_152592_ || state.m_60734_() == Blocks.f_152562_ || state.m_60734_() == Blocks.f_152554_ || state.m_60734_() == Blocks.f_152558_ || state.m_60734_() == Blocks.f_152594_ || state.m_60734_() == Blocks.f_152595_ || state.m_60734_() == Blocks.f_50224_ || state.m_60734_() == Blocks.f_50713_ || state.m_60734_() == Blocks.f_50736_ || state.m_60734_() == Blocks.f_152593_ || state.m_60734_() == Blocks.f_50712_ || state.m_60734_() == Blocks.f_50737_ || state.m_60734_() == Blocks.f_50282_ || state.m_60734_() == Blocks.f_50395_ || state.m_60734_() == Blocks.f_50063_ || state.m_60734_() == Blocks.f_50714_ || state.m_60734_() == Blocks.f_50283_ || state.m_60734_() == Blocks.f_50284_ || state.m_60734_() == Blocks.f_50637_ || state.m_60734_() == Blocks.f_50413_ || state.m_60734_() == Blocks.f_50650_ || state.m_60734_() == Blocks.f_50441_ || state.m_60734_() == Blocks.f_50469_ || state.m_60734_() == Blocks.f_50442_ || state.m_60734_() == Blocks.f_50041_ || state.m_60734_() == Blocks.f_50042_ || state.m_60734_() == Blocks.f_50096_ || state.m_60734_() == Blocks.f_50097_ || state.m_60734_() == Blocks.f_50098_ || state.m_60734_() == Blocks.f_50099_ || state.m_60734_() == Blocks.f_50100_ || state.m_60734_() == Blocks.f_50101_ || state.m_60734_() == Blocks.f_50102_ || state.m_60734_() == Blocks.f_50103_ || state.m_60734_() == Blocks.f_50104_ || state.m_60734_() == Blocks.f_50105_ || state.m_60734_() == Blocks.f_50106_ || state.m_60734_() == Blocks.f_50107_ || state.m_60734_() == Blocks.f_50108_ || state.m_60734_() == Blocks.f_50109_ || state.m_60734_() == Blocks.f_50336_ || state.m_60734_() == Blocks.f_50337_ || state.m_60734_() == Blocks.f_50338_ || state.m_60734_() == Blocks.f_50339_ || state.m_60734_() == Blocks.f_50340_ || state.m_60734_() == Blocks.f_50341_ || state.m_60734_() == Blocks.f_50342_ || state.m_60734_() == Blocks.f_50343_ || state.m_60734_() == Blocks.f_50344_ || state.m_60734_() == Blocks.f_50345_ || state.m_60734_() == Blocks.f_50346_ || state.m_60734_() == Blocks.f_50347_ || state.m_60734_() == Blocks.f_50348_ || state.m_60734_() == Blocks.f_50349_ || state.m_60734_() == Blocks.f_50350_ || state.m_60734_() == Blocks.f_50351_;
    }

    private static void sendAngerNotification(ServerLevel server, String cause, double amount) {
        for (ServerPlayer player : server.m_6907_()) {
            if (!player.getPersistentData().m_128471_("debugAnger")) continue;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[ANGER] " + cause + ": +" + String.format("%.2f", amount))));
        }
    }

    private static void sendDebugInfo(ServerLevel server, Player player, boolean enclosed, boolean inCave, boolean insideHouse, int enclosedTicks, int caveTicks, int houseTicks) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        double angerLevel = AngerSystemProcedure.getAngerLevel(server);
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        double enclosedProgress = (double)enclosedTicks / 2400.0 * 100.0;
        double caveProgress = (double)caveTicks / 12000.0 * 100.0;
        double houseProgress = (double)houseTicks / 1200.0 * 100.0;
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(0, 40, 0));
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)("\u00a7cANGER: " + String.format("%.2f", angerLevel) + " / 50.0"))));
        String subtitle = "Phase: " + phase + " | Enclosed: " + (enclosed ? "\u00a7aYES" : "\u00a77NO") + " | Cave: " + (inCave ? "\u00a7aYES" : "\u00a77NO") + " | House: " + (insideHouse ? "\u00a7aYES" : "\u00a77NO");
        sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)subtitle)));
        String actionBar = "Enclosed: " + String.format("%.1f", enclosedProgress) + "% | Cave: " + String.format("%.1f", caveProgress) + "% | House: " + String.format("%.1f", houseProgress) + "%";
        sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)actionBar)));
    }

    public static class AngerSavedData
    extends SavedData {
        public static final String NAME = "fromthecaves_anger_data";
        private double angerLevel = 0.0;

        public static AngerSavedData load(CompoundTag tag) {
            AngerSavedData data = new AngerSavedData();
            data.angerLevel = tag.m_128459_("angerLevel");
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128347_("angerLevel", this.angerLevel);
            return tag;
        }

        public double getAngerLevel() {
            return this.angerLevel;
        }

        public void addAnger(double amount) {
            this.angerLevel += amount;
            this.m_77762_();
        }

        public void setAngerLevel(double level) {
            this.angerLevel = level;
            this.m_77762_();
        }

        public void resetAnger() {
            this.angerLevel = 0.0;
            this.m_77762_();
        }
    }
}

