/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import net.mcreator.fromthecaves.entity.FROMTHECAVES2WALLEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RevealWallMobProcedure {
    private static final double BASE_PROB = 0.0015;
    private static final double MAX_PROB = 0.003;
    private static final int LIGHT_THRESHOLD = 18;
    private static final int REVEAL_DISTANCE = 2;
    private static final long BLINDNESS_DELAY = 20L;
    private static final int BLINDNESS_DURATION = 60;
    private static final long DESPAWN_DELAY = 30L;

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent evt) {
        Player player = evt.getPlayer();
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor.m_5776_()) {
            return;
        }
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel);
        if (phase < 1 || phase > 2) {
            return;
        }
        BlockPos pos = evt.getPos();
        if (serverLevel.m_45517_(LightLayer.BLOCK, pos) >= 18) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, player, 0.0015, 0.003);
        if (Math.random() >= dynamicProb) {
            return;
        }
        BlockPos target = pos.m_5484_(player.m_6350_(), 2);
        BlockState bs = serverLevel.m_8055_(target);
        if (bs.m_60734_() != Blocks.f_50069_ && bs.m_60734_() != Blocks.f_152550_ && bs.m_60734_() != Blocks.f_50334_ && bs.m_60734_() != Blocks.f_50228_ && bs.m_60734_() != Blocks.f_50122_ && bs.m_60734_() != Blocks.f_152496_ && bs.m_60734_() != Blocks.f_49997_ && bs.m_60734_() != Blocks.f_49996_ && bs.m_60734_() != Blocks.f_152505_ && bs.m_60734_() != Blocks.f_49995_ && bs.m_60734_() != Blocks.f_50173_ && bs.m_60734_() != Blocks.f_50264_ && bs.m_60734_() != Blocks.f_50059_ && bs.m_60734_() != Blocks.f_50089_ && bs.m_60734_() != Blocks.f_152469_ && bs.m_60734_() != Blocks.f_152468_ && bs.m_60734_() != Blocks.f_152506_ && bs.m_60734_() != Blocks.f_152467_ && bs.m_60734_() != Blocks.f_152473_ && bs.m_60734_() != Blocks.f_152479_ && bs.m_60734_() != Blocks.f_152472_ && bs.m_60734_() != Blocks.f_152474_) {
            return;
        }
        serverLevel.m_46597_(target, Blocks.f_50016_.m_49966_());
        FROMTHECAVES2WALLEntity mob = (FROMTHECAVES2WALLEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVES_2_WALL.get()).m_20615_((Level)serverLevel);
        if (mob == null) {
            return;
        }
        mob.m_7678_((double)target.m_123341_() + 0.5, target.m_123342_(), (double)target.m_123343_() + 0.5, 0.0f, 0.0f);
        serverLevel.m_7967_((Entity)mob);
        CompoundTag nbt = mob.getPersistentData();
        long now = serverLevel.m_46467_();
        nbt.m_128356_("spawnTick", now);
        nbt.m_128356_("seenTick", 0L);
        SoundEvent breakSound = RevealWallMobProcedure.resolveSound(SoundEvents.f_12442_);
        if (breakSound != null) {
            serverLevel.m_5594_(null, target, breakSound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity e = ev.getEntity();
        if (!(e instanceof FROMTHECAVES2WALLEntity)) {
            return;
        }
        FROMTHECAVES2WALLEntity mob = (FROMTHECAVES2WALLEntity)e;
        Level level = mob.m_9236_();
        if (level.m_5776_() || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase < 1 || phase > 2) {
            return;
        }
        ServerPlayer closest = null;
        double minDistSq = Double.MAX_VALUE;
        for (ServerPlayer p : serverLevel.m_6907_()) {
            double d2 = mob.m_20280_((Entity)p);
            if (!(d2 < minDistSq)) continue;
            minDistSq = d2;
            closest = p;
        }
        if (closest != null) {
            double dx = closest.m_20185_() - mob.m_20185_();
            double dz = closest.m_20189_() - mob.m_20189_();
            float yaw = (float)Math.toDegrees(Math.atan2(dz, dx)) - 90.0f;
            mob.m_146922_(yaw);
            mob.f_20885_ = yaw;
            mob.f_20883_ = yaw;
        }
        CompoundTag nbt = mob.getPersistentData();
        long now = serverLevel.m_46467_();
        long spawnTick = nbt.m_128454_("spawnTick");
        long seenTick = nbt.m_128454_("seenTick");
        if (now <= spawnTick) {
            return;
        }
        if (seenTick == 0L) {
            for (ServerPlayer p : serverLevel.m_6907_()) {
                if (!p.m_142582_((Entity)mob)) continue;
                nbt.m_128356_("seenTick", now);
                break;
            }
            return;
        }
        long sinceSeen = now - seenTick;
        if (sinceSeen == 20L) {
            for (ServerPlayer p : serverLevel.m_6907_()) {
                if (!p.m_142582_((Entity)mob)) continue;
                p.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, 0, false, true));
                SoundEvent ambient = RevealWallMobProcedure.resolveSound(SoundEvents.f_11689_);
                if (ambient == null) continue;
                serverLevel.m_5594_(null, p.m_20183_(), ambient, SoundSource.AMBIENT, 1.0f, 0.75f);
            }
        }
        if (sinceSeen >= 30L) {
            BlockPos pos = mob.m_20183_();
            SoundEvent dig = RevealWallMobProcedure.resolveSound(SoundEvents.f_12446_);
            if (dig != null) {
                serverLevel.m_5594_(null, pos, dig, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            mob.m_146870_();
        }
    }

    private static SoundEvent resolveSound(Object soundConst) {
        Object res;
        Method m2;
        if (soundConst instanceof SoundEvent) {
            SoundEvent se = (SoundEvent)soundConst;
            return se;
        }
        try {
            m2 = soundConst.getClass().getMethod("value", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception m2) {
            // empty catch block
        }
        try {
            m2 = soundConst.getClass().getMethod("get", new Class[0]);
            res = m2.invoke(soundConst, new Object[0]);
            if (res instanceof SoundEvent) {
                return (SoundEvent)res;
            }
        }
        catch (Exception m3) {
            // empty catch block
        }
        try {
            m2 = soundConst.getClass().getMethod("orElse", Object.class);
            Object object = m2.invoke(soundConst, new Object[]{null});
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

