/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DeadpigSpawnProcedure {
    private static final int SPAWN_CHECK_INTERVAL = 2;
    private static final double BASE_PROB = 1.5E-5;
    private static final double MAX_PROB = 3.5E-5;
    private static final int MIN_DISTANCE = 9;
    private static final int MAX_DISTANCE = 32;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 2 && phase != 3) {
            return;
        }
        if (level.m_46467_() % 2L != 0L) {
            return;
        }
        double spawnProb = ChunkTensionProcedure.getDynamicProbability(level, player, 1.5E-5, 3.5E-5);
        if (level.f_46441_.m_188500_() > spawnProb) {
            return;
        }
        BlockPos spawnPos = DeadpigSpawnProcedure.findValidSpawnPosition(level, player);
        if (spawnPos == null) {
            return;
        }
        BlockState deadpigBlock = ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation("from_the_caves", "deadpig"))).m_49966_();
        if (deadpigBlock.m_61138_((Property)BlockStateProperties.f_61374_)) {
            directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            randomDir = directions[level.f_46441_.m_188503_(directions.length)];
            deadpigBlock = (BlockState)deadpigBlock.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)randomDir);
        } else if (deadpigBlock.m_61138_((Property)BlockStateProperties.f_61372_)) {
            directions = Direction.values();
            randomDir = directions[level.f_46441_.m_188503_(directions.length)];
            deadpigBlock = (BlockState)deadpigBlock.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)randomDir);
        }
        level.m_7731_(spawnPos, deadpigBlock, 3);
        for (int i = 0; i < 15; ++i) {
            double offsetX = (level.f_46441_.m_188500_() - 0.5) * 1.0;
            double offsetY = level.f_46441_.m_188500_() * 1.0;
            double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 1.0;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)spawnPos.m_123341_() + 0.5 + offsetX, (double)spawnPos.m_123342_() + offsetY, (double)spawnPos.m_123343_() + 0.5 + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
        }
        level.m_5594_(null, spawnPos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 0.8f);
    }

    private static BlockPos findValidSpawnPosition(ServerLevel level, Player player) {
        BlockPos playerPos = player.m_20183_();
        for (int attempts = 0; attempts < 20; ++attempts) {
            double distance = 9.0 + level.f_46441_.m_188500_() * 23.0;
            double angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
            int offsetX = (int)(Math.cos(angle) * distance);
            int offsetZ = (int)(Math.sin(angle) * distance);
            for (int yOffset = -10; yOffset <= 10; ++yOffset) {
                BlockPos checkPos = playerPos.m_7918_(offsetX, yOffset, offsetZ);
                if (!level.m_8055_(checkPos).m_60795_() || !level.m_8055_(checkPos.m_7495_()).m_60804_((BlockGetter)level, checkPos.m_7495_()) || !level.m_8055_(checkPos.m_7494_()).m_60795_()) continue;
                return checkPos;
            }
        }
        return null;
    }
}

