/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib.animatable.GeoEntity;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhaseBlockSpawnProcedure {
    private static final double BASE_PROB = 4.5E-5;
    private static final double MAX_PROB = 6.0E-5;
    private static final int SCAN_RADIUS = 20;
    private static final int MIN_DISTANCE = 5;
    private static final Map<Block, RegistryObject<? extends EntityType<?>>> BLOCK_TO_RO = new HashMap();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerLevel world = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)world);
        if (phase != 1 && phase != 2 && phase != 3) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(world, player, 4.5E-5, 6.0E-5);
        if (world.f_46441_.m_188500_() >= dynamicProb) {
            return;
        }
        BlockPos ppos = player.m_20183_();
        BlockPos bestPos = null;
        RegistryObject<? extends EntityType<?>> bestRO = null;
        double bestDist2 = Double.MAX_VALUE;
        for (int dx = -20; dx <= 20; ++dx) {
            for (int dy = -20; dy <= 20; ++dy) {
                for (int dz = -20; dz <= 20; ++dz) {
                    double d2;
                    BlockPos pos = ppos.m_7918_(dx, dy, dz);
                    RegistryObject<? extends EntityType<?>> ro = BLOCK_TO_RO.get(world.m_8055_(pos).m_60734_());
                    if (ro == null || world.m_8055_(pos.m_7494_()).m_60734_() != world.m_8055_(pos).m_60734_() || !((d2 = pos.m_123331_((Vec3i)ppos)) < bestDist2)) continue;
                    bestDist2 = d2;
                    bestPos = pos;
                    bestRO = ro;
                }
            }
        }
        if (bestPos == null) {
            return;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            Entity e;
            EntityType type;
            BlockPos spawnPos = bestPos.m_121945_(dir);
            if (!world.m_46859_(spawnPos) || spawnPos.m_123331_((Vec3i)ppos) < 25.0 || (type = (EntityType)bestRO.get()) == null || !((e = type.m_262496_(world, spawnPos, MobSpawnType.MOB_SUMMONED)) instanceof Mob)) continue;
            Mob mob = (Mob)e;
            if (!(e instanceof GeoEntity)) continue;
            Vec3 toBlock = Vec3.m_82512_((Vec3i)bestPos).m_82546_(mob.m_20182_()).m_82541_();
            float yaw = (float)(Math.atan2(toBlock.f_82481_, toBlock.f_82479_) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-Math.asin(toBlock.f_82480_) * 180.0 / Math.PI);
            mob.m_146922_(yaw);
            mob.m_146926_(pitch);
            mob.m_5616_(yaw);
            mob.m_21557_(true);
            mob.m_20049_("phaseStone");
            mob.getPersistentData().m_128379_("chasing", false);
            return;
        }
    }

    static {
        BLOCK_TO_RO.put(Blocks.f_50069_, FromTheCavesModEntities.FROMTHECAVESSTONE);
        BLOCK_TO_RO.put(Blocks.f_50652_, FromTheCavesModEntities.FROMTHECAVESCOBBLESTONE);
        BLOCK_TO_RO.put(Blocks.f_152490_, FromTheCavesModEntities.FROMTHECAVESAMETHYST);
        BLOCK_TO_RO.put(Blocks.f_50705_, FromTheCavesModEntities.FROMTHECAVESOAKPLANKS);
        BLOCK_TO_RO.put(Blocks.f_50741_, FromTheCavesModEntities.FROMTHECAVESSPRUCEPLANKS);
        BLOCK_TO_RO.put(Blocks.f_50000_, FromTheCavesModEntities.FROMTHECAVESSPRUCELOGS);
        BLOCK_TO_RO.put(Blocks.f_49999_, FromTheCavesModEntities.FROMTHECAVESOAKLOGS);
        BLOCK_TO_RO.put(Blocks.f_50742_, FromTheCavesModEntities.FROMTHECAVESBIRCHPLANKS);
        BLOCK_TO_RO.put(Blocks.f_50001_, FromTheCavesModEntities.FROMTHECAVESBIRCHLOGS);
        BLOCK_TO_RO.put(Blocks.f_50002_, FromTheCavesModEntities.FROMTHECAVESJUNGLELOGS);
        BLOCK_TO_RO.put(Blocks.f_50004_, FromTheCavesModEntities.FROMTHECAVESDARKOAKLOGS);
    }
}

