/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSHADOWEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PhaseTwoShadowStareAmbushProcedure {
    private static final double BASE_PROB_PHASE2 = 6.5E-6;
    private static final double MAX_PROB_PHASE2 = 7.5E-6;
    private static final int COOLDOWN_TICKS = 1200;
    private static final int MIN_DIST = 8;
    private static final int MAX_DIST = 20;
    private static final int MAX_MOBS = 2;
    private static final double MOVE_SPEED = 0.55;
    private static final double FOV_HALF_COS = Math.cos(Math.toRadians(70.0));
    private static final long MAX_LIFE_TICKS = 2000L;
    private static final String FROZEN_KEY = "frozenWaterBlocks";
    private static final int DOLPHIN_GRACE_INTERVAL = 60;
    private static final int DOLPHIN_GRACE_DURATION = 60;
    private static final int WATER_PUSH_INTERVAL = 20;
    private static final double WATER_PUSH_STRENGTH = 0.3;
    private static final double GRAB_DISTANCE = 1.6;
    private static final int BREAK_INTERVAL = 3;
    private static final int VOID_ZONE_SIZE = 2;
    private static final Map<UUID, Long> playerCooldown = new HashMap<UUID, Long>();
    private static final Map<UUID, UUID> grabbedPlayers = new HashMap<UUID, UUID>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 2) {
            return;
        }
        if (player.m_20183_().m_123342_() <= 5) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, 6.5E-6, 7.5E-6);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        long now = server.m_46467_();
        UUID puid = player.m_20148_();
        if (playerCooldown.containsKey(puid) && now < playerCooldown.get(puid)) {
            return;
        }
        playerCooldown.put(puid, now + 1200L);
        int count = 1 + server.m_213780_().m_188503_(2);
        for (int i = 0; i < count; ++i) {
            FROMTHECAVESSHADOWEntity e;
            int tries;
            double angle = server.m_213780_().m_188500_() * Math.PI * 2.0;
            double dist = 8.0 + server.m_213780_().m_188500_() * 12.0;
            int sx = (int)Math.round((double)player.m_20183_().m_123341_() + Math.cos(angle) * dist);
            int sz = (int)Math.round((double)player.m_20183_().m_123343_() + Math.sin(angle) * dist);
            int sy = player.m_20183_().m_123342_();
            BlockPos spawnPos = new BlockPos(sx, sy, sz);
            for (tries = 0; !server.m_46859_(spawnPos) && tries < 6; ++tries) {
                spawnPos = spawnPos.m_7494_();
            }
            for (tries = 0; spawnPos.m_123342_() > 1 && !server.m_46859_(spawnPos) && tries < 6; ++tries) {
                spawnPos = spawnPos.m_7495_();
            }
            if (!server.m_46859_(spawnPos) || FromTheCavesModEntities.FROMTHECAVESSHADOW.get() == null || (e = (FROMTHECAVESSHADOWEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOW.get()).m_20615_((Level)server)) == null) continue;
            e.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
            CompoundTag nbt = e.getPersistentData();
            nbt.m_128356_("fromtc_spawnTime", now);
            nbt.m_128359_("fromtc_role", "stare_ambush");
            nbt.m_128405_("fromtc_ambushState", 0);
            nbt.m_128379_("fromtc_firstLookHandled", false);
            e.m_21557_(false);
            e.m_20242_(false);
            server.m_7967_((Entity)e);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        for (ServerLevel server : ev.getServer().m_129785_()) {
            long now = server.m_46467_();
            ArrayList<FROMTHECAVESSHADOWEntity> shadows = new ArrayList<FROMTHECAVESSHADOWEntity>();
            for (Entity ent : server.m_142646_().m_142273_()) {
                if (!(ent instanceof FROMTHECAVESSHADOWEntity)) continue;
                FROMTHECAVESSHADOWEntity shadow = (FROMTHECAVESSHADOWEntity)ent;
                shadows.add(shadow);
            }
            for (FROMTHECAVESSHADOWEntity e : shadows) {
                boolean firstHandled;
                BlockPos below;
                int mobY;
                long spawnTime;
                CompoundTag data;
                if (e == null || e.m_213877_()) continue;
                FROMTHECAVESSHADOWEntity pmob = null;
                if (e instanceof PathfinderMob) {
                    pmob = e;
                }
                if (pmob == null || !"stare_ambush".equals((data = e.getPersistentData()).m_128461_("fromtc_role"))) continue;
                Player target = server.m_45930_((Entity)e, 20.0);
                if (target == null) {
                    e.m_21557_(true);
                    e.m_20256_(Vec3.f_82478_);
                    continue;
                }
                PhaseTwoShadowStareAmbushProcedure.processFrozenBlocks(server, (PathfinderMob)pmob);
                pmob.m_21441_(BlockPathTypes.WATER, 0.0f);
                if (PhaseTwoShadowStareAmbushProcedure.isInOrTouchingWater((PathfinderMob)pmob, server)) {
                    long nextWaterPush;
                    long nextDolphinGrace;
                    long tick = server.m_46467_();
                    if (tick >= (nextDolphinGrace = pmob.getPersistentData().m_128454_("nextDolphinGraceTick"))) {
                        pmob.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 60, 0, false, true));
                        pmob.getPersistentData().m_128356_("nextDolphinGraceTick", tick + 60L);
                    }
                    if (tick >= (nextWaterPush = pmob.getPersistentData().m_128454_("nextWaterPushTick"))) {
                        Vec3 mobPos = pmob.m_20182_();
                        Vec3 playerPos = target.m_146892_();
                        Vec3 dir = playerPos.m_82546_(mobPos).m_82541_();
                        pmob.m_20256_(pmob.m_20184_().m_82549_(dir.m_82490_(0.3)));
                        pmob.getPersistentData().m_128356_("nextWaterPushTick", tick + 20L);
                    }
                }
                long l = spawnTime = data.m_128441_("fromtc_spawnTime") ? data.m_128454_("fromtc_spawnTime") : now;
                if (now - spawnTime > 2000L) {
                    e.m_146870_();
                    continue;
                }
                int targetY = target.m_20183_().m_123342_();
                if (targetY >= (mobY = pmob.m_20183_().m_123342_()) && server.m_6425_(below = pmob.m_20183_().m_7495_()).m_76152_() == Fluids.f_76193_ && !PhaseTwoShadowStareAmbushProcedure.isPosAlreadyFrozen((PathfinderMob)pmob, below)) {
                    server.m_46597_(below, Blocks.f_50449_.m_49966_());
                    PhaseTwoShadowStareAmbushProcedure.addFrozenBlock((PathfinderMob)pmob, below, server.m_46467_() + 20L);
                }
                double distToTarget = e.m_20270_((Entity)target);
                boolean isGrabbing = data.m_128471_("fromtc_grabbing");
                if (!isGrabbing && distToTarget <= 1.6) {
                    data.m_128379_("fromtc_grabbing", true);
                    data.m_128356_("fromtc_lastBreakTick", now);
                    data.m_128405_("fromtc_grabStartY", target.m_20183_().m_123342_());
                    grabbedPlayers.put(target.m_20148_(), e.m_20148_());
                    isGrabbing = true;
                }
                if (isGrabbing) {
                    PhaseTwoShadowStareAmbushProcedure.handleGrabbing(server, e, target, data, now);
                    continue;
                }
                Vec3 ownerLook = target.m_20154_();
                Vec3 toEntity = e.m_20182_().m_82546_(target.m_146892_());
                double len = toEntity.m_82553_();
                if (len < 1.0E-4) {
                    len = 1.0E-4;
                }
                Vec3 dirToEntity = toEntity.m_82490_(1.0 / len);
                boolean ownerLooking = ownerLook.m_82541_().m_82526_(dirToEntity) >= FOV_HALF_COS;
                int ambushState = data.m_128441_("fromtc_ambushState") ? data.m_128451_("fromtc_ambushState") : 0;
                boolean bl = firstHandled = data.m_128441_("fromtc_firstLookHandled") && data.m_128471_("fromtc_firstLookHandled");
                if (ownerLooking) {
                    boolean movedByNav;
                    block38: {
                        if (!firstHandled && ambushState == 0) {
                            data.m_128405_("fromtc_ambushState", 1);
                            try {
                                e.m_20124_(Pose.STANDING);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            data.m_128379_("fromtc_firstLookHandled", true);
                        }
                        data.m_128405_("fromtc_ambushState", 1);
                        e.m_21557_(false);
                        movedByNav = false;
                        try {
                            PathNavigation nav = e.m_21573_();
                            if (nav == null) break block38;
                            try {
                                Method m = nav.getClass().getMethod("moveTo", LivingEntity.class, Double.TYPE);
                                if (m != null) {
                                    m.invoke((Object)nav, target, 0.55);
                                    movedByNav = true;
                                }
                            }
                            catch (NoSuchMethodException nsme) {
                                try {
                                    Method m2 = nav.getClass().getMethod("moveTo", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                                    m2.invoke((Object)nav, target.m_20185_(), target.m_20186_(), target.m_20189_(), 0.55);
                                    movedByNav = true;
                                }
                                catch (Throwable m2) {}
                            }
                        }
                        catch (Throwable nav) {
                            // empty catch block
                        }
                    }
                    if (movedByNav) continue;
                    Vec3 toTarget = target.m_20182_().m_82546_(e.m_20182_());
                    Vec3 horiz = new Vec3(toTarget.f_82479_, 0.0, toTarget.f_82481_);
                    double lenHoriz = horiz.m_82553_();
                    if (lenHoriz > 0.1) {
                        e.m_20256_(new Vec3(horiz.f_82479_ / lenHoriz * 0.55, e.m_20184_().f_82480_, horiz.f_82481_ / lenHoriz * 0.55));
                        e.m_146922_((float)(Math.toDegrees(Math.atan2(horiz.f_82481_, horiz.f_82479_)) - 90.0));
                        continue;
                    }
                    e.m_20256_(new Vec3(0.0, e.m_20184_().f_82480_, 0.0));
                    continue;
                }
                if (!firstHandled && ambushState == 0) {
                    boolean crouch;
                    boolean bl2 = crouch = server.f_46441_.m_188500_() < 0.5;
                    if (crouch) {
                        data.m_128405_("fromtc_ambushState", 2);
                        try {
                            e.m_20124_(Pose.CROUCHING);
                        }
                        catch (Throwable throwable) {}
                    } else {
                        data.m_128405_("fromtc_ambushState", 0);
                        try {
                            e.m_20124_(Pose.STANDING);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    data.m_128379_("fromtc_firstLookHandled", true);
                }
                e.m_21557_(true);
                e.m_20256_(Vec3.f_82478_);
                if (ambushState == 2) {
                    try {
                        e.m_20124_(Pose.CROUCHING);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                try {
                    e.m_20124_(Pose.STANDING);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static void processFrozenBlocks(ServerLevel server, PathfinderMob mob) {
        String[] entries;
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        if (raw == null || raw.isEmpty()) {
            return;
        }
        StringBuilder remaining = new StringBuilder();
        long tick = server.m_46467_();
        for (String e : entries = raw.split(";")) {
            if (e == null || e.isEmpty()) continue;
            try {
                String[] parts = e.split(":");
                if (parts.length < 4) continue;
                int x = Integer.parseInt(parts[0]);
                int y = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                long expire = Long.parseLong(parts[3]);
                BlockPos p = new BlockPos(x, y, z);
                if (tick >= expire) {
                    Block cur = server.m_8055_(p).m_60734_();
                    if (cur != Blocks.f_50449_ && cur != Blocks.f_50126_) continue;
                    server.m_46597_(p, Blocks.f_49990_.m_49966_());
                    continue;
                }
                remaining.append(x).append(":").append(y).append(":").append(z).append(":").append(expire).append(";");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mob.getPersistentData().m_128359_(FROZEN_KEY, remaining.toString());
    }

    private static boolean isPosAlreadyFrozen(PathfinderMob mob, BlockPos pos) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        if (raw == null || raw.isEmpty()) {
            return false;
        }
        String token = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":";
        return raw.contains(token);
    }

    private static void addFrozenBlock(PathfinderMob mob, BlockPos pos, long expireTick) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        String token = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":";
        if (raw != null && raw.contains(token)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (raw != null && !raw.isEmpty()) {
            sb.append(raw);
        }
        sb.append(pos.m_123341_()).append(":").append(pos.m_123342_()).append(":").append(pos.m_123343_()).append(":").append(expireTick).append(";");
        mob.getPersistentData().m_128359_(FROZEN_KEY, sb.toString());
    }

    private static boolean isInOrTouchingWater(PathfinderMob mob, ServerLevel server) {
        if (mob.m_20069_()) {
            return true;
        }
        BlockPos o = mob.m_20183_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || server.m_8055_(o.m_7918_(dx, 0, dz)).m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }

    private static void handleGrabbing(ServerLevel server, FROMTHECAVESSHADOWEntity mob, Player player, CompoundTag data, long now) {
        mob.m_21557_(true);
        mob.m_20242_(true);
        BlockPos playerPos = player.m_20183_();
        BlockPos mobPos = mob.m_20183_();
        mob.m_6021_(player.m_20185_(), player.m_20186_(), player.m_20189_());
        player.m_20334_(0.0, 0.0, 0.0);
        mob.m_20334_(0.0, 0.0, 0.0);
        long lastBreak = data.m_128454_("fromtc_lastBreakTick");
        if (now - lastBreak >= 3L) {
            data.m_128356_("fromtc_lastBreakTick", now);
            BlockPos centerPos = playerPos.m_7495_();
            PhaseTwoShadowStareAmbushProcedure.break2x2x2Area(server, centerPos);
            player.m_6021_(player.m_20185_(), player.m_20186_() - 1.0, player.m_20189_());
            mob.m_6021_(mob.m_20185_(), mob.m_20186_() - 1.0, mob.m_20189_());
        }
        if (playerPos.m_123342_() <= 0) {
            PhaseTwoShadowStareAmbushProcedure.createVoidZone(server, playerPos);
            grabbedPlayers.remove(player.m_20148_());
            data.m_128473_("fromtc_grabbing");
            data.m_128473_("fromtc_lastBreakTick");
            data.m_128473_("fromtc_grabStartY");
            mob.m_146870_();
        }
    }

    private static void break2x2x2Area(ServerLevel server, BlockPos center) {
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(state)) continue;
                    RestoreBrokenBlocksManagerProcedure.destroyAndRecord(server, pos, false);
                }
            }
        }
    }

    private static void createVoidZone(ServerLevel server, BlockPos center) {
        for (int x = -1; x <= 3; ++x) {
            for (int y = -1; y <= 3; ++y) {
                for (int z = -1; z <= 3; ++z) {
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (state.m_60795_() || state.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(state)) continue;
                    server.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }
    }
}

