/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ProtectedBlocksProcedure {
    private static final Map<BlockPos, BlockData> blockDataCache = new HashMap<BlockPos, BlockData>();
    private static long tickCounter = 0L;
    private static final long CLEANUP_INTERVAL = 1200L;
    private static final long MAX_CACHE_AGE = 2400L;
    private static final int MAX_CACHE_SIZE = 1000;

    public static boolean isProtected(BlockState state) {
        if (state == null) {
            return false;
        }
        Block b = state.m_60734_();
        return b instanceof ChestBlock || b instanceof ShulkerBoxBlock || b instanceof BarrelBlock || b instanceof EnderChestBlock || b instanceof BedBlock || b instanceof FurnaceBlock || b instanceof LecternBlock || b instanceof BlastFurnaceBlock || b instanceof SmokerBlock || b instanceof DispenserBlock || b instanceof DropperBlock || b instanceof HopperBlock || b instanceof BrewingStandBlock || b instanceof BeaconBlock || b instanceof JukeboxBlock;
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        ServerLevel server;
        BlockEntity blockEntity;
        if (event.getPlayer() != null) {
            return;
        }
        BlockState state = event.getState();
        if (!ProtectedBlocksProcedure.isProtected(state)) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (blockEntity = (server = (ServerLevel)levelAccessor).m_7702_(event.getPos())) != null) {
            CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
            blockDataCache.put(event.getPos().m_7949_(), new BlockData(state, data, server.m_46467_()));
        }
        event.setCanceled(true);
        if (event.hasResult()) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        if (event.getLevel() == null) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List affectedBlocks = event.getAffectedBlocks();
        Iterator iterator = affectedBlocks.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = (BlockPos)iterator.next();
            BlockState state = server.m_8055_(pos);
            if (!ProtectedBlocksProcedure.isProtected(state)) continue;
            iterator.remove();
            BlockEntity blockEntity = server.m_7702_(pos);
            CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
            blockDataCache.put(pos.m_7949_(), new BlockData(state, data, server.m_46467_()));
        }
    }

    @SubscribeEvent
    public static void onBlockChange(BlockEvent.NeighborNotifyEvent event) {
        BlockData data;
        if (event.getLevel() == null) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        BlockPos pos = event.getPos();
        if (!blockDataCache.containsKey(pos)) {
            return;
        }
        BlockState currentState = level.m_8055_(pos);
        if (currentState.m_60795_() && (data = blockDataCache.get(pos)) != null && ProtectedBlocksProcedure.isProtected(data.state)) {
            ProtectedBlocksProcedure.restoreProtectedBlock(level, pos, data.state, data.data);
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ChunkAccess chunk = event.getChunk();
        int chunkX = chunk.m_7697_().f_45578_;
        int chunkZ = chunk.m_7697_().f_45579_;
        blockDataCache.entrySet().removeIf(entry -> {
            BlockPos pos = (BlockPos)entry.getKey();
            return pos.m_123341_() >> 4 == chunkX && pos.m_123343_() >> 4 == chunkZ;
        });
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (++tickCounter < 1200L) {
            return;
        }
        tickCounter = 0L;
        long currentTime = event.getServer().m_129783_().m_46467_();
        blockDataCache.entrySet().removeIf(entry -> currentTime - ((BlockData)entry.getValue()).timestamp > 2400L);
        if (blockDataCache.size() > 1000) {
            Iterator<Map.Entry<BlockPos, BlockData>> iterator = blockDataCache.entrySet().iterator();
            int toRemove = blockDataCache.size() - 1000;
            for (int i = 0; i < toRemove && iterator.hasNext(); ++i) {
                iterator.next();
                iterator.remove();
            }
        }
    }

    public static void cacheBlockData(ServerLevel level, BlockPos pos) {
        if (level == null || pos == null) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        if (!ProtectedBlocksProcedure.isProtected(state)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        CompoundTag data = ProtectedBlocksProcedure.saveContainerContents(blockEntity);
        blockDataCache.put(pos.m_7949_(), new BlockData(state, data, level.m_46467_()));
    }

    private static CompoundTag saveContainerContents(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            CompoundTag items = new CompoundTag();
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack stack = container.m_8020_(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                stack.m_41739_(itemTag);
                items.m_128365_("Slot" + i, (Tag)itemTag);
            }
            tag.m_128365_("Items", (Tag)items);
            tag.m_128405_("Size", container.m_6643_());
        }
        return tag;
    }

    private static void restoreContainerContents(BlockEntity blockEntity, CompoundTag tag) {
        if (blockEntity == null || tag == null) {
            return;
        }
        if (blockEntity instanceof Container && tag.m_128441_("Items")) {
            Container container = (Container)blockEntity;
            CompoundTag items = tag.m_128469_("Items");
            for (int i = 0; i < container.m_6643_(); ++i) {
                String slotKey = "Slot" + i;
                if (!items.m_128441_(slotKey)) continue;
                CompoundTag itemTag = items.m_128469_(slotKey);
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                container.m_6836_(i, stack);
            }
            blockEntity.m_6596_();
        }
    }

    public static void restoreProtectedBlock(ServerLevel level, BlockPos pos, BlockState state, CompoundTag savedData) {
        BlockEntity blockEntity;
        if (level == null || pos == null || state == null) {
            return;
        }
        level.m_7731_(pos, state, 3);
        if (savedData != null && (blockEntity = level.m_7702_(pos)) != null) {
            ProtectedBlocksProcedure.restoreContainerContents(blockEntity, savedData);
        }
        blockDataCache.remove(pos);
    }

    private static class BlockData {
        BlockState state;
        CompoundTag data;
        long timestamp;

        BlockData(BlockState state, CompoundTag data, long timestamp) {
            this.state = state;
            this.data = data;
            this.timestamp = timestamp;
        }
    }
}

