/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkeletonSkullEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.5E-5;
    private static final double MAX_PROB_PHASE1 = 4.0E-5;
    private static final double BASE_PROB_PHASE2 = 4.0E-5;
    private static final double MAX_PROB_PHASE2 = 4.5E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int ROTATION_DURATION = 200;
    private static final Map<Integer, SkullEventState> activeEvents = new HashMap<Integer, SkullEventState>();
    private static final Map<BlockPos, Long> skullCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double maxProb = phase == 1 ? 4.0E-5 : 4.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validSkulls = SkeletonSkullEventsProcedure.findValidSkulls(server, player);
        if (validSkulls.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validSkulls.removeIf(pos -> skullCooldowns.containsKey(pos) && currentTime < skullCooldowns.get(pos));
        if (validSkulls.isEmpty()) {
            return;
        }
        BlockPos chosen = validSkulls.get(server.m_213780_().m_188503_(validSkulls.size()));
        SkullEvent event = SkullEvent.values()[server.m_213780_().m_188503_(SkullEvent.values().length)];
        skullCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new SkullEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, SkullEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SkullEventState> entry = iterator.next();
            SkullEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            switch (state.event) {
                case SKULL_ROTATION: {
                    SkeletonSkullEventsProcedure.handleSkullRotation(server, state);
                    break;
                }
                case SKULL_AMBIENT_SOUND: {
                    SkeletonSkullEventsProcedure.handleAmbientSound(server, state);
                }
            }
            if (state.tickCount < 200) continue;
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidSkulls(ServerLevel server, Player player) {
        ArrayList<BlockPos> skulls = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof SkullBlock) && !(state.m_60734_() instanceof WallSkullBlock)) continue;
                    skulls.add(pos.m_7949_());
                }
            }
        }
        return skulls;
    }

    private static void handleSkullRotation(ServerLevel server, SkullEventState state) {
        BlockState skullState = server.m_8055_(state.skullPos);
        if (!(skullState.m_60734_() instanceof SkullBlock)) {
            return;
        }
        if (state.tickCount % 10 == 0) {
            double dx = state.player.m_20185_() - ((double)state.skullPos.m_123341_() + 0.5);
            double dz = state.player.m_20189_() - ((double)state.skullPos.m_123343_() + 0.5);
            float targetYaw = (float)(Math.atan2(dz, dx) * 57.29577951308232) + 90.0f;
            int rotation = Math.floorMod((int)(targetYaw / 22.5f), 16);
            server.m_7731_(state.skullPos, (BlockState)skullState.m_61124_((Property)SkullBlock.f_56314_, (Comparable)Integer.valueOf(rotation)), 3);
        }
    }

    private static void handleAmbientSound(ServerLevel server, SkullEventState state) {
        if (state.tickCount % 60 == 0 && server.m_213780_().m_188501_() < 0.3f) {
            server.m_5594_(null, state.skullPos, SoundEvents.f_12423_, SoundSource.HOSTILE, 0.5f, 1.0f);
        }
    }

    private static enum SkullEvent {
        SKULL_ROTATION,
        SKULL_AMBIENT_SOUND;

    }

    private static class SkullEventState {
        SkullEvent event;
        Player player;
        BlockPos skullPos;
        int tickCount;
        int originalRotation;

        SkullEventState(SkullEvent event, Player player, BlockPos skullPos) {
            this.event = event;
            this.player = player;
            this.skullPos = skullPos;
            this.tickCount = 0;
            this.originalRotation = 0;
        }
    }
}

