/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.mcreator.fromthecaves.procedures.PhotosensitiveSafetyProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CemeteryMarkerFlickerProcedure {
    private static final double MARKER_DETECTION_RADIUS = 32.0;
    private static final double MAX_SOUND_DISTANCE = 8.0;
    private static final int SCAN_RADIUS_BLOCKS = 14;
    private static final int FLICKER_MIN_TICKS = 25;
    private static final int FLICKER_MAX_TICKS = 55;
    private static final int COOLDOWN_TICKS = 400;
    private static final int CHECK_INTERVAL = 60;
    private static final float ENERGY_SOUND_VOLUME = 0.05f;
    private static final int ENERGY_SOUND_INTERVAL = 120;
    private static final Map<Integer, FlickerState> activeFlickers = new HashMap<Integer, FlickerState>();
    private static final Map<BlockPos, Long> blockCooldowns = new HashMap<BlockPos, Long>();
    private static int flickerIdCounter = 0;
    private static long lastCheckTick = 0L;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        long currentTick = server.m_46467_();
        if (currentTick - lastCheckTick < 60L) {
            return;
        }
        lastCheckTick = currentTick;
        if (PhotosensitiveSafetyProcedure.isPhotosensitiveModeEnabled((LevelAccessor)level)) {
            return;
        }
        boolean markerNearby = CemeteryMarkerFlickerProcedure.checkForCemeteryMarker(server, player);
        if (!markerNearby) {
            return;
        }
        List<LightBlockInfo> lightBlocks = CemeteryMarkerFlickerProcedure.findNearbyLightBlocks(server, player);
        if (lightBlocks.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        lightBlocks.removeIf(block -> blockCooldowns.containsKey(block.pos) && currentTime < blockCooldowns.get(block.pos));
        if (lightBlocks.isEmpty()) {
            return;
        }
        lightBlocks.forEach(block -> blockCooldowns.put(block.pos, currentTime + 400L));
        activeFlickers.put(flickerIdCounter++, new FlickerState(player, lightBlocks));
    }

    private static boolean checkForCemeteryMarker(ServerLevel server, Player player) {
        Block cemeteryMarker = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "cemetery_marker"));
        if (cemeteryMarker == null) {
            return false;
        }
        int minX = (int)(player.m_20185_() - 32.0);
        int maxX = (int)(player.m_20185_() + 32.0);
        int minZ = (int)(player.m_20189_() - 32.0);
        int maxZ = (int)(player.m_20189_() + 32.0);
        int minY = Math.max(server.m_141937_(), (int)(player.m_20186_() - 32.0));
        int maxY = Math.min(server.m_151558_() - 1, (int)(player.m_20186_() + 32.0));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    double distance;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (server.m_8055_(pos).m_60734_() != cemeteryMarker || !((distance = player.m_20275_((double)x + 0.5, (double)y + 0.5, (double)z + 0.5)) <= 1024.0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static List<LightBlockInfo> findNearbyLightBlocks(ServerLevel server, Player player) {
        ArrayList<LightBlockInfo> lightBlocks = new ArrayList<LightBlockInfo>();
        int minX = player.m_20183_().m_123341_() - 14;
        int maxX = player.m_20183_().m_123341_() + 14;
        int minZ = player.m_20183_().m_123343_() - 14;
        int maxZ = player.m_20183_().m_123343_() + 14;
        int minY = Math.max(server.m_141937_(), player.m_20183_().m_123342_() - 6);
        int maxY = Math.min(server.m_151558_() - 1, player.m_20183_().m_123342_() + 6);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (block instanceof TorchBlock && !(block instanceof WallTorchBlock)) {
                        lightBlocks.add(new LightBlockInfo(pos, state, false, null, false, false, false));
                        continue;
                    }
                    if (block instanceof WallTorchBlock) {
                        Direction facing = (Direction)state.m_61143_((Property)WallTorchBlock.f_58119_);
                        lightBlocks.add(new LightBlockInfo(pos, state, true, facing, false, false, false));
                        continue;
                    }
                    if (block instanceof CampfireBlock) {
                        lightBlocks.add(new LightBlockInfo(pos, state, false, null, true, false, false));
                        continue;
                    }
                    if (block instanceof CandleBlock) {
                        lightBlocks.add(new LightBlockInfo(pos, state, false, null, false, true, false));
                        continue;
                    }
                    if (!(block instanceof CandleCakeBlock)) continue;
                    lightBlocks.add(new LightBlockInfo(pos, state, false, null, false, false, true));
                }
            }
        }
        return lightBlocks;
    }

    private static boolean isValidLightBlock(ServerLevel server, LightBlockInfo block) {
        BlockState current = server.m_8055_(block.pos);
        Block currentBlock = current.m_60734_();
        if (block.isCampfire) {
            return currentBlock instanceof CampfireBlock;
        }
        if (block.isWallTorch) {
            return currentBlock instanceof WallTorchBlock || currentBlock == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorchwall"));
        }
        if (block.isCandle) {
            return currentBlock instanceof CandleBlock;
        }
        if (block.isCandleCake) {
            return currentBlock instanceof CandleCakeBlock;
        }
        return currentBlock instanceof TorchBlock && !(currentBlock instanceof WallTorchBlock) || currentBlock == ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorch"));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, FlickerState>> iterator = activeFlickers.entrySet().iterator();
        Block unlitTorch = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorch"));
        Block unlitWallTorch = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("from_the_caves", "ftcunlittorchwall"));
        Block unlitCampfire = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("minecraft", "campfire"));
        if (unlitTorch == null || unlitWallTorch == null || unlitCampfire == null) {
            activeFlickers.clear();
            return;
        }
        SoundEvent fireExtinguishSound = SoundEvents.f_11937_;
        SoundEvent energySound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("from_the_caves", "energy"));
        while (iterator.hasNext()) {
            Player p;
            double pz;
            double py;
            Map.Entry<Integer, FlickerState> entry = iterator.next();
            FlickerState state = entry.getValue();
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            boolean markerNearby = CemeteryMarkerFlickerProcedure.checkForCemeteryMarker(server, state.player);
            if (!markerNearby) {
                for (LightBlockInfo block2 : state.lightBlocks) {
                    if (!CemeteryMarkerFlickerProcedure.isValidLightBlock(server, block2)) continue;
                    BlockState current = server.m_8055_(block2.pos);
                    if (block2.isCampfire) {
                        if (current.m_60734_() == unlitCampfire && current.m_61138_((Property)CampfireBlock.f_51227_) && !((Boolean)current.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                            server.m_7731_(block2.pos, (BlockState)block2.state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true)), 3);
                            double px = (double)block2.pos.m_123341_() + 0.5;
                            py = (double)block2.pos.m_123342_() + 0.5;
                            pz = (double)block2.pos.m_123343_() + 0.5;
                            p = server.m_45924_(px, py, pz, 8.0, false);
                            if (p != null) {
                                server.m_5594_(null, block2.pos, fireExtinguishSound, SoundSource.BLOCKS, 0.02f, 0.5f);
                            }
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.1, 0.1, 0.1, 0.02);
                        }
                    } else if (block2.isWallTorch) {
                        if (current.m_60734_() == unlitWallTorch) {
                            server.m_7731_(block2.pos, (BlockState)block2.state.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)block2.facing), 3);
                            double px = (double)block2.pos.m_123341_() + 0.5;
                            py = (double)block2.pos.m_123342_() + 0.7;
                            pz = (double)block2.pos.m_123343_() + 0.5;
                            p = server.m_45924_(px, py, pz, 8.0, false);
                            if (p != null) {
                                server.m_5594_(null, block2.pos, fireExtinguishSound, SoundSource.BLOCKS, 0.02f, 0.5f);
                            }
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.1, 0.1, 0.1, 0.02);
                        }
                    } else if (block2.isCandle || block2.isCandleCake) {
                        if (current.m_61138_((Property)CandleBlock.f_152791_) && !((Boolean)current.m_61143_((Property)CandleBlock.f_152791_)).booleanValue()) {
                            BlockState newState = (BlockState)current.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            server.m_7731_(block2.pos, newState, 3);
                            double px = (double)block2.pos.m_123341_() + 0.5;
                            double py2 = (double)block2.pos.m_123342_() + 0.5;
                            double pz2 = (double)block2.pos.m_123343_() + 0.5;
                            Player p2 = server.m_45924_(px, py2, pz2, 8.0, false);
                            if (p2 != null) {
                                server.m_5594_(null, block2.pos, fireExtinguishSound, SoundSource.BLOCKS, 0.02f, 0.5f);
                            }
                            server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py2, pz2, 1, 0.1, 0.1, 0.1, 0.02);
                        }
                    } else if (current.m_60734_() == unlitTorch) {
                        server.m_7731_(block2.pos, block2.state, 3);
                        double px = (double)block2.pos.m_123341_() + 0.5;
                        py = (double)block2.pos.m_123342_() + 0.7;
                        pz = (double)block2.pos.m_123343_() + 0.5;
                        p = server.m_45924_(px, py, pz, 8.0, false);
                        if (p != null) {
                            server.m_5594_(null, block2.pos, fireExtinguishSound, SoundSource.BLOCKS, 0.02f, 0.5f);
                        }
                        server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.1, 0.1, 0.1, 0.02);
                    }
                    block2.isLit = true;
                }
                iterator.remove();
                continue;
            }
            if (energySound != null && state.tickCount >= state.nextEnergySoundTick) {
                double px = state.player.m_20185_();
                double py3 = state.player.m_20186_();
                double pz3 = state.player.m_20189_();
                float randomPitch = 0.8f + server.m_213780_().m_188501_() * 0.4f;
                server.m_6263_(null, px, py3, pz3, energySound, SoundSource.AMBIENT, 0.05f, randomPitch);
                state.nextEnergySoundTick = state.tickCount + 120 + server.m_213780_().m_188503_(20);
            }
            state.lightBlocks.removeIf(block -> !CemeteryMarkerFlickerProcedure.isValidLightBlock(server, block));
            if (state.lightBlocks.isEmpty()) {
                iterator.remove();
                continue;
            }
            for (LightBlockInfo block2 : state.lightBlocks) {
                if (state.tickCount < block2.nextFlickerTick) continue;
                BlockState current = server.m_8055_(block2.pos);
                if (block2.isCampfire) {
                    if (current.m_60734_() == unlitCampfire && current.m_61138_((Property)CampfireBlock.f_51227_)) {
                        if (!block2.isLit) {
                            server.m_7731_(block2.pos, (BlockState)block2.state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true)), 3);
                            block2.isLit = true;
                        } else if (((Boolean)current.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
                            server.m_7731_(block2.pos, (BlockState)current.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 3);
                            block2.isLit = false;
                        }
                    }
                } else if (block2.isWallTorch) {
                    if (current.m_60734_() == unlitWallTorch && !block2.isLit) {
                        server.m_7731_(block2.pos, (BlockState)block2.state.m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)block2.facing), 3);
                        block2.isLit = true;
                    } else if (current.m_60734_() instanceof WallTorchBlock) {
                        server.m_7731_(block2.pos, (BlockState)unlitWallTorch.m_49966_().m_61124_((Property)WallTorchBlock.f_58119_, (Comparable)block2.facing), 3);
                        block2.isLit = false;
                    }
                } else if (block2.isCandle || block2.isCandleCake) {
                    if (current.m_61138_((Property)CandleBlock.f_152791_)) {
                        if (!((Boolean)current.m_61143_((Property)CandleBlock.f_152791_)).booleanValue() && !block2.isLit) {
                            BlockState newState = (BlockState)current.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                            server.m_7731_(block2.pos, newState, 3);
                            block2.isLit = true;
                        } else if (((Boolean)current.m_61143_((Property)CandleBlock.f_152791_)).booleanValue()) {
                            BlockState newState = (BlockState)current.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false));
                            server.m_7731_(block2.pos, newState, 3);
                            block2.isLit = false;
                        }
                    }
                } else if (current.m_60734_() == unlitTorch && !block2.isLit) {
                    server.m_7731_(block2.pos, block2.state, 3);
                    block2.isLit = true;
                } else if (current.m_60734_() instanceof TorchBlock) {
                    server.m_7731_(block2.pos, unlitTorch.m_49966_(), 3);
                    block2.isLit = false;
                }
                double px = (double)block2.pos.m_123341_() + 0.5;
                py = (double)block2.pos.m_123342_() + (block2.isCampfire || block2.isCandle || block2.isCandleCake ? 0.5 : 0.7);
                pz = (double)block2.pos.m_123343_() + 0.5;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123762_, px, py, pz, 1, 0.1, 0.1, 0.1, 0.02);
                p = server.m_45924_(px, py, pz, 8.0, false);
                if (p != null) {
                    server.m_5594_(null, block2.pos, fireExtinguishSound, SoundSource.BLOCKS, 0.02f, block2.isLit ? 0.05f : 0.1f);
                }
                block2.nextFlickerTick = state.tickCount + new Random().nextInt(31) + 25;
            }
        }
    }

    private static class FlickerState {
        Player player;
        List<LightBlockInfo> lightBlocks;
        int tickCount;
        int nextEnergySoundTick;

        FlickerState(Player player, List<LightBlockInfo> lightBlocks) {
            this.player = player;
            this.lightBlocks = lightBlocks;
            this.tickCount = 0;
            this.nextEnergySoundTick = 120;
        }
    }

    private static class LightBlockInfo {
        final BlockPos pos;
        final BlockState state;
        final boolean isWallTorch;
        final Direction facing;
        final boolean isCampfire;
        final boolean isCandle;
        final boolean isCandleCake;
        boolean isLit;
        int nextFlickerTick;

        LightBlockInfo(BlockPos pos, BlockState state, boolean isWallTorch, Direction facing, boolean isCampfire, boolean isCandle, boolean isCandleCake) {
            this.pos = pos.m_7949_();
            this.state = state;
            this.isWallTorch = isWallTorch;
            this.facing = facing;
            this.isCampfire = isCampfire;
            this.isCandle = isCandle;
            this.isCandleCake = isCandleCake;
            this.isLit = isCampfire ? (state.m_61138_((Property)CampfireBlock.f_51227_) ? (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_) : true) : (isCandle || isCandleCake ? (state.m_61138_((Property)CandleBlock.f_152791_) ? (Boolean)state.m_61143_((Property)CandleBlock.f_152791_) : true) : true);
            this.nextFlickerTick = new Random().nextInt(31) + 25;
        }
    }
}

