/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CampFireEventProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int EXTINGUISH_DURATION = 200;
    private static final int SOUL_FIRE_DURATION = 160;
    private static final Map<Integer, CampfireEventState> activeEvents = new HashMap<Integer, CampfireEventState>();
    private static final Map<BlockPos, Long> campfireCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validCampfires = CampFireEventProcedure.findValidCampfires(server, player);
        if (validCampfires.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validCampfires.removeIf(pos -> campfireCooldowns.containsKey(pos) && currentTime < campfireCooldowns.get(pos));
        if (validCampfires.isEmpty()) {
            return;
        }
        BlockPos chosen = validCampfires.get(server.m_213780_().m_188503_(validCampfires.size()));
        CampfireEvent event = CampfireEvent.values()[server.m_213780_().m_188503_(CampfireEvent.values().length)];
        campfireCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new CampfireEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, CampfireEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, CampfireEventState> entry = iterator.next();
            CampfireEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            BlockState currentState = server.m_8055_(state.campfirePos);
            if (!(currentState.m_60734_() instanceof CampfireBlock)) {
                iterator.remove();
                continue;
            }
            switch (state.event) {
                case CAMPFIRE_EXTINGUISH: {
                    CampFireEventProcedure.handleCampfireExtinguish(server, state);
                    if (state.tickCount < 200) break;
                    iterator.remove();
                    break;
                }
                case CAMPFIRE_SMOKE_PATTERNS: {
                    CampFireEventProcedure.handleSmokePatterns(server, state);
                    if (state.tickCount < 200) break;
                    iterator.remove();
                    break;
                }
                case CAMPFIRE_SOUL_FLAMES: {
                    CampFireEventProcedure.handleSoulFlames(server, state);
                    if (state.tickCount < 160) break;
                    iterator.remove();
                }
            }
        }
    }

    private static List<BlockPos> findValidCampfires(ServerLevel server, Player player) {
        ArrayList<BlockPos> campfires = new ArrayList<BlockPos>();
        int radius = 32;
        BlockPos playerPos = player.m_20183_();
        int minX = playerPos.m_123341_() - radius;
        int maxX = playerPos.m_123341_() + radius;
        int minZ = playerPos.m_123343_() - radius;
        int maxZ = playerPos.m_123343_() + radius;
        int minY = Mth.m_14045_((int)(playerPos.m_123342_() - 6), (int)0, (int)(server.m_151558_() - 1));
        int maxY = Mth.m_14045_((int)(playerPos.m_123342_() + 6), (int)0, (int)(server.m_151558_() - 1));
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof CampfireBlock) || !state.m_61138_((Property)CampfireBlock.f_51227_) || !((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) continue;
                    campfires.add(pos.m_7949_());
                }
            }
        }
        return campfires;
    }

    private static void handleCampfireExtinguish(ServerLevel server, CampfireEventState state) {
        BlockState currentState;
        BlockState campfireState = server.m_8055_(state.campfirePos);
        if (!(campfireState.m_60734_() instanceof CampfireBlock)) {
            return;
        }
        if (!campfireState.m_61138_((Property)CampfireBlock.f_51227_)) {
            return;
        }
        if (state.tickCount == 1) {
            server.m_7731_(state.campfirePos, (BlockState)campfireState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false)), 3);
            server.m_5594_(null, state.campfirePos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 1.0f);
            state.extinguished = true;
        } else if (state.tickCount == 199 && (currentState = server.m_8055_(state.campfirePos)).m_60734_() instanceof CampfireBlock && currentState.m_61138_((Property)CampfireBlock.f_51227_)) {
            server.m_7731_(state.campfirePos, (BlockState)currentState.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true)), 3);
            server.m_5594_(null, state.campfirePos, SoundEvents.f_11942_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
    }

    private static void handleSmokePatterns(ServerLevel server, CampfireEventState state) {
        double centerX = (double)state.campfirePos.m_123341_() + 0.5;
        double centerY = (double)state.campfirePos.m_123342_() + 0.5;
        double centerZ = (double)state.campfirePos.m_123343_() + 0.5;
        int patternType = state.tickCount / 40 % 3;
        switch (patternType) {
            case 0: {
                double angle = (double)state.tickCount * 0.2 % (Math.PI * 2);
                double radius = 1.0;
                double x = centerX + Math.cos(angle) * radius;
                double z = centerZ + Math.sin(angle) * radius;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, x, centerY + 1.0, z, 1, 0.0, 0.0, 0.0, 0.0);
                break;
            }
            case 1: {
                double offset = (double)(state.tickCount % 40) * 0.05;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, centerX - 1.0 + offset, centerY + 1.0, centerZ, 1, 0.0, 0.0, 0.0, 0.0);
                break;
            }
            case 2: {
                double spiralAngle = (double)state.tickCount * 0.3 % (Math.PI * 2);
                double spiralRadius = (double)(state.tickCount % 40) * 0.025;
                double spiralX = centerX + Math.cos(spiralAngle) * spiralRadius;
                double spiralZ = centerZ + Math.sin(spiralAngle) * spiralRadius;
                double spiralY = centerY + 1.0 + (double)(state.tickCount % 40) * 0.01;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123777_, spiralX, spiralY, spiralZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void handleSoulFlames(ServerLevel server, CampfireEventState state) {
        double x = (double)state.campfirePos.m_123341_() + 0.5;
        double y = (double)state.campfirePos.m_123342_() + 0.3;
        double z = (double)state.campfirePos.m_123343_() + 0.5;
        if (!state.soulFireActive) {
            state.soulFireActive = true;
            server.m_5594_(null, state.campfirePos, SoundEvents.f_12404_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        for (int i = 0; i < 3; ++i) {
            double offsetX = (server.m_213780_().m_188500_() - 0.5) * 0.5;
            double offsetZ = (server.m_213780_().m_188500_() - 0.5) * 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123745_, x + offsetX, y, z + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (state.tickCount == 159) {
            server.m_5594_(null, state.campfirePos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.3f, 1.5f);
        }
    }

    private static enum CampfireEvent {
        CAMPFIRE_EXTINGUISH,
        CAMPFIRE_SMOKE_PATTERNS,
        CAMPFIRE_SOUL_FLAMES;

    }

    private static class CampfireEventState {
        CampfireEvent event;
        Player player;
        BlockPos campfirePos;
        int tickCount;
        boolean extinguished;
        boolean soulFireActive;

        CampfireEventState(CampfireEvent event, Player player, BlockPos campfirePos) {
            this.event = event;
            this.player = player;
            this.campfirePos = campfirePos;
            this.tickCount = 0;
            this.extinguished = false;
            this.soulFireActive = false;
        }
    }
}

