/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.procedures.NoAfectarSaltoProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JumpWhenNoPathProcedure {
    private static final double MAX_CHECK_DIST = 64.0;
    private static final double MIN_DIST_TO_JUMP = 4.0;
    private static final int STUCK_TICKS_THRESHOLD = 8;
    private static final double MIN_JUMP_Y = 0.4;
    private static final double MAX_JUMP_Y = 5.0;
    private static final double MIN_JUMP_HORIZ = 0.2;
    private static final double MAX_JUMP_HORIZ = 5.0;
    private static final String KEY_STUCK_TICKS = "ftc_noPathTicks";
    private static final String KEY_JUMP_COOLDOWN = "ftc_jumpCooldown";
    private static final int JUMP_COOLDOWN_TICKS = 40;
    private static final double GRAVITY = 0.08;
    private static final double AIR_RESISTANCE = 0.98;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent ev) {
        boolean hasPath;
        int cooldown;
        double dz;
        double dy;
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel server = (ServerLevel)mob.m_9236_();
        ResourceLocation rl = BuiltInRegistries.f_256780_.m_7981_((Object)mob.m_6095_());
        if (rl == null) {
            return;
        }
        if (!"from_the_caves".equals(rl.m_135827_())) {
            return;
        }
        Player target = server.m_45930_((Entity)mob, 64.0);
        if (target == null) {
            mob.getPersistentData().m_128473_(KEY_STUCK_TICKS);
            return;
        }
        if (NoAfectarSaltoProcedure.deberiaSaltear((Entity)mob)) {
            return;
        }
        double dx = target.m_20185_() - mob.m_20185_();
        double distSq = dx * dx + (dy = target.m_20186_() - mob.m_20186_()) * dy + (dz = target.m_20189_() - mob.m_20189_()) * dz;
        if (distSq <= 16.0) {
            mob.getPersistentData().m_128473_(KEY_STUCK_TICKS);
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (data.m_128441_(KEY_JUMP_COOLDOWN) && (cooldown = data.m_128451_(KEY_JUMP_COOLDOWN)) > 0) {
            data.m_128405_(KEY_JUMP_COOLDOWN, --cooldown);
            if (cooldown <= 0) {
                data.m_128473_(KEY_JUMP_COOLDOWN);
            }
            return;
        }
        PathNavigation nav = mob.m_21573_();
        boolean bl = hasPath = !nav.m_26571_();
        if (hasPath) {
            mob.getPersistentData().m_128473_(KEY_STUCK_TICKS);
            return;
        }
        double motionSpeedSq = mob.m_20184_().f_82479_ * mob.m_20184_().f_82479_ + mob.m_20184_().f_82481_ * mob.m_20184_().f_82481_;
        if (motionSpeedSq > 1.0E-4) {
            mob.getPersistentData().m_128473_(KEY_STUCK_TICKS);
            return;
        }
        int stuck = data.m_128441_(KEY_STUCK_TICKS) ? data.m_128451_(KEY_STUCK_TICKS) : 0;
        data.m_128405_(KEY_STUCK_TICKS, ++stuck);
        if (stuck >= 8) {
            double len;
            double dist = Math.sqrt(distSq);
            double factor = (dist - 4.0) / 60.0;
            factor = Math.max(0.0, Math.min(1.0, factor));
            double jumpY = 0.4 + factor * 4.6;
            double jumpHoriz = 0.2 + factor * 4.8;
            if (dy > 0.0) {
                double requiredVy = Math.sqrt(0.16 * dy);
                double tEst = requiredVy / 0.08;
                double dragAdj = 1.0 / Math.pow(0.98, tEst);
                jumpY = Math.max(jumpY, requiredVy *= dragAdj * 1.1);
            }
            double nx = (len = Math.sqrt(dx * dx + dy * dy + dz * dz)) > 1.0E-6 ? dx / len : 0.0;
            double ny = len > 1.0E-6 ? dy / len : 0.0;
            double nz = len > 1.0E-6 ? dz / len : 0.0;
            mob.m_20242_(false);
            mob.m_21557_(true);
            double horizDist = Math.sqrt(dx * dx + dz * dz);
            double horizVelNeeded = horizDist / (jumpY / 0.08);
            horizVelNeeded /= 1.0 - Math.pow(0.98, horizVelNeeded);
            double newVelX = nx * Math.min(horizVelNeeded, jumpHoriz);
            double newVelZ = nz * Math.min(horizVelNeeded, jumpHoriz);
            double newVelY = Math.max(mob.m_20184_().f_82480_, 0.0) + (ny * jumpHoriz + jumpY);
            mob.m_20334_(newVelX, newVelY, newVelZ);
            try {
                mob.m_6478_(MoverType.SELF, mob.m_20184_());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            data.m_128473_(KEY_STUCK_TICKS);
            data.m_128405_(KEY_JUMP_COOLDOWN, 40);
            data.m_128405_("ftc_reenableAiNextTick", 1);
        }
        if (data.m_128441_("ftc_reenableAiNextTick")) {
            int v = data.m_128451_("ftc_reenableAiNextTick");
            if (v > 0) {
                data.m_128405_("ftc_reenableAiNextTick", --v);
                if (v <= 0) {
                    data.m_128473_("ftc_reenableAiNextTick");
                    mob.m_21557_(false);
                }
            } else {
                data.m_128473_("ftc_reenableAiNextTick");
                mob.m_21557_(false);
            }
        }
    }
}

