/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.init.FromTheCavesModItems;
import net.mcreator.fromthecaves.procedures.CrossUseCounterProcedure;
import net.mcreator.fromthecaves.procedures.Phase2PossessionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PossessedMobExorcismProcedure {
    private static final double EXORCISM_CHANCE = 0.15;
    private static final double IRON_CROSS_CHANCE = 0.5;
    private static final int CROSS_DAMAGE = 5;
    private static final Set<UUID> EXORCISM_IN_PROGRESS = ConcurrentHashMap.newKeySet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract ev) {
        if (ev.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (ev.getLevel().m_5776_()) {
            return;
        }
        Player entity = ev.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity player = (LivingEntity)entity;
        Entity target = ev.getTarget();
        if (!(target instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)target;
        if (!PossessedMobExorcismProcedure.isPossessedMob(mob.m_6095_())) {
            return;
        }
        UUID mobId = mob.m_20148_();
        if (!EXORCISM_IN_PROGRESS.add(mobId)) {
            return;
        }
        try {
            ServerLevel serverLevel;
            Mob vanillaMob;
            ItemStack mainStack = player.m_21205_();
            if (mainStack.m_41720_() != FromTheCavesModItems.WOODEN_CROSS.get() && mainStack.m_41720_() != FromTheCavesModItems.IRON_CROSS.get()) {
                return;
            }
            Level level = ev.getLevel();
            if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) != 2) {
                return;
            }
            double exorcismChance = 0.15;
            if (mainStack.m_41720_() == FromTheCavesModItems.IRON_CROSS.get() || player.m_21206_().m_41720_() == FromTheCavesModItems.IRON_CROSS.get()) {
                exorcismChance = 0.5;
            }
            if (level.f_46441_.m_188500_() >= exorcismChance) {
                return;
            }
            EntityType<?> vanillaType = PossessedMobExorcismProcedure.getVanillaType(mob.m_6095_());
            if (vanillaType == null) {
                return;
            }
            BlockPos pos = mob.m_20183_();
            float yaw = mob.m_146908_();
            float pitch = mob.m_146909_();
            if (!PossessedMobExorcismProcedure.removeFromPossessionTracking(mobId)) {
                return;
            }
            CompoundTag savedNbt = PossessedMobExorcismProcedure.saveBasicNbt(mob);
            mob.m_146870_();
            if (level instanceof ServerLevel && (vanillaMob = (Mob)vanillaType.m_20615_((Level)(serverLevel = (ServerLevel)level))) != null) {
                PossessedMobExorcismProcedure.loadBasicNbt(vanillaMob, savedNbt);
                vanillaMob.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, yaw, pitch);
                serverLevel.m_7967_((Entity)vanillaMob);
                PossessedMobExorcismProcedure.spawnExorcismEffects(serverLevel, pos);
                mainStack.m_41622_(5, player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                CrossUseCounterProcedure.incrementExorcismCounter(player, level);
            }
        }
        finally {
            EXORCISM_IN_PROGRESS.remove(mobId);
        }
    }

    private static boolean isPossessedMob(EntityType<?> type) {
        return type == FromTheCavesModEntities.POSSESSED_V.get() || type == FromTheCavesModEntities.POSSESSED_P.get() || type == FromTheCavesModEntities.POSSESSED_C.get() || type == FromTheCavesModEntities.POSSESSED_CKN.get() || type == FromTheCavesModEntities.POSSESSED_S.get() || type == FromTheCavesModEntities.POSSESSED_SURVIVOR.get() || type == FromTheCavesModEntities.POSSESSED_W.get() || type == FromTheCavesModEntities.POSSESSED_IG.get() || type == FromTheCavesModEntities.POSSESSED_Z.get() || type == FromTheCavesModEntities.POSSESSED_SK.get() || type == FromTheCavesModEntities.POSSESSED_SP.get() || type == FromTheCavesModEntities.POSSESSED_CRP.get() || type == FromTheCavesModEntities.POSSESSED_END.get() || type == FromTheCavesModEntities.POSSESSED_RAVAGER.get();
    }

    private static EntityType<?> getVanillaType(EntityType<?> possessedType) {
        if (possessedType == FromTheCavesModEntities.POSSESSED_V.get()) {
            return EntityType.f_20492_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_P.get()) {
            return EntityType.f_20510_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_C.get()) {
            return EntityType.f_20557_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_CKN.get()) {
            return EntityType.f_20555_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_S.get()) {
            return EntityType.f_20520_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_SURVIVOR.get()) {
            return EntityType.f_20494_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_W.get()) {
            return EntityType.f_20499_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_IG.get()) {
            return EntityType.f_20460_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_Z.get()) {
            return EntityType.f_20501_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_SK.get()) {
            return EntityType.f_20524_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_SP.get()) {
            return EntityType.f_20479_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_CRP.get()) {
            return EntityType.f_20558_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_END.get()) {
            return EntityType.f_20566_;
        }
        if (possessedType == FromTheCavesModEntities.POSSESSED_RAVAGER.get()) {
            return EntityType.f_20518_;
        }
        return null;
    }

    private static CompoundTag saveBasicNbt(Mob mob) {
        CompoundTag nbt = new CompoundTag();
        if (mob.m_21223_() < mob.m_21233_()) {
            nbt.m_128350_("Health", mob.m_21223_());
        }
        if (mob.m_8077_()) {
            nbt.m_128359_("CustomName", mob.m_7770_().getString());
        }
        if (mob instanceof Animal) {
            nbt.m_128405_("Age", ((Animal)mob).m_146764_());
        }
        return nbt;
    }

    private static void loadBasicNbt(Mob mob, CompoundTag nbt) {
        if (nbt.m_128441_("Health")) {
            mob.m_21153_(nbt.m_128457_("Health"));
        }
        if (nbt.m_128441_("CustomName")) {
            mob.m_6593_((Component)Component.m_237113_((String)nbt.m_128461_("CustomName")));
        }
        if (mob instanceof Animal && nbt.m_128441_("Age")) {
            ((Animal)mob).m_146762_(nbt.m_128451_("Age"));
        }
    }

    private static void spawnExorcismEffects(ServerLevel level, BlockPos pos) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 20, 0.3, 0.3, 0.3, 0.05);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 12, 0.2, 0.5, 0.2, 0.08);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 30, 0.5, 0.5, 0.5, 1.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123747_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 2, 0.0, 0.0, 0.0, 0.0);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.2, (double)pos.m_123343_() + 0.5, 8, 0.3, 0.1, 0.3, 0.02);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12563_, SoundSource.HOSTILE, 1.0f, 1.0f);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12404_, SoundSource.HOSTILE, 0.9f, 1.3f);
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 0.7f, 0.8f);
    }

    private static boolean removeFromPossessionTracking(UUID mobId) {
        try {
            Field savedField = Phase2PossessionProcedure.class.getDeclaredField("SAVED");
            savedField.setAccessible(true);
            Map savedMap = (Map)savedField.get(null);
            boolean wasRemoved = savedMap.remove(mobId) != null;
            return wasRemoved;
        }
        catch (Exception e) {
            return false;
        }
    }
}

