/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSTEPSEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModBlocks;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StepsAmbushProcedure {
    private static final double BASE_PROB = 3.0E-5;
    private static final double MAX_PROB = 4.5E-5;
    private static final double MIN_SPAWN_DIST = 6.0;
    private static final double MAX_SPAWN_DIST = 10.0;
    private static final int MAX_PLAYER_Y = 55;
    private static final double MIN_SPEED = 0.48;
    private static final double MAX_SPEED = 0.48;
    private static final long STEP_INTERVAL = 35L;
    private static final double DESPAWN_RANGE = 2.0;
    private static final double BEHIND_DISTANCE = 3.0;
    private static final Map<UUID, FROMTHECAVESSTEPSEntity> activeMobs = new HashMap<UUID, FROMTHECAVESSTEPSEntity>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = event.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        ServerLevel world = (ServerLevel)player2.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)world);
        if (phase != 1 && phase != 2) {
            return;
        }
        if (player2.m_20186_() > 55.0) {
            return;
        }
        UUID uid = player2.m_20148_();
        if (activeMobs.containsKey(uid)) {
            return;
        }
        double dynProb = ChunkTensionProcedure.getDynamicProbability(world, (Player)player2, 3.0E-5, 4.5E-5);
        if (world.f_46441_.m_188500_() >= dynProb) {
            return;
        }
        double angle = world.f_46441_.m_188500_() * Math.PI * 2.0;
        double dist = 6.0 + world.f_46441_.m_188500_() * 4.0;
        int dx = Mth.m_14107_((double)(Math.cos(angle) * dist));
        int dz = Mth.m_14107_((double)(Math.sin(angle) * dist));
        BlockPos spawnPos = player2.m_20183_().m_7918_(dx, 0, dz);
        FROMTHECAVESSTEPSEntity mob = (FROMTHECAVESSTEPSEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSTEPS.get()).m_20615_((Level)world);
        if (mob == null) {
            return;
        }
        mob.m_6842_(true);
        double speed = 0.48;
        CompoundTag data = mob.getPersistentData();
        data.m_128347_("FTC_Steps_Speed", speed);
        data.m_128356_("FTC_LastStepTick", world.m_46467_());
        data.m_128362_("FTC_Target", uid);
        mob.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_(), (double)spawnPos.m_123343_() + 0.5, world.f_46441_.m_188501_() * 360.0f, 0.0f);
        world.m_7967_((Entity)mob);
        activeMobs.put(uid, mob);
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent event) {
        PathNavigation nav;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof FROMTHECAVESSTEPSEntity)) {
            return;
        }
        FROMTHECAVESSTEPSEntity mob = (FROMTHECAVESSTEPSEntity)livingEntity;
        Level lvl = mob.m_9236_();
        if (lvl.m_5776_()) {
            return;
        }
        if (!(lvl instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)lvl;
        CompoundTag data = mob.getPersistentData();
        if (!data.m_128403_("FTC_Target")) {
            StepsAmbushProcedure.removeFromActive(mob);
            return;
        }
        Player target = world.m_46003_(data.m_128342_("FTC_Target"));
        if (!(target instanceof ServerPlayer)) {
            mob.m_146870_();
            activeMobs.remove(data.m_128342_("FTC_Target"));
            return;
        }
        ServerPlayer player = (ServerPlayer)target;
        mob.m_21557_(false);
        double dxLook = player.m_20185_() - mob.m_20185_();
        double dzLook = player.m_20189_() - mob.m_20189_();
        float yaw = (float)(Math.atan2(dzLook, dxLook) * 180.0 / Math.PI) - 90.0f;
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_21563_().m_24960_((Entity)player, 10.0f, 10.0f);
        Vec3 lookVec = player.m_20154_().m_82541_();
        Vec3 desired = player.m_20182_().m_82546_(lookVec.m_82490_(3.0));
        double desiredX = desired.f_82479_;
        double desiredY = desired.f_82480_;
        double desiredZ = desired.f_82481_;
        double speed = data.m_128459_("FTC_Steps_Speed");
        if (Double.isNaN(speed) || speed < 0.48) {
            speed = 0.48;
        }
        if ((nav = mob.m_21573_()) != null) {
            nav.m_26519_(desiredX, desiredY, desiredZ, speed);
        } else {
            double dz;
            double dx = desiredX - mob.m_20185_();
            double len = Math.hypot(dx, dz = desiredZ - mob.m_20189_());
            if (len > 1.0E-6) {
                double vx = dx / len * speed;
                double vz = dz / len * speed;
                mob.m_20334_(vx, mob.m_20184_().f_82480_, vz);
                mob.m_6478_(MoverType.SELF, mob.m_20184_());
            }
        }
        long now = world.m_46467_();
        long lastStep = data.m_128454_("FTC_LastStepTick");
        if (now >= lastStep + 35L) {
            data.m_128356_("FTC_LastStepTick", now);
            BlockPos under = mob.m_20183_();
            BlockState underState = world.m_8055_(under);
            if (!ProtectedBlocksProcedure.isProtected(underState) && underState.m_60734_() != FromTheCavesModBlocks.STEP.get()) {
                world.m_46597_(under, ((Block)FromTheCavesModBlocks.STEP.get()).m_49966_());
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                for (int i = 1; i <= 2; ++i) {
                    BlockState st;
                    BlockPos pos = under.m_5484_(dir, i);
                    if (!world.m_46749_(pos) || (st = world.m_8055_(pos)).m_60795_() || ProtectedBlocksProcedure.isProtected(st) || st.m_60734_() == FromTheCavesModBlocks.STEP.get()) continue;
                    RestoreBrokenBlocksManagerProcedure.destroyAndRecord(world, pos, false);
                }
            }
            SoundType soundType = underState.getSoundType((LevelReader)world, under, (Entity)mob);
            SoundEvent stepSound = soundType.m_56776_();
            float volume = soundType.m_56773_();
            float pitch = soundType.m_56774_();
            world.m_5594_(null, under, stepSound, SoundSource.BLOCKS, volume, pitch);
        }
        if ((double)mob.m_20270_((Entity)player) <= 2.0) {
            mob.m_146870_();
            StepsAmbushProcedure.removeFromActive(mob);
        }
        if (mob.m_213877_()) {
            StepsAmbushProcedure.removeFromActive(mob);
        }
    }

    private static void removeFromActive(FROMTHECAVESSTEPSEntity mob) {
        CompoundTag data = mob.getPersistentData();
        if (data != null && data.m_128403_("FTC_Target")) {
            UUID u = data.m_128342_("FTC_Target");
            FROMTHECAVESSTEPSEntity cur = activeMobs.get(u);
            if (cur != null && cur.m_20148_().equals(mob.m_20148_())) {
                activeMobs.remove(u);
            }
        } else {
            activeMobs.values().removeIf(e -> e == mob);
        }
    }
}

