/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AngerSystemProcedure {
    private static final double CROSS_USE_ANGER = 0.1;
    private static final double WOLF_KILL_ANGER = 0.5;
    private static final double VILLAGER_KILL_ANGER = 0.5;
    private static final double EXORCISM_ANGER = 2.0;
    private static final double ENCLOSED_ANGER_PER_INTERVAL = 3.0;
    private static final double BELOW_Y45_ANGER_PER_INTERVAL = 8.0;
    private static final int ENCLOSED_Y_THRESHOLD = 50;
    private static final int ENCLOSED_CHECK_TICKS = 2400;
    private static final int BELOW_Y45_CHECK_TICKS = 18000;
    private static final int DEBUG_UPDATE_TICKS = 20;
    private static final double ANGER_THRESHOLD_PHASE2 = 35.0;

    private static AngerSavedData getAngerData(ServerLevel level) {
        DimensionDataStorage storage = level.m_7654_().m_129783_().m_8895_();
        return (AngerSavedData)storage.m_164861_(AngerSavedData::load, AngerSavedData::new, "fromthecaves_anger_data");
    }

    public static double getAngerLevel(ServerLevel level) {
        return AngerSystemProcedure.getAngerData(level).getAngerLevel();
    }

    public static void addAnger(ServerLevel level, double amount) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level) < 1) {
            return;
        }
        AngerSavedData data = AngerSystemProcedure.getAngerData(level);
        double previousAnger = data.getAngerLevel();
        data.addAnger(amount);
        double currentAnger = data.getAngerLevel();
        if (previousAnger < 35.0 && currentAnger >= 35.0) {
            PhaseManagerProcedure.setManualPhase((LevelAccessor)level, 2);
        }
    }

    public static void setAngerLevel(ServerLevel level, double amount) {
        AngerSystemProcedure.getAngerData(level).setAngerLevel(amount);
    }

    public static void resetAnger(ServerLevel level) {
        AngerSystemProcedure.getAngerData(level).resetAnger();
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().m_129892_().m_82094_();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fromthecaves").then(Commands.m_82127_((String)"angerDebug").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_230896_();
            if (player == null) {
                source.m_81352_((Component)Component.m_237113_((String)"This command can only be executed by a player."));
                return 0;
            }
            boolean current = player.getPersistentData().m_128471_("debugAnger");
            boolean newState = !current;
            player.getPersistentData().m_128379_("debugAnger", newState);
            source.m_288197_(() -> Component.m_237113_((String)("Anger Debug mode " + (newState ? "enabled" : "disabled"))), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"resetAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                AngerSystemProcedure.resetAnger(server);
                source.m_288197_(() -> Component.m_237113_((String)"Anger level has been reset to 0"), true);
                return 1;
            }
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"getAnger").requires(source -> source.m_6761_(2))).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerLevel level = source.m_81372_();
            if (level instanceof ServerLevel) {
                ServerLevel server = level;
                double anger = AngerSystemProcedure.getAngerLevel(server);
                source.m_288197_(() -> Component.m_237113_((String)("Current Anger Level: " + String.format("%.2f", anger))), false);
                return 1;
            }
            return 0;
        })));
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity sourceEntity = event.getSource().m_7639_();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        LivingEntity deadEntity = event.getEntity();
        Level level = deadEntity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        EntityType type = deadEntity.m_6095_();
        if (type == EntityType.f_20499_) {
            AngerSystemProcedure.addAnger(server, 0.5);
            AngerSystemProcedure.sendAngerNotification(server, "Wolf killed", 0.5);
        } else if (type == EntityType.f_20492_) {
            AngerSystemProcedure.addAnger(server, 0.5);
            AngerSystemProcedure.sendAngerNotification(server, "Villager killed", 0.5);
        }
    }

    public static void onCrossUsed(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 0.1);
        AngerSystemProcedure.sendAngerNotification(server, "Cross used", 0.1);
    }

    public static void onExorcism(ServerLevel server) {
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        AngerSystemProcedure.addAnger(server, 2.0);
        AngerSystemProcedure.sendAngerNotification(server, "Exorcism performed", 2.0);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server) < 1) {
            return;
        }
        CompoundTag nbt = player.getPersistentData();
        BlockPos playerPos = player.m_20183_();
        boolean isEnclosed = false;
        if (playerPos.m_123342_() < 50) {
            isEnclosed = AngerSystemProcedure.isPlayerInTunnel(server, playerPos);
        }
        int enclosedTicks = nbt.m_128451_("ftc_enclosedTicks");
        if (isEnclosed) {
            nbt.m_128405_("ftc_enclosedTicks", ++enclosedTicks);
            if (enclosedTicks >= 2400) {
                AngerSystemProcedure.addAnger(server, 3.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player enclosed", 3.0);
                nbt.m_128405_("ftc_enclosedTicks", 0);
            }
        } else if (enclosedTicks > 0) {
            nbt.m_128405_("ftc_enclosedTicks", 0);
        }
        boolean isBelowY45 = playerPos.m_123342_() < 45;
        int belowY45Ticks = nbt.m_128451_("ftc_belowY45Ticks");
        if (isBelowY45) {
            nbt.m_128405_("ftc_belowY45Ticks", ++belowY45Ticks);
            if (belowY45Ticks >= 18000) {
                AngerSystemProcedure.addAnger(server, 8.0);
                AngerSystemProcedure.sendAngerNotification(server, "Player below Y45", 8.0);
                nbt.m_128405_("ftc_belowY45Ticks", 0);
            }
        } else if (belowY45Ticks > 0) {
            nbt.m_128405_("ftc_belowY45Ticks", 0);
        }
        if (player.f_19797_ % 20 == 0 && nbt.m_128471_("debugAnger")) {
            AngerSystemProcedure.sendDebugInfo(server, player, isEnclosed, isBelowY45, enclosedTicks, belowY45Ticks);
        }
    }

    private static boolean isPlayerInTunnel(ServerLevel level, BlockPos playerPos) {
        BlockState state;
        int dz;
        int dy;
        int dx;
        int airBlocksFound = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (dx = -1; dx <= 1; ++dx) {
            for (dy = 0; dy <= 2; ++dy) {
                for (dz = -1; dz <= 1; ++dz) {
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    state = level.m_8055_((BlockPos)mutable);
                    if (!state.m_280296_() && !state.m_60795_() && state.m_60791_() == 0) {
                        return false;
                    }
                    if (!state.m_60795_() && state.m_280296_()) continue;
                    ++airBlocksFound;
                }
            }
        }
        if (airBlocksFound > 27) {
            return false;
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dy = -1; dy <= 3; ++dy) {
                for (dz = -2; dz <= 2; ++dz) {
                    if (dx >= -1 && dx <= 1 && dy >= 0 && dy <= 2 && dz >= -1 && dz <= 1) continue;
                    mutable.m_122178_(playerPos.m_123341_() + dx, playerPos.m_123342_() + dy, playerPos.m_123343_() + dz);
                    state = level.m_8055_((BlockPos)mutable);
                    if (state.m_60795_() || state.m_60791_() > 0 || !state.m_280296_() && !state.m_60815_() || state.m_280296_()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void sendAngerNotification(ServerLevel server, String cause, double amount) {
        for (ServerPlayer player : server.m_6907_()) {
            if (!player.getPersistentData().m_128471_("debugAnger")) continue;
            player.m_213846_((Component)Component.m_237113_((String)("\u00a7c[ANGER] " + cause + ": +" + String.format("%.2f", amount))));
        }
    }

    private static void sendDebugInfo(ServerLevel server, Player player, boolean enclosed, boolean belowY45, int enclosedTicks, int belowY45Ticks) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        double angerLevel = AngerSystemProcedure.getAngerLevel(server);
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        double enclosedProgress = (double)enclosedTicks / 2400.0 * 100.0;
        double belowY45Progress = (double)belowY45Ticks / 18000.0 * 100.0;
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(0, 40, 0));
        sp.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)Component.m_237113_((String)("\u00a7cANGER: " + String.format("%.2f", angerLevel) + " / 35.0"))));
        String subtitle = "Phase: " + phase + " | Enclosed: " + (enclosed ? "YES" : "NO") + " | Below Y45: " + (belowY45 ? "YES" : "NO");
        sp.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)Component.m_237113_((String)subtitle)));
        String actionBar = "Enclosed: " + String.format("%.1f", enclosedProgress) + "% | Below Y45: " + String.format("%.1f", belowY45Progress) + "%";
        sp.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)actionBar)));
    }

    public static class AngerSavedData
    extends SavedData {
        public static final String NAME = "fromthecaves_anger_data";
        private double angerLevel = 0.0;

        public static AngerSavedData load(CompoundTag tag) {
            AngerSavedData data = new AngerSavedData();
            data.angerLevel = tag.m_128459_("angerLevel");
            return data;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            tag.m_128347_("angerLevel", this.angerLevel);
            return tag;
        }

        public double getAngerLevel() {
            return this.angerLevel;
        }

        public void addAnger(double amount) {
            this.angerLevel += amount;
            this.m_77762_();
        }

        public void setAngerLevel(double level) {
            this.angerLevel = level;
            this.m_77762_();
        }

        public void resetAnger() {
            this.angerLevel = 0.0;
            this.m_77762_();
        }
    }
}

