/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.mcreator.fromthecaves.SessionVariables;
import net.mcreator.fromthecaves.entity.FROMTHECAVESROOFEntity;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSIGNEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SpawnSignEventProcedure {
    private static final double BASE_PROB = 7.0E-6;
    private static final double MAX_PROB = 8.5E-6;
    private static final int MIN_DIST = 10;
    private static final int MAX_DIST = 20;
    private static final int SIGN_LIFETIME_TICKS = 6000;
    private static final int MAX_ACTIVE_SIGNS = 15;
    private static final String[] MESSAGES = new String[]{"Here I am", "Behind", "Wait Here", "Don't move", "It's listening", "Below the floor", "We are close", "They come at night", "You are never alone", "Shut your eyes", "So cold below", "Come lower", "It waits", "Watch the ground", "Below You", "Count to Ten", "Look Up", "Don't Turn Around", "Lights Out", "Listen Carefully", "Silence", "Do You Hear It?"};
    private static final Map<BlockPos, SignData> activeSigns = new ConcurrentHashMap<BlockPos, SignData>();
    private static final List<PendingSpawn> pendingSpawns = Collections.synchronizedList(new ArrayList());
    private static final List<PendingBreak> pendingBreaks = Collections.synchronizedList(new ArrayList());
    private static final Map<UUID, Pending360> pending360 = new ConcurrentHashMap<UUID, Pending360>();
    private static final Map<UUID, CountdownEvent> countdownEvents = new ConcurrentHashMap<UUID, CountdownEvent>();
    private static final Map<UUID, FreezeEvent> freezeEvents = new ConcurrentHashMap<UUID, FreezeEvent>();
    private static final Map<UUID, LightsOutEvent> lightsOutEvents = new ConcurrentHashMap<UUID, LightsOutEvent>();
    private static final Map<UUID, ListenEvent> listenEvents = new ConcurrentHashMap<UUID, ListenEvent>();
    private static final Map<UUID, SilenceEvent> silenceEvents = new ConcurrentHashMap<UUID, SilenceEvent>();
    private static final Map<UUID, WhisperEvent> whisperEvents = new ConcurrentHashMap<UUID, WhisperEvent>();
    private static final Map<UUID, MotionEvent> motionEvents = new ConcurrentHashMap<UUID, MotionEvent>();
    private static final Map<UUID, WatchingEvent> watchingEvents = new ConcurrentHashMap<UUID, WatchingEvent>();
    private static final Map<UUID, MirrorEvent> mirrorEvents = new ConcurrentHashMap<UUID, MirrorEvent>();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player p = ev.player;
        if (p == null || p.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)p.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel) != 2) {
            return;
        }
        if (!serverLevel.m_6042_().f_63858_()) {
            return;
        }
        long now = serverLevel.m_46467_();
        RandomSource rand = serverLevel.m_213780_();
        SpawnSignEventProcedure.cleanupExpiredSigns(serverLevel, now);
        if (activeSigns.size() < 15) {
            double dynamicProb = ChunkTensionProcedure.getDynamicProbability(serverLevel, p, 7.0E-6, 8.5E-6);
            if (rand.m_188500_() < dynamicProb) {
                SpawnSignEventProcedure.spawnNewSign(serverLevel, p, rand, now);
            }
        }
        SpawnSignEventProcedure.processPendingSpawns(serverLevel, now);
        SpawnSignEventProcedure.processPendingBreaks(serverLevel, now);
        SpawnSignEventProcedure.processPending360(serverLevel, now);
        SpawnSignEventProcedure.processCountdownEvents(serverLevel, now);
        SpawnSignEventProcedure.processFreezeEvents(serverLevel, now);
        SpawnSignEventProcedure.processLightsOutEvents(serverLevel, now);
        SpawnSignEventProcedure.processListenEvents(serverLevel, now);
        SpawnSignEventProcedure.processSilenceEvents(serverLevel, now);
        SpawnSignEventProcedure.processWhisperEvents(serverLevel, now);
        SpawnSignEventProcedure.processWatchingEvents(serverLevel, now);
        SpawnSignEventProcedure.processMirrorEvents(serverLevel, now);
    }

    private static void cleanupExpiredSigns(ServerLevel level, long now) {
        activeSigns.entrySet().removeIf(entry -> {
            if (now - ((SignData)entry.getValue()).spawnTick > 6000L) {
                level.m_7471_((BlockPos)entry.getKey(), false);
                return true;
            }
            return false;
        });
    }

    private static void spawnNewSign(ServerLevel level, Player player, RandomSource rand, long now) {
        double angle = rand.m_188500_() * Math.PI * 2.0;
        double dist = 10.0 + rand.m_188500_() * 10.0;
        int dx = (int)Math.round(Math.cos(angle) * dist);
        int dz = (int)Math.round(Math.sin(angle) * dist);
        BlockPos base = player.m_20183_().m_7918_(dx, 0, dz);
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, base.m_123341_(), base.m_123343_());
        BlockPos signPos = new BlockPos(base.m_123341_(), y, base.m_123343_());
        if (!level.m_46749_(signPos)) {
            return;
        }
        if (!level.m_8055_(signPos).m_60795_()) {
            return;
        }
        if (!level.m_8055_(signPos.m_7495_()).m_280296_()) {
            return;
        }
        level.m_46597_(signPos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(rand.m_188503_(16))));
        BlockEntity be = level.m_7702_(signPos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            String chosen = MESSAGES[rand.m_188503_(MESSAGES.length)];
            String[] lines = SpawnSignEventProcedure.splitMessage(chosen);
            SpawnSignEventProcedure.writeSignText(sign, lines, level, signPos);
        }
        activeSigns.put(signPos, new SignData(now));
    }

    @SubscribeEvent
    public static void onPlayerInFrontOfSign(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player == null || player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)player.m_9236_();
        if (PhaseManagerProcedure.getCurrentPhase((LevelAccessor)serverLevel) != 2) {
            return;
        }
        long now = serverLevel.m_46467_();
        RandomSource rand = serverLevel.m_213780_();
        for (Map.Entry<BlockPos, SignData> entry : activeSigns.entrySet()) {
            SignBlockEntity sign;
            BlockEntity be;
            double distSq;
            BlockPos signPos = entry.getKey();
            SignData data = entry.getValue();
            if (data.triggered || (distSq = player.m_20275_((double)signPos.m_123341_() + 0.5, (double)signPos.m_123342_(), (double)signPos.m_123343_() + 0.5)) > 9.0 || !((be = serverLevel.m_7702_(signPos)) instanceof SignBlockEntity) || !SpawnSignEventProcedure.isPlayerInFrontOfSign(player, signPos, sign = (SignBlockEntity)be) || !(rand.m_188500_() < 0.5)) continue;
            SpawnSignEventProcedure.triggerSignEvent(serverLevel, player, signPos, rand, now);
            data.triggered = true;
        }
    }

    private static boolean isPlayerInFrontOfSign(Player player, BlockPos signPos, SignBlockEntity sign) {
        try {
            int rot = (Integer)sign.m_58900_().m_61143_((Property)StandingSignBlock.f_56987_);
            double yaw = (double)rot * 22.5;
            Vec3 frontDir = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
            double dx = player.m_20185_() - ((double)signPos.m_123341_() + 0.5);
            double dz = player.m_20189_() - ((double)signPos.m_123343_() + 0.5);
            Vec3 toPlayer = new Vec3(dx, 0.0, dz);
            if (toPlayer.m_82556_() < 1.0E-6) {
                return false;
            }
            return frontDir.m_82526_(toPlayer = toPlayer.m_82541_()) > 0.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void triggerSignEvent(ServerLevel level, Player player, BlockPos signPos, RandomSource rand, long now) {
        int event = rand.m_188503_(16) + 1;
        switch (event) {
            case 1: {
                pendingSpawns.add(new PendingSpawn(signPos, player.m_20148_(), now));
                break;
            }
            case 2: {
                pending360.putIfAbsent(player.m_20148_(), new Pending360(player.m_20148_(), signPos, now, player.m_146908_()));
                break;
            }
            case 3: {
                pendingBreaks.add(new PendingBreak(signPos, now + 40L));
                break;
            }
            case 4: {
                SpawnSignEventProcedure.playCaveSound(level, signPos);
                break;
            }
            case 5: {
                SpawnSignEventProcedure.handleBelowYouEvent(level, player, signPos, now);
                break;
            }
            case 6: {
                SpawnSignEventProcedure.handleCountdownEvent(level, player, now);
                break;
            }
            case 7: {
                SpawnSignEventProcedure.handleLookUpEvent(level, player, now);
                break;
            }
            case 8: {
                SpawnSignEventProcedure.handleFreezeEvent(level, player, now);
                break;
            }
            case 9: {
                SpawnSignEventProcedure.handleLightsOutEvent(level, player, now);
                break;
            }
            case 10: {
                SpawnSignEventProcedure.handleListenEvent(level, player, now);
                break;
            }
            case 11: {
                SpawnSignEventProcedure.handleSilenceEvent(level, player, now);
                break;
            }
            case 12: {
                SpawnSignEventProcedure.handleWhisperEvent(level, player, now);
                break;
            }
            case 14: {
                SpawnSignEventProcedure.handleWatchingEvent(level, player, now);
                break;
            }
            case 15: {
                SpawnSignEventProcedure.handleMirrorEvent(level, player, now);
                break;
            }
            case 16: {
                SpawnSignEventProcedure.playCaveSound(level, signPos);
            }
        }
    }

    private static void handleCountdownEvent(ServerLevel level, Player player, long now) {
        CountdownEvent event = new CountdownEvent(now);
        countdownEvents.put(player.m_20148_(), event);
        BlockPos frontPos = player.m_20183_().m_5484_(player.m_6350_(), 2);
        SpawnSignEventProcedure.spawnCountdownSign(level, player, frontPos, "Count to Ten");
        ++event.signSpawnIndex;
    }

    private static void processCountdownEvents(ServerLevel level, long now) {
        countdownEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            CountdownEvent event = (CountdownEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            if (player == null) {
                return true;
            }
            long elapsed = now - event.startTick;
            long interval = 40L;
            int expectedNumber = 10 - (int)(elapsed / interval);
            if (expectedNumber < event.currentNumber && expectedNumber >= 0) {
                event.currentNumber = expectedNumber;
                BlockPos frontPos = player.m_20183_().m_5484_(player.m_6350_(), 2);
                SpawnSignEventProcedure.spawnCountdownSign(level, player, frontPos, String.valueOf(expectedNumber));
                event.signPositions.add(frontPos);
                ++event.signSpawnIndex;
            }
            if (expectedNumber < 0) {
                for (int i = 0; i < 3; ++i) {
                    Mob steal = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVES_2_STEAL.get()).m_20615_((Level)level);
                    if (steal == null) continue;
                    double angle = Math.random() * Math.PI * 2.0;
                    double dist = 8.0 + Math.random() * 4.0;
                    double sx = player.m_20185_() + Math.cos(angle) * dist;
                    double sz = player.m_20189_() + Math.sin(angle) * dist;
                    steal.m_7678_(sx, player.m_20186_(), sz, 0.0f, 0.0f);
                    level.m_7967_((Entity)steal);
                }
                for (BlockPos pos : event.signPositions) {
                    level.m_7471_(pos, false);
                }
                return true;
            }
            return false;
        });
    }

    private static void spawnCountdownSign(ServerLevel level, Player player, BlockPos pos, String text) {
        CountdownEvent ev;
        if (!level.m_46749_(pos)) {
            return;
        }
        if (!level.m_8055_(pos).m_60795_()) {
            return;
        }
        int rot = (int)Math.floor((double)((player.m_146908_() + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF;
        level.m_46597_(pos, (BlockState)Blocks.f_50095_.m_49966_().m_61124_((Property)StandingSignBlock.f_56987_, (Comparable)Integer.valueOf(rot)));
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            SpawnSignEventProcedure.writeSignText(sign, new String[]{text, "", "", ""}, level, pos);
        }
        int idx = (ev = countdownEvents.get(player.m_20148_())) == null ? 0 : ev.signSpawnIndex;
        float pitch = Math.max(0.5f, 1.2f - (float)idx * 0.05f);
        SoundEvent wood = SoundEvents.f_12635_;
        level.m_5594_(null, pos, wood, SoundSource.BLOCKS, 0.9f, pitch);
    }

    private static void handleLookUpEvent(ServerLevel level, Player player, long now) {
        BlockPos above = player.m_20183_().m_6630_(10);
        FROMTHECAVESROOFEntity roof = (FROMTHECAVESROOFEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESROOF.get()).m_20615_((Level)level);
        if (roof != null) {
            roof.m_7678_((double)above.m_123341_() + 0.5, above.m_123342_(), (double)above.m_123343_() + 0.5, 0.0f, 0.0f);
            CompoundTag nbt = roof.getPersistentData();
            nbt.m_128362_("targetPlayerUUID", player.m_20148_());
            nbt.m_128356_("spawnTick", now);
            level.m_7967_((Entity)roof);
        }
    }

    private static void handleFreezeEvent(ServerLevel level, Player player, long now) {
        FreezeEvent event = new FreezeEvent(now, player.m_146908_(), player.m_146909_());
        freezeEvents.put(player.m_20148_(), event);
        Vec3 behind = player.m_20154_().m_82541_().m_82490_(-2.5);
        Vec3 spawnPos = player.m_20182_().m_82549_(behind);
        FROMTHECAVESSIGNEntity mob = (FROMTHECAVESSIGNEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSIGN.get()).m_20615_((Level)level);
        if (mob != null) {
            mob.m_7678_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, player.m_146908_() + 180.0f, 0.0f);
            CompoundTag nbt = mob.getPersistentData();
            nbt.m_128362_("targetUUID", player.m_20148_());
            nbt.m_128356_("spawnTick", now);
            nbt.m_128379_("transient360", true);
            mob.m_20225_(true);
            mob.m_21557_(true);
            try {
                mob.m_20331_(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            level.m_7967_((Entity)mob);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 6, 0.6, 0.4, 0.6, 0.02);
            SoundEvent spawnSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "it_16"));
            if (spawnSound != null) {
                level.m_5594_(null, player.m_20183_(), spawnSound, SoundSource.AMBIENT, 0.6f, 0.9f);
            }
        }
    }

    private static void processFreezeEvents(ServerLevel level, long now) {
        freezeEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            FreezeEvent event = (FreezeEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            if (player == null) {
                return true;
            }
            if (now >= event.endTick) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.m_21195_(MobEffects.f_19597_);
                    sp.m_21195_(MobEffects.f_19610_);
                } else {
                    player.m_21195_(MobEffects.f_19597_);
                    player.m_21195_(MobEffects.f_19610_);
                }
                return true;
            }
            player.m_146922_(event.lockedYaw);
            player.m_146926_(event.lockedPitch);
            player.m_5618_(event.lockedYaw);
            player.m_5616_(event.lockedYaw);
            player.m_20256_(Vec3.f_82478_);
            player.f_19864_ = true;
            if (player instanceof ServerPlayer) {
                ((ServerPlayer)player).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 4, false, false));
                ((ServerPlayer)player).m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, 0, false, false));
            } else {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 4, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 80, 0, false, false));
            }
            if (now >= event.nextSoundTick) {
                String[] sounds = new String[]{"it_16", "it_22", "it_16"};
                String soundName = sounds[event.soundIndex % sounds.length];
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", soundName));
                if (sound != null) {
                    float vol = 0.7f + (float)(event.soundIndex % 3) * 0.05f;
                    float pitch = 0.9f + (float)(event.soundIndex % 2) * 0.08f;
                    level.m_5594_(null, player.m_20183_(), sound, SoundSource.AMBIENT, vol, pitch);
                }
                level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 4, 0.4, 0.2, 0.4, 0.01);
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    if (event.soundIndex % 2 == 0) {
                        sp.m_5661_((Component)Component.m_237113_((String)"Don't turn around..."), true);
                    }
                }
                ++event.soundIndex;
                event.nextSoundTick = now + 40L;
            }
            return false;
        });
    }

    private static void handleLightsOutEvent(ServerLevel level, Player player, long now) {
        boolean hasLightNearby = false;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BlockPos checkPos = player.m_20183_().m_7918_(x, y, z);
                    BlockState state = level.m_8055_(checkPos);
                    if (state.m_60791_() <= 0) continue;
                    hasLightNearby = true;
                    break;
                }
                if (hasLightNearby) break;
            }
            if (hasLightNearby) break;
        }
        if (!hasLightNearby) {
            return;
        }
        LightsOutEvent event = new LightsOutEvent(now);
        lightsOutEvents.put(player.m_20148_(), event);
        for (int x = -15; x <= 15; ++x) {
            for (int y = -15; y <= 15; ++y) {
                for (int z = -15; z <= 15; ++z) {
                    BlockState state;
                    BlockPos lightPos = player.m_20183_().m_7918_(x, y, z);
                    if (!level.m_46749_(lightPos) || (state = level.m_8055_(lightPos)).m_60791_() <= 0) continue;
                    event.savedStates.put(lightPos.m_7949_(), state);
                    event.removedLights.add(lightPos.m_7949_());
                    level.m_46597_(lightPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    private static void processLightsOutEvents(ServerLevel level, long now) {
        lightsOutEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            LightsOutEvent event = (LightsOutEvent)entry.getValue();
            if (now >= event.endTick) {
                for (Map.Entry<BlockPos, BlockState> lightEntry : event.savedStates.entrySet()) {
                    BlockPos pos = lightEntry.getKey();
                    BlockState state = lightEntry.getValue();
                    if (!level.m_46749_(pos) || !level.m_8055_(pos).m_60795_()) continue;
                    level.m_46597_(pos, state);
                }
                return true;
            }
            return false;
        });
    }

    private static void handleListenEvent(ServerLevel level, Player player, long now) {
        ListenEvent event = new ListenEvent(now);
        listenEvents.put(player.m_20148_(), event);
        SoundEvent init = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "steps_1"));
        if (init != null) {
            level.m_5594_(null, player.m_20183_(), init, SoundSource.AMBIENT, 0.45f, 1.0f);
        }
    }

    private static void processListenEvents(ServerLevel level, long now) {
        listenEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            ListenEvent event = (ListenEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            if (player == null) {
                return true;
            }
            if (now >= event.endTick) {
                return true;
            }
            if (now >= event.nextSoundTick) {
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "steps_1"));
                if (sound != null) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double dist = 5.0 + Math.random() * 10.0;
                    double dx = Math.cos(angle) * dist;
                    double dz = Math.sin(angle) * dist;
                    double sx = player.m_20185_() + dx;
                    double sy = player.m_20186_();
                    double sz = player.m_20189_() + dz;
                    double distance = Math.sqrt(dx * dx + dz * dz);
                    float volume = (float)Math.max(0.35, 1.0 - distance / 20.0);
                    float pitch = (float)(0.95 + (Math.random() - 0.5) * 0.12);
                    BlockPos soundPos = new BlockPos((int)Math.floor(sx), (int)Math.floor(sy), (int)Math.floor(sz));
                    level.m_5594_(null, soundPos, sound, SoundSource.AMBIENT, volume, pitch);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, sx, sy + 0.5, sz, 1, 0.1, 0.1, 0.1, 0.0);
                }
                event.nextSoundTick = now + (long)(40 + level.f_46441_.m_188503_(80));
            }
            return false;
        });
    }

    private static void handleSilenceEvent(ServerLevel level, Player player, long now) {
        SilenceEvent event = new SilenceEvent(now);
        silenceEvents.put(player.m_20148_(), event);
    }

    private static void processSilenceEvents(ServerLevel level, long now) {
        silenceEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            SilenceEvent event = (SilenceEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            if (player == null) {
                return true;
            }
            if (now >= event.endTick) {
                return true;
            }
            if (now >= event.nextHeartbeatTick) {
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "heartbeat"));
                if (sound != null) {
                    level.m_5594_(null, player.m_20183_(), sound, SoundSource.AMBIENT, 0.5f, 1.0f);
                }
                event.nextHeartbeatTick = now + 60L;
            }
            double currentDbLevel = SessionVariables.currentDbLevels.getOrDefault(player.m_20148_(), -60.0);
            CompoundTag pdata = player.getPersistentData();
            if (currentDbLevel >= -30.0) {
                pdata.m_128379_("madeASound", true);
                if (!pdata.m_128441_("nextPillarTick")) {
                    pdata.m_128356_("nextPillarTick", now + 5L);
                }
            }
            if (pdata.m_128471_("madeASound")) {
                long nextPillarTick = pdata.m_128454_("nextPillarTick");
                if (now >= nextPillarTick) {
                    int px = player.m_20183_().m_123341_();
                    int pz = player.m_20183_().m_123343_();
                    int layer = pdata.m_128451_("pillarLayer");
                    int targetY = player.m_20183_().m_123342_() - 1 - layer;
                    if (targetY < 0) {
                        pdata.m_128379_("madeASound", false);
                        pdata.m_128473_("soundPillarBlocks");
                        pdata.m_128473_("pillarLayer");
                        pdata.m_128473_("nextPillarTick");
                    } else {
                        String raw = pdata.m_128461_("soundPillarBlocks");
                        StringBuilder sb = new StringBuilder(raw == null ? "" : raw);
                        for (int dx = 0; dx <= 1; ++dx) {
                            for (int dz = 0; dz <= 1; ++dz) {
                                BlockPos below = new BlockPos(px + dx, targetY, pz + dz);
                                if (!level.m_46749_(below)) continue;
                                BlockState bs = level.m_8055_(below);
                                try {
                                    if (!bs.m_60795_() && bs.m_60734_() != Blocks.f_50752_ && !ProtectedBlocksProcedure.isProtected(bs)) {
                                        sb.append(below.m_123341_()).append(":").append(below.m_123342_()).append(":").append(below.m_123343_()).append(";");
                                        RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, below, false);
                                        continue;
                                    }
                                    if (!bs.m_60795_() && bs.m_60734_() == Blocks.f_50752_) continue;
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        }
                        pdata.m_128359_("soundPillarBlocks", sb.toString());
                        pdata.m_128405_("pillarLayer", layer + 1);
                        pdata.m_128356_("nextPillarTick", now + 5L);
                    }
                }
                if (player.m_20183_().m_123342_() <= 1) {
                    BlockPos center = player.m_20183_();
                    for (int ox = -1; ox <= 1; ++ox) {
                        for (int oy = -1; oy <= 1; ++oy) {
                            for (int oz = -1; oz <= 1; ++oz) {
                                BlockPos p = center.m_7918_(ox, oy, oz);
                                if (!level.m_46749_(p)) continue;
                                level.m_46597_(p, Blocks.f_50016_.m_49966_());
                            }
                        }
                    }
                    String raw = pdata.m_128461_("soundPillarBlocks");
                    if (raw != null && !raw.isEmpty()) {
                        String[] entries;
                        for (String e : entries = raw.split(";")) {
                            if (e == null || e.isEmpty()) continue;
                            try {
                                int z;
                                int y;
                                int x;
                                BlockPos below;
                                String[] parts = e.split(":");
                                if (parts.length < 3 || !level.m_46749_(below = new BlockPos(x = Integer.parseInt(parts[0]), y = Integer.parseInt(parts[1]), z = Integer.parseInt(parts[2])))) continue;
                                BlockState bs = level.m_8055_(below);
                                try {
                                    if (bs.m_60795_() || bs.m_60734_() == Blocks.f_50752_ || ProtectedBlocksProcedure.isProtected(bs)) continue;
                                    RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, below, false);
                                }
                                catch (Throwable throwable) {}
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    pdata.m_128473_("soundPillarBlocks");
                    pdata.m_128473_("pillarLayer");
                    pdata.m_128473_("nextPillarTick");
                    pdata.m_128379_("madeASound", false);
                }
            }
            return false;
        });
    }

    private static void handleWhisperEvent(ServerLevel level, Player player, long now) {
        WhisperEvent event = new WhisperEvent(now);
        whisperEvents.put(player.m_20148_(), event);
        SoundEvent init = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "it_16"));
        if (init != null) {
            level.m_5594_(null, player.m_20183_(), init, SoundSource.AMBIENT, 0.15f, 0.9f);
        }
    }

    private static void processWhisperEvents(ServerLevel level, long now) {
        whisperEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            WhisperEvent event = (WhisperEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            if (player == null) {
                return true;
            }
            if (now >= event.endTick) {
                return true;
            }
            if (now >= event.nextWhisperTick) {
                String[] sounds = new String[]{"it_16", "it_22", "it_16"};
                String soundName = sounds[event.whisperIndex % sounds.length];
                SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", soundName));
                if (sound != null) {
                    float baseVolume = 0.15f + Math.min(1.0f, (float)(now - event.startTick) / 200.0f) * 0.6f;
                    double ang = Math.random() * Math.PI * 2.0;
                    double r = 1.0 + Math.random() * 2.0;
                    double sx = player.m_20185_() + Math.cos(ang) * r;
                    double sz = player.m_20189_() + Math.sin(ang) * r;
                    BlockPos soundPos = new BlockPos((int)Math.floor(sx), (int)Math.floor(player.m_20186_()), (int)Math.floor(sz));
                    float pitch = 0.75f + (float)(event.whisperIndex % 3) * 0.05f;
                    level.m_5594_(null, soundPos, sound, SoundSource.AMBIENT, baseVolume, pitch);
                    level.m_8767_((ParticleOptions)ParticleTypes.f_123796_, sx, player.m_20186_() + 1.0, sz, 1, 0.05, 0.05, 0.05, 0.0);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        if (event.whisperIndex % 4 == 0) {
                            sp.m_5661_((Component)Component.m_237113_((String)"\u2026"), true);
                        }
                    }
                }
                ++event.whisperIndex;
                event.nextWhisperTick = now + 40L;
            }
            return false;
        });
    }

    private static void handleWatchingEvent(ServerLevel level, Player player, long now) {
        WatchingEvent event = new WatchingEvent(now);
        for (int i = 0; i < 5; ++i) {
            double angle = 1.2566370614359172 * (double)i;
            double distance = 12.0;
            double x = player.m_20185_() + Math.cos(angle) * distance;
            double z = player.m_20189_() + Math.sin(angle) * distance;
            Mob watcher = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESSIGN.get()).m_20615_((Level)level);
            if (watcher == null) continue;
            int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)x, (int)z);
            watcher.m_7678_(x, (double)y, z, 0.0f, 0.0f);
            watcher.m_21557_(true);
            watcher.m_21530_();
            Vec3 toPlayer = player.m_20182_().m_82546_(watcher.m_20182_()).m_82541_();
            float yaw = (float)(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_) * 180.0 / Math.PI) - 90.0f;
            watcher.m_146922_(yaw);
            watcher.f_20885_ = yaw;
            watcher.f_20883_ = yaw;
            CompoundTag nbt = watcher.getPersistentData();
            nbt.m_128379_("isWatcher", true);
            nbt.m_128362_("watcherTarget", player.m_20148_());
            level.m_7967_((Entity)watcher);
            event.watchers.add(watcher);
        }
        watchingEvents.put(player.m_20148_(), event);
    }

    private static void processWatchingEvents(ServerLevel level, long now) {
        watchingEvents.entrySet().removeIf(entry -> {
            Vec3 toPlayer;
            UUID playerId = (UUID)entry.getKey();
            WatchingEvent event = (WatchingEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            if (player == null) {
                for (Mob watcher : event.watchers) {
                    if (watcher == null || !watcher.m_6084_()) continue;
                    watcher.m_146870_();
                }
                return true;
            }
            event.watchers.removeIf(w -> w == null || !w.m_6084_());
            if (event.watchers.isEmpty()) {
                return true;
            }
            for (Mob watcher : event.watchers) {
                toPlayer = player.m_20182_().m_82546_(watcher.m_20182_()).m_82541_();
                float yaw = (float)(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_) * 180.0 / Math.PI) - 90.0f;
                watcher.m_146922_(yaw);
                watcher.f_20885_ = yaw;
                watcher.f_20883_ = yaw;
            }
            if (!event.hasTeleported && now >= event.nextMoveTick) {
                for (Mob watcher : event.watchers) {
                    toPlayer = player.m_20182_().m_82546_(watcher.m_20182_()).m_82541_();
                    Vec3 newPos = watcher.m_20182_().m_82549_(toPlayer.m_82490_(2.0));
                    watcher.m_7678_(newPos.f_82479_, watcher.m_20186_(), newPos.f_82481_, watcher.m_146908_(), 0.0f);
                }
                event.hasTeleported = true;
                event.teleportTick = now;
                System.out.println("[DEBUG] Watchers teleported 2 blocks closer at tick " + now);
            } else if (event.hasTeleported && now >= event.teleportTick + 40L) {
                for (Mob watcher : event.watchers) {
                    SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("fromthecaves", "it_16"));
                    if (sound != null) {
                        level.m_5594_(null, watcher.m_20183_(), sound, SoundSource.AMBIENT, 0.5f, 0.8f);
                    }
                    watcher.m_146870_();
                }
                System.out.println("[DEBUG] All watchers despawned at tick " + now);
                return true;
            }
            return false;
        });
    }

    private static void handleMirrorEvent(ServerLevel level, Player player, long now) {
        double angle = Math.random() * Math.PI * 2.0;
        double dist = 10.0 + Math.random() * 5.0;
        double dx = Math.cos(angle) * dist;
        double dz = Math.sin(angle) * dist;
        Vec3 spawnPos = player.m_20182_().m_82520_(dx, 0.0, dz);
        int x = (int)Math.floor(spawnPos.f_82479_);
        int z = (int)Math.floor(spawnPos.f_82481_);
        int y = level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z);
        Mob doppel = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVES_3_DOPPEL.get()).m_20615_((Level)level);
        if (doppel == null) {
            return;
        }
        doppel.m_7678_(spawnPos.f_82479_, (double)y, spawnPos.f_82481_, player.m_146908_(), 0.0f);
        doppel.m_146922_(player.m_146908_());
        doppel.f_20885_ = player.m_146908_();
        doppel.f_20883_ = player.m_146908_();
        CompoundTag nbt = doppel.getPersistentData();
        nbt.m_128379_("isMirrorSign", true);
        nbt.m_128362_("targetUUID", player.m_20148_());
        nbt.m_128356_("spawnTick", now);
        nbt.m_128347_("prevX", player.m_20185_());
        nbt.m_128347_("prevZ", player.m_20189_());
        nbt.m_128405_("tickDelay", 0);
        doppel.m_21557_(true);
        doppel.m_21530_();
        level.m_7967_((Entity)doppel);
        MirrorEvent event = new MirrorEvent(now, doppel);
        mirrorEvents.put(player.m_20148_(), event);
    }

    private static void processMirrorEvents(ServerLevel level, long now) {
        mirrorEvents.entrySet().removeIf(entry -> {
            UUID playerId = (UUID)entry.getKey();
            MirrorEvent event = (MirrorEvent)entry.getValue();
            Player player = level.m_46003_(playerId);
            Mob doppel = event.doppelganger;
            if (player == null || doppel == null || !doppel.m_6084_()) {
                if (doppel != null && doppel.m_6084_()) {
                    doppel.m_146870_();
                }
                return true;
            }
            CompoundTag nbt = doppel.getPersistentData();
            if (event.mirrorPhase && now < event.stopTick) {
                int tickDelay = nbt.m_128451_("tickDelay");
                if (++tickDelay >= 1) {
                    tickDelay = 0;
                    double prevX = nbt.m_128459_("prevX");
                    double prevZ = nbt.m_128459_("prevZ");
                    double mdx = player.m_20185_() - prevX;
                    double mdz = player.m_20189_() - prevZ;
                    Vec3 newPos = doppel.m_20182_().m_82492_(mdx, 0.0, mdz);
                    int nx = (int)Math.floor(newPos.f_82479_);
                    int nz = (int)Math.floor(newPos.f_82481_);
                    int ny = level.m_6924_(Heightmap.Types.WORLD_SURFACE, nx, nz);
                    doppel.m_7678_(newPos.f_82479_, (double)ny, newPos.f_82481_, doppel.m_146908_(), 0.0f);
                    nbt.m_128347_("prevX", player.m_20185_());
                    nbt.m_128347_("prevZ", player.m_20189_());
                }
                nbt.m_128405_("tickDelay", tickDelay);
                Vec3 diff = player.m_20182_().m_82546_(doppel.m_20182_());
                float yaw = (float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 180.0 / Math.PI) - 90.0f;
                doppel.m_146922_(yaw);
                doppel.f_20885_ = yaw;
                doppel.f_20883_ = yaw;
                double distSq = diff.f_82479_ * diff.f_82479_ + diff.f_82481_ * diff.f_82481_;
                if (distSq < 25.0) {
                    Vec3 awayDir = doppel.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                    Vec3 fleePos = doppel.m_20182_().m_82549_(awayDir.m_82490_(3.0));
                    doppel.m_7678_(fleePos.f_82479_, doppel.m_20186_(), fleePos.f_82481_, yaw + 180.0f, 0.0f);
                }
            } else if (now >= event.stopTick && event.mirrorPhase) {
                event.mirrorPhase = false;
                event.stopTick = now + 60L;
                Vec3 diff = player.m_20182_().m_82546_(doppel.m_20182_());
                float yaw = (float)(Math.atan2(diff.f_82481_, diff.f_82479_) * 180.0 / Math.PI) - 90.0f;
                doppel.m_146922_(yaw);
                doppel.f_20885_ = yaw;
                doppel.f_20883_ = yaw;
            } else if (!event.mirrorPhase && now >= event.stopTick) {
                SoundEvent cave = (SoundEvent)SoundEvents.f_11689_.m_203334_();
                level.m_5594_(null, doppel.m_20183_(), cave, SoundSource.AMBIENT, 1.0f, 0.7f);
                doppel.m_146870_();
                return true;
            }
            return false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingSpawns(ServerLevel level, long now) {
        List<PendingSpawn> list = pendingSpawns;
        synchronized (list) {
            pendingSpawns.removeIf(ps -> {
                if (now < ps.detectTick + 20L) {
                    return false;
                }
                Player target = level.m_46003_(ps.playerId);
                if (target instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)target;
                    SpawnSignEventProcedure.spawnBehindPlayer(level, sp, now);
                }
                return true;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPendingBreaks(ServerLevel level, long now) {
        List<PendingBreak> list = pendingBreaks;
        synchronized (list) {
            pendingBreaks.removeIf(pb -> {
                if (now < pb.atTick) {
                    return false;
                }
                level.m_7471_(pb.signPos, false);
                activeSigns.remove(pb.signPos);
                return true;
            });
        }
    }

    private static void processPending360(ServerLevel level, long now) {
        pending360.entrySet().removeIf(entry -> {
            Pending360 watch = (Pending360)entry.getValue();
            Player pl = level.m_46003_(watch.playerId);
            if (!(pl instanceof ServerPlayer)) {
                return true;
            }
            ServerPlayer spp = (ServerPlayer)pl;
            if (now - watch.startTick > 600L) {
                return true;
            }
            float yaw = spp.m_146908_();
            float delta = Math.abs(yaw - watch.lastYaw);
            if (delta > 180.0f) {
                delta = 360.0f - delta;
            }
            watch.accumulated += (double)delta;
            watch.lastYaw = yaw;
            if (watch.accumulated >= 360.0) {
                SpawnSignEventProcedure.spawnBehindPlayer(level, spp, now);
                return true;
            }
            return false;
        });
    }

    private static void spawnBehindPlayer(ServerLevel level, ServerPlayer player, long now) {
        Vec3 behind = player.m_20154_().m_82541_().m_82490_(-1.5);
        Vec3 spawn = player.m_20182_().m_82549_(behind);
        FROMTHECAVESSIGNEntity mob = (FROMTHECAVESSIGNEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSIGN.get()).m_20615_((Level)level);
        if (mob != null) {
            mob.m_7678_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, player.m_146908_() + 180.0f, 0.0f);
            CompoundTag nbt = mob.getPersistentData();
            nbt.m_128362_("targetUUID", player.m_20148_());
            nbt.m_128356_("spawnTick", now);
            nbt.m_128379_("soundPlayed", false);
            nbt.m_128379_("transient360", true);
            level.m_7967_((Entity)mob);
        }
    }

    private static void handleBelowYouEvent(ServerLevel level, Player player, BlockPos signPos, long now) {
        BlockEntity be = level.m_7702_(signPos);
        if (be instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)be;
            SpawnSignEventProcedure.writeSignText(sign, new String[]{"Below You", "", "", ""}, level, signPos);
        }
        SpawnSignEventProcedure.spawnBelowSpider(level, player, now);
    }

    private static void spawnBelowSpider(ServerLevel level, Player player, long now) {
        int SPAWN_DEPTH = 32;
        int py = player.m_20183_().m_123342_() - 32;
        int minY = level.m_141937_() + 1;
        int maxY = level.m_151558_() - 2;
        py = Math.max(minY, Math.min(py, maxY));
        BlockPos center = new BlockPos(player.m_20183_().m_123341_(), py, player.m_20183_().m_123343_());
        if (!level.m_46749_(center)) {
            return;
        }
        for (int dx = 0; dx <= 1; ++dx) {
            for (int dy = 0; dy <= 1; ++dy) {
                for (int dz = 0; dz <= 1; ++dz) {
                    BlockState bs;
                    BlockPos bp = center.m_7918_(dx, dy, dz);
                    if (!level.m_46749_(bp) || (bs = level.m_8055_(bp)).m_60734_() == Blocks.f_50752_) continue;
                    try {
                        if (ProtectedBlocksProcedure.isProtected(bs)) {
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    level.m_46597_(bp, Blocks.f_50016_.m_49966_());
                }
            }
        }
        Mob spider = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESBELOWSPIDER.get()).m_20615_((Level)level);
        if (spider != null) {
            spider.m_7678_((double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, 0.0f, 0.0f);
            spider.m_20242_(false);
            spider.m_21557_(false);
            spider.m_21530_();
            CompoundTag nbt = spider.getPersistentData();
            BlockPos playerPos = player.m_20183_();
            nbt.m_128405_("su_targetX", playerPos.m_123341_());
            nbt.m_128405_("su_targetY", playerPos.m_123342_());
            nbt.m_128405_("su_targetZ", playerPos.m_123343_());
            nbt.m_128356_("su_nextBreakTick", now + 20L);
            nbt.m_128379_("su_running", false);
            level.m_7967_((Entity)spider);
        }
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity livingEntity = ev.getEntity();
        if (!(livingEntity instanceof FROMTHECAVESSIGNEntity)) {
            return;
        }
        FROMTHECAVESSIGNEntity mob = (FROMTHECAVESSIGNEntity)livingEntity;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag nbt = mob.getPersistentData();
        if (!nbt.m_128471_("transient360")) {
            return;
        }
        if (!nbt.m_128403_("targetUUID")) {
            return;
        }
        UUID tid = nbt.m_128342_("targetUUID");
        Player target = level.m_46003_(tid);
        if (target == null) {
            long spawnTick = nbt.m_128454_("spawnTick");
            if (level.m_46467_() > spawnTick + 200L) {
                mob.m_146870_();
            }
            return;
        }
        if (SpawnSignEventProcedure.isPlayerLookingAtMob(target, (Mob)mob)) {
            mob.m_146870_();
        }
    }

    private static boolean isPlayerLookingAtMob(Player player, Mob mob) {
        Vec3 eye = player.m_20299_(1.0f);
        Vec3 mobEye = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_() * 0.9, 0.0);
        Vec3 toMob = mobEye.m_82546_(eye);
        double len = toMob.m_82553_();
        if (len < 1.0E-6) {
            return true;
        }
        Vec3 toMobN = toMob.m_82490_(1.0 / len);
        Vec3 look = player.m_20154_().m_82541_();
        return look.m_82526_(toMobN) > 0.87;
    }

    private static void playCaveSound(ServerLevel level, BlockPos pos) {
        level.m_5594_(null, pos, (SoundEvent)SoundEvents.f_11689_.m_203334_(), SoundSource.AMBIENT, 1.0f, 0.7f);
    }

    private static String[] splitMessage(String msg) {
        String[] lines = new String[]{"", "", "", ""};
        if (msg.length() <= 15 || !msg.contains(" ")) {
            lines[0] = msg;
            return lines;
        }
        String[] words = msg.split(" ");
        int w = words.length;
        StringBuilder[] builders = new StringBuilder[]{new StringBuilder(), new StringBuilder(), new StringBuilder()};
        for (int i = 0; i < w; ++i) {
            if (i < (w + 2) / 3) {
                builders[0].append(words[i]).append(' ');
                continue;
            }
            if (i < 2 * (w + 2) / 3) {
                builders[1].append(words[i]).append(' ');
                continue;
            }
            builders[2].append(words[i]).append(' ');
        }
        lines[0] = builders[0].toString().trim();
        lines[1] = builders[1].toString().trim();
        lines[2] = builders[2].toString().trim();
        return lines;
    }

    private static void writeSignText(SignBlockEntity sign, String[] lines, ServerLevel level, BlockPos pos) {
        if (sign == null) {
            return;
        }
        try {
            CompoundTag tag = sign.m_187482_();
            CompoundTag front = new CompoundTag();
            ListTag msgs = new ListTag();
            for (int i = 0; i < 4; ++i) {
                String line = i < lines.length ? lines[i] : "";
                msgs.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)line))));
            }
            front.m_128365_("messages", (Tag)msgs);
            tag.m_128365_("front_text", (Tag)front);
            tag.m_128359_("id", "minecraft:sign");
            sign.m_142466_(tag);
            sign.m_6596_();
            level.m_46597_(pos, sign.m_58900_());
            level.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
            return;
        }
        catch (Exception e) {
            try {
                Method m = null;
                try {
                    m = sign.getClass().getMethod("setMessage", Integer.TYPE, Component.class, Boolean.TYPE);
                }
                catch (NoSuchMethodException ex) {
                    m = sign.getClass().getMethod("setMessage", Integer.TYPE, Component.class);
                }
                if (m != null) {
                    for (int i = 0; i < Math.min(lines.length, 4); ++i) {
                        if (m.getParameterCount() == 3) {
                            m.invoke((Object)sign, i, Component.m_237113_((String)lines[i]), false);
                            continue;
                        }
                        m.invoke((Object)sign, i, Component.m_237113_((String)lines[i]));
                    }
                    sign.m_6596_();
                    level.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
                    return;
                }
            }
            catch (Exception m) {
                // empty catch block
            }
            try {
                CompoundTag tag = sign.m_187482_();
                for (int i = 0; i < Math.min(lines.length, 4); ++i) {
                    tag.m_128359_("Text" + (i + 1), Component.Serializer.m_130703_((Component)Component.m_237113_((String)lines[i])));
                }
                tag.m_128359_("id", "minecraft:sign");
                sign.m_142466_(tag);
                sign.m_6596_();
                level.m_46597_(pos, sign.m_58900_());
                level.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    private static class SignData {
        final long spawnTick;
        boolean triggered;

        SignData(long tick) {
            this.spawnTick = tick;
            this.triggered = false;
        }
    }

    private static class PendingSpawn {
        final BlockPos signPos;
        final UUID playerId;
        final long detectTick;

        PendingSpawn(BlockPos p, UUID id, long t) {
            this.signPos = p;
            this.playerId = id;
            this.detectTick = t;
        }
    }

    private static class Pending360 {
        final UUID playerId;
        final BlockPos signPos;
        final long startTick;
        float lastYaw;
        double accumulated;

        Pending360(UUID pid, BlockPos sp, long st, float yaw) {
            this.playerId = pid;
            this.signPos = sp;
            this.startTick = st;
            this.lastYaw = yaw;
            this.accumulated = 0.0;
        }
    }

    private static class PendingBreak {
        final BlockPos signPos;
        final long atTick;

        PendingBreak(BlockPos p, long t) {
            this.signPos = p;
            this.atTick = t;
        }
    }

    private static class CountdownEvent {
        final long startTick;
        int currentNumber;
        final List<BlockPos> signPositions;
        int signSpawnIndex;

        CountdownEvent(long tick) {
            this.startTick = tick;
            this.currentNumber = 10;
            this.signPositions = new ArrayList<BlockPos>();
            this.signSpawnIndex = 0;
        }
    }

    private static class FreezeEvent {
        final long startTick;
        final float lockedYaw;
        final float lockedPitch;
        final long endTick;
        long nextSoundTick;
        int soundIndex;

        FreezeEvent(long tick, float yaw, float pitch) {
            this.startTick = tick;
            this.lockedYaw = yaw;
            this.lockedPitch = pitch;
            this.endTick = tick + 200L;
            this.nextSoundTick = tick + 40L;
            this.soundIndex = 0;
        }
    }

    private static class LightsOutEvent {
        final long startTick;
        final long endTick;
        final List<BlockPos> removedLights;
        final Map<BlockPos, BlockState> savedStates;

        LightsOutEvent(long tick) {
            this.startTick = tick;
            this.endTick = tick + 600L;
            this.removedLights = new ArrayList<BlockPos>();
            this.savedStates = new HashMap<BlockPos, BlockState>();
        }
    }

    private static class ListenEvent {
        final long startTick;
        final long endTick;
        long nextSoundTick;

        ListenEvent(long tick) {
            this.startTick = tick;
            this.endTick = tick + 400L;
            this.nextSoundTick = tick + 40L;
        }
    }

    private static class SilenceEvent {
        final long startTick;
        final long endTick;
        long nextHeartbeatTick;

        SilenceEvent(long tick) {
            this.startTick = tick;
            this.endTick = tick + 400L;
            this.nextHeartbeatTick = tick + 60L;
        }
    }

    private static class WhisperEvent {
        final long startTick;
        final long endTick;
        long nextWhisperTick;
        int whisperIndex;

        WhisperEvent(long tick) {
            this.startTick = tick;
            this.endTick = tick + 200L;
            this.nextWhisperTick = tick + 40L;
            this.whisperIndex = 0;
        }
    }

    private static class WatchingEvent {
        final long startTick;
        final List<Mob> watchers;
        int closenessStage;
        long nextMoveTick;
        boolean hasTeleported;
        long teleportTick;

        WatchingEvent(long tick) {
            this.startTick = tick;
            this.watchers = new ArrayList<Mob>();
            this.closenessStage = 0;
            this.nextMoveTick = tick + 30L;
            this.hasTeleported = false;
            this.teleportTick = 0L;
        }
    }

    private static class MirrorEvent {
        final long startTick;
        final Mob doppelganger;
        boolean mirrorPhase;
        long stopTick;

        MirrorEvent(long tick, Mob mob) {
            this.startTick = tick;
            this.doppelganger = mob;
            this.mirrorPhase = true;
            this.stopTick = tick + 300L;
        }
    }

    private static class MotionEvent {
        final long startTick;
        final long endTick;
        final Vec3 lockedPosition;
        final long activationTick;

        MotionEvent(long tick, Vec3 pos) {
            this.startTick = tick;
            this.endTick = tick + 300L;
            this.lockedPosition = pos;
            this.activationTick = tick + 40L;
        }
    }
}

