/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.entity.FROMTHECAVESSHADOWEntity;
import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class JukeboxEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int EVENT_DURATION = 600;
    private static final List<SoundEvent> MUSIC_DISCS = Arrays.asList(SoundEvents.f_12085_, SoundEvents.f_12140_, SoundEvents.f_12086_, SoundEvents.f_12141_, SoundEvents.f_12142_, SoundEvents.f_12143_, SoundEvents.f_12144_, SoundEvents.f_12146_, SoundEvents.f_12147_, SoundEvents.f_12149_, SoundEvents.f_12084_, SoundEvents.f_12148_, SoundEvents.f_184218_, SoundEvents.f_215723_, SoundEvents.f_12145_);
    private static final Map<Integer, JukeboxEventState> activeEvents = new HashMap<Integer, JukeboxEventState>();
    private static final Map<BlockPos, Long> jukeboxCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validJukeboxes = JukeboxEventsProcedure.findValidJukeboxes(server, player);
        if (validJukeboxes.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validJukeboxes.removeIf(pos -> jukeboxCooldowns.containsKey(pos) && currentTime < jukeboxCooldowns.get(pos));
        if (validJukeboxes.isEmpty()) {
            return;
        }
        BlockPos chosen = validJukeboxes.get(server.m_213780_().m_188503_(validJukeboxes.size()));
        JukeboxEvent event = JukeboxEvent.DISTORTED_PLAY;
        jukeboxCooldowns.put(chosen, currentTime + 5L);
        activeEvents.put(eventIdCounter++, new JukeboxEventState(event, player, chosen));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, JukeboxEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, JukeboxEventState> entry = iterator.next();
            JukeboxEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            if (state.tickCount >= 600) {
                JukeboxEventsProcedure.stopAllDiscs(server);
                if (state.mob != null && state.mob.m_6084_()) {
                    state.mob.m_146870_();
                    state.mob = null;
                }
                iterator.remove();
                continue;
            }
            switch (state.event) {
                case DISTORTED_PLAY: {
                    JukeboxEventsProcedure.handleDistortedPlay(server, state);
                }
            }
        }
    }

    private static List<BlockPos> findValidJukeboxes(ServerLevel server, Player player) {
        ArrayList<BlockPos> jukeboxes = new ArrayList<BlockPos>();
        int chunkX = player.m_146902_().f_45578_;
        int chunkZ = player.m_146902_().f_45579_;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                LevelChunk chunk = server.m_6325_(chunkX + dx, chunkZ + dz);
                for (BlockPos pos : chunk.m_62954_().keySet()) {
                    if (!(server.m_8055_(pos).m_60734_() instanceof JukeboxBlock)) continue;
                    jukeboxes.add(pos.m_7949_());
                }
            }
        }
        return jukeboxes;
    }

    private static void handleDistortedPlay(ServerLevel server, JukeboxEventState state) {
        double dist;
        double distSqToPlayer;
        if (state.tickCount == 1) {
            state.selectedDisc = MUSIC_DISCS.get(server.m_213780_().m_188503_(MUSIC_DISCS.size()));
            state.currentPitch = server.m_213780_().m_188501_() * 0.3f + 0.1f;
            JukeboxEventsProcedure.playDiscSound(server, state.jukeboxPos, state.selectedDisc, state.currentPitch);
            state.playing = true;
            FROMTHECAVESSHADOWEntity shadow = (FROMTHECAVESSHADOWEntity)((EntityType)FromTheCavesModEntities.FROMTHECAVESSHADOW.get()).m_20615_((Level)server);
            if (shadow != null) {
                shadow.m_7678_((double)state.jukeboxPos.m_123341_() + 0.5, state.jukeboxPos.m_123342_() + 1, (double)state.jukeboxPos.m_123343_() + 0.5, 0.0f, 0.0f);
                Vec3 toPlayer = state.player.m_20182_().m_82546_(shadow.m_20182_());
                float yaw = (float)(Math.atan2(toPlayer.f_82481_, toPlayer.f_82479_) * 180.0 / Math.PI) - 90.0f;
                shadow.m_146922_(yaw);
                shadow.f_20885_ = yaw;
                shadow.f_20883_ = yaw;
                shadow.m_21557_(true);
                shadow.m_20225_(true);
                server.m_7967_((Entity)shadow);
                state.mob = shadow;
            }
        }
        if (state.playing && state.tickCount % 80 == 0) {
            JukeboxEventsProcedure.stopAllDiscs(server);
            state.currentPitch = server.m_213780_().m_188501_() * 0.3f + 0.1f;
            JukeboxEventsProcedure.playDiscSound(server, state.jukeboxPos, state.selectedDisc, state.currentPitch);
        }
        if (state.playing && state.tickCount % 3 == 0) {
            double d = server.m_213780_().m_188500_() * 2.0 * Math.PI;
            double dx = Math.cos(d) * 0.5;
            double dz = Math.sin(d) * 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123758_, (double)state.jukeboxPos.m_123341_() + 0.5 + dx, (double)state.jukeboxPos.m_123342_() + 1.2, (double)state.jukeboxPos.m_123343_() + 0.5 + dz, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (state.mob != null && state.mob.m_6084_()) {
            Vec3 playerEye = state.player.m_146892_();
            Vec3 mobEye = state.mob.m_146892_();
            Vec3 toMob = mobEye.m_82546_(playerEye).m_82541_();
            Vec3 lookDir = state.player.m_20154_();
            double dot = lookDir.m_82526_(toMob);
            double angle = Math.acos(Mth.m_14008_((double)dot, (double)-1.0, (double)1.0)) * 57.29577951308232;
            if (angle < 65.0 && state.despawnTimer < 0) {
                state.despawnTimer = 0;
            }
            if (state.despawnTimer >= 0) {
                ++state.despawnTimer;
                if (state.despawnTimer >= 12) {
                    state.mob.m_146870_();
                    state.mob = null;
                }
            }
        }
        if ((distSqToPlayer = state.player.m_20275_((double)state.jukeboxPos.m_123341_() + 0.5, (double)state.jukeboxPos.m_123342_(), (double)state.jukeboxPos.m_123343_() + 0.5)) <= 4.0) {
            JukeboxEventsProcedure.stopAllDiscs(server);
            state.playing = false;
            if (state.mob != null && state.mob.m_6084_()) {
                state.mob.m_146870_();
                state.mob = null;
            }
            state.tickCount = 600;
            return;
        }
        if (state.playing && (dist = state.player.m_20275_((double)state.jukeboxPos.m_123341_() + 0.5, (double)state.jukeboxPos.m_123342_(), (double)state.jukeboxPos.m_123343_() + 0.5)) <= 1.0) {
            JukeboxEventsProcedure.stopAllDiscs(server);
            state.playing = false;
            if (state.mob != null && state.mob.m_6084_()) {
                state.mob.m_146870_();
            }
            state.tickCount = 600;
        }
    }

    private static void playDiscSound(ServerLevel server, BlockPos pos, SoundEvent sound, float pitch) {
        server.m_5594_(null, pos, sound, SoundSource.RECORDS, 3.0f, pitch);
    }

    private static void stopDiscSound(ServerLevel server, SoundEvent sound) {
        ResourceLocation loc = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
        if (loc != null) {
            server.m_7654_().m_6846_().m_11268_((Packet)new ClientboundStopSoundPacket(loc, SoundSource.RECORDS));
        }
    }

    private static void stopAllDiscs(ServerLevel server) {
        server.m_7654_().m_6846_().m_11268_((Packet)new ClientboundStopSoundPacket(null, SoundSource.RECORDS));
    }

    private static enum JukeboxEvent {
        DISTORTED_PLAY;

    }

    private static class JukeboxEventState {
        JukeboxEvent event;
        Player player;
        BlockPos jukeboxPos;
        int tickCount;
        SoundEvent selectedDisc;
        float currentPitch;
        FROMTHECAVESSHADOWEntity mob;
        boolean playing;
        int despawnTimer;

        JukeboxEventState(JukeboxEvent event, Player player, BlockPos jukeboxPos) {
            this.event = event;
            this.player = player;
            this.jukeboxPos = jukeboxPos;
            this.tickCount = 0;
            this.playing = false;
            this.despawnTimer = -1;
        }
    }
}

