/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SignEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 2.5E-5;
    private static final double MAX_PROB_PHASE1 = 3.0E-5;
    private static final double BASE_PROB_PHASE2 = 3.0E-5;
    private static final double MAX_PROB_PHASE2 = 3.5E-5;
    private static final int SCAN_RADIUS = 20;
    private static final double VIEW_ANGLE_THRESHOLD = 0.85;
    private static final int RESTORE_DELAY_TICKS = 100;
    private static final String[] GENERAL_MESSAGES = new String[]{"Here I am", "Behind", "Wait Here", "Don't move", "It's listening", "Below the floor", "We are close", "They come at night", "You are never alone", "Shut your eyes", "So cold below", "Come lower", "It waits", "Watch the ground", "Below You", "Count to Ten", "Look Up", "Don't Turn Around", "Lights Out", "Listen Carefully", "Silence", "Do You Hear It?"};
    private static final String[][] WOODEN_CROSS_MESSAGES = new String[][]{{"That cross...", "it burns me.", "", ""}, {"You should not", "carry that cross.", "", ""}, {"The wooden cross", "enrages me.", "", ""}, {"The cross", "burns me.", "", ""}, {"Take the cross", "away.", "", ""}, {"That cross", "hurts.", "", ""}, {"The cross", "weakens me.", "", ""}, {"I hate", "the cross.", "", ""}, {"The cross...", "it stings.", "", ""}, {"Hide", "the cross.", "", ""}, {"The cross steals", "my strength.", "", ""}, {"The cross", "blinds me.", "", ""}, {"Your cross", "hurts.", "", ""}, {"Drop", "the cross.", "", ""}, {"That cross burns", "my eyes.", "", ""}, {"The cross cracks", "my bones.", "", ""}, {"The cross", "banishes me.", "", ""}};
    private static final String[][] IRON_CROSS_MESSAGES = new String[][]{{"The iron cross...", "I cannot take it.", "", ""}, {"Iron cross...", "too strong.", "", ""}, {"The metal burns", "my hands.", "", ""}, {"I fear the", "iron cross.", "", ""}, {"That Iron cross", "repels me.", "", ""}, {"The blessed", "iron cross hurts.", "", ""}, {"I cannot touch", "iron crosses.", "", ""}, {"Iron cross...", "it scorches.", "", ""}, {"The iron cross", "defeats me.", "", ""}, {"Iron cross...", "my weakness.", "", ""}};
    private static final Map<Integer, SignEventState> activeEvents = new HashMap<Integer, SignEventState>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase != 1 && phase != 2) {
            return;
        }
        double baseProb = phase == 1 ? 2.5E-5 : 3.0E-5;
        double maxProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validSigns = SignEventsProcedure.findValidSigns(server, player);
        if (validSigns.isEmpty()) {
            return;
        }
        BlockPos chosenPos = validSigns.get(server.m_213780_().m_188503_(validSigns.size()));
        BlockEntity be = server.m_7702_(chosenPos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        BlockState originalBlockState = server.m_8055_(chosenPos);
        Component[] originalText = new Component[4];
        try {
            for (int i = 0; i < 4; ++i) {
                originalText[i] = sign.m_277142_().m_277138_(i, false);
            }
        }
        catch (Exception e) {
            return;
        }
        SignEvent event = SignEvent.values()[server.m_213780_().m_188503_(SignEvent.values().length)];
        activeEvents.put(eventIdCounter++, new SignEventState(event, player, chosenPos, originalBlockState, originalText));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, SignEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, SignEventState> entry = iterator.next();
            SignEventState state = entry.getValue();
            if (state.player == null || state.player.m_213877_() || !(state.player.m_9236_() instanceof ServerLevel)) {
                SignEventsProcedure.restoreSign(state);
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            BlockEntity be = server.m_7702_(state.signPos);
            if (!(be instanceof SignBlockEntity)) {
                iterator.remove();
                continue;
            }
            ++state.tickCount;
            boolean isViewing = SignEventsProcedure.isPlayerLookingAtSign(state.player, state.signPos);
            if (isViewing) {
                if (!state.playerViewing) {
                    state.playerViewing = true;
                    state.viewingTicks = 0;
                }
                ++state.viewingTicks;
                if (state.viewingTicks >= 20 && !state.shouldRestore) {
                    state.shouldRestore = true;
                    state.restoreCountdown = 100;
                }
            } else {
                state.playerViewing = false;
                state.viewingTicks = 0;
            }
            if (state.shouldRestore) {
                --state.restoreCountdown;
                if (state.restoreCountdown <= 0) {
                    SignEventsProcedure.restoreSign(state);
                    iterator.remove();
                    continue;
                }
            }
            switch (state.event) {
                case SPIN_CLOCKWISE: {
                    SignEventsProcedure.handleSpinClockwise(server, state);
                    break;
                }
                case SPIN_COUNTERCLOCKWISE: {
                    SignEventsProcedure.handleSpinCounterclockwise(server, state);
                    break;
                }
                case SPIN_RANDOM: {
                    SignEventsProcedure.handleSpinRandom(server, state);
                    break;
                }
                case FLIP_ROTATION: {
                    SignEventsProcedure.handleFlipRotation(server, state);
                    break;
                }
                case TEXT_CHANGE_GENERAL: {
                    SignEventsProcedure.handleTextChangeGeneral(server, state);
                    break;
                }
                case TEXT_CHANGE_WOODEN_CROSS: {
                    SignEventsProcedure.handleTextChangeWoodenCross(server, state);
                    break;
                }
                case TEXT_CHANGE_IRON_CROSS: {
                    SignEventsProcedure.handleTextChangeIronCross(server, state);
                    break;
                }
                case TEXT_FADE: {
                    SignEventsProcedure.handleTextFade(server, state);
                }
            }
            if (state.tickCount < 600 || state.shouldRestore) continue;
            SignEventsProcedure.restoreSign(state);
            iterator.remove();
        }
    }

    private static List<BlockPos> findValidSigns(ServerLevel server, Player player) {
        ArrayList<BlockPos> signs = new ArrayList<BlockPos>();
        BlockPos playerPos = player.m_20183_();
        for (int x = -20; x <= 20; ++x) {
            for (int y = -20; y <= 20; ++y) {
                for (int z = -20; z <= 20; ++z) {
                    BlockEntity be;
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockState state = server.m_8055_(checkPos);
                    if (!(state.m_60734_() instanceof SignBlock) || !((be = server.m_7702_(checkPos)) instanceof SignBlockEntity)) continue;
                    signs.add(checkPos);
                }
            }
        }
        return signs;
    }

    private static boolean isPlayerLookingAtSign(Player player, BlockPos signPos) {
        Vec3 playerEye = player.m_20299_(1.0f);
        Vec3 signCenter = new Vec3((double)signPos.m_123341_() + 0.5, (double)signPos.m_123342_() + 0.5, (double)signPos.m_123343_() + 0.5);
        Vec3 toSign = signCenter.m_82546_(playerEye).m_82541_();
        Vec3 playerLook = player.m_20252_(1.0f).m_82541_();
        double dot = playerLook.m_82526_(toSign);
        double distance = playerEye.m_82554_(signCenter);
        return dot > 0.85 && distance <= 8.0;
    }

    private static void handleSpinClockwise(ServerLevel server, SignEventState state) {
        if (state.tickCount % 4 != 0) {
            return;
        }
        BlockState currentState = server.m_8055_(state.signPos);
        BlockState rotated = currentState.m_60717_(Rotation.CLOCKWISE_90);
        server.m_7731_(state.signPos, rotated, 3);
        server.m_5594_(null, state.signPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.3f, 1.2f);
    }

    private static void handleSpinCounterclockwise(ServerLevel server, SignEventState state) {
        if (state.tickCount % 4 != 0) {
            return;
        }
        BlockState currentState = server.m_8055_(state.signPos);
        BlockState rotated = currentState.m_60717_(Rotation.COUNTERCLOCKWISE_90);
        server.m_7731_(state.signPos, rotated, 3);
        server.m_5594_(null, state.signPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.3f, 1.2f);
    }

    private static void handleSpinRandom(ServerLevel server, SignEventState state) {
        if (state.tickCount % 8 != 0) {
            return;
        }
        BlockState currentState = server.m_8055_(state.signPos);
        Rotation[] rotations = new Rotation[]{Rotation.CLOCKWISE_90, Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_180};
        Rotation randomRot = rotations[server.m_213780_().m_188503_(rotations.length)];
        BlockState rotated = currentState.m_60717_(randomRot);
        server.m_7731_(state.signPos, rotated, 3);
        server.m_5594_(null, state.signPos, SoundEvents.f_12634_, SoundSource.BLOCKS, 0.4f, 0.9f + server.m_213780_().m_188501_() * 0.4f);
    }

    private static void handleFlipRotation(ServerLevel server, SignEventState state) {
        if (state.tickCount % 10 != 0) {
            return;
        }
        BlockState currentState = server.m_8055_(state.signPos);
        BlockState rotated = currentState.m_60717_(Rotation.CLOCKWISE_180);
        server.m_7731_(state.signPos, rotated, 3);
        server.m_5594_(null, state.signPos, SoundEvents.f_12630_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private static void handleTextChangeGeneral(ServerLevel server, SignEventState state) {
        if (state.tickCount != 1) {
            return;
        }
        BlockEntity be = server.m_7702_(state.signPos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        String chosenMessage = GENERAL_MESSAGES[server.m_213780_().m_188503_(GENERAL_MESSAGES.length)];
        String[] lines = SignEventsProcedure.splitMessageToLines(chosenMessage);
        SignEventsProcedure.writeSignText(sign, lines, server, state.signPos);
        server.m_5594_(null, state.signPos, SoundEvents.f_12565_, SoundSource.BLOCKS, 0.6f, 1.3f);
    }

    private static void handleTextChangeWoodenCross(ServerLevel server, SignEventState state) {
        if (state.tickCount != 1) {
            return;
        }
        BlockEntity be = server.m_7702_(state.signPos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        String[] lines = WOODEN_CROSS_MESSAGES[server.m_213780_().m_188503_(WOODEN_CROSS_MESSAGES.length)];
        SignEventsProcedure.writeSignText(sign, lines, server, state.signPos);
        server.m_5594_(null, state.signPos, SoundEvents.f_12565_, SoundSource.BLOCKS, 0.6f, 0.8f);
    }

    private static void handleTextChangeIronCross(ServerLevel server, SignEventState state) {
        if (state.tickCount != 1) {
            return;
        }
        BlockEntity be = server.m_7702_(state.signPos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        String[] lines = IRON_CROSS_MESSAGES[server.m_213780_().m_188503_(IRON_CROSS_MESSAGES.length)];
        SignEventsProcedure.writeSignText(sign, lines, server, state.signPos);
        server.m_5594_(null, state.signPos, SoundEvents.f_12565_, SoundSource.BLOCKS, 0.6f, 0.8f);
    }

    private static void handleTextFade(ServerLevel server, SignEventState state) {
        if (state.tickCount % 10 != 0) {
            return;
        }
        BlockEntity be = server.m_7702_(state.signPos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        int progress = state.tickCount / 10;
        String[] fadedMessages = new String[4];
        for (int i = 0; i < 4; ++i) {
            Component original = state.originalText[i];
            String text = original.getString();
            fadedMessages[i] = progress < text.length() ? text.substring(0, text.length() - progress) : "";
        }
        SignEventsProcedure.writeSignText(sign, fadedMessages, server, state.signPos);
        if (state.tickCount % 20 == 0) {
            server.m_5594_(null, state.signPos, SoundEvents.f_12331_, SoundSource.BLOCKS, 0.2f, 1.5f);
        }
    }

    private static String[] splitMessageToLines(String message) {
        String[] lines = new String[]{"", "", "", ""};
        if (message.length() <= 15) {
            lines[0] = message;
            return lines;
        }
        String[] words = message.split(" ");
        if (words.length == 1) {
            lines[0] = message;
            return lines;
        }
        int lineIndex = 0;
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            if (currentLine.length() + word.length() + 1 <= 15) {
                if (currentLine.length() > 0) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (lineIndex >= 3) break;
            lines[lineIndex] = currentLine.toString();
            ++lineIndex;
            currentLine = new StringBuilder(word);
        }
        if (lineIndex < 4 && currentLine.length() > 0) {
            lines[lineIndex] = currentLine.toString();
        }
        return lines;
    }

    private static void restoreSign(SignEventState state) {
        Level level;
        if (state.player == null || !((level = state.player.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockEntity be = server.m_7702_(state.signPos);
        if (!(be instanceof SignBlockEntity)) {
            return;
        }
        SignBlockEntity sign = (SignBlockEntity)be;
        server.m_7731_(state.signPos, state.originalBlockState, 3);
        String[] originalStrings = new String[4];
        for (int i = 0; i < 4; ++i) {
            originalStrings[i] = state.originalText[i].getString();
        }
        SignEventsProcedure.writeSignText(sign, originalStrings, server, state.signPos);
        server.m_5594_(null, state.signPos, SoundEvents.f_12635_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private static void writeSignText(SignBlockEntity sign, String[] lines, ServerLevel level, BlockPos pos) {
        if (sign == null) {
            return;
        }
        try {
            CompoundTag tag = sign.m_187482_();
            CompoundTag front = new CompoundTag();
            ListTag msgs = new ListTag();
            for (int i = 0; i < 4; ++i) {
                String line = i < lines.length ? lines[i] : "";
                msgs.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)Component.m_237113_((String)line))));
            }
            front.m_128365_("messages", (Tag)msgs);
            tag.m_128365_("front_text", (Tag)front);
            tag.m_128359_("id", "minecraft:sign");
            sign.m_142466_(tag);
            sign.m_6596_();
            level.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
        }
        catch (Exception e) {
            try {
                CompoundTag tag = sign.m_187482_();
                for (int i = 0; i < Math.min(lines.length, 4); ++i) {
                    tag.m_128359_("Text" + (i + 1), Component.Serializer.m_130703_((Component)Component.m_237113_((String)lines[i])));
                }
                tag.m_128359_("id", "minecraft:sign");
                sign.m_142466_(tag);
                sign.m_6596_();
                level.m_7260_(pos, sign.m_58900_(), sign.m_58900_(), 3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static enum SignEvent {
        SPIN_CLOCKWISE,
        SPIN_COUNTERCLOCKWISE,
        SPIN_RANDOM,
        FLIP_ROTATION,
        TEXT_CHANGE_GENERAL,
        TEXT_CHANGE_WOODEN_CROSS,
        TEXT_CHANGE_IRON_CROSS,
        TEXT_FADE;

    }

    private static class SignEventState {
        SignEvent event;
        Player player;
        BlockPos signPos;
        int tickCount;
        BlockState originalBlockState;
        Component[] originalText;
        boolean playerViewing;
        int viewingTicks;
        boolean shouldRestore;
        int restoreCountdown;

        SignEventState(SignEvent event, Player player, BlockPos signPos, BlockState originalBlockState, Component[] originalText) {
            this.event = event;
            this.player = player;
            this.signPos = signPos;
            this.tickCount = 0;
            this.originalBlockState = originalBlockState;
            this.originalText = originalText;
            this.playerViewing = false;
            this.viewingTicks = 0;
            this.shouldRestore = false;
            this.restoreCountdown = 0;
        }
    }
}

