/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import net.mcreator.fromthecaves.init.FromTheCavesModEntities;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.mcreator.fromthecaves.procedures.ProtectedBlocksProcedure;
import net.mcreator.fromthecaves.procedures.RestoreBrokenBlocksManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class SoundMimicSpawnProcedure {
    private static final double BASE_PROB = 4.0E-5;
    private static final double MAX_PROB = 5.5E-5;
    private static final double FIXED_DIST = 8.0;
    private static final long SOUND_TO_CHASE_DELAY = 20L;
    private static final double CHASE_SPEED = 0.75;
    private static final int BLINDNESS_TICKS = 100;
    private static final double OPAQUE_DISTANCE = 2.0;
    private static final double DESPAWN_DISTANCE = 1.0;
    private static final String KEY_SPAWN_TIME = "sm_spawnTime";
    private static final String KEY_SOUND_TIME = "sm_soundTime";
    private static final String KEY_SOUND_PLAYED = "sm_soundPlayed";
    private static final String KEY_CHASING = "sm_chasing";
    private static final String[] SOUND_LIST = new String[]{"block.sculk_shrieker.shriek", "block.sculk_sensor.clicking", "block.portal.ambient", "entity.drowned.ambient", "entity.pig.ambient", "entity.sheep.ambient", "entity.chicken.ambient", "entity.ravager.ambient", "entity.strider.ambient", "entity.zombie.ambient", "block.grass.step"};
    private static final double BASE_PURSUIT_SPEED = 0.7;
    private static final double MAX_PURSUIT_SPEED = 0.7;
    private static final double MIN_PURSUIT_SPEED = 0.7;
    private static final double VERTICAL_SPEED_MULTIPLIER = 1.2;
    private static final double BLOCK_BREAK_DISTANCE = 1.5;
    private static final double BLOCK_BREAK_HARDNESS_LIMIT = 50.0;
    private static final int BLOCK_BREAK_RADIUS = 1;
    private static final double RANDOM_DRIFT_FACTOR = 0.05;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)level);
        if (phase != 1 && phase != 2 && phase != 3) {
            return;
        }
        if (player.m_20186_() >= 60.0) {
            return;
        }
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(level, player, 4.0E-5, 5.5E-5);
        if (Math.random() >= dynamicProb) {
            return;
        }
        double angle = Math.random() * Math.PI * 2.0;
        double sx = player.m_20185_() + Math.cos(angle) * 8.0;
        double sz = player.m_20189_() + Math.sin(angle) * 8.0;
        double sy = player.m_20186_();
        Mob mob = null;
        try {
            mob = (Mob)((EntityType)FromTheCavesModEntities.FROMTHECAVESSOUNDMIMIC.get()).m_262496_(level, BlockPos.m_274561_((double)sx, (double)sy, (double)sz), MobSpawnType.MOB_SUMMONED);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (mob == null) {
            return;
        }
        BlockPos mPos = mob.m_20183_();
        if (!level.m_8055_(mPos).m_60795_()) {
            mob.m_146870_();
            return;
        }
        CompoundTag data = mob.getPersistentData();
        data.m_128356_(KEY_SPAWN_TIME, level.m_46467_());
        data.m_128379_(KEY_SOUND_PLAYED, false);
        data.m_128473_(KEY_SOUND_TIME);
        data.m_128379_(KEY_CHASING, false);
        mob.m_6842_(true);
        int idx = level.f_46441_.m_188503_(SOUND_LIST.length);
        ResourceLocation soundLoc = new ResourceLocation("minecraft", SOUND_LIST[idx]);
        SoundEvent se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundLoc);
        if (se == null) {
            se = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("minecraft", "ambient.cave"));
        }
        if (se != null) {
            level.m_5594_(null, mob.m_20183_(), se, SoundSource.HOSTILE, 1.0f, 1.0f);
            data.m_128356_(KEY_SOUND_TIME, level.m_46467_());
            data.m_128379_(KEY_SOUND_PLAYED, true);
        }
    }

    @SubscribeEvent
    public static void onMobTick(LivingEvent.LivingTickEvent ev) {
        LivingEntity ent = ev.getEntity();
        if (!(ent instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)ent;
        if (!mob.m_6095_().equals(FromTheCavesModEntities.FROMTHECAVESSOUNDMIMIC.get())) {
            return;
        }
        if (mob.m_9236_().f_46443_) {
            return;
        }
        ServerLevel level = (ServerLevel)mob.m_9236_();
        CompoundTag data = mob.getPersistentData();
        long now = level.m_46467_();
        if (!data.m_128471_(KEY_SOUND_PLAYED)) {
            return;
        }
        Player player = level.m_45930_((Entity)mob, 32.0);
        if (player == null) {
            mob.m_146870_();
            return;
        }
        mob.m_21391_((Entity)player, 360.0f, 360.0f);
        double dx = player.m_20185_() - mob.m_20185_();
        double dz = player.m_20189_() - mob.m_20189_();
        double dy = player.m_20188_() - (mob.m_20186_() + (double)mob.m_20192_());
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz)) * 180.0 / Math.PI);
        mob.m_146922_(yaw);
        mob.f_20883_ = yaw;
        mob.f_20885_ = yaw;
        mob.m_146926_(pitch);
        AABB playerBoxInflated = player.m_20191_().m_82400_(2.0);
        if (mob.m_20191_().m_82381_(playerBoxInflated) && mob.m_20145_()) {
            mob.m_6842_(false);
        }
        if (data.m_128471_(KEY_CHASING)) {
            mob.m_20242_(true);
            mob.m_21557_(true);
            if (mob.m_20191_().m_82381_(player.m_20191_().m_82400_(1.0))) {
                SoundMimicSpawnProcedure.performArrivalAttackAndDespawn(mob, player, level);
                return;
            }
            Vec3 fromMobEye = mob.m_20182_().m_82520_(0.0, (double)mob.m_20192_(), 0.0);
            Vec3 toPlayerEye = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 dir = toPlayerEye.m_82546_(fromMobEye).m_82541_();
            double distanceToPlayer = fromMobEye.m_82554_(toPlayerEye);
            double speedFactor = Math.min(1.0, distanceToPlayer / 20.0);
            double pursuitSpeed = 0.7 + speedFactor * 0.0;
            double verticalAdjustment = dir.f_82480_ > 0.0 ? 1.2 : (dir.f_82480_ < 0.0 ? 1.2 : 1.0);
            Vec3 adjustedDir = new Vec3(dir.f_82479_, dir.f_82480_ * verticalAdjustment, dir.f_82481_).m_82541_();
            double randomAngle = level.f_46441_.m_188500_() * Math.PI * 2.0;
            double driftX = Math.cos(randomAngle) * 0.05;
            double driftZ = Math.sin(randomAngle) * 0.05;
            Vec3 drift = new Vec3(driftX, 0.0, driftZ);
            adjustedDir = adjustedDir.m_82549_(drift).m_82541_();
            Vec3 motion = adjustedDir.m_82490_(pursuitSpeed);
            mob.m_20256_(motion);
            try {
                mob.m_6478_(MoverType.SELF, motion);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (mob.m_20191_().m_82381_(player.m_20191_().m_82400_(1.0))) {
                SoundMimicSpawnProcedure.performArrivalAttackAndDespawn(mob, player, level);
                return;
            }
            Vec3 toPlayerXZ = new Vec3(player.m_20185_() - mob.m_20185_(), 0.0, player.m_20189_() - mob.m_20189_());
            double horizSq = toPlayerXZ.m_82556_();
            if (horizSq <= 1.44) {
                double tx = player.m_20185_() - dir.f_82479_ * 0.5;
                double tz = player.m_20189_() - dir.f_82481_ * 0.5;
                mob.m_6021_(tx, mob.m_20186_(), tz);
                if (mob.m_20191_().m_82381_(player.m_20191_().m_82400_(1.0))) {
                    SoundMimicSpawnProcedure.performArrivalAttackAndDespawn(mob, player, level);
                    return;
                }
            }
            for (int i = 1; i <= 2; ++i) {
                BlockPos breakPos;
                BlockState state;
                float hardness;
                Vec3 start = fromMobEye;
                double checkDistance = (double)i * 1.5 / 2.0;
                Vec3 end = start.m_82549_(adjustedDir.m_82490_(checkDistance));
                ClipContext clipContext = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)mob);
                BlockHitResult hit = level.m_45547_(clipContext);
                if (hit.m_6662_() != HitResult.Type.BLOCK || !((hardness = (state = level.m_8055_(breakPos = hit.m_82425_())).m_60800_((BlockGetter)level, breakPos)) >= 0.0f) || !((double)hardness <= 50.0) || state.m_60795_()) continue;
                if (ProtectedBlocksProcedure.isProtected(state)) {
                    return;
                }
                RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, breakPos, false);
                level.m_7106_((ParticleOptions)ParticleTypes.f_123813_, (double)breakPos.m_123341_() + 0.5, (double)breakPos.m_123342_() + 0.5, (double)breakPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                level.m_5594_(null, breakPos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (Direction dirAdj : Direction.values()) {
                    BlockPos adjPos = breakPos.m_121945_(dirAdj);
                    BlockState adjState = level.m_8055_(adjPos);
                    float adjHardness = adjState.m_60800_((BlockGetter)level, adjPos);
                    if (!(adjHardness >= 0.0f) || !((double)adjHardness <= 25.0) || !level.f_46441_.m_188499_() || ProtectedBlocksProcedure.isProtected(adjState)) continue;
                    RestoreBrokenBlocksManagerProcedure.destroyAndRecord(level, adjPos, false);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)adjPos.m_123341_() + 0.5, (double)adjPos.m_123342_() + 0.5, (double)adjPos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        if (!data.m_128441_(KEY_SOUND_TIME)) {
            return;
        }
        long soundTime = data.m_128454_(KEY_SOUND_TIME);
        if (now - soundTime >= 20L) {
            data.m_128379_(KEY_CHASING, true);
            mob.m_6842_(false);
            mob.m_20242_(true);
            data.m_128356_(KEY_SPAWN_TIME, now);
            if (mob.m_20191_().m_82381_(player.m_20191_().m_82400_(1.0))) {
                SoundMimicSpawnProcedure.performArrivalAttackAndDespawn(mob, player, level);
                return;
            }
        }
    }

    private static void performArrivalAttackAndDespawn(Mob mob, Player player, ServerLevel level) {
        try {
            player.m_6469_(level.m_269111_().m_269333_((LivingEntity)mob), 1.0f);
        }
        catch (Throwable ignored) {
            player.m_6469_(level.m_269111_().m_269264_(), 1.0f);
        }
        ResourceLocation appearLoc = new ResourceLocation("from_the_caves", "appear_1");
        SoundEvent appearSe = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(appearLoc);
        if (appearSe != null) {
            level.m_5594_(null, mob.m_20183_(), appearSe, SoundSource.AMBIENT, 0.7f, 0.98f);
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 0, false, false));
        mob.m_146870_();
    }
}

