/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class WaterIntelligentProcedure {
    private static final int DOLPHIN_GRACE_INTERVAL = 60;
    private static final int DOLPHIN_GRACE_DURATION = 60;
    private static final int WATER_PUSH_INTERVAL = 20;
    private static final double WATER_PUSH_STRENGTH = 0.3;
    private static final String FROZEN_KEY = "frozenWaterBlocks_AI";
    private static final Set<String> AFFECTED_ENTITIES;

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        BlockPos below;
        Player player;
        LivingEntity living = event.getEntity();
        if (!(living instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob mob = (PathfinderMob)living;
        if (mob.m_9236_().m_5776_()) {
            return;
        }
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
        if (key == null) {
            return;
        }
        String idPath = key.m_135815_().toLowerCase();
        String fullId = key.toString().toLowerCase();
        if (!AFFECTED_ENTITIES.contains(idPath) && !AFFECTED_ENTITIES.contains(fullId)) {
            return;
        }
        WaterIntelligentProcedure.processFrozenBlocks(server, mob);
        mob.m_21441_(BlockPathTypes.WATER, 0.0f);
        if (WaterIntelligentProcedure.isInOrTouchingWater(mob)) {
            long nextPush;
            CompoundTag data;
            long nextGrace;
            long tick = server.m_46467_();
            if (tick >= (nextGrace = (data = mob.getPersistentData()).m_128454_("nextDolphinGraceTick"))) {
                mob.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 60, 0, false, true));
                data.m_128356_("nextDolphinGraceTick", tick + 60L);
            }
            if (tick >= (nextPush = data.m_128454_("nextWaterPushTick"))) {
                Player near = server.m_45930_((Entity)mob, 10.0);
                if (near != null) {
                    Vec3 dir = near.m_146892_().m_82546_(mob.m_20182_()).m_82541_();
                    mob.m_20256_(mob.m_20184_().m_82549_(dir.m_82490_(0.3)));
                }
                data.m_128356_("nextWaterPushTick", tick + 20L);
            }
        }
        if ((player = server.m_45930_((Entity)mob, 42.0)) != null && player.m_20183_().m_123342_() == mob.m_20183_().m_123342_() && server.m_6425_(below = mob.m_20183_().m_7495_()).m_76152_() == Fluids.f_76193_ && !WaterIntelligentProcedure.isPosAlreadyFrozen(mob, below)) {
            server.m_46597_(below, Blocks.f_50449_.m_49966_());
            long expire = server.m_46467_() + 20L;
            WaterIntelligentProcedure.addFrozenBlock(mob, below, expire);
        }
    }

    private static void processFrozenBlocks(ServerLevel server, PathfinderMob mob) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        if (raw == null || raw.isEmpty()) {
            return;
        }
        StringBuilder remaining = new StringBuilder();
        long tick = server.m_46467_();
        for (String e : raw.split(";")) {
            if (e == null || e.isEmpty()) continue;
            try {
                String[] parts = e.split(":");
                if (parts.length < 4) continue;
                int x = Integer.parseInt(parts[0]);
                int y = Integer.parseInt(parts[1]);
                int z = Integer.parseInt(parts[2]);
                long expire = Long.parseLong(parts[3]);
                BlockPos pos = new BlockPos(x, y, z);
                if (tick >= expire) {
                    Block cur = server.m_8055_(pos).m_60734_();
                    if (cur != Blocks.f_50449_ && cur != Blocks.f_50126_) continue;
                    server.m_46597_(pos, Blocks.f_49990_.m_49966_());
                    continue;
                }
                remaining.append(e).append(";");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mob.getPersistentData().m_128359_(FROZEN_KEY, remaining.toString());
    }

    private static boolean isPosAlreadyFrozen(PathfinderMob mob, BlockPos pos) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        if (raw == null || raw.isEmpty()) {
            return false;
        }
        return raw.contains(pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":");
    }

    private static void addFrozenBlock(PathfinderMob mob, BlockPos pos, long expireTick) {
        String raw = mob.getPersistentData().m_128461_(FROZEN_KEY);
        String token = pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":";
        if (raw != null && raw.contains(token)) {
            return;
        }
        mob.getPersistentData().m_128359_(FROZEN_KEY, (raw == null ? "" : raw) + pos.m_123341_() + ":" + pos.m_123342_() + ":" + pos.m_123343_() + ":" + expireTick + ";");
    }

    private static boolean isInOrTouchingWater(PathfinderMob mob) {
        if (mob.m_20069_()) {
            return true;
        }
        Level world = mob.m_9236_();
        BlockPos o = mob.m_20183_();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || world.m_8055_(o.m_7918_(dx, 0, dz)).m_60734_() != Blocks.f_49990_) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HashSet<String> s = new HashSet<String>(Arrays.asList("fromthecaveseyeless", "from_the_caves:fromthecaveseyeless"));
        AFFECTED_ENTITIES = Collections.unmodifiableSet(s);
    }
}

