/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.mcreator.fromthecaves.procedures.ChunkTensionProcedure;
import net.mcreator.fromthecaves.procedures.PhaseManagerProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FurnaceEventsProcedure {
    private static final double BASE_PROB_PHASE1 = 3.0E-5;
    private static final double MAX_PROB_PHASE1 = 3.5E-5;
    private static final double BASE_PROB_PHASE2 = 3.5E-5;
    private static final double MAX_PROB_PHASE2 = 4.0E-5;
    private static final int SCAN_CHUNK_RADIUS = 1;
    private static final int COOLDOWN_TICKS = 5;
    private static final int SMOKE_DURATION = 100;
    private static final double SOUND_RADIUS = 5.0;
    private static final Map<Integer, FurnaceEventState> activeEvents = new HashMap<Integer, FurnaceEventState>();
    private static final Map<BlockPos, Long> furnaceCooldowns = new HashMap<BlockPos, Long>();
    private static int eventIdCounter = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = ev.player;
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int phase = PhaseManagerProcedure.getCurrentPhase((LevelAccessor)server);
        if (phase < 1 || phase > 2) {
            return;
        }
        double baseProb = phase == 1 ? 3.0E-5 : 3.5E-5;
        double maxProb = phase == 1 ? 3.5E-5 : 4.0E-5;
        double dynamicProb = ChunkTensionProcedure.getDynamicProbability(server, player, baseProb, maxProb);
        if (server.m_213780_().m_188500_() >= dynamicProb) {
            return;
        }
        List<BlockPos> validFurnaces = FurnaceEventsProcedure.findValidFurnaces(server, player);
        if (validFurnaces.isEmpty()) {
            return;
        }
        long currentTime = server.m_46467_();
        validFurnaces.removeIf(pos -> furnaceCooldowns.containsKey(pos) && currentTime < furnaceCooldowns.get(pos));
        if (validFurnaces.isEmpty()) {
            return;
        }
        BlockPos chosen = validFurnaces.get(server.m_213780_().m_188503_(validFurnaces.size()));
        furnaceCooldowns.put(chosen, currentTime + 5L);
        SubEvent picked = FurnaceEventsProcedure.pickRandomSubEvent(server);
        activeEvents.put(eventIdCounter++, new FurnaceEventState(chosen, player, picked));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent ev) {
        if (ev.phase != TickEvent.Phase.END) {
            return;
        }
        Iterator<Map.Entry<Integer, FurnaceEventState>> iterator = activeEvents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, FurnaceEventState> entry = iterator.next();
            FurnaceEventState state = entry.getValue();
            if (!(state.player.m_9236_() instanceof ServerLevel)) {
                iterator.remove();
                continue;
            }
            ServerLevel server = (ServerLevel)state.player.m_9236_();
            ++state.tickCount;
            ++state.subTick;
            double offsetX = (server.f_46441_.m_188500_() - 0.5) * 0.18;
            double offsetY = 0.7 + server.f_46441_.m_188500_() * 0.18;
            double offsetZ = (server.f_46441_.m_188500_() - 0.5) * 0.18;
            double velX = (server.f_46441_.m_188500_() - 0.5) * 0.01;
            double velY = 0.03 + server.f_46441_.m_188500_() * 0.03;
            double velZ = (server.f_46441_.m_188500_() - 0.5) * 0.01;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)state.furnacePos.m_123341_() + 0.5 + offsetX, (double)state.furnacePos.m_123342_() + offsetY, (double)state.furnacePos.m_123343_() + 0.5 + offsetZ, 1, velX, velY, velZ, 0.005);
            if (state.tickCount % 10 == 0) {
                server.m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)state.furnacePos.m_123341_() + 0.5 + offsetX, (double)state.furnacePos.m_123342_() + offsetY, (double)state.furnacePos.m_123343_() + 0.5 + offsetZ, 2, velX * 0.8, velY * 0.9, velZ * 0.8, 0.01);
            }
            switch (state.subEvent) {
                case SOUL_SMOKE: {
                    FurnaceEventsProcedure.handleSoulSmoke(server, state);
                    break;
                }
                case EMBER_SPARKS: {
                    FurnaceEventsProcedure.handleEmberSparks(server, state);
                    break;
                }
                case SLAM: {
                    FurnaceEventsProcedure.handleSlam(server, state);
                    break;
                }
                case FLARE: {
                    FurnaceEventsProcedure.handleFlare(server, state);
                    break;
                }
                case COLD_PULSE: {
                    FurnaceEventsProcedure.handleColdPulse(server, state);
                    break;
                }
                case TEMP_LIT: {
                    FurnaceEventsProcedure.handleTempLit(server, state);
                }
            }
            if (state.tickCount < 100) continue;
            iterator.remove();
        }
    }

    private static SubEvent pickRandomSubEvent(ServerLevel server) {
        int r = server.f_46441_.m_188503_(100);
        if (r < 30) {
            return SubEvent.SOUL_SMOKE;
        }
        if (r < 50) {
            return SubEvent.EMBER_SPARKS;
        }
        if (r < 65) {
            return SubEvent.SLAM;
        }
        if (r < 82) {
            return SubEvent.FLARE;
        }
        if (r < 92) {
            return SubEvent.COLD_PULSE;
        }
        return SubEvent.TEMP_LIT;
    }

    private static void handleSoulSmoke(ServerLevel server, FurnaceEventState state) {
        if (state.subTick % 40 == 0) {
            FurnaceEventsProcedure.playSoundToNearbyPlayers(server, state.furnacePos, new ResourceLocation("minecraft", "ambient.cave"), 0.7f, 0.8f + server.f_46441_.m_188501_() * 0.4f);
        }
    }

    private static void handleEmberSparks(ServerLevel server, FurnaceEventState state) {
        if (state.subTick % 4 == 0) {
            double x = (double)state.furnacePos.m_123341_() + 0.5 + (server.f_46441_.m_188500_() - 0.5) * 0.28;
            double y = (double)state.furnacePos.m_123342_() + 0.6 + server.f_46441_.m_188500_() * 0.25;
            double z = (double)state.furnacePos.m_123343_() + 0.5 + (server.f_46441_.m_188500_() - 0.5) * 0.28;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 1, 0.0, 0.01, 0.0, 0.005);
            if (server.f_46441_.m_188503_(6) == 0) {
                FurnaceEventsProcedure.playSoundToNearbyPlayers(server, state.furnacePos, new ResourceLocation("minecraft", "item.firecharge.use"), 0.6f, 0.9f + server.f_46441_.m_188501_() * 0.2f);
            }
        }
    }

    private static void handleSlam(ServerLevel server, FurnaceEventState state) {
        if (state.subTick == 3) {
            FurnaceEventsProcedure.playSoundToNearbyPlayers(server, state.furnacePos, new ResourceLocation("minecraft", "block.chest.close"), 1.0f, 0.9f + server.f_46441_.m_188501_() * 0.2f);
            double x = (double)state.furnacePos.m_123341_() + 0.5;
            double y = (double)state.furnacePos.m_123342_() + 1.0;
            double z = (double)state.furnacePos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 6, 0.18, 0.12, 0.18, 0.01);
        }
    }

    private static void handleFlare(ServerLevel server, FurnaceEventState state) {
        if (state.subTick < 10 && state.subTick % 2 == 0) {
            double x = (double)state.furnacePos.m_123341_() + 0.5;
            double y = (double)state.furnacePos.m_123342_() + 1.0 + server.f_46441_.m_188500_() * 0.2;
            double z = (double)state.furnacePos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 4, 0.2, 0.12, 0.2, 0.02);
            FurnaceEventsProcedure.playSoundToNearbyPlayers(server, state.furnacePos, new ResourceLocation("minecraft", "entity.generic.explode"), 0.8f, 0.7f + server.f_46441_.m_188501_() * 0.4f);
        }
    }

    private static void handleColdPulse(ServerLevel server, FurnaceEventState state) {
        if (state.subTick % 12 == 0) {
            double x = (double)state.furnacePos.m_123341_() + 0.5;
            double y = (double)state.furnacePos.m_123342_() + 1.0;
            double z = (double)state.furnacePos.m_123343_() + 0.5;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123746_, x, y, z, 4, 0.28, 0.12, 0.28, 0.015);
            server.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.15, z, 2, 0.3, 0.08, 0.3, 0.008);
            FurnaceEventsProcedure.playSoundToNearbyPlayers(server, state.furnacePos, new ResourceLocation("minecraft", "entity.trident.thunder"), 0.6f, 0.5f + server.f_46441_.m_188501_() * 0.6f);
        }
    }

    private static void handleTempLit(ServerLevel server, FurnaceEventState state) {
        BlockState current = server.m_8055_(state.furnacePos);
        if (current.m_60734_() instanceof FurnaceBlock && current.m_61138_((Property)BlockStateProperties.f_61443_)) {
            if (!((Boolean)current.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                server.m_7731_(state.furnacePos, (BlockState)current.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)), 3);
            }
            if (state.tickCount >= 160) {
                server.m_7731_(state.furnacePos, (BlockState)current.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)), 3);
            }
        }
    }

    private static void playSoundToNearbyPlayers(ServerLevel server, BlockPos pos, ResourceLocation soundResource, float volume, float pitch) {
        if (soundResource == null) {
            return;
        }
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundResource);
        if (sound == null) {
            return;
        }
        AABB box = new AABB(pos).m_82400_(5.0);
        List nearby = server.m_45976_(ServerPlayer.class, box);
        for (ServerPlayer p : nearby) {
            p.m_5496_(sound, volume, pitch);
        }
    }

    private static List<BlockPos> findValidFurnaces(ServerLevel server, Player player) {
        ArrayList<BlockPos> furnaces = new ArrayList<BlockPos>();
        int chunkX = player.m_146902_().f_45578_;
        int chunkZ = player.m_146902_().f_45579_;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                LevelChunk chunk = server.m_6325_(chunkX + dx, chunkZ + dz);
                for (BlockPos pos : chunk.m_62954_().keySet()) {
                    BlockState state = server.m_8055_(pos);
                    if (!(state.m_60734_() instanceof FurnaceBlock)) continue;
                    furnaces.add(pos.m_7949_());
                }
            }
        }
        return furnaces;
    }

    private static enum SubEvent {
        SOUL_SMOKE,
        EMBER_SPARKS,
        SLAM,
        FLARE,
        COLD_PULSE,
        TEMP_LIT;

    }

    private static class FurnaceEventState {
        BlockPos furnacePos;
        Player player;
        int tickCount;
        SubEvent subEvent;
        int subTick;

        FurnaceEventState(BlockPos furnacePos, Player player, SubEvent subEvent) {
            this.furnacePos = furnacePos;
            this.player = player;
            this.tickCount = 0;
            this.subEvent = subEvent;
            this.subTick = 0;
        }
    }
}

