/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.fromthecaves.procedures;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobCrawlSystemProcedure {
    private static final Set<String> CRAWLABLE_MOBS = new HashSet<String>();
    private static final int CHECK_INTERVAL = 2;
    private static final float CRAWL_HEIGHT = 0.6f;
    private static final float CRAWL_WIDTH_MULTIPLIER = 1.0f;
    private static final String NBT_IS_CRAWLING = "FTC_isCrawling";
    private static final String NBT_ORIGINAL_WIDTH = "FTC_origWidth";
    private static final String NBT_ORIGINAL_HEIGHT = "FTC_origHeight";
    private static final String NBT_EYE_HEIGHT_OFFSET = "FTC_eyeOffset";

    public static void addCrawlableMob(String entityId) {
        CRAWLABLE_MOBS.add(entityId);
    }

    public static void removeCrawlableMob(String entityId) {
        CRAWLABLE_MOBS.remove(entityId);
    }

    public static boolean isCrawlable(Entity entity) {
        if (entity == null) {
            return false;
        }
        ResourceLocation key = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (key == null) {
            return false;
        }
        return CRAWLABLE_MOBS.contains(key.toString());
    }

    @SubscribeEvent
    public static void onEntityTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        Mob mob = (Mob)entity;
        if (!MobCrawlSystemProcedure.isCrawlable((Entity)mob)) {
            return;
        }
        if (mob.f_19797_ % 2 != 0) {
            return;
        }
        Level world = mob.m_9236_();
        boolean shouldCrawl = MobCrawlSystemProcedure.shouldMobCrawl(world, mob);
        CompoundTag data = mob.getPersistentData();
        boolean isCrawling = data.m_128471_(NBT_IS_CRAWLING);
        if (shouldCrawl && !isCrawling) {
            MobCrawlSystemProcedure.startCrawling(mob, data);
        } else if (!shouldCrawl && isCrawling) {
            MobCrawlSystemProcedure.stopCrawling(mob, data);
        }
        if (data.m_128471_(NBT_IS_CRAWLING)) {
            MobCrawlSystemProcedure.maintainCrawlBoundingBox(mob, data);
        }
    }

    private static boolean shouldMobCrawl(Level world, Mob mob) {
        BlockPos[] walls;
        Vec3 pos = mob.m_20182_();
        double eyeHeight = mob.m_20192_();
        if (eyeHeight < 0.8) {
            return false;
        }
        BlockPos headPos = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_ + 1.0), (int)Math.floor(pos.f_82481_));
        BlockPos aboveHead = new BlockPos((int)Math.floor(pos.f_82479_), (int)Math.floor(pos.f_82480_ + 1.5), (int)Math.floor(pos.f_82481_));
        boolean hasLowCeiling = false;
        BlockState stateHead = world.m_8055_(headPos);
        BlockState stateAbove = world.m_8055_(aboveHead);
        if (!stateHead.m_60795_() && stateHead.m_60804_((BlockGetter)world, headPos)) {
            hasLowCeiling = true;
        } else if (!stateAbove.m_60795_() && stateAbove.m_60804_((BlockGetter)world, aboveHead)) {
            hasLowCeiling = true;
        }
        if (!hasLowCeiling) {
            return false;
        }
        BlockPos feetPos = mob.m_20183_();
        BlockState feetState = world.m_8055_(feetPos);
        if (!feetState.m_60795_() && !feetState.m_60812_((BlockGetter)world, feetPos).m_83281_()) {
            return false;
        }
        int solidWalls = 0;
        for (BlockPos wallPos : walls = new BlockPos[]{feetPos.m_122012_(), feetPos.m_122019_(), feetPos.m_122029_(), feetPos.m_122024_()}) {
            BlockState wallState = world.m_8055_(wallPos);
            if (wallState.m_60795_() || !wallState.m_60804_((BlockGetter)world, wallPos)) continue;
            ++solidWalls;
        }
        return solidWalls >= 2;
    }

    private static void startCrawling(Mob mob, CompoundTag data) {
        AABB originalBB = mob.m_20191_();
        float originalWidth = (float)(originalBB.f_82291_ - originalBB.f_82288_);
        float originalHeight = (float)(originalBB.f_82292_ - originalBB.f_82289_);
        data.m_128350_(NBT_ORIGINAL_WIDTH, originalWidth);
        data.m_128350_(NBT_ORIGINAL_HEIGHT, originalHeight);
        data.m_128379_(NBT_IS_CRAWLING, true);
        MobCrawlSystemProcedure.applyCrawlBoundingBox(mob, originalWidth * 1.0f, 0.6f);
        mob.m_20124_(Pose.SWIMMING);
        try {
            mob.m_6210_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void stopCrawling(Mob mob, CompoundTag data) {
        if (!data.m_128441_(NBT_ORIGINAL_WIDTH) || !data.m_128441_(NBT_ORIGINAL_HEIGHT)) {
            data.m_128379_(NBT_IS_CRAWLING, false);
            return;
        }
        float originalWidth = data.m_128457_(NBT_ORIGINAL_WIDTH);
        float originalHeight = data.m_128457_(NBT_ORIGINAL_HEIGHT);
        MobCrawlSystemProcedure.applyCrawlBoundingBox(mob, originalWidth, originalHeight);
        mob.m_20124_(Pose.STANDING);
        try {
            mob.m_6210_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        data.m_128379_(NBT_IS_CRAWLING, false);
        data.m_128473_(NBT_ORIGINAL_WIDTH);
        data.m_128473_(NBT_ORIGINAL_HEIGHT);
    }

    private static void maintainCrawlBoundingBox(Mob mob, CompoundTag data) {
        if (!data.m_128441_(NBT_ORIGINAL_WIDTH)) {
            return;
        }
        float originalWidth = data.m_128457_(NBT_ORIGINAL_WIDTH);
        float currentWidth = originalWidth * 1.0f;
        AABB currentBB = mob.m_20191_();
        float currentHeight = (float)(currentBB.f_82292_ - currentBB.f_82289_);
        if (currentHeight > 0.70000005f) {
            MobCrawlSystemProcedure.applyCrawlBoundingBox(mob, currentWidth, 0.6f);
        }
    }

    private static void applyCrawlBoundingBox(Mob mob, float width, float height) {
        Vec3 pos = mob.m_20182_();
        double halfWidth = (double)width / 2.0;
        AABB newBB = new AABB(pos.f_82479_ - halfWidth, pos.f_82480_, pos.f_82479_ + halfWidth, pos.f_82480_ + (double)height, pos.f_82481_ - halfWidth, pos.f_82481_ + halfWidth);
        try {
            mob.m_20011_(newBB);
        }
        catch (Throwable t) {
            try {
                mob.m_6210_();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean isMobCrawling(Mob mob) {
        if (mob == null) {
            return false;
        }
        return mob.getPersistentData().m_128471_(NBT_IS_CRAWLING);
    }

    public static void forceCrawl(Mob mob, boolean crawl) {
        if (mob == null) {
            return;
        }
        CompoundTag data = mob.getPersistentData();
        if (crawl) {
            MobCrawlSystemProcedure.startCrawling(mob, data);
        } else {
            MobCrawlSystemProcedure.stopCrawling(mob, data);
        }
    }

    public static Set<String> getCrawlableMobs() {
        return new HashSet<String>(CRAWLABLE_MOBS);
    }

    public static void clearCrawlableMobs() {
        CRAWLABLE_MOBS.clear();
    }

    public static float getEffectiveEyeHeight(Mob mob) {
        if (MobCrawlSystemProcedure.isMobCrawling(mob)) {
            return 0.51000005f;
        }
        return mob.m_20192_();
    }

    static {
        CRAWLABLE_MOBS.add("from_the_caves:FROMTHECAVES2STEAL");
    }
}

